/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BusWoffBillQtyExcessValidator
extends AbstractValidator {
    public void validate() {
        String entityName = this.getEntityKey();
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isAdjust = bill.getBoolean("isadjust");
            boolean isSelfWoff = bill.getBoolean("isselfwoff");
            if (!isAdjust || !isSelfWoff) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long srcId = entry.getLong("e_srcbillid");
                long srcEntryId = entry.getLong("e_srcentryid");
                if (srcId == 0L || srcEntryId == 0L) continue;
                srcBillIds.add(srcId);
                srcEntryIds.add(srcEntryId);
            }
        }
        if (srcBillIds.size() == 0 || srcEntryIds.size() == 0) {
            return;
        }
        HashMap<Long, Tuple> srcBillInfo = new HashMap<Long, Tuple>(16);
        DataSet srcBills = QueryServiceHelper.queryDataSet((String)"woffqtyexcess", (String)entityName, (String)"entry.id,entry.e_unwoffqty,entry.e_unwoffnotaxamt", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds), new QFilter("entry.id", "in", srcEntryIds)}, null);
        for (Row row : srcBills) {
            Long entryId = row.getLong("entry.id");
            srcBillInfo.put(entryId, Tuple.create((Object)row.getBigDecimal("entry.e_unwoffqty"), (Object)row.getBigDecimal("entry.e_unwoffnotaxamt")));
        }
        block3: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isAdjust = bill.getBoolean("isadjust");
            boolean isSelfWoff = bill.getBoolean("isselfwoff");
            if (!isAdjust || !isSelfWoff) continue;
            boolean isBasedAmt = bill.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            String billNo = bill.getString("billno");
            String billName = "ar_busbill".equals(entityName) ? ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355", (String)"BusWoffBillQtyExcessValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355", (String)"BusWoffBillQtyExcessValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
            for (DynamicObject entry : entrys) {
                BigDecimal srcUnWoffQty;
                long srcEntryId = entry.getLong("e_srcentryid");
                Tuple tuple = (Tuple)srcBillInfo.get(srcEntryId);
                if (tuple == null) continue;
                if (isBasedAmt) {
                    BigDecimal srcUnWoffAmt;
                    BigDecimal currentAmt = entry.getBigDecimal("e_amount");
                    if (currentAmt.multiply(srcUnWoffAmt = (BigDecimal)tuple.item2).compareTo(BigDecimal.ZERO) <= 0 && currentAmt.abs().compareTo(srcUnWoffAmt.abs()) <= 0) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7684\u91d1\u989d\u8d85\u8fc7\u6e90%2$s\u7684\u672a\u51b2\u56de\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusWoffBillQtyExcessValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, billName));
                    continue block3;
                }
                BigDecimal currentQty = entry.getBigDecimal("e_quantity");
                if (currentQty.multiply(srcUnWoffQty = (BigDecimal)tuple.item1).compareTo(BigDecimal.ZERO) <= 0 && currentQty.abs().compareTo(srcUnWoffQty.abs()) <= 0) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7684\u6570\u91cf\u8d85\u8fc7\u6e90%2$s\u7684\u672a\u51b2\u56de\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusWoffBillQtyExcessValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, billName));
                continue block3;
            }
        }
    }
}

