/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.util.EmptyUtils;

public class CancelAdjExchValidator
extends AbstractValidator {
    private boolean isAr;
    private boolean isAdjExch;

    private String getInitPeriod() {
        return ResManager.loadKDString((String)"\u671f\u521d", (String)"CancelAdjExchValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
    }

    public CancelAdjExchValidator(boolean isAr, boolean isAdjExch) {
        this.isAr = isAr;
        this.isAdjExch = isAdjExch;
    }

    public CancelAdjExchValidator(boolean isAdjExch) {
        this.isAdjExch = isAdjExch;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        if (this.isAdjExch) {
            this.isAr = "AR".equals(dataEntities[0].getDataEntity().getString("bizsystem"));
        }
        AdjExchService adjExchService = new AdjExchService(this.isAr ? "ar" : "ap");
        DynamicObject[] dynamicObjects = new DynamicObject[dataEntities.length];
        String billName = dataEntities[0].getDataEntity().getDataEntityType().getName();
        for (int i = 0; i < dataEntities.length; ++i) {
            dynamicObjects[i] = dataEntities[i].getDataEntity();
        }
        List<Long> orgIds = adjExchService.getOrgIds(dynamicObjects);
        Map<Long, Boolean> orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject adjExchRecord = dataEntity.getDataEntity();
            DynamicObject org = adjExchRecord.getDynamicObject("org");
            DynamicObject period = adjExchRecord.getDynamicObject(this.isAdjExch ? "period" : "curperiod");
            if (this.isAdjExch && orgAndParamMap.get(org.getPkValue()) != null && !orgAndParamMap.get(org.getPkValue()).booleanValue()) continue;
            boolean isNotFailure = true;
            List<String> errorMessageList = adjExchService.cancelAdjValidate(org, period);
            isNotFailure = errorMessageList.isEmpty();
            StringBuilder errorMessage = new StringBuilder();
            if (!isNotFailure) {
                errorMessage = this.getErrorMessage(errorMessageList, org, period, dataEntity);
            }
            if (EmptyUtils.isNotEmpty(billName) && billName.endsWith("_init")) {
                period = null;
                List<String> errorMessageListForInit = adjExchService.cancelAdjValidate(org, period, true);
                if (!isNotFailure && !errorMessageList.isEmpty()) {
                    errorMessage.append('\n');
                }
                if (isNotFailure) {
                    isNotFailure = errorMessageList.isEmpty();
                }
                if (!isNotFailure) {
                    errorMessage.append((CharSequence)this.getErrorMessage(errorMessageListForInit, org, period, dataEntity));
                }
            }
            if (isNotFailure) continue;
            this.addErrorMessage(dataEntity, errorMessage.toString());
        }
        if (dataEntities.length > 1 && this.getFalseDataEntities().size() == dataEntities.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u4fdd\u8bc1\u7ed3\u7b97\u7ec4\u7ec7\u8c03\u6c47\u671f\u95f4\u672a\u7ed3\u8d26\u5e76\u4e14\u65e0\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u8c03\u6c47\u5355\u7684\u524d\u63d0\u4e0b\uff0c\u5bf9\u5df2\u8c03\u6c47\u7684\u8bb0\u5f55\u4f9d\u6b21\u53cd\u7ed3\u7b97\u3002", (String)"CancelAdjExchValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public StringBuilder getErrorMessage(List<String> errorMessageList, DynamicObject org, DynamicObject period, ExtendedDataEntity dataEntity) {
        StringBuilder errorInfo = new StringBuilder();
        if (EmptyUtils.isNotEmpty(errorMessageList)) {
            String periodName = this.getInitPeriod();
            if (period != null) {
                periodName = period.getString("name");
            }
            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\u3002", (String)"CancelAdjExchValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"), periodName));
            for (String errorMessage : errorMessageList) {
                errorInfo.append(errorMessage);
            }
        }
        return errorInfo;
    }
}

