/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class CasPayBillExcessValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasPayBillExcessValidator.class);
    protected boolean isValidateEntry = false;
    protected boolean isValidateBill = true;

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.seq");
        selectors.add("entry.settleorg");
        selectors.add("entry.e_payableamt");
        selectors.add("entry.e_refundamt");
        selectors.add("entry.e_sourcebillid");
        selectors.add("entry.e_sourcebillentryid");
        selectors.add("sourcebilltype");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        Map<Long, String> directApplyMessage;
        logger.info("CasPayBillExcessValidator start");
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        logger.info("CasPayBillExcessValidator validate isValidateEntry is\u3010 " + this.isValidateEntry + " \u3011\uff0cisValidateBill\u3010 " + this.isValidateBill + "\u3011");
        if (!this.isValidateBill && !this.isValidateEntry) {
            return result;
        }
        ArrayList<DynamicObject> directArApBills = new ArrayList<DynamicObject>(others.length);
        ArrayList<DynamicObject> directApApplyBills = new ArrayList<DynamicObject>(others.length);
        for (DynamicObject casBill : others) {
            String sourceBillType = casBill.getString("sourcebilltype");
            if (ObjectUtils.isEmpty((Object)sourceBillType) || "cas_paybill".equals(sourceBillType)) continue;
            if ("ap_finapbill".equals(sourceBillType) || "ar_finarbill".equals(sourceBillType)) {
                directArApBills.add(casBill);
                continue;
            }
            if (!"ap_payapply".equals(sourceBillType)) continue;
            directApApplyBills.add(casBill);
        }
        Map<Long, String> directArApMessage = this.directArApValidator(directArApBills);
        if (!directArApMessage.isEmpty()) {
            result.putAll(directArApMessage);
        }
        if (!(directApplyMessage = this.directApApplyValidator(directApApplyBills)).isEmpty()) {
            result.putAll(directApplyMessage);
        }
        logger.info("CasPayBillExcessValidator validate result \uff1a" + result);
        return result;
    }

    private Map<Long, String> directArApValidator(List<DynamicObject> directArApBills) {
        if (ObjectUtils.isEmpty(directArApBills)) {
            return new HashMap<Long, String>(8);
        }
        logger.info("CasPayBillExcessValidator directArApValidator begin");
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        HashMap<Long, List<DynamicObject>> casDetailMap = new HashMap<Long, List<DynamicObject>>(64);
        HashMap<Long, BigDecimal> casSrcFinAmountMap = new HashMap<Long, BigDecimal>(64);
        for (DynamicObject casBill : directArApBills) {
            String sourceBillType = casBill.getString("sourcebilltype");
            DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
            for (DynamicObject casDetailRow : entry) {
                long sourceBillId = casDetailRow.getLong("e_sourcebillid");
                long sourceEntryId = casDetailRow.getLong("e_sourcebillentryid");
                BigDecimal ePayableAmt = casDetailRow.getBigDecimal("e_payableamt");
                if ("ap_finapbill".equals(sourceBillType)) {
                    finApBillIds.add(sourceBillId);
                } else {
                    finArBillIds.add(sourceBillId);
                }
                List detailRows = casDetailMap.getOrDefault(sourceEntryId, new ArrayList(16));
                detailRows.add(casDetailRow);
                casDetailMap.put(sourceEntryId, detailRows);
                BigDecimal casAmount = casSrcFinAmountMap.getOrDefault(sourceBillId, BigDecimal.ZERO);
                casAmount = casAmount.add(ePayableAmt);
                casSrcFinAmountMap.put(sourceBillId, casAmount);
            }
        }
        HashMap<Long, String> excessFinMap = new HashMap<Long, String>(64);
        if (!finApBillIds.isEmpty()) {
            Map<Long, String> excessFinApMap = this.downTarExcessValidator(finApBillIds, casDetailMap, casSrcFinAmountMap, false);
            logger.info("CasPayBillExcessValidator directArApValidator excessFinApIds :" + excessFinApMap);
            excessFinMap.putAll(excessFinApMap);
        }
        if (!finArBillIds.isEmpty()) {
            Map<Long, String> excessFinArMap = this.downTarExcessValidator(finArBillIds, casDetailMap, casSrcFinAmountMap, true);
            logger.info("CasPayBillExcessValidator directArApValidator excessFinArIds :" + excessFinArMap);
            excessFinMap.putAll(excessFinArMap);
        }
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        if (!excessFinMap.isEmpty()) {
            block2: for (DynamicObject casBill : directArApBills) {
                String errorMessage;
                String srcBillNo;
                DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
                boolean isAr = "ar_finarbill".equals(casBill.getString("sourcebilltype"));
                boolean isGoOn = true;
                for (DynamicObject detail : entry) {
                    long sourceBillEntryId = detail.getLong("e_sourcebillentryid");
                    srcBillNo = (String)excessFinMap.get(sourceBillEntryId);
                    if (ObjectUtils.isEmpty((Object)srcBillNo)) continue;
                    errorMessage = this.returnErrorMessage(isAr, detail.getInt("seq"), srcBillNo);
                    result.put(casBill.getLong("id"), errorMessage);
                    isGoOn = false;
                    break;
                }
                if (!isGoOn) continue;
                for (DynamicObject detail : entry) {
                    long sourceBillId = detail.getLong("e_sourcebillid");
                    srcBillNo = (String)excessFinMap.get(sourceBillId);
                    if (ObjectUtils.isEmpty((Object)srcBillNo)) continue;
                    errorMessage = this.returnErrorMessage(isAr, detail.getInt("seq"), srcBillNo);
                    result.put(casBill.getLong("id"), errorMessage);
                    continue block2;
                }
            }
        }
        logger.info("CasPayBillExcessValidator directArApValidator result :" + result);
        return result;
    }

    private Map<Long, String> directApApplyValidator(List<DynamicObject> directApApplyBills) {
        if (ObjectUtils.isEmpty(directApApplyBills)) {
            return new HashMap<Long, String>(8);
        }
        logger.info("CasPayBillExcessValidator directApApplyValidator begin");
        ArrayList<Long> applyBillIds = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject casBill : directApApplyBills) {
            DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
            for (DynamicObject casDetailRow : entry) {
                applyBillIds.add(casDetailRow.getLong("e_sourcebillid"));
                orgIds.add(casDetailRow.getLong("settleorg.id"));
            }
        }
        String selectors = "id,entry.id,entry.e_approvedamt,billno,entry.e_approvedseleamt,settlecurrency,paycurrency";
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply_bills", (String)"ap_payapply", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}, (String)"");
        HashMap<Long, BigDecimal> applyAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, Object> applyRowAmountMap = new HashMap<Long, Object>(64);
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(64);
        HashMap<Long, String> difCurrencyMap = new HashMap<Long, String>(64);
        for (Row applyBill : applyDataSet) {
            Long settleCurrencyId;
            long applyId = applyBill.getLong("id");
            long entryId = applyBill.getLong("entry.id");
            Iterator e_approvedamt = applyBill.getBigDecimal("entry.e_approvedamt");
            BigDecimal applyAmount = applyAmountMap.getOrDefault(applyId, BigDecimal.ZERO);
            applyAmount = applyAmount.add((BigDecimal)((Object)e_approvedamt));
            applyAmountMap.put(applyId, applyAmount);
            applyRowAmountMap.put(entryId, e_approvedamt);
            billNoMap.put(applyId, applyBill.getString("billno"));
            Long payCurrencyId = applyBill.getLong("paycurrency");
            if (payCurrencyId.equals(settleCurrencyId = applyBill.getLong("settlecurrency"))) continue;
            difCurrencyMap.put(applyId, applyBill.getString("billno"));
        }
        HashMap<Long, String> errorMessage = new HashMap<Long, String>(64);
        HashSet<Long> excessApplyIds = new HashSet<Long>(64);
        for (DynamicObject casBill : directApApplyBills) {
            HashMap<Long, BigDecimal> sumApplyAmountMap = new HashMap<Long, BigDecimal>(64);
            DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
            for (DynamicObject casRow : entry) {
                BigDecimal applyRowAmount;
                boolean isExcess;
                long srcBillId = casRow.getLong("e_sourcebillid");
                long srcEntryId = casRow.getLong("e_sourcebillentryid");
                BigDecimal casEntryAmount = casRow.getBigDecimal("e_payableamt").subtract(casRow.getBigDecimal("e_refundamt"));
                BigDecimal sumApplyAmount = sumApplyAmountMap.getOrDefault(srcBillId, BigDecimal.ZERO);
                sumApplyAmount = sumApplyAmount.add(casEntryAmount);
                sumApplyAmountMap.put(srcBillId, sumApplyAmount);
                if (!this.isValidateEntry || !(isExcess = this.isExcessPay(casEntryAmount, applyRowAmount = applyRowAmountMap.getOrDefault(srcEntryId, BigDecimal.ZERO), false))) continue;
                excessApplyIds.add(srcBillId);
            }
            if (!this.isValidateBill) continue;
            for (Map.Entry entrySet : sumApplyAmountMap.entrySet()) {
                BigDecimal applyAmount;
                Long srcBillId = (Long)entrySet.getKey();
                BigDecimal sumApplyAmount = (BigDecimal)entrySet.getValue();
                boolean isExcess = this.isExcessPay(sumApplyAmount, applyAmount = applyAmountMap.getOrDefault(srcBillId, BigDecimal.ZERO), false);
                if (!isExcess) continue;
                excessApplyIds.add(srcBillId);
            }
        }
        String casSelectors = "entry.e_payableamt,entry.e_refundamt,entry.e_sourcebillid,entry.e_sourcebillentryid";
        QFilter filter = new QFilter("entry.e_sourcebillid", "in", applyBillIds);
        filter.and("billstatus", "not in", Arrays.asList("G", "H"));
        filter.and("entry.settleorg", "in", orgIds);
        DataSet casPayBillData = QueryServiceHelper.queryDataSet((String)"query_cas_bills", (String)"cas_paybill", (String)casSelectors, (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, BigDecimal> casSrcRowAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> casSrcBillAmountMap = new HashMap<Long, BigDecimal>(64);
        for (Row casPayBill : casPayBillData) {
            Long srcBillId = casPayBill.getLong("entry.e_sourcebillid");
            Long srcEntryId = casPayBill.getLong("entry.e_sourcebillentryid");
            BigDecimal casEntryAmount = casPayBill.getBigDecimal("entry.e_payableamt").subtract(casPayBill.getBigDecimal("entry.e_refundamt"));
            BigDecimal srcRowAmount = casSrcRowAmountMap.getOrDefault(srcEntryId, BigDecimal.ZERO);
            srcRowAmount = srcRowAmount.add(casEntryAmount);
            casSrcRowAmountMap.put(srcEntryId, srcRowAmount);
            BigDecimal srcBillAmount = casSrcBillAmountMap.getOrDefault(srcBillId, BigDecimal.ZERO);
            srcBillAmount = srcBillAmount.add(casEntryAmount);
            casSrcBillAmountMap.put(srcBillId, srcBillAmount);
        }
        if (this.isValidateBill) {
            for (Map.Entry entrySet : applyAmountMap.entrySet()) {
                Long applyId = (Long)entrySet.getKey();
                BigDecimal applySumAmount = (BigDecimal)entrySet.getValue();
                BigDecimal casSrcBillAmount = casSrcBillAmountMap.getOrDefault(applyId, BigDecimal.ZERO);
                boolean isExcess = this.isExcessPay(casSrcBillAmount, applySumAmount, false);
                if (!isExcess) continue;
                excessApplyIds.add(applyId);
            }
        }
        if (this.isValidateEntry) {
            for (Map.Entry entrySet : applyRowAmountMap.entrySet()) {
                Long applyRowId = (Long)entrySet.getKey();
                BigDecimal approvedAmt = (BigDecimal)entrySet.getValue();
                BigDecimal casSrcRowAmount = casSrcRowAmountMap.getOrDefault(applyRowId, BigDecimal.ZERO);
                boolean isExcess = this.isExcessPay(casSrcRowAmount, approvedAmt, false);
                if (!isExcess) continue;
                excessApplyIds.add(applyRowId);
            }
        }
        if (excessApplyIds.isEmpty()) {
            return errorMessage;
        }
        block9: for (DynamicObject casBill : directApApplyBills) {
            long sourceBillId;
            DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
            boolean isGoOn = true;
            for (DynamicObject casDetailRow : entry) {
                sourceBillId = casDetailRow.getLong("e_sourcebillid");
                long sourceEntryId = casDetailRow.getLong("e_sourcebillentryid");
                if (!excessApplyIds.contains(sourceEntryId)) continue;
                if (difCurrencyMap.get(sourceBillId) == null) {
                    errorMessage.put(casBill.getLong("id"), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u6838\u51c6\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), casDetailRow.getInt("seq"), billNoMap.get(sourceBillId)));
                    isGoOn = false;
                    break;
                }
                errorMessage.put(casBill.getLong("id"), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), casDetailRow.getInt("seq"), billNoMap.get(sourceBillId)));
                isGoOn = false;
                break;
            }
            if (!isGoOn) continue;
            for (DynamicObject casDetailRow : entry) {
                sourceBillId = casDetailRow.getLong("e_sourcebillid");
                if (!excessApplyIds.contains(sourceBillId)) continue;
                if (difCurrencyMap.get(sourceBillId) == null) {
                    errorMessage.put(casBill.getLong("id"), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u6838\u51c6\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), casDetailRow.getInt("seq"), billNoMap.get(sourceBillId)));
                    continue block9;
                }
                errorMessage.put(casBill.getLong("id"), String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), casDetailRow.getInt("seq"), billNoMap.get(sourceBillId)));
                continue block9;
            }
        }
        return errorMessage;
    }

    private Map<Long, String> downTarExcessValidator(Set<Long> billIds, Map<Long, List<DynamicObject>> casDetailMap, Map<Long, BigDecimal> casSrcFinAmountMap, boolean isAr) {
        boolean isExcess;
        BigDecimal srcEntryAmt;
        Object settleMode;
        Set entryIds;
        long billId;
        logger.info("CasPayBillExcessValidator downTarExcessValidator begin .");
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (billIds.isEmpty()) {
            return result;
        }
        String entityKey = isAr ? "ar_finarbill" : "ap_finapbill";
        BillModel billModel = BillModelFactory.getModel(entityKey);
        List<String> detailSelectors = Arrays.asList("id", billModel.HEAD_ORG, billModel.ENTRY + "." + billModel.E_PRICETAXTOTAL + " " + billModel.E_PRICETAXTOTAL, billModel.ENTRY_PK, billModel.HEAD_PRICETAXTOTAL, billModel.HEAD_BILLNO);
        List<String> planSelectors = Arrays.asList("id", billModel.HEAD_ORG, billModel.P_ENTRY_PK, billModel.P_ENTRY + "." + billModel.P_PLANPRICETAX + " " + billModel.P_PLANPRICETAX);
        DataSet detailBills = QueryServiceHelper.queryDataSet((String)"downTarExcessValidator", (String)entityKey, (String)String.join((CharSequence)",", detailSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, null);
        if (detailBills.isEmpty()) {
            return result;
        }
        DataSet planBills = QueryServiceHelper.queryDataSet((String)"downTarExcessValidator", (String)entityKey, (String)String.join((CharSequence)",", planSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, null);
        HashSet<Long> orgIds = new HashSet<Long>(64);
        DataSet orgInfo = detailBills.copy();
        for (Row info : orgInfo) {
            orgIds.add(info.getLong(billModel.HEAD_ORG));
        }
        String settleModelKey = isAr ? "ar_003" : "ap_003";
        Map<Long, Object> settleModelMap = SystemParameterHelper.batchGetAppParameter(isAr, new ArrayList<Long>(orgIds), settleModelKey);
        HashMap<Long, BigDecimal> finBillAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, BigDecimal> finEntryAmountMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, Set> finEntryIdMap = new HashMap<Long, Set>(64);
        HashSet<Long> detailRowIds = new HashSet<Long>(64);
        HashSet<Long> planRowIds = new HashSet<Long>(64);
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(64);
        for (Row row : detailBills) {
            finBillAmountMap.put(row.getLong("id"), row.getBigDecimal(billModel.HEAD_PRICETAXTOTAL));
            finEntryAmountMap.put(row.getLong(billModel.ENTRY_PK), row.getBigDecimal(billModel.E_PRICETAXTOTAL));
            billId = row.getLong("id");
            entryIds = finEntryIdMap.getOrDefault(billId, new HashSet(64));
            entryIds.add(row.getLong(billModel.ENTRY_PK));
            finEntryIdMap.put(billId, entryIds);
            settleMode = settleModelMap.get(row.getLong(billModel.HEAD_ORG));
            if ("1".equals(settleMode)) {
                detailRowIds.add(row.getLong(billModel.ENTRY_PK));
            }
            billNoMap.put(billId, row.getString(billModel.HEAD_BILLNO));
        }
        for (Row row : planBills) {
            finEntryAmountMap.put(row.getLong(billModel.P_ENTRY_PK), row.getBigDecimal(billModel.P_PLANPRICETAX));
            billId = row.getLong("id");
            entryIds = finEntryIdMap.getOrDefault(billId, new HashSet(64));
            entryIds.add(row.getLong(billModel.P_ENTRY_PK));
            finEntryIdMap.put(billId, entryIds);
            settleMode = settleModelMap.get(row.getLong(billModel.HEAD_ORG));
            if (!"2".equals(settleMode)) continue;
            planRowIds.add(row.getLong(billModel.P_ENTRY_PK));
        }
        if (this.isValidateEntry) {
            for (Map.Entry<Long, Object> entry : casDetailMap.entrySet()) {
                List casDetails = (List)entry.getValue();
                for (DynamicObject casDetailRow : casDetails) {
                    boolean isExcess2;
                    BigDecimal ePayableAmt = casDetailRow.getBigDecimal("e_payableamt");
                    long sourceEntryId = casDetailRow.getLong("e_sourcebillentryid");
                    long sourceBillId = casDetailRow.getLong("e_sourcebillid");
                    srcEntryAmt = (BigDecimal)finEntryAmountMap.get(sourceEntryId);
                    if (srcEntryAmt == null || !(isExcess2 = this.isExcessPay(ePayableAmt, srcEntryAmt, isAr))) continue;
                    result.put(sourceEntryId, (String)billNoMap.get(sourceBillId));
                }
            }
        }
        if (this.isValidateBill) {
            for (Map.Entry<Long, Object> entry : casSrcFinAmountMap.entrySet()) {
                boolean isExcess3;
                Long srcBillId = entry.getKey();
                BigDecimal srcBillAmt = (BigDecimal)finBillAmountMap.get(srcBillId);
                if (srcBillAmt == null || !(isExcess3 = this.isExcessPay((BigDecimal)entry.getValue(), srcBillAmt, isAr))) continue;
                result.put(srcBillId, (String)billNoMap.get(srcBillId));
            }
        }
        Map<Long, Set<Long>> targetRowIdsMap = this.getTargetRowRelationMap(billModel, entityKey, orgIds, finBillAmountMap.keySet(), detailRowIds, planRowIds);
        logger.info("CasPayBillExcessValidator downTarExcessValidator targetRowIdsMap:" + targetRowIdsMap);
        if (targetRowIdsMap.isEmpty()) {
            return result;
        }
        HashSet hashSet = new HashSet(64);
        for (Map.Entry<Long, Set<Long>> entrySet : targetRowIdsMap.entrySet()) {
            hashSet.addAll(entrySet.getValue());
        }
        QFilter filter = new QFilter("entry.id", "in", hashSet);
        filter.and("billstatus", "not in", Arrays.asList("G", "H"));
        DataSet casDataSet = QueryServiceHelper.queryDataSet((String)"query_cas_paybill", (String)"cas_paybill", (String)"entry.id entryid,entry.e_payableamt e_payableamt,entry.e_refundamt e_refundamt", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, BigDecimal> casAmountMap = new HashMap<Long, BigDecimal>(64);
        for (Row row : casDataSet) {
            casAmountMap.put(row.getLong("entryid"), row.getBigDecimal("e_payableamt").subtract(row.getBigDecimal("e_refundamt")));
        }
        if (this.isValidateEntry) {
            HashSet<Long> excessEntryIds = new HashSet<Long>(64);
            for (Map.Entry<Long, Set<Long>> entry : targetRowIdsMap.entrySet()) {
                Long srcEntryId = entry.getKey();
                Set<Long> tarCasEntryIds = entry.getValue();
                srcEntryAmt = (BigDecimal)finEntryAmountMap.get(srcEntryId);
                if (srcEntryAmt == null) continue;
                BigDecimal casAmountSum = BigDecimal.ZERO;
                for (Map.Entry<Long, List<DynamicObject>> objectEntry : casDetailMap.entrySet()) {
                    Long sourceEntryId = objectEntry.getKey();
                    List<DynamicObject> casDetailRows = objectEntry.getValue();
                    Iterator<DynamicObject> iterator = casDetailRows.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject casDetailRow = iterator.next();
                        if (!sourceEntryId.equals(srcEntryId) || tarCasEntryIds.contains(casDetailRow.getLong("id"))) continue;
                        BigDecimal casAmount = casDetailRow.getBigDecimal("e_payableamt");
                        casAmountSum = casAmountSum.add(casAmount);
                    }
                }
                Iterator<Object> iterator = tarCasEntryIds.iterator();
                while (iterator.hasNext()) {
                    Long casEntryId = (Long)iterator.next();
                    casAmountSum = casAmountSum.add(casAmountMap.getOrDefault(casEntryId, BigDecimal.ZERO));
                }
                isExcess = this.isExcessPay(casAmountSum, srcEntryAmt, isAr);
                if (!isExcess) continue;
                excessEntryIds.add(srcEntryId);
            }
            logger.info("CasPayBillExcessValidator downTarExcessValidator excessEntryIds is\uff1a" + excessEntryIds);
            if (!excessEntryIds.isEmpty()) {
                for (Map.Entry<Long, Set<Long>> entry : finEntryIdMap.entrySet()) {
                    Long finBillId = entry.getKey();
                    for (Long finEntryId : entry.getValue()) {
                        if (!excessEntryIds.contains(finEntryId)) continue;
                        result.put(finEntryId, (String)billNoMap.get(finBillId));
                    }
                }
            }
        }
        if (this.isValidateBill) {
            Map<Long, BigDecimal> notBOTPCasMap = this.getNotBOTPCasMap(targetRowIdsMap, casDetailMap);
            for (Map.Entry entry : finEntryIdMap.entrySet()) {
                Long finBillId = (Long)entry.getKey();
                BigDecimal finAmount = finBillAmountMap.getOrDefault(finBillId, BigDecimal.ZERO);
                Set entryIds2 = (Set)entry.getValue();
                BigDecimal tarCasBillAmountSum = BigDecimal.ZERO;
                for (Long entryId : entryIds2) {
                    Set<Long> tempCasEntryIds = targetRowIdsMap.get(entryId);
                    if (ObjectUtils.isEmpty(tempCasEntryIds)) continue;
                    for (Long casEntryId : tempCasEntryIds) {
                        tarCasBillAmountSum = tarCasBillAmountSum.add(casAmountMap.getOrDefault(casEntryId, BigDecimal.ZERO));
                    }
                    BigDecimal notBOTPCasAmount = notBOTPCasMap.getOrDefault(entryId, BigDecimal.ZERO);
                    tarCasBillAmountSum = tarCasBillAmountSum.add(notBOTPCasAmount);
                }
                isExcess = this.isExcessPay(tarCasBillAmountSum, finAmount, isAr);
                if (!isExcess) continue;
                result.put(finBillId, (String)billNoMap.get(finBillId));
            }
        }
        return result;
    }

    private Map<Long, Set<Long>> getTargetRowRelationMap(BillModel billModel, String entityKey, Set<Long> orgIds, Set<Long> finBillIds, Set<Long> detailRowIds, Set<Long> planRowIds) {
        List<Long> casPayBillIds;
        Map<Long, Map<String, List<Long>>> allTargetRowIds;
        HashMap<Long, Set<Long>> targetRowIdsMap = new HashMap<Long, Set<Long>>(8);
        if (!detailRowIds.isEmpty()) {
            allTargetRowIds = BOTPNewHelper.loadAllTargetRowIds(entityKey, billModel.ENTRY, finBillIds.toArray(new Long[0]), detailRowIds.toArray(new Long[0]));
            for (Map.Entry<Long, Map<String, List<Long>>> entrySet : allTargetRowIds.entrySet()) {
                casPayBillIds = (List<Long>)((Map)entrySet.getValue()).get("cas_paybill");
                if (ObjectUtils.isEmpty((Object)casPayBillIds)) continue;
                targetRowIdsMap.put(entrySet.getKey(), new HashSet<Long>(casPayBillIds));
            }
        }
        if (!planRowIds.isEmpty()) {
            allTargetRowIds = BOTPNewHelper.loadAllTargetRowIds(entityKey, billModel.P_ENTRY, finBillIds.toArray(new Long[0]), planRowIds.toArray(new Long[0]));
            for (Map.Entry<Long, Map<String, List<Long>>> entrySet : allTargetRowIds.entrySet()) {
                casPayBillIds = entrySet.getValue().get("cas_paybill");
                if (ObjectUtils.isEmpty(casPayBillIds)) continue;
                targetRowIdsMap.put(entrySet.getKey(), new HashSet<Long>(casPayBillIds));
            }
        }
        if (!targetRowIdsMap.isEmpty()) {
            ArrayList allCasRowIds = new ArrayList(64);
            ArrayList<Long> allCasBillIds = new ArrayList<Long>(32);
            for (Map.Entry entrySet : targetRowIdsMap.entrySet()) {
                allCasRowIds.addAll((Collection)entrySet.getValue());
            }
            QFilter filter = new QFilter("entry.id", "in", allCasRowIds);
            filter.and(new QFilter("entry.settleorg", "in", orgIds));
            DataSet casPayBillDataSet = QueryServiceHelper.queryDataSet((String)"query_cas_id", (String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
            for (Row row : casPayBillDataSet) {
                allCasBillIds.add(row.getLong("id"));
            }
            Map<Long, Long> loadNearSourceRowIds = BOTPNewHelper.loadNearSourceRowIds("cas_paybill", "entry", allCasBillIds.toArray(new Long[0]), allCasRowIds.toArray(new Long[0]), entityKey);
            QFilter qFilter = new QFilter("org.id", "in", orgIds);
            qFilter.and(billModel.HEAD_SOURCEBILLTYPE, "=", (Object)entityKey);
            qFilter.and(billModel.HEAD_BILLTYPE + ".number", "=", (Object)("ap_finapbill".equals(entityKey) ? "ApFin_borr_BT_S" : "arfin_borrowar_BT_S"));
            HashSet<Long> allAdjustEntryIds = new HashSet<Long>(32);
            DataSet finDetailDataSet = QueryServiceHelper.queryDataSet((String)"query_fin_detail", (String)entityKey, (String)(billModel.ENTRY + ".id"), (QFilter[])new QFilter[]{qFilter, new QFilter(billModel.ENTRY + ".id", "in", loadNearSourceRowIds.values())}, (String)"");
            for (Object row : finDetailDataSet) {
                allAdjustEntryIds.add(row.getLong(billModel.ENTRY + ".id"));
            }
            DataSet finPlanDataSet = QueryServiceHelper.queryDataSet((String)"query_fin_plan", (String)entityKey, (String)(billModel.P_ENTRY + ".id"), (QFilter[])new QFilter[]{qFilter, new QFilter(billModel.P_ENTRY + ".id", "in", loadNearSourceRowIds.values())}, (String)"");
            for (Row row : finPlanDataSet) {
                allAdjustEntryIds.add(row.getLong(billModel.P_ENTRY + ".id"));
            }
            Iterator iterator = targetRowIdsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                Long finRowId = (Long)next.getKey();
                Set casRowIds = (Set)next.getValue();
                Iterator iterator1 = casRowIds.iterator();
                while (iterator1.hasNext()) {
                    Long casRowId = (Long)iterator1.next();
                    Long nearFinRowId = loadNearSourceRowIds.get(casRowId);
                    if (nearFinRowId == null || !allAdjustEntryIds.contains(nearFinRowId) || finRowId.equals(nearFinRowId)) continue;
                    iterator1.remove();
                }
                if (!casRowIds.isEmpty()) continue;
                iterator.remove();
            }
        }
        return targetRowIdsMap;
    }

    private Map<Long, BigDecimal> getNotBOTPCasMap(Map<Long, Set<Long>> targetRowIdsMap, Map<Long, List<DynamicObject>> casDetailMap) {
        HashMap<Long, BigDecimal> notBOTPCasMap = new HashMap<Long, BigDecimal>(8);
        HashSet hasBOTPRowIds = new HashSet(64);
        for (Map.Entry<Long, Set<Long>> entry : targetRowIdsMap.entrySet()) {
            hasBOTPRowIds.addAll(entry.getValue());
        }
        for (Map.Entry<Long, Collection<Long>> entry : casDetailMap.entrySet()) {
            Long srcRowId = entry.getKey();
            List casDetailRows = (List)entry.getValue();
            for (DynamicObject casDetailRow : casDetailRows) {
                if (hasBOTPRowIds.contains(casDetailRow.getLong("id"))) continue;
                BigDecimal ePayableAmt = casDetailRow.getBigDecimal("e_payableamt");
                BigDecimal amount = notBOTPCasMap.getOrDefault(srcRowId, BigDecimal.ZERO);
                amount = amount.add(ePayableAmt);
                notBOTPCasMap.put(srcRowId, amount);
            }
        }
        return notBOTPCasMap;
    }

    private boolean isExcessPay(BigDecimal casRowPayAmt, BigDecimal priceTaxTotal, boolean isAr) {
        if (priceTaxTotal.signum() == 0 && casRowPayAmt.signum() != 0) {
            return true;
        }
        if (priceTaxTotal.signum() != 0 && casRowPayAmt.abs().compareTo(priceTaxTotal.abs()) > 0) {
            return true;
        }
        if (!isAr && casRowPayAmt.signum() != 0 && casRowPayAmt.signum() != priceTaxTotal.signum()) {
            return true;
        }
        return isAr && casRowPayAmt.signum() != 0 && casRowPayAmt.multiply(priceTaxTotal).signum() > 0;
    }

    private String returnErrorMessage(boolean isAr, int seq, String srcBillNo) {
        return isAr ? String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u8d22\u52a1\u5e94\u6536\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u8d22\u52a1\u5e94\u6536\u5355\u7684\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, srcBillNo) : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355%2$s\u6240\u5173\u8054\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayBillExcessValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), seq, srcBillNo);
    }
}

