/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class CasPayEntryExcessBySrcIdValidator
implements IOthersExecCtrlService {
    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.seq");
        selectors.add("entry.settleorg");
        selectors.add("entry.e_payableamt");
        selectors.add("entry.e_refundamt");
        selectors.add("entry.e_sourcebillid");
        selectors.add("entry.e_sourcebillentryid");
        selectors.add("sourcebilltype");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        HashMap<Long, String> result = new HashMap<Long, String>(32);
        ArrayList<DynamicObject> directFinApBills = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> directFinArBills = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> directApplyBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject casBill : others) {
            String sourceBillType = casBill.getString("sourcebilltype");
            if ("ap_finapbill".equals(sourceBillType)) {
                directFinApBills.add(casBill);
                continue;
            }
            if ("ap_payapply".equals(sourceBillType)) {
                directApplyBills.add(casBill);
                continue;
            }
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            directFinArBills.add(casBill);
        }
        result.putAll(this.directFinApValidator(directFinApBills));
        result.putAll(this.directFinArValidator(directFinArBills));
        result.putAll(this.directApplyValidator(directApplyBills));
        return result;
    }

    private Map<Long, String> directFinApValidator(List<DynamicObject> directFinApBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        if (directFinApBills.isEmpty()) {
            return result;
        }
        ArrayList<Long> finApBillIds = new ArrayList<Long>(32);
        ArrayList<Long> finApRowIds = new ArrayList<Long>(32);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject payBill : directFinApBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (Object casRow : entry) {
                finApBillIds.add(casRow.getLong("e_sourcebillid"));
                finApRowIds.add(casRow.getLong("e_sourcebillentryid"));
                orgIds.add(casRow.getLong("settleorg.id"));
            }
        }
        Map<Long, BigDecimal> finApRowId4casRowSumAmtMap = this.getSourceRowId4casRowSumAmtMap(orgIds, finApBillIds, finApRowIds);
        DataSet finApDateSet = QueryServiceHelper.queryDataSet((String)"query_fin_ap", (String)"ap_finapbill", (String)"id,billno,detailentry.id,detailentry.e_pricetaxtotal,planentity.id,planentity.planpricetax", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
        HashMap<Long, BigDecimal> finApRowAmtMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, String> finApBillNoMap = new HashMap<Long, String>(32);
        for (Row finApRow : finApDateSet) {
            Long billId = finApRow.getLong("id");
            String billNo = finApRow.getString("billno");
            Long detailEntryId = finApRow.getLong("detailentry.id");
            BigDecimal detailEntryAmt = finApRow.getBigDecimal("detailentry.e_pricetaxtotal");
            Long planEntityId = finApRow.getLong("planentity.id");
            BigDecimal planEntityAmt = finApRow.getBigDecimal("planentity.planpricetax");
            if (!finApBillNoMap.containsKey(billId)) {
                finApBillNoMap.put(billId, billNo);
            }
            if (!finApRowAmtMap.containsKey(detailEntryId)) {
                finApRowAmtMap.put(detailEntryId, detailEntryAmt);
            }
            if (finApRowAmtMap.containsKey(planEntityId)) continue;
            finApRowAmtMap.put(planEntityId, planEntityAmt);
        }
        HashSet<Long> excessFinApRowIds = new HashSet<Long>(16);
        for (Map.Entry<Long, BigDecimal> entrySet : finApRowId4casRowSumAmtMap.entrySet()) {
            boolean excessPay;
            Long finApRowId = entrySet.getKey();
            BigDecimal casRowSumAmt = entrySet.getValue();
            BigDecimal finApRowAmt = (BigDecimal)finApRowAmtMap.get(finApRowId);
            if (finApRowAmt == null || !(excessPay = this.isExcessPay(casRowSumAmt, finApRowAmt, false))) continue;
            excessFinApRowIds.add(finApRowId);
        }
        if (excessFinApRowIds.isEmpty()) {
            return result;
        }
        block4: for (DynamicObject payBill : directFinApBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject casRow : entry) {
                long eSourceBillEntryId = casRow.getLong("e_sourcebillentryid");
                if (!excessFinApRowIds.contains(eSourceBillEntryId)) continue;
                long eSourceBillId = casRow.getLong("e_sourcebillid");
                int seq = casRow.getInt("seq");
                String errorMessage = this.returnErrorMessage(false, seq, (String)finApBillNoMap.get(eSourceBillId));
                result.put(payBill.getLong("id"), errorMessage);
                continue block4;
            }
        }
        return result;
    }

    private Map<Long, String> directFinArValidator(List<DynamicObject> directFinArBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        if (directFinArBills.isEmpty()) {
            return result;
        }
        ArrayList<Long> finArBillIds = new ArrayList<Long>(32);
        ArrayList<Long> finArRowIds = new ArrayList<Long>(32);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject payBill : directFinArBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (Object casRow : entry) {
                finArBillIds.add(casRow.getLong("e_sourcebillid"));
                finArRowIds.add(casRow.getLong("e_sourcebillentryid"));
                orgIds.add(casRow.getLong("settleorg.id"));
            }
        }
        Map<Long, BigDecimal> finArRowId4casRowSumAmtMap = this.getSourceRowId4casRowSumAmtMap(orgIds, finArBillIds, finArRowIds);
        DataSet finArDateSet = QueryServiceHelper.queryDataSet((String)"query_fin_ar", (String)"ar_finarbill", (String)"id,billno,entry.id,entry.e_recamount,planentity.id,planentity.planpricetax", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
        HashMap<Long, BigDecimal> finArRowAmtMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, String> finArBillNoMap = new HashMap<Long, String>(32);
        for (Row finArRow : finArDateSet) {
            Long billId = finArRow.getLong("id");
            String billNo = finArRow.getString("billno");
            Long entryId = finArRow.getLong("entry.id");
            BigDecimal entryAmt = finArRow.getBigDecimal("entry.e_recamount");
            Long planEntityId = finArRow.getLong("planentity.id");
            BigDecimal planEntityAmt = finArRow.getBigDecimal("planentity.planpricetax");
            if (!finArBillNoMap.containsKey(billId)) {
                finArBillNoMap.put(billId, billNo);
            }
            if (!finArRowAmtMap.containsKey(entryId)) {
                finArRowAmtMap.put(entryId, entryAmt);
            }
            if (finArRowAmtMap.containsKey(planEntityId)) continue;
            finArRowAmtMap.put(planEntityId, planEntityAmt);
        }
        HashSet<Long> excessFinArRowIds = new HashSet<Long>(16);
        for (Map.Entry<Long, BigDecimal> entrySet : finArRowId4casRowSumAmtMap.entrySet()) {
            boolean excessPay;
            Long finApRowId = entrySet.getKey();
            BigDecimal casRowSumAmt = entrySet.getValue();
            BigDecimal finArRowAmt = (BigDecimal)finArRowAmtMap.get(finApRowId);
            if (finArRowAmt == null || !(excessPay = this.isExcessPay(casRowSumAmt, finArRowAmt, true))) continue;
            excessFinArRowIds.add(finApRowId);
        }
        if (excessFinArRowIds.isEmpty()) {
            return result;
        }
        block4: for (DynamicObject payBill : directFinArBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject casRow : entry) {
                long eSourceBillEntryId = casRow.getLong("e_sourcebillentryid");
                if (!excessFinArRowIds.contains(eSourceBillEntryId)) continue;
                long eSourceBillId = casRow.getLong("e_sourcebillid");
                int seq = casRow.getInt("seq");
                String errorMessage = this.returnErrorMessage(true, seq, (String)finArBillNoMap.get(eSourceBillId));
                result.put(payBill.getLong("id"), errorMessage);
                continue block4;
            }
        }
        return result;
    }

    private Map<Long, String> directApplyValidator(List<DynamicObject> directApplyBills) {
        BigDecimal eApprovedAmt;
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        if (directApplyBills.isEmpty()) {
            return result;
        }
        ArrayList<Long> applyBillIds = new ArrayList<Long>(32);
        ArrayList<Long> applyRowIds = new ArrayList<Long>(32);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject payBill : directApplyBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject casRow : entry) {
                applyBillIds.add(casRow.getLong("e_sourcebillid"));
                applyRowIds.add(casRow.getLong("e_sourcebillentryid"));
                orgIds.add(casRow.getLong("settleorg.id"));
            }
        }
        Map<Long, BigDecimal> applyRowId4casRowSumAmtMap = this.getSourceRowId4casRowSumAmtMap(orgIds, applyBillIds, applyRowIds);
        DataSet applyDateSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,entry.id,entry.e_approvedamt,billno,paycurrency,settlecurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)}, (String)"");
        HashMap<Long, BigDecimal> applyRowAmtMap = new HashMap<Long, BigDecimal>(64);
        HashMap<Long, String> applyBillNoMap = new HashMap<Long, String>(32);
        HashSet<Long> noSameCurrencyApplyIds = new HashSet<Long>(32);
        for (Object applyRow : applyDateSet) {
            Long l = applyRow.getLong("id");
            String billNo = applyRow.getString("billno");
            Long entryId = applyRow.getLong("entry.id");
            eApprovedAmt = applyRow.getBigDecimal("entry.e_approvedamt");
            if (!applyBillNoMap.containsKey(l)) {
                applyBillNoMap.put(l, billNo);
            }
            applyRowAmtMap.put(entryId, eApprovedAmt);
            if (applyRow.getLong("paycurrency").equals(applyRow.getLong("settlecurrency"))) continue;
            noSameCurrencyApplyIds.add(l);
        }
        HashSet<Long> excessApplyRowIds = new HashSet<Long>(16);
        for (Map.Entry entry : applyRowId4casRowSumAmtMap.entrySet()) {
            boolean excessPay;
            Long applyRowId = (Long)entry.getKey();
            BigDecimal casRowSumAmt = (BigDecimal)entry.getValue();
            eApprovedAmt = (BigDecimal)applyRowAmtMap.get(applyRowId);
            if (eApprovedAmt == null || !(excessPay = this.isExcessPay(casRowSumAmt, eApprovedAmt, false))) continue;
            excessApplyRowIds.add(applyRowId);
        }
        if (excessApplyRowIds.isEmpty()) {
            return result;
        }
        String message = ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6309\u6e90\u5355ID\u67e5\u8be2\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u6e90\u5355\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u7684\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayEntryExcessBySrcIdValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        String string = ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6309\u6e90\u5355ID\u67e5\u8be2\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u6e90\u5355\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\u7684\u6838\u51c6\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayEntryExcessBySrcIdValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        block4: for (DynamicObject payBill : directApplyBills) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject casRow : entry) {
                long eSourceBillEntryId = casRow.getLong("e_sourcebillentryid");
                if (!excessApplyRowIds.contains(eSourceBillEntryId)) continue;
                long eSourceBillId = casRow.getLong("e_sourcebillid");
                int seq = casRow.getInt("seq");
                String errorMessage = noSameCurrencyApplyIds.contains(eSourceBillId) ? message : string;
                result.put(payBill.getLong("id"), String.format(errorMessage, seq, applyBillNoMap.get(eSourceBillId)));
                continue block4;
            }
        }
        return result;
    }

    private Map<Long, BigDecimal> getSourceRowId4casRowSumAmtMap(Set<Long> orgIds, List<Long> sourceBillIds, List<Long> sourceRowIds) {
        QFilter filter = new QFilter("billstatus", "not in", Arrays.asList("G", "H"));
        filter.and("entry.settleorg", "in", orgIds);
        filter.and(new QFilter("entry.e_sourcebillid", "in", sourceBillIds));
        filter.and(new QFilter("entry.e_sourcebillentryid", "in", sourceRowIds));
        DataSet casPayDataSet = QueryServiceHelper.queryDataSet((String)"query_cas_pay", (String)"cas_paybill", (String)"entry.id,entry.e_sourcebillentryid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, BigDecimal> sourceRowId4casRowSumAmtMap = new HashMap<Long, BigDecimal>(16);
        for (Row casRow : casPayDataSet) {
            Long finArRowId = casRow.getLong("entry.e_sourcebillentryid");
            BigDecimal casRowSumAmt = sourceRowId4casRowSumAmtMap.getOrDefault(finArRowId, BigDecimal.ZERO);
            casRowSumAmt = casRowSumAmt.add(casRow.getBigDecimal("entry.e_payableamt").subtract(casRow.getBigDecimal("entry.e_refundamt")));
            sourceRowId4casRowSumAmtMap.put(finArRowId, casRowSumAmt);
        }
        return sourceRowId4casRowSumAmtMap;
    }

    private boolean isExcessPay(BigDecimal casRowPayAmt, BigDecimal priceTaxTotal, boolean isAr) {
        if (priceTaxTotal.signum() == 0 && casRowPayAmt.signum() != 0) {
            return true;
        }
        if (priceTaxTotal.signum() != 0 && casRowPayAmt.abs().compareTo(priceTaxTotal.abs()) > 0) {
            return true;
        }
        if (!isAr && casRowPayAmt.signum() != 0 && casRowPayAmt.signum() != priceTaxTotal.signum()) {
            return true;
        }
        return isAr && casRowPayAmt.signum() != 0 && casRowPayAmt.multiply(priceTaxTotal).signum() > 0;
    }

    private String returnErrorMessage(boolean isAr, int seq, String srcBillNo) {
        return isAr ? String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6309\u6e90\u5355ID\u67e5\u8be2\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u6e90\u5355\u8d22\u52a1\u5e94\u6536\u5355%2$s\u7684\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayEntryExcessBySrcIdValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), seq, srcBillNo) : String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4ed8\u6b3e\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c\u6309\u6e90\u5355ID\u67e5\u8be2\u7684\u4ed8\u6b3e\u5904\u7406\u5e94\u4ed8\u91d1\u989d\u603b\u548c\u5927\u4e8e\u6e90\u5355\u8d22\u52a1\u5e94\u4ed8\u5355%2$s\u7684\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CasPayEntryExcessBySrcIdValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), seq, srcBillNo);
    }
}

