/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class CasRecSettleOrgValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(CasRecSettleOrgValidator.class);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.e_settleorg");
        selectors.add("entry.e_sourcebillid");
        selectors.add("sourcebilltype");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        logger.info("CasRecSettleOrgValidator validate begin");
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        for (DynamicObject other : others) {
            if (!"ar_finarbill".equals(other.getString("sourcebilltype"))) continue;
            DynamicObjectCollection entry = other.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                finArBillIds.add(detail.getLong("e_sourcebillid"));
            }
        }
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        if (finArBillIds.isEmpty()) {
            return result;
        }
        HashMap<Long, Long> srcBillOrgMap = new HashMap<Long, Long>(64);
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_org", (String)"ar_finarbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
        for (Row finArRow : finArDataSet) {
            srcBillOrgMap.put(finArRow.getLong("id"), finArRow.getLong("org"));
        }
        block3: for (DynamicObject other : others) {
            if (!"ar_finarbill".equals(other.getString("sourcebilltype"))) continue;
            long payBillId = other.getLong("id");
            DynamicObjectCollection entry = other.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                long settleOrgId = detail.getLong("e_settleorg.id");
                Long srcOrgId = (Long)srcBillOrgMap.get(detail.getLong("e_sourcebillid"));
                if (srcOrgId != null && srcOrgId == settleOrgId) continue;
                result.put(payBillId, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4e0a\u6e38\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u6536\u6b3e\u660e\u7ec6\u7ed3\u7b97\u7ec4\u7ec7\u9700\u4e0e\u4e0a\u6e38\u5355\u636e\u7ed3\u7b97\u7ec4\u7ec7\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u540e\u4fee\u6539\u3002", (String)"CasRecSettleOrgValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue block3;
            }
        }
        logger.info("CasRecSettleOrgValidator validate end");
        return result;
    }
}

