/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

@Deprecated
public class FinApQtyExcessValidator
extends AbstractExecControlValidator {
    private static final Log logger = LogFactory.getLog(FinApQtyExcessValidator.class);
    protected String entityName = "ap_finapbill";
    protected BillModel billModel = BillModelFactory.getModel(this.entityName);

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add(this.billModel.HEAD_SOURCEBILLTYPE);
        selectors.add(this.billModel.E_SEQ);
        selectors.add(this.billModel.E_SOURCEBILLID);
        selectors.add(this.billModel.E_SOURCEBILLENTRYID);
        selectors.add(this.billModel.E_BASEUNITQTY);
        return selectors;
    }

    public void validate() {
        logger.info("FinApQtyExcessValidator entityName is : " + this.entityName);
        ArrayList<ExtendedDataEntity> directPurInAps = new ArrayList<ExtendedDataEntity>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            if (!"im_purinbill".equals(finApBill.getString(this.billModel.HEAD_SOURCEBILLTYPE))) continue;
            directPurInAps.add(dataEntity);
        }
        logger.info("FinApQtyExcessValidator validate size : " + directPurInAps.size());
        if (directPurInAps.isEmpty()) {
            return;
        }
        Map<Long, String> excessPurInMessage = this.directBillValidator(directPurInAps);
        if (ObjectUtils.isEmpty(excessPurInMessage)) {
            return;
        }
        block1: for (ExtendedDataEntity directPurInAp : directPurInAps) {
            DynamicObject bill = directPurInAp.getDataEntity();
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject detailRow : detailEntry) {
                long eSourceEntryId = detailRow.getLong(this.billModel.E_SOURCEBILLENTRYID);
                String excessMessage = excessPurInMessage.get(eSourceEntryId);
                if (excessMessage == null) continue;
                String message = ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4e0b\u63a8\u98ce\u9669\uff0c\u5206\u5f55\u7b2c%1$s\u884c%2$s", (String)"FinApQtyExcessValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.addMessage(directPurInAp, String.format(message, detailRow.getInt("seq"), excessMessage));
                continue block1;
            }
        }
    }

    protected Map<Long, String> directBillValidator(List<ExtendedDataEntity> directPurInEntities) {
        HashSet<Long> purBillIds = new HashSet<Long>(64);
        HashSet<Long> needRemoveFinApEntryIds = new HashSet<Long>(64);
        HashMap<Long, BigDecimal> calculatePurBillQtyMap = new HashMap<Long, BigDecimal>(64);
        for (ExtendedDataEntity entity : directPurInEntities) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject[] detailRow : detailEntry) {
                needRemoveFinApEntryIds.add(detailRow.getLong("id"));
                purBillIds.add(detailRow.getLong(this.billModel.E_SOURCEBILLID));
                long purEntryId = detailRow.getLong(this.billModel.E_SOURCEBILLENTRYID);
                BigDecimal baseQty = calculatePurBillQtyMap.getOrDefault(purEntryId, BigDecimal.ZERO);
                baseQty = baseQty.add(detailRow.getBigDecimal(this.billModel.E_BASEUNITQTY));
                calculatePurBillQtyMap.put(purEntryId, baseQty);
            }
        }
        if (purBillIds.isEmpty()) {
            return new HashMap<Long, String>(8);
        }
        QFilter filter = new QFilter("id", "in", purBillIds);
        String selectors = "billno,billentry.id,billentry.baseqty,billentry.entrysettleorg,billentry.returnbaseqty";
        DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)"im_purinbill", (String)selectors, (QFilter[])new QFilter[]{filter});
        ArrayList<Long> purInEntryIds = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(64);
        for (DynamicObject purInBill : purInBills) {
            DynamicObjectCollection billEntry = purInBill.getDynamicObjectCollection("billentry");
            for (DynamicObject detailRow : billEntry) {
                purInEntryIds.add(detailRow.getLong("id"));
                orgIds.add(detailRow.getLong("entrysettleorg.id"));
            }
        }
        this.calculateAllPurBillQtyMap(calculatePurBillQtyMap, purInEntryIds, orgIds, needRemoveFinApEntryIds);
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        String billName = "ap_finapbill".equals(this.entityName) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"FinApQtyExcessValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355", (String)"FinApQtyExcessValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        for (DynamicObject purInBill : purInBills) {
            DynamicObjectCollection billEntry = purInBill.getDynamicObjectCollection("billentry");
            for (DynamicObject purInRow : billEntry) {
                BigDecimal purInQty = purInRow.getBigDecimal("baseqty").subtract(purInRow.getBigDecimal("returnbaseqty"));
                BigDecimal calculatePurBillQty = calculatePurBillQtyMap.getOrDefault(purInRow.getLong("id"), BigDecimal.ZERO);
                if (calculatePurBillQty.abs().compareTo(purInQty.abs()) <= 0 && calculatePurBillQty.multiply(purInQty).signum() >= 0) continue;
                String message = ResManager.loadKDString((String)"\u4e0a\u6e38\u91c7\u8d2d\u5165\u5e93\u5355%1$s\u6240\u5173\u8054\u7684%2$s\u57fa\u672c\u6570\u91cf[%3$s]\u603b\u548c\u5927\u4e8e\u91c7\u8d2d\u5165\u5e93\u5355\u7684\u57fa\u672c\u6570\u91cf-\u5df2\u9000\u5e93\u57fa\u672c\u6570\u91cf[%4$s]\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApQtyExcessValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                result.put(purInRow.getLong("id"), String.format(message, purInBill.getString("billno"), billName, calculatePurBillQty, purInQty));
            }
        }
        return result;
    }

    protected void calculateAllPurBillQtyMap(Map<Long, BigDecimal> calculatePurBillQtyMap, List<Long> purInEntryIds, Set<Long> orgIds, Set<Long> needRemoveFinApEntryIds) {
        Map<Long, Set<Long>> targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap("im_purinbill", "billentry", purInEntryIds.toArray(new Long[0]), this.entityName);
        if (ObjectUtils.isEmpty(targetRowIdsMap)) {
            return;
        }
        ArrayList finApEntryIds = new ArrayList(64);
        for (Map.Entry<Long, Set<Long>> entrySet : targetRowIdsMap.entrySet()) {
            finApEntryIds.addAll(entrySet.getValue());
        }
        finApEntryIds.removeAll(needRemoveFinApEntryIds);
        if (ObjectUtils.isEmpty(finApEntryIds)) {
            return;
        }
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.add(this.billModel.ENTRY_PK);
        selectors.add(this.billModel.ENTRY + "." + this.billModel.E_BASEUNITQTY + " " + this.billModel.E_BASEUNITQTY);
        QFilter filter = new QFilter(this.billModel.HEAD_ORG, "in", orgIds);
        filter.and(new QFilter(this.billModel.ENTRY_PK, "in", finApEntryIds));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"queryBill", (String)this.entityName, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, BigDecimal> billEntryQtyMap = new HashMap<Long, BigDecimal>(64);
        for (Row finApBill : finApDataSet) {
            billEntryQtyMap.put(finApBill.getLong(this.billModel.ENTRY_PK), finApBill.getBigDecimal(this.billModel.E_BASEUNITQTY));
        }
        for (Map.Entry<Long, Set<Long>> entrySet : targetRowIdsMap.entrySet()) {
            Long purInEntryId = entrySet.getKey();
            Set<Long> apEntryIds = entrySet.getValue();
            BigDecimal calculatePurBillQty = calculatePurBillQtyMap.getOrDefault(purInEntryId, BigDecimal.ZERO);
            for (Long apEntryId : apEntryIds) {
                BigDecimal apEntryQty = billEntryQtyMap.getOrDefault(apEntryId, BigDecimal.ZERO);
                calculatePurBillQty = calculatePurBillQty.add(apEntryQty);
            }
            calculatePurBillQtyMap.put(purInEntryId, calculatePurBillQty);
        }
    }
}

