/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;

public class FromEasBillValidator
extends AbstractValidator {
    public void validate() {
        if (!"unaudit".equals(this.getOperateKey())) {
            return;
        }
        Set<String> validateEntityKeys = this.getValidateEntityKeys();
        if (!validateEntityKeys.contains(this.getEntityKey())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String entityName = MetadataServiceHelper.getDataEntityType((String)this.getEntityKey()).getDisplayName().getLocaleValue();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!BillSrcTypeEnum.FROMEAS.getValue().equals(bill.getString("billsrctype"))) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684%2$s\u4e3aEAS\u96c6\u6210\u65b9\u6848\u540c\u6b65\u7684\u5355\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FromEasBillValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno"), entityName));
        }
    }

    private Set<String> getValidateEntityKeys() {
        HashSet<String> entityKeys = new HashSet<String>(8);
        entityKeys.add("ap_finapbill");
        entityKeys.add("ar_finarbill");
        entityKeys.add("ap_busbill");
        entityKeys.add("ar_busbill");
        entityKeys.add("ap_payapply");
        entityKeys.add("ap_paidbill");
        entityKeys.add("ar_receivedbill");
        entityKeys.add("ar_baddebtlossbill");
        return entityKeys;
    }
}

