/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.vo.ImportSettleVo;

public class ImportSettleSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ImportSettleSaveValidator.class);
    private final Map<String, Object> dataCache = new HashMap<String, Object>(2);
    private Map<String, Map<String, ImportSettleVo>> billMapGroupByType;

    public ImportSettleSaveValidator(Map<String, Map<String, ImportSettleVo>> billMapGroupByType) {
        this.billMapGroupByType = billMapGroupByType;
    }

    public void validate() {
        this.validator(this.billMapGroupByType);
    }

    private void validator(Map<String, Map<String, ImportSettleVo>> billMapGroupByType) {
        String entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        for (ExtendedDataEntity entity : this.dataEntities) {
            String message;
            int mainResult;
            String asstBillNo;
            Object message2;
            String message3;
            String message4;
            String message5;
            String message6;
            String message7;
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            String orgNumber = org.getString("number");
            String settleRelation = bill.getString("settlerelation");
            String relationName = SettleRelationEnum.getNameByValue(settleRelation);
            String mainEntity = bill.getString("billentity");
            String mainName = BillTypeEnum.getNameByValue(mainEntity);
            Map<String, ImportSettleVo> mainBills = billMapGroupByType.get(mainEntity);
            DynamicObject settleOrg = bill.getDynamicObject("org");
            String orgNum = settleOrg.getString("number");
            String mainBillNo = bill.getString("mainbillnum");
            BigDecimal mainCurrSettleAmt = bill.getBigDecimal("totalsettleamt");
            BigDecimal asstCanSettleAmt = BigDecimal.ZERO;
            BigDecimal asstCurrSettleAmt = BigDecimal.ZERO;
            HashSet<Long> asstCurrencyIds = new HashSet<Long>(2);
            boolean flag = false;
            ImportSettleVo mainVo = mainBills.get(mainBillNo);
            if (mainVo == null) {
                String message8 = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684%3$s\u3002", (String)"ImportSettleSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, mainBillNo, mainName);
                this.addErrorMessage(entity, message8);
                continue;
            }
            String mainOrgNum = mainVo.getOrgName();
            if (!orgNum.equals(mainOrgNum)) {
                message7 = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684%3$s\u3002", (String)"ImportSettleSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, mainBillNo, mainName);
                this.addErrorMessage(entity, message7);
                continue;
            }
            String mainBillStatus = mainVo.getStatus();
            if (("ap_finapbill".equals(mainEntity) || "ar_finarbill".equals(mainEntity)) && !"C".equals(mainBillStatus)) {
                message7 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{mainBillNo});
                this.addErrorMessage(entity, message7);
                continue;
            }
            if ("cas_paybill".equals(mainEntity) && !"D".equals(mainBillStatus) && !"F".equals(mainBillStatus) && !"I".equals(mainBillStatus)) {
                message7 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{mainBillNo});
                this.addErrorMessage(entity, message7);
                continue;
            }
            if ("cas_recbill".equals(mainEntity) && !"D".equals(mainBillStatus)) {
                message7 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{mainBillNo});
                this.addErrorMessage(entity, message7);
                continue;
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            if (entry.size() == 0) {
                String message9 = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684%3$s\u3002", (String)"ImportSettleSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, mainBillNo, mainName);
                this.addErrorMessage(entity, message9);
                continue;
            }
            for (DynamicObject asstBill : entry) {
                String asstEntity = asstBill.getString("e_billentity");
                String asstName = BillTypeEnum.getNameByValue(asstEntity);
                String asstBillNo2 = asstBill.getString("billnum");
                Map<String, ImportSettleVo> asstBills = billMapGroupByType.get(asstEntity);
                ImportSettleVo asstBillVo = asstBills.get(asstBillNo2);
                if (asstBillVo != null) {
                    asstCurrencyIds.add(asstBillVo.getCurrencyId());
                }
                if (asstBillVo == null) {
                    message6 = "appaysettle".equals(settleRelation) || "recsettle".equals(settleRelation) ? String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684\u5355\u636e\u3002", (String)"ImportSettleSaveValidator_19", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, asstBillNo2) : String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684%3$s\u3002", (String)"ImportSettleSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, asstBillNo2, asstName);
                    this.addErrorMessage(entity, message6);
                    flag = true;
                    break;
                }
                String asstOrgNum = asstBillVo.getOrgName();
                if (!orgNum.equals(asstOrgNum)) {
                    message5 = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684%3$s\u3002", (String)"ImportSettleSaveValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, asstBillNo2, asstName);
                    this.addErrorMessage(entity, message5);
                    flag = true;
                    break;
                }
                String asstBillStatus = asstBillVo.getStatus();
                if (("ap_finapbill".equals(asstEntity) || "ar_finarbill".equals(asstEntity)) && !"C".equals(asstBillStatus)) {
                    String message10 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{asstBillNo2});
                    this.addErrorMessage(entity, message10);
                    flag = true;
                    break;
                }
                if ("cas_paybill".equals(asstEntity) && !"D".equals(asstBillStatus) && !"F".equals(asstBillStatus) && !"I".equals(asstBillStatus)) {
                    String message11 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{asstBillNo2});
                    this.addErrorMessage(entity, message11);
                    flag = true;
                    break;
                }
                if ("cas_recbill".equals(asstEntity) && !"D".equals(asstBillStatus)) {
                    String message12 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ImportSettleSaveValidator_3", (String)"fi-arapcommon", (Object[])new Object[]{asstBillNo2});
                    this.addErrorMessage(entity, message12);
                    flag = true;
                    break;
                }
                asstCanSettleAmt = asstCanSettleAmt.add(asstBill.getBigDecimal("unsettledamt"));
                asstCurrSettleAmt = asstCurrSettleAmt.add(asstBill.getBigDecimal("settleamt"));
                int asstResult = asstCanSettleAmt.abs().compareTo(asstCurrSettleAmt.abs());
                if (asstResult >= 0) continue;
                message4 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportSettleSaveValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                this.addErrorMessage(entity, message4);
            }
            if (flag) continue;
            BigDecimal mainCanSettleAmt = bill.getBigDecimal("totalunsettledamt");
            BigDecimal mainPayableAmt = bill.getBigDecimal("mainpayableamt");
            String mainAsstactType = bill.getString("mainasstacttype");
            Long mainAsstactId = bill.getLong("mainasstactid.id");
            if ("arapsettle".equals(settleRelation) || "aparsettle".equals(settleRelation)) {
                Long mainBizPartnerId = this.getBizPartnerId(mainAsstactType, mainAsstactId);
                for (DynamicObject asstBill : entry) {
                    String asstAsstactType = asstBill.getString("asstacttype");
                    Long asstAsstactId = asstBill.getLong("asstactid.id");
                    Long asstBizPartnerId = this.getBizPartnerId(asstAsstactType, asstAsstactId);
                    if (mainBizPartnerId != null && asstBizPartnerId != null && Long.compare(mainBizPartnerId, asstBizPartnerId) == 0) continue;
                    message3 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s:%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u7684\u5f80\u6765\u7c7b\u578b\u5fc5\u987b\u4e3a\u5ba2\u6237\u6216\u4f9b\u5e94\u5546\uff0c\u5e76\u4e14\u5f80\u6765\u6237\u7684\u5546\u52a1\u4f19\u4f34\u5fc5\u987b\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportSettleSaveValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                    this.addErrorMessage(entity, message3);
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if (mainPayableAmt.signum() != mainCurrSettleAmt.signum()) {
                message2 = "ap_settleimport".equals(entityName) ? String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u3002", (String)"ImportSettleSaveValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName) : String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u4e0e\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u3002", (String)"ImportSettleSaveValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                this.addErrorMessage(entity, (String)message2);
                continue;
            }
            for (DynamicObject asstBill : entry) {
                asstBillNo = asstBill.getString("billnum");
                BigDecimal asstSettleAmt = asstBill.getBigDecimal("settleamt");
                BigDecimal asstPayableAmt = asstBill.getBigDecimal("payableamt");
                if (asstSettleAmt.signum() == asstPayableAmt.signum()) continue;
                message4 = "ap_settleimport".equals(entityName) ? String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u3002", (String)"ImportSettleSaveValidator_8", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillNo, relationName) : String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u5355\u636e\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u4e0e\u5e94\u6536\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u3002", (String)"ImportSettleSaveValidator_9", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillNo, relationName);
                this.addErrorMessage(entity, message4);
                flag = true;
                break;
            }
            if (flag) continue;
            if ("apself".equals(settleRelation) || "arself".equals(settleRelation) || "payself".equals(settleRelation) || "recself".equals(settleRelation)) {
                if (mainCanSettleAmt.compareTo(BigDecimal.ZERO) < 0) {
                    message2 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ImportSettleSaveValidator_10", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                    this.addErrorMessage(entity, (String)message2);
                    continue;
                }
                for (DynamicObject asstBill : entry) {
                    asstBillNo = asstBill.getString("billnum");
                    BigDecimal asstBillCanStAmt = asstBill.getBigDecimal("unsettledamt");
                    if (asstBillCanStAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    message5 = String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"ImportSettleSaveValidator_11", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillNo, relationName);
                    this.addErrorMessage(entity, message5);
                    flag = true;
                    break;
                }
            }
            if (flag) continue;
            if ("aprecsettle".equals(settleRelation) || "arpaysettle".equals(settleRelation)) {
                if (mainCanSettleAmt.compareTo(BigDecimal.ZERO) > 0) {
                    message2 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"ImportSettleSaveValidator_12", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                    this.addErrorMessage(entity, (String)message2);
                    continue;
                }
                for (DynamicObject asstBill : entry) {
                    BigDecimal asstBillCanStAmt = asstBill.getBigDecimal("unsettledamt");
                    String asstBillNo3 = asstBill.getString("billnum");
                    if (asstBillCanStAmt.compareTo(BigDecimal.ZERO) >= 0) continue;
                    message5 = String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ImportSettleSaveValidator_13", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillNo3, relationName);
                    this.addErrorMessage(entity, message5);
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ("appaysettle".equals(settleRelation) || "recsettle".equals(settleRelation) || "aparsettle".equals(settleRelation) || "arapsettle".equals(settleRelation) || "payrecsettle".equals(settleRelation) || "recpaysettle".equals(settleRelation)) {
                BigDecimal mainPayAbleAmt = bill.getBigDecimal("mainpayableamt");
                int mainDirection = mainPayAbleAmt.signum();
                for (DynamicObject asstBill : entry) {
                    BigDecimal asstPayAbleAmt = asstBill.getBigDecimal("payableamt");
                    int asstDirection = asstPayAbleAmt.signum();
                    if (mainDirection == asstDirection) continue;
                    message3 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportSettleSaveValidator_14", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                    this.addErrorMessage(entity, message3);
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ((mainResult = mainCanSettleAmt.abs().compareTo(mainCurrSettleAmt.abs())) < 0) {
                String message13 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportSettleSaveValidator_15", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                this.addErrorMessage(entity, message13);
                continue;
            }
            int asstResult = asstCanSettleAmt.abs().compareTo(asstCurrSettleAmt.abs());
            if (asstResult < 0) {
                message = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u8f85\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportSettleSaveValidator_16", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                this.addErrorMessage(entity, message);
                continue;
            }
            if (asstCurrencyIds.size() == 1) {
                Long mainCurrencyId = mainBills.get(mainBillNo).getCurrencyId();
                if (!asstCurrencyIds.contains(mainCurrencyId) || mainCurrSettleAmt.abs().compareTo(asstCurrSettleAmt.abs()) == 0) continue;
                message6 = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u76f8\u540c\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u76f8\u540c\u3002", (String)"ImportSettleSaveValidator_17", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo, relationName);
                this.addErrorMessage(entity, message6);
                continue;
            }
            message = ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7f16\u53f7%s\uff1a\u8f85\u65b9\u5e01\u79cd\u5fc5\u987b\u76f8\u540c\u3002", (String)"ImportSettleSaveValidator_18", (String)"fi-arapcommon", (Object[])new Object[]{mainBillNo});
            this.addErrorMessage(entity, message);
        }
    }

    public Long getBizPartnerId(String asstactType, Long asstactId) {
        if ("bd_customer".equals(asstactType)) {
            String key = "bd_customer" + asstactId;
            Long bizPartnerId = (Long)this.dataCache.get(key);
            if (bizPartnerId == null) {
                DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                bizPartnerId = customer.getLong("bizpartner.id");
                this.dataCache.put(key, bizPartnerId);
            }
            return bizPartnerId;
        }
        if ("bd_supplier".equals(asstactType)) {
            String key = "bd_supplier" + asstactId;
            Long bizPartnerId = (Long)this.dataCache.get(key);
            if (bizPartnerId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactId)});
                bizPartnerId = supplier.getLong("bizpartner.id");
                this.dataCache.put(key, bizPartnerId);
            }
            return bizPartnerId;
        }
        return null;
    }
}

