/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class LiquidationAuditValidator
extends AbstractValidator {
    private Boolean isAr;

    public LiquidationAuditValidator(Boolean isAr) {
        this.isAr = isAr;
    }

    public void validate() {
        Map<String, Set<Long>> sourceMap = this.getSourceId();
        for (Map.Entry<String, Set<Long>> entry : sourceMap.entrySet()) {
            String sourceBillType = entry.getKey();
            Set<Long> sourceIds = entry.getValue();
            if (sourceIds == null || sourceIds.size() <= 0) continue;
            if ("cas_recbill".equals(sourceBillType) || "ar_receivedbill".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) || "ap_paidbill".equals(sourceBillType)) {
                this.validateRecOrPay(sourceIds, sourceBillType);
                continue;
            }
            Map<String, BigDecimal> sourceAmt = this.getSourceAmt(sourceIds);
            this.validate(sourceAmt);
        }
    }

    private void validateRecOrPay(Set<Long> sourceIds, String billEntity) {
        HashMap<Long, BigDecimal> sourceAmt = new HashMap<Long, BigDecimal>(64);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billEntity, (String)"entry.id,entry.e_unsettledamt", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", sourceIds)});
        for (DynamicObject bill : bills) {
            Long entryId = bill.getLong("entry.id");
            BigDecimal unsettledAmt = bill.getBigDecimal("entry.e_unsettledamt");
            sourceAmt.put(entryId, unsettledAmt);
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal clearAmt;
                BigDecimal unsettledAmt;
                Long sourceEntryId = entryInfo.getLong("sourceentryid");
                if (sourceAmt.get(sourceEntryId) == null || (unsettledAmt = (BigDecimal)sourceAmt.get(sourceEntryId)).compareTo(clearAmt = entryInfo.getBigDecimal("unsettleamt")) == 0) continue;
                String message = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u65e0\u6cd5\u5b8c\u5168\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u6e05\u7406\u91d1\u989d\u3002", (String)"LiquidationAuditValidatoro_2", (String)"fi-arapcommon", (Object[])new Object[0]), entryInfo.getInt("seq"));
                this.addErrorMessage(entity, message);
            }
        }
    }

    private void validate(Map<String, BigDecimal> sourceAmt) {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            String billStatus = bill.getString("billstatus");
            if (!"B".equals(billStatus)) continue;
            String billno = bill.getString("billno");
            String sourceBillType = bill.getString("sourcebilltype");
            if ("cas_recbill".equals(sourceBillType) || "ar_receivedbill".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) || "ap_paidbill".equals(sourceBillType)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
            HashMap<String, BigDecimal> liquidation = new HashMap<String, BigDecimal>(64);
            for (DynamicObject row : entry) {
                String sourceBillno = row.getString("sourcebillno");
                BigDecimal rowamt = row.getBigDecimal("unsettleamt");
                BigDecimal liquiAmt = (BigDecimal)liquidation.get(sourceBillno);
                if (liquiAmt == null) {
                    liquidation.put(sourceBillno, rowamt);
                    continue;
                }
                liquidation.put(sourceBillno, liquiAmt.add(rowamt));
            }
            for (Map.Entry next : liquidation.entrySet()) {
                String key = (String)next.getKey();
                BigDecimal value = (BigDecimal)next.getValue();
                BigDecimal sourcedifAmt = sourceAmt.get(key);
                if (sourcedifAmt.compareTo(value) == 0) continue;
                String errorMessageTemplate = ResManager.loadKDString((String)"\u672a\u6e05\u9879\u6e05\u7406\u5355%1$s\u4e0a\u6e38\u5e94\u4ed8\u5355%2$s\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u6e05\u7406\u3002", (String)"LiquidationAuditValidatoro_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                if (this.isAr.booleanValue()) {
                    errorMessageTemplate = ResManager.loadKDString((String)"\u672a\u6e05\u9879\u6e05\u7406\u5355%1$s\u4e0a\u6e38\u5e94\u6536\u5355%2$s\u5b58\u5728\u5728\u9014\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u6e05\u7406\u3002", (String)"LiquidationAuditValidatoro_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                }
                String message = String.format(errorMessageTemplate, billno, key);
                this.addErrorMessage(entity, message);
            }
        }
    }

    public Map<String, Set<Long>> getSourceId() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billInfo = entity.getDataEntity();
            String sourceBillType = billInfo.getString("sourcebilltype");
            DynamicObjectCollection entry = billInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                Long sourceBillId;
                Set<Long> sourceIds;
                if ("cas_recbill".equals(sourceBillType) || "ar_receivedbill".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) || "ap_paidbill".equals(sourceBillType)) {
                    Long sourceEntryId;
                    Set<Long> sourceEntryIds;
                    if (map.get(sourceBillType) == null) {
                        sourceEntryIds = new HashSet(64);
                        sourceEntryId = row.getLong("sourceentryid");
                        sourceEntryIds.add(sourceEntryId);
                        map.put(sourceBillType, sourceEntryIds);
                        continue;
                    }
                    sourceEntryIds = (Set)map.get(sourceBillType);
                    sourceEntryId = row.getLong("sourceentryid");
                    sourceEntryIds.add(sourceEntryId);
                    map.put(sourceBillType, sourceEntryIds);
                    continue;
                }
                if (map.get(sourceBillType) == null) {
                    sourceIds = new HashSet(64);
                    sourceBillId = row.getLong("sourcebillid");
                    sourceIds.add(sourceBillId);
                    map.put(sourceBillType, sourceIds);
                    continue;
                }
                sourceIds = (Set)map.get(sourceBillType);
                sourceBillId = row.getLong("sourcebillid");
                sourceIds.add(sourceBillId);
                map.put(sourceBillType, sourceIds);
            }
        }
        return map;
    }

    public Map<String, BigDecimal> getSourceAmt(Set<Long> sourceIds) {
        HashMap<String, BigDecimal> sourceAmt;
        block6: {
            sourceAmt = new HashMap<String, BigDecimal>(64);
            if (sourceIds.size() <= 0) break block6;
            if (this.isAr.booleanValue()) {
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"ar_finarbill", (String)"billno,entry.e_lockedamt,entry.e_settledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIds)});
                for (DynamicObject bill : bills) {
                    String billno = bill.getString("billno");
                    BigDecimal difAmt = bill.getBigDecimal("entry.e_lockedamt").subtract(bill.getBigDecimal("entry.e_settledamt"));
                    if (sourceAmt.get(billno) == null) {
                        sourceAmt.put(billno, difAmt);
                        continue;
                    }
                    BigDecimal positiondifAmt = (BigDecimal)sourceAmt.get(billno);
                    sourceAmt.put(billno, positiondifAmt.add(difAmt));
                }
            } else {
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,detailentry.lockedamt,detailentry.settledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIds)});
                for (DynamicObject bill : bills) {
                    String billno = bill.getString("billno");
                    BigDecimal difAmt = bill.getBigDecimal("detailentry.lockedamt").subtract(bill.getBigDecimal("detailentry.settledamt"));
                    if (sourceAmt.get(billno) == null) {
                        sourceAmt.put(billno, difAmt);
                        continue;
                    }
                    BigDecimal positiondifAmt = (BigDecimal)sourceAmt.get(billno);
                    sourceAmt.put(billno, positiondifAmt.add(difAmt));
                }
            }
        }
        return sourceAmt;
    }
}

