/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.util.EmptyUtils;

public class MustInputControlValidator
extends AbstractExecControlValidator {
    @Override
    public Set<String> preparePropertys() {
        return new HashSet<String>(2);
    }

    public void validate() {
        Map<String, String> validatorMap = this.getValidatorMap();
        if (ObjectUtils.isEmpty(validatorMap)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject row;
            DynamicObject busRow;
            DynamicObjectCollection entry;
            DynamicObject bill = dataEntity.getDataEntity();
            for (Map.Entry<String, String> entrySet : validatorMap.entrySet()) {
                Object fieldValue = bill.get(entrySet.getKey());
                if (!EmptyUtils.isEmpty(fieldValue)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"MustInputControlValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), entrySet.getValue()));
            }
            if ("ap_busbill".equals(this.getEntityKey())) {
                entry = bill.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry.size(); ++i) {
                    busRow = (DynamicObject)entry.get(i);
                    if (busRow.getDynamicObject("e_material") != null && busRow.getDynamicObject("e_measureunit") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (busRow.getDynamicObject("e_material") != null && busRow.getDynamicObject("e_baseunit") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (busRow.getDynamicObject("e_material") == null || busRow.getBigDecimal("e_quantity").signum() == 0 || busRow.getBigDecimal("e_baseunitqty").signum() != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"MustInputControlValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
            }
            if ("ar_busbill".equals(this.getEntityKey())) {
                entry = bill.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry.size(); ++i) {
                    busRow = (DynamicObject)entry.get(i);
                    if (busRow.getDynamicObject("e_material") != null && busRow.getDynamicObject("e_baseunit") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (busRow.getDynamicObject("e_material") == null || busRow.getBigDecimal("e_quantity").signum() == 0 || busRow.getBigDecimal("e_baseunitqty").signum() != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"MustInputControlValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
            }
            if ("ap_payapply".equals(this.getEntityKey())) {
                entry = bill.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry.size(); ++i) {
                    row = (DynamicObject)entry.get(i);
                    if (EmptyUtils.isEmpty(row.get("e_asstacttype"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u5f80\u6765\u7c7b\u578b\u201d\u3002", (String)"MustInputControlValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (!EmptyUtils.isEmpty(row.get("e_asstact"))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u5f80\u6765\u6237\u201d\u3002", (String)"MustInputControlValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
            }
            if ("ap_finapbill".equals(this.getEntityKey())) {
                entry = bill.getDynamicObjectCollection("detailentry");
                for (int i = 0; i < entry.size(); ++i) {
                    row = (DynamicObject)entry.get(i);
                    if (EmptyUtils.isNotEmpty(row.get("material")) && EmptyUtils.isEmpty(row.get("e_baseunit"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (!EmptyUtils.isNotEmpty(row.get("material")) || row.getBigDecimal("quantity").signum() == 0 || row.getBigDecimal("e_baseunitqty").signum() != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"MustInputControlValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
            }
            if ("ar_finarbill".equals(this.getEntityKey())) {
                entry = bill.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry.size(); ++i) {
                    row = (DynamicObject)entry.get(i);
                    if (EmptyUtils.isNotEmpty(row.get("e_material")) && EmptyUtils.isEmpty(row.get("e_baseunit"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    }
                    if (!EmptyUtils.isNotEmpty(row.get("e_material")) || row.getBigDecimal("e_quantity").signum() == 0 || row.getBigDecimal("e_baseunitqty").signum() != 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"MustInputControlValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
            }
            if (!"ar_revcfmbill".equals(this.getEntityKey())) continue;
            entry = bill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entry.size(); ++i) {
                row = (DynamicObject)entry.get(i);
                if (EmptyUtils.isNotEmpty(row.get("e_material")) && EmptyUtils.isEmpty(row.get("e_baseunitid"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u5355\u4f4d\u201d\u3002", (String)"MustInputControlValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                }
                if (!EmptyUtils.isNotEmpty(row.get("e_material")) || row.getBigDecimal("e_quantity").signum() == 0 || row.getBigDecimal("e_baseunitqty").signum() != 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"MustInputControlValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
            }
        }
    }

    private Map<String, String> getValidatorMap() {
        HashMap<String, String> validatorMap = new HashMap<String, String>(8);
        String entityKey = this.getEntityKey();
        validatorMap.put("exratetable", ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"MustInputControlValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        if (!"ap_invoice".equals(entityKey)) {
            validatorMap.put("exchangerate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"MustInputControlValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ap_finapbill".equals(entityKey) || "ap_busbill".equals(entityKey) || "ar_finarbill".equals(entityKey) || "ar_busbill".equals(entityKey) || "ar_revcfmbill".equals(entityKey)) {
            validatorMap.put("payproperty", ResManager.loadKDString((String)"\u6b3e\u9879\u6027\u8d28", (String)"MustInputControlValidator_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ap_finapbill".equals(entityKey) || "ap_busbill".equals(entityKey) || "ar_finarbill".equals(entityKey) || "ar_busbill".equals(entityKey) || "ar_revcfmbill".equals(entityKey) || "ar_invoice".equals(entityKey) || "ap_liquidation".equals(entityKey) || "ar_liquidation".equals(entityKey) || "ar_baddebtlossbill".equals(entityKey)) {
            validatorMap.put("asstacttype", ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u578b", (String)"MustInputControlValidator_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"MustInputControlValidator_10", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ap_invoice".equals(entityKey)) {
            validatorMap.put("asstacttype", ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u578b", (String)"MustInputControlValidator_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("receivablessupp", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"MustInputControlValidator_10", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ar_revcfmbill".equals(entityKey)) {
            validatorMap.put("confirmway", ResManager.loadKDString((String)"\u786e\u8ba4\u65b9\u5f0f", (String)"MustInputControlValidator_11", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ap_paidbill".equals(entityKey)) {
            validatorMap.put("paymenttype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"MustInputControlValidator_12", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("payee", ResManager.loadKDString((String)"\u6536\u6b3e\u65b9", (String)"MustInputControlValidator_13", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("payeetype", ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u7c7b\u578b", (String)"MustInputControlValidator_14", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if ("ar_receivedbill".equals(entityKey)) {
            validatorMap.put("rectype", ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b", (String)"MustInputControlValidator_15", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("asstact", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9", (String)"MustInputControlValidator_16", (String)"fi-arapcommon", (Object[])new Object[0]));
            validatorMap.put("asstacttype", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u7c7b\u578b", (String)"MustInputControlValidator_17", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return validatorMap;
    }
}

