/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class PayBillSettleAmtValidator
implements IOthersExecCtrlService {
    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.e_payableamt");
        selectors.add("entry.e_payablelocamt");
        selectors.add("entry.e_settledamt");
        selectors.add("entry.e_settledlocalamt");
        selectors.add("entry.e_unsettledamt");
        selectors.add("entry.e_unsettledlocalamt");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] payBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        block0: for (DynamicObject payBill : payBills) {
            long payBillId = payBill.getLong("id");
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject casPayRow = (DynamicObject)entry.get(i);
                BigDecimal ePayAbleAmt = casPayRow.getBigDecimal("e_payableamt");
                BigDecimal ePayAbleLocAmt = casPayRow.getBigDecimal("e_payablelocamt");
                if (BigDecimal.ZERO.compareTo(casPayRow.getBigDecimal("e_settledamt")) != 0) {
                    result.put(payBillId, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7b2c%1$s\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5e94\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleAmtValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (BigDecimal.ZERO.compareTo(casPayRow.getBigDecimal("e_settledlocalamt")) != 0) {
                    result.put(payBillId, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7b2c%1$s\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5e94\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleAmtValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (ePayAbleAmt.compareTo(casPayRow.getBigDecimal("e_unsettledamt")) != 0) {
                    result.put(payBillId, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7b2c%1$s\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5e94\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleAmtValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (ePayAbleLocAmt.compareTo(casPayRow.getBigDecimal("e_unsettledlocalamt")) == 0) continue;
                result.put(payBillId, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7b2c%1$s\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u4f4d\u5e01\u5e94\u7b49\u4e8e\u5e94\u4ed8\u6298\u672c\u5e01\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleAmtValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                continue block0;
            }
        }
        return result;
    }
}

