/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayBillSettleModelValidator
implements IOthersExecCtrlService {
    private static final Log logger = LogFactory.getLog(PayBillSettleModelValidator.class);

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        logger.info("PayBillSettleModelValidator start");
        HashMap<Long, String> result = new HashMap<Long, String>(others.length);
        HashSet<Long> sourceApIdSet = new HashSet<Long>(64);
        HashSet<Long> sourceArIdSet = new HashSet<Long>(64);
        this.buildSrcIdSet(others, sourceArIdSet, sourceApIdSet);
        Map<Long, DynamicObject> srcBillMap = this.buildSrcBillMap(sourceArIdSet, sourceApIdSet);
        if (srcBillMap.size() > 0) {
            HashMap<Long, Integer> settleParamMap = new HashMap<Long, Integer>(8);
            for (DynamicObject bill : others) {
                DynamicObjectCollection sourceEntry;
                List srcEntryIdList;
                String sourceBillType = bill.getString("sourcebilltype");
                Long sourceBillId = bill.getLong("sourcebillid");
                DynamicObject sourceBill = srcBillMap.get(sourceBillId);
                if (!StringUtils.isNotEmpty((String)sourceBillType) || sourceBillId == 0L || !EmptyUtils.isNotEmpty(sourceBill)) continue;
                boolean isAr = "ar_finarbill".equals(sourceBillType);
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                int settleParam = 0;
                Long entryId = 0L;
                boolean isFirst = true;
                for (DynamicObject row : entry) {
                    Long entryLkSrcId;
                    DynamicObjectCollection entryLk;
                    if (isFirst) {
                        Long orgId = row.getLong("settleorg.id");
                        if (!ObjectUtils.isEmpty(settleParamMap.get(orgId))) {
                            settleParam = (Integer)settleParamMap.get(orgId);
                        } else {
                            settleParam = isAr ? ArApHelper.getArSettleParam(orgId) : ArApHelper.getApSettleParam(orgId);
                            settleParamMap.put(orgId, settleParam);
                            isFirst = false;
                        }
                    }
                    if (!EmptyUtils.isNotEmpty(entryLk = row.getDynamicObjectCollection("entry_lk")) || !sourceBillId.equals(entryLkSrcId = Long.valueOf(((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid")))) continue;
                    entryId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sid");
                    break;
                }
                if (entryId == 0L) continue;
                if (1 == settleParam) {
                    String entryName = isAr ? "entry" : "detailentry";
                    DynamicObjectCollection sourceEntry2 = sourceBill.getDynamicObjectCollection(entryName);
                    List srcEntryIdList2 = sourceEntry2.stream().map(entryInfo -> entryInfo.getLong("id")).collect(Collectors.toList());
                    if (srcEntryIdList2.contains(entryId)) continue;
                    result.put(bill.getLong("id"), ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u5173\u8054\u7684\u660e\u7ec6\u884c\uff0c\u4e0e\u7ed3\u7b97\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleModelValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    continue;
                }
                if (2 != settleParam || (srcEntryIdList = (sourceEntry = sourceBill.getDynamicObjectCollection("planentity")).stream().map(entryInfo -> entryInfo.getLong("id")).collect(Collectors.toList())).contains(entryId)) continue;
                result.put(bill.getLong("id"), ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0e\u4e0a\u6e38\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u5173\u8054\u7684\u660e\u7ec6\u884c\uff0c\u4e0e\u7ed3\u7b97\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayBillSettleModelValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        logger.info("PayBillSettleModelValidator end");
        return result;
    }

    private Map<Long, DynamicObject> buildSrcBillMap(Set<Long> sourceArIdSet, Set<Long> sourceApIdSet) {
        DynamicObject[] bills;
        HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(64);
        if (sourceApIdSet.size() > 0) {
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.id,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceApIdSet.toArray())})) {
                srcBillMap.put(bill.getLong("id"), bill);
            }
        }
        if (sourceArIdSet.size() > 0) {
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,entry.id,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceArIdSet.toArray())})) {
                srcBillMap.put(bill.getLong("id"), bill);
            }
        }
        return srcBillMap;
    }

    private void buildSrcIdSet(DynamicObject[] others, Set<Long> sourceArIdSet, Set<Long> sourceApIdSet) {
        for (DynamicObject bill : others) {
            String sourceBillType = bill.getString("sourcebilltype");
            Long sourceBillId = bill.getLong("sourcebillid");
            if ("ap_finapbill".equals(sourceBillType)) {
                sourceApIdSet.add(sourceBillId);
                continue;
            }
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            sourceArIdSet.add(sourceBillId);
        }
    }

    @Override
    public Set<String> preparePropertys() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("id");
        set.add("sourcebilltype");
        set.add("sourcebillid");
        set.add("entry.settleorg");
        set.add("entry_lk_sbillid");
        set.add("entry_lk_sid");
        set.add("entry_lk");
        return set;
    }
}

