/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class PayBillStatusValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> billIds = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, Boolean> autoPushParams = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            long billId = bill.getLong("id");
            billIds.add(billId);
        }
        Map<Long, Set<Long>> targetBillIdMap = BOTPHelper.findDirtTargetBillIds(this.entityKey, billIds.toArray(new Long[0]), "cas_paybill", "cas_paybill");
        Set payBillIds = targetBillIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", payBillIds);
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{idFilter});
        Map<Long, Set<Long>> changeBillIdMap = BOTPHelper.findDirtTargetBillIds(this.entityKey, billIds.toArray(new Long[0]), "ap_payapplychange", "ap_payapplychange");
        Set changeBillIds = changeBillIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection changeBills = QueryServiceHelper.query((String)"ap_payapplychange", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", changeBillIds)});
        block1: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set<Long> tarChangeBillIds;
            DynamicObject bill = dataEntity.getDataEntity();
            long billId = bill.getLong("id");
            Set<Long> targetBillIds = targetBillIdMap.get(billId);
            if (targetBillIds == null) continue;
            for (DynamicObject payBill : payBills) {
                String billStatus;
                if (!targetBillIds.contains(payBill.getLong("id")) || "G".equals(billStatus = payBill.getString("billstatus")) || this.hasAutoPushPayBill(bill, autoPushParams) && "A".equals(billStatus)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"PayBillStatusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            if ((tarChangeBillIds = changeBillIdMap.get(billId)) == null) continue;
            for (DynamicObject changeBill : changeBills) {
                String billStatus;
                Long changId = changeBill.getLong("id");
                if (!tarChangeBillIds.contains(changId) || "C".equals(billStatus = changeBill.getString("billstatus"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"PayBillStatusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue block1;
            }
        }
    }

    private boolean hasAutoPushPayBill(DynamicObject bill, Map<Long, Boolean> autoPushParams) {
        if ("ap_finapbill".equals(this.entityKey)) {
            if (!"CASH".equals(bill.getString("purmode"))) {
                return false;
            }
            long orgId = bill.getLong("org.id");
            Boolean isAutoPush = autoPushParams.get(orgId);
            if (isAutoPush == null) {
                isAutoPush = SystemParameterHelper.getAPBooleanParam(orgId, "ap_017");
                autoPushParams.put(orgId, isAutoPush);
            }
            return isAutoPush;
        }
        return false;
    }
}

