/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class PayPropertyQtyControlValidator
extends AbstractExecControlValidator {
    @Override
    public Set<String> preparePropertys() {
        return new HashSet<String>(2);
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        BillModel billModel = BillModelFactory.getModel(this.entityKey);
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isBaseDonAmt = bill.getBoolean("payproperty.isbasedonamt");
            if (!isBaseDonAmt) continue;
            DynamicObjectCollection detailRows = bill.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject detailRow : detailRows) {
                BigDecimal qty = detailRow.getBigDecimal(billModel.E_QUANTITY);
                if (qty.signum() == 0 || qty.compareTo(BigDecimal.ONE) == 0 || qty.compareTo(BigDecimal.ONE.negate()) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u5355\u636e\u6570\u91cf\u9700\u4e3a\u00b11\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayPropertyQtyControlValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

