/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PeriodAuditOrUnauditValidator
extends AbstractValidator {
    public void validate() {
        long orgId;
        DynamicObject bill;
        HashSet<String> billTypeSet = new HashSet<String>(4);
        billTypeSet.add("ap_paidbill");
        billTypeSet.add("ap_finapbill");
        billTypeSet.add("ap_busbill");
        String initKey = billTypeSet.contains(this.entityKey) ? "ap_init" : "ar_init";
        HashSet<Long> orgSet = new HashSet<Long>(this.dataEntities.length);
        ArrayList<ExtendedDataEntity> checkEntityList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        if ("ap_paidbill".equals(this.entityKey) || "ar_receivedbill".equals(this.entityKey)) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                bill = dataEntity.getDataEntity();
                long orgId2 = bill.getLong("org.id");
                orgSet.add(orgId2);
                checkEntityList.add(dataEntity);
            }
        } else {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                bill = dataEntity.getDataEntity();
                boolean isPeriod = bill.getBoolean("isperiod");
                if (!isPeriod) continue;
                orgId = bill.getLong("org.id");
                orgSet.add(orgId);
                checkEntityList.add(dataEntity);
            }
        }
        if (orgSet.isEmpty()) {
            return;
        }
        String initSelector = "id,org.name,isfinishinit";
        DynamicObject[] initDatas = BusinessDataServiceHelper.load((String)initKey, (String)initSelector, (QFilter[])new QFilter[]{new QFilter("org", "in", orgSet)});
        HashMap<Long, String> orgMsgMap = this.getOrgMsgMap(initDatas);
        for (ExtendedDataEntity dataEntity : checkEntityList) {
            DynamicObject bill2 = dataEntity.getDataEntity();
            orgId = bill2.getLong("org.id");
            String msg = orgMsgMap.get(orgId);
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private HashMap<Long, String> getOrgMsgMap(DynamicObject[] initDatas) {
        boolean isAuditOp = "audit".equalsIgnoreCase(this.getOperateKey());
        HashMap<Long, String> orgMsgMap = new HashMap<Long, String>(initDatas.length);
        if (isAuditOp) {
            for (DynamicObject initData : initDatas) {
                if (initData.getBoolean("isfinishinit")) {
                    orgMsgMap.put(initData.getLong("org.id"), ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u671f\u521d\u5355\u636e\u5df2\u81ea\u52a8\u5ba1\u6838\u3002", (String)"PeriodBillAuditValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{initData.getString("org.name")}));
                    continue;
                }
                orgMsgMap.put(initData.getLong("org.id"), ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5c06\u81ea\u52a8\u5ba1\u6838\u671f\u521d\u5355\u636e\u3002", (String)"PeriodBillAuditValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        } else {
            block15: for (DynamicObject initData : initDatas) {
                long orgId = initData.getLong("org.id");
                String orgName = initData.getString("org.name");
                if (initData.getBoolean("isfinishinit")) {
                    orgMsgMap.put(orgId, ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u53cd\u521d\u59cb\u5316\u5c06\u81ea\u52a8\u53cd\u5ba1\u6838\u671f\u521d\u5355\u636e\u3002", (String)"PeriodBillAuditValidator_2", (String)"fi-arapcommon", (Object[])new Object[]{orgName}));
                    continue;
                }
                switch (this.entityKey) {
                    case "ap_paidbill": {
                        orgMsgMap.put(orgId, ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u81ea\u52a8\u53cd\u5ba1\u6838\u671f\u521d\u5355\u636e\uff0c\u82e5\u5355\u636e\u72b6\u6001\u4ecd\u4e3a\u5df2\u4ed8\u6b3e\u8bf7\u68c0\u67e5\uff1a1.\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1b2.\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff1b3.\u5355\u636e\u5df2\u5173\u8054\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\u3002\u8bf7\u68c0\u67e5\u65e0\u8bef\u540e\u518d\u6b21\u5c1d\u8bd5\u53cd\u521d\u59cb\u5316\u3002", (String)"PeriodBillAuditValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue block15;
                    }
                    case "ar_receivedbill": {
                        orgMsgMap.put(orgId, ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u81ea\u52a8\u53cd\u5ba1\u6838\u671f\u521d\u5355\u636e\uff0c\u82e5\u5355\u636e\u72b6\u6001\u4ecd\u4e3a\u5df2\u6536\u6b3e\u8bf7\u68c0\u67e5\uff1a1.\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1b2.\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff1b3.\u5355\u636e\u5df2\u5173\u8054\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\u3002\u8bf7\u68c0\u67e5\u65e0\u8bef\u540e\u518d\u6b21\u5c1d\u8bd5\u53cd\u521d\u59cb\u5316\u3002", (String)"PeriodBillAuditValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue block15;
                    }
                    case "ap_busbill": 
                    case "ar_busbill": {
                        orgMsgMap.put(orgId, ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u4f1a\u81ea\u52a8\u53cd\u5ba1\u6838\u671f\u521d\u5355\u636e\uff0c\u82e5\u5355\u636e\u72b6\u6001\u4ecd\u4e3a\u5df2\u5ba1\u6838\u8bf7\u68c0\u67e5\uff1a1.\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1b2.\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\u3002\u8bf7\u68c0\u67e5\u65e0\u8bef\u540e\u518d\u6b21\u5c1d\u8bd5\u53cd\u521d\u59cb\u5316\u3002", (String)"PeriodBillAuditValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue block15;
                    }
                    case "ap_finapbill": 
                    case "ar_finarbill": {
                        orgMsgMap.put(orgId, ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u4f1a\u81ea\u52a8\u53cd\u5ba1\u6838\u671f\u521d\u5355\u636e\uff0c\u82e5\u5355\u636e\u72b6\u6001\u4ecd\u4e3a\u5df2\u5ba1\u6838\u8bf7\u68c0\u67e5\uff1a1.\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff1b2.\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff1b3.\u5355\u636e\u5df2\u5173\u8054\u751f\u6210\u6838\u9500\u8bb0\u5f55\uff1b4.\u5355\u636e\u5df2\u5173\u8054\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\u3002\u8bf7\u68c0\u67e5\u65e0\u8bef\u540e\u518d\u6b21\u5c1d\u8bd5\u53cd\u521d\u59cb\u5316\u3002", (String)"PeriodBillAuditValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                }
            }
        }
        return orgMsgMap;
    }
}

