/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class RecBillSettleAmtValidator
implements IOthersExecCtrlService {
    @Override
    public Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("entry.e_receivableamt");
        selectors.add("entry.e_receivablelocamt");
        selectors.add("entry.e_settledamt");
        selectors.add("entry.e_settledlocalamt");
        selectors.add("entry.e_unsettledamt");
        selectors.add("entry.e_unsettledlocalamt");
        return selectors;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] recBills) {
        HashMap<Long, String> result = new HashMap<Long, String>(64);
        block0: for (DynamicObject recBill : recBills) {
            long recBillId = recBill.getLong("id");
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject casRecRow = (DynamicObject)entry.get(i);
                BigDecimal eRecAbleAmt = casRecRow.getBigDecimal("e_receivableamt");
                BigDecimal eRecAbleLocAmt = casRecRow.getBigDecimal("e_receivablelocamt");
                if (BigDecimal.ZERO.compareTo(casRecRow.getBigDecimal("e_settledamt")) != 0) {
                    result.put(recBillId, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u7b2c%1$s\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u5e94\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleAmtValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (BigDecimal.ZERO.compareTo(casRecRow.getBigDecimal("e_settledlocalamt")) != 0) {
                    result.put(recBillId, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u7b2c%1$s\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u5e01\u5e94\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleAmtValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (eRecAbleAmt.compareTo(casRecRow.getBigDecimal("e_unsettledamt")) != 0) {
                    result.put(recBillId, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u7b2c%1$s\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5e94\u7b49\u4e8e\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleAmtValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                    continue block0;
                }
                if (eRecAbleLocAmt.compareTo(casRecRow.getBigDecimal("e_unsettledlocalamt")) == 0) continue;
                result.put(recBillId, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u7b2c%1$s\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u6298\u672c\u4f4d\u5e01\u5e94\u7b49\u4e8e\u5e94\u6536\u6298\u672c\u5e01\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleAmtValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1));
                continue block0;
            }
        }
        return result;
    }
}

