/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RecBillSettleModelValidator
implements IOthersExecCtrlService {
    @Override
    public Set<String> preparePropertys() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("id");
        set.add("sourcebilltype");
        set.add("sourcebillid");
        set.add("entry.e_settleorg");
        set.add("entry_lk_sbillid");
        set.add("entry_lk_sid");
        set.add("entry_lk");
        return set;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] others) {
        HashMap<Long, String> result = new HashMap<Long, String>(others.length);
        HashSet<Long> sourceArIdSet = new HashSet<Long>(64);
        this.buildSrcIdSet(others, sourceArIdSet);
        Map<Long, DynamicObject> srcBillMap = this.buildSrcBillMap(sourceArIdSet);
        if (srcBillMap.size() > 0) {
            HashMap<Long, Integer> settleParamMap = new HashMap<Long, Integer>(8);
            for (DynamicObject bill : others) {
                List srcEntryIdList;
                DynamicObjectCollection sourceEntry;
                String sourceBillType = bill.getString("sourcebilltype");
                Long sourceBillId = bill.getLong("sourcebillid");
                DynamicObject sourceBill = srcBillMap.get(sourceBillId);
                if (!StringUtils.isNotEmpty((String)sourceBillType) || sourceBillId == 0L || !EmptyUtils.isNotEmpty(sourceBill)) continue;
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                int settleParam = 0;
                Long entryId = 0L;
                boolean isFirst = true;
                for (DynamicObject row : entry) {
                    Long entryLkSrcId;
                    DynamicObjectCollection entryLk;
                    if (isFirst) {
                        Long orgId = row.getLong("e_settleorg.id");
                        if (!ObjectUtils.isEmpty(settleParamMap.get(orgId))) {
                            settleParam = (Integer)settleParamMap.get(orgId);
                        } else {
                            settleParam = ArApHelper.getArSettleParam(orgId);
                            settleParamMap.put(orgId, settleParam);
                            isFirst = false;
                        }
                    }
                    if (!EmptyUtils.isNotEmpty(entryLk = row.getDynamicObjectCollection("entry_lk")) || !sourceBillId.equals(entryLkSrcId = Long.valueOf(((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid")))) continue;
                    entryId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sid");
                    break;
                }
                if (entryId == 0L) continue;
                if (1 == settleParam) {
                    sourceEntry = sourceBill.getDynamicObjectCollection("entry");
                    srcEntryIdList = sourceEntry.stream().map(entryInfo -> entryInfo.getLong("id")).collect(Collectors.toList());
                    if (srcEntryIdList.contains(entryId)) continue;
                    result.put(bill.getLong("id"), ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4e0e\u4e0a\u6e38\u5e94\u6536\u5355\u636e\u5173\u8054\u7684\u660e\u7ec6\u884c\uff0c\u4e0e\u7ed3\u7b97\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleModelValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    continue;
                }
                if (2 != settleParam || (srcEntryIdList = (sourceEntry = sourceBill.getDynamicObjectCollection("planentity")).stream().map(entryInfo -> entryInfo.getLong("id")).collect(Collectors.toList())).contains(entryId)) continue;
                result.put(bill.getLong("id"), ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4e0e\u4e0a\u6e38\u5e94\u6536\u5355\u636e\u5173\u8054\u7684\u660e\u7ec6\u884c\uff0c\u4e0e\u7ed3\u7b97\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecBillSettleModelValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        return result;
    }

    private void buildSrcIdSet(DynamicObject[] others, Set<Long> sourceArIdSet) {
        for (DynamicObject bill : others) {
            String sourceBillType = bill.getString("sourcebilltype");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            sourceArIdSet.add(sourceBillId);
        }
    }

    private Map<Long, DynamicObject> buildSrcBillMap(Set<Long> sourceArIdSet) {
        HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(64);
        if (sourceArIdSet.size() > 0) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,entry.id,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceArIdSet.toArray())})) {
                srcBillMap.put(bill.getLong("id"), bill);
            }
        }
        return srcBillMap;
    }
}

