/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.GLUtils;

public class ReconcileBaseValidator
extends AbstractValidator {
    public static final String ENTITY_FRM_RECONCILIATION_INDEX = "frm_reconciliation_index";
    public static final String ENTITY_FRM_RECONCILIATION_SCHEME = "frm_reconciliation_scheme";
    public static final String ENTITY_GL_ACCOUNTBOOK = "gl_accountbook";
    public static final String BD_BOOKSTYPE = "1";
    private boolean isAr;

    public void validate() {
        this.isAr = "ar_init".equals(this.entityKey);
        boolean isSubmitOp = "submit".equalsIgnoreCase(this.getOperateKey());
        String appId = this.isAr ? "/BBRH+122=39" : "+HKZHSKFXOX";
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>(0);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            long orgPk = (Long)org.getPkValue();
            String orgName = org.getLocaleString("name").getLocaleValue();
            if (isSubmitOp) {
                boolean p_008 = false;
                Object value = orgMap.get(orgPk);
                if (ObjectUtils.isEmpty(value)) {
                    p_008 = SystemParameterHelper.getAppBooleanParam(appId, orgPk, this.isAr ? "ar_008" : "ap_008");
                    orgMap.put(orgPk, p_008);
                } else {
                    p_008 = (Boolean)value;
                }
                if (!p_008) continue;
                String message = this.chkScheme(orgPk);
                if (message == null) {
                    message = this.chkAccountBook(info, orgPk);
                }
                if (message == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u4e0d\u6ee1\u8db3\u5bf9\u8d26\u6761\u4ef6\uff1a%2$s", (String)"ReconcileBaseValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, message);
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            this.chkScheme(dataEntity, orgPk, orgName);
            this.chkAccountBook(dataEntity, info, orgPk, orgName);
        }
    }

    private String chkScheme(long orgPk) {
        String message = null;
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_FRM_RECONCILIATION_SCHEME, (Long)orgPk);
        if (!QueryServiceHelper.exists((String)ENTITY_FRM_RECONCILIATION_SCHEME, (QFilter[])new QFilter[]{qFilter, orgFilter})) {
            message = ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ReconcileBaseValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        return message;
    }

    private String chkAccountBook(DynamicObject info, long orgPk) {
        String message = null;
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        qFilter.and(new QFilter("bookstype.accounttype", "=", (Object)BD_BOOKSTYPE));
        String selector = "periodtype, curperiod, isendinit";
        DynamicObject accountBook = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_GL_ACCOUNTBOOK, (String)selector, (QFilter[])new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object)accountBook)) {
            message = ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ReconcileBaseValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if (!accountBook.getBoolean("isendinit")) {
            message = ResManager.loadKDString((String)"\u603b\u8d26\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ReconcileBaseValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if (!Objects.equals(info.getLong("periodtype.id"), accountBook.getLong("periodtype.id"))) {
            message = ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0e\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReconcileBaseValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else {
            Long curPeriodPk = accountBook.getLong("curperiod.id");
            DynamicObject startPeriod = info.getDynamicObject("startperiod");
            DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodPk, (String)"bd_period", (String)"periodyear, periodnumber");
            if (!PeriodHelper.after(curPeriod, startPeriod) && !startPeriod.getPkValue().equals(curPeriodPk)) {
                String bizAppName = AppMetadataCache.getAppInfo((String)(this.isAr ? "ar" : "ap")).getName().getLocaleValue();
                message = ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u5e94\u5927\u4e8e\u7b49\u4e8e%s\u542f\u7528\u671f\u95f4\u3002", (String)"ReconcileBaseValidator_5", (String)"fi-arapcommon", (Object[])new Object[]{bizAppName});
            }
        }
        return message;
    }

    private void chkScheme(ExtendedDataEntity dataEntity, long orgPk, String orgName) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_FRM_RECONCILIATION_SCHEME, (Long)orgPk);
        if (!QueryServiceHelper.exists((String)ENTITY_FRM_RECONCILIATION_SCHEME, (QFilter[])new QFilter[]{qFilter, orgFilter})) {
            String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u7684\u5bf9\u8d26\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ReconcileBaseValidator_6", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, message);
        }
    }

    private void chkAccountBook(ExtendedDataEntity dataEntity, DynamicObject info, long orgPk, String orgName) {
        DynamicObject accountBook = GLUtils.getAccountBook4Master(orgPk);
        if (ObjectUtils.isEmpty((Object)accountBook)) {
            String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u7684\u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ReconcileBaseValidator_7", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, message);
        } else if (!accountBook.getBoolean("isendinit")) {
            String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u603b\u8d26\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ReconcileBaseValidator_8", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
            this.addErrorMessage(dataEntity, message);
        } else {
            if (!Objects.equals(info.getLong("periodtype.id"), accountBook.getLong("periodtype.id"))) {
                String message = ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%s \u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0e\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReconcileBaseValidator_9", (String)"fi-arapcommon", (Object[])new Object[]{orgName});
                this.addErrorMessage(dataEntity, message);
            }
            DynamicObject startPeriod = info.getDynamicObject("startperiod");
            DynamicObject glStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBook.getLong("startperiod.id"), (String)"bd_period", (String)"periodyear, periodnumber");
            DynamicObject glCurPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBook.getLong("curperiod.id"), (String)"bd_period", (String)"periodyear, periodnumber");
            if (!PeriodHelper.afterEquals(startPeriod, glStartPeriod) || !PeriodHelper.beforeEquals(startPeriod, glCurPeriod)) {
                String bizAppName = AppMetadataCache.getAppInfo((String)(this.isAr ? "ar" : "ap")).getName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%1$s %2$s\u542f\u7528\u671f\u95f4\u4e0d\u5728\u5bf9\u5e94\u4f1a\u8ba1\u4e3b\u8d26\u7c3f\u7684\u542f\u7528\u671f\u95f4\u4e0e\u5f53\u524d\u671f\u95f4\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"ReconcileBaseValidator_10", (String)"fi-arapcommon", (Object[])new Object[0]), orgName, bizAppName);
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

