/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StringUtils;

public class SettleSchemeExecuteValidator
extends AbstractValidator {
    private final boolean isAr;
    private Map<Long, Object> arParamMap = new HashMap<Long, Object>(128);
    private Map<Long, Object> apParamMap = new HashMap<Long, Object>(128);

    public SettleSchemeExecuteValidator(boolean isAr) {
        this.isAr = isAr;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        this.getOrgParam(datas);
        for (ExtendedDataEntity data : datas) {
            this.validateScheme(data);
        }
    }

    private void validateScheme(ExtendedDataEntity data) {
        DynamicObject info = data.getDataEntity();
        DynamicObjectCollection orgEntryColl = info.getDynamicObjectCollection("orgentry");
        if (orgEntryColl == null || orgEntryColl.size() == 0) {
            return;
        }
        ILocaleString schemeName = info.getLocaleString("name");
        DynamicObjectCollection ruleEntry = info.getDynamicObjectCollection("ruleentry");
        for (DynamicObject orgEntry : orgEntryColl) {
            DynamicObject org = orgEntry.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) continue;
            ILocaleString orgName = org.getLocaleString("name");
            for (int i = 0; i < ruleEntry.size(); ++i) {
                String format;
                DynamicObject rule = (DynamicObject)ruleEntry.get(i);
                String settleRelation = rule.getString("settlerelation");
                if (!this.isValidateScheme(settleRelation)) continue;
                int settlemodel = 1;
                settlemodel = this.isAr ? Integer.parseInt((String)this.arParamMap.get(org.getLong("id"))) : Integer.parseInt((String)this.apParamMap.get(org.getLong("id")));
                List<String> entities = SettleRelationEnum.getEntityByRelation(settleRelation);
                String mainbill = entities.get(0);
                String asstbill = StringUtils.isNotEmpty(rule.getString("asstbill")) ? rule.getString("asstbill") : entities.get(1);
                String matchFieldInfo = rule.getString("matchfieldinfo");
                int mainFilterSeq = -1;
                int asstFilterSeq = -1;
                int mainMatchFieldSeq = -1;
                int asstMatchFieldSeq = -1;
                if ("ar_finarbill".equals(mainbill) || "ap_finapbill".equals(mainbill)) {
                    String mainfilter_tag = rule.getString("mainfilter_tag");
                    if (!ObjectUtils.isEmpty((Object)mainfilter_tag)) {
                        QFilter filterGridValue = this.getFilterGridValue(mainbill, mainfilter_tag);
                        mainFilterSeq = this.validateSettleModel(filterGridValue, settlemodel);
                    }
                    mainMatchFieldSeq = this.validateSettleModel(matchFieldInfo, settlemodel, true);
                }
                if ("ar_finarbill".equals(asstbill) || "ap_finapbill".equals(asstbill)) {
                    String asstfilter_tag = rule.getString("asstfilter_tag");
                    int asstSettleModel = settlemodel;
                    if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) && "ap_finapbill".equals(asstbill)) {
                        asstSettleModel = Integer.parseInt((String)this.apParamMap.get(org.getLong("id")));
                    } else if (SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) && "ar_finarbill".equals(asstbill)) {
                        asstSettleModel = Integer.parseInt((String)this.arParamMap.get(org.getLong("id")));
                    }
                    if (!ObjectUtils.isEmpty((Object)asstfilter_tag)) {
                        QFilter filterGridValue = this.getFilterGridValue(asstbill, asstfilter_tag);
                        asstFilterSeq = this.validateSettleModel(filterGridValue, asstSettleModel);
                    }
                    if (mainMatchFieldSeq == -1) {
                        asstMatchFieldSeq = this.validateSettleModel(matchFieldInfo, asstSettleModel, false);
                    }
                }
                if (mainFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u9002\u7528\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, mainFilterSeq + 1, orgName));
                }
                if (asstFilterSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u9002\u7528\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, asstFilterSeq + 1, orgName));
                }
                if (mainMatchFieldSeq != -1) {
                    format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u4e3b\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]);
                    this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, mainMatchFieldSeq + 1, orgName));
                }
                if (asstMatchFieldSeq == -1) continue;
                format = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848%1$s\u7b2c%2$s\u4e2a\u7ed3\u7b97\u6267\u884c\u89c4\u5219\u8f85\u65b9\u5355\u636e\u914d\u7f6e\u7684\u5339\u914d\u6761\u4ef6\u7b2c%3$s\u884c\u5b57\u6bb5\u6240\u5728\u5206\u5f55\u4e0e\u9002\u7528\u7ec4\u7ec7\uff1a%4$s\u7ed3\u7b97\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SettleSchemeExecuteValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.addFatalErrorMessage(data, String.format(format, schemeName, i + 1, asstMatchFieldSeq + 1, orgName));
            }
        }
    }

    private boolean isValidateScheme(String settleRelation) {
        return !SettleRelationEnum.RECSELF.getValue().equals(settleRelation) && !SettleRelationEnum.PAYSELF.getValue().equals(settleRelation);
    }

    private QFilter getFilterGridValue(String entityName, String exprission) {
        CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)exprission, CRCondition.class);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private int validateSettleModel(QFilter filterGridValue, int settlemodel) {
        ArrayList<String> propertyList = new ArrayList<String>(4);
        List recursiveNests = filterGridValue.getNests(true);
        propertyList.add(filterGridValue.getProperty());
        for (QFilter.QFilterNest nest : recursiveNests) {
            QFilter filter = nest.getFilter();
            String propertyName = filter.getProperty();
            if (propertyList.contains(propertyName)) continue;
            propertyList.add(propertyName);
        }
        if (settlemodel == 1) {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("planentity.")) continue;
                return i;
            }
        } else {
            for (int i = 0; i < propertyList.size(); ++i) {
                if (!((String)propertyList.get(i)).startsWith("entry.") && !((String)propertyList.get(i)).startsWith("detailentry.")) continue;
                return i;
            }
        }
        return -1;
    }

    private int validateSettleModel(String matchFieldInfo, int settlemodel, boolean isMain) {
        if (StringUtils.isNotEmpty(matchFieldInfo)) {
            String key = isMain ? "mainfield" : "asstfield";
            List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
            for (int i = 0; i < fieldEntrys.size(); ++i) {
                String field = (String)((Map)fieldEntrys.get(i)).get(key);
                if (!(settlemodel == 1 ? field.startsWith("planentity.") : field.startsWith("entry.") || field.startsWith("detailentry."))) continue;
                return i;
            }
        }
        return -1;
    }

    private void getOrgParam(ExtendedDataEntity[] datas) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(128);
        for (ExtendedDataEntity data : datas) {
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection orgEntries = info.getDynamicObjectCollection("orgentry");
            for (DynamicObject orgEntry : orgEntries) {
                DynamicObject org = orgEntry.getDynamicObject("org");
                if (ObjectUtils.isEmpty((Object)org)) continue;
                orgIdList.add(org.getLong("id"));
            }
        }
        this.arParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, orgIdList, "ar_003");
        this.apParamMap = SystemParameterHelper.batchGetAppParameter(Boolean.FALSE, orgIdList, "ap_003");
    }
}

