/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.fi.arapcommon.enums.ECTxBizEnum;

public class UnFinishECValidator
extends AbstractValidator {
    private final List<ECTxBizEnum> ecTxEnums;

    public UnFinishECValidator(List<ECTxBizEnum> ecTxEnums) {
        this.ecTxEnums = ecTxEnums;
    }

    public void validate() {
        Map<String, List<String>> unFinishedTxInfoMap = this.getECUnFinishInvoiceIds();
        if (ObjectUtils.isEmpty(unFinishedTxInfoMap)) {
            return;
        }
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject invoice = dataEntity.getDataEntity();
            List<String> unFinishedTxs = unFinishedTxInfoMap.get(invoice.getString("id"));
            if (ObjectUtils.isEmpty(unFinishedTxs)) continue;
            Set needValidateTxs = this.ecTxEnums.stream().map(ECTxBizEnum::getKey).collect(Collectors.toSet());
            for (String unFinishedTx : unFinishedTxs) {
                if (!needValidateTxs.contains(unFinishedTx)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u901a\u8fc7\u201c\u8054\u67e5>\u8054\u67e5\u4e8b\u52a1\u65e5\u5fd7\u201d\u529f\u80fd\u67e5\u770b\u5bf9\u5e94\u7684\u4fe1\u606f\u6216\u5728\u201c\u5206\u5e03\u5f0f\u7ba1\u7406>\u5206\u5e03\u5f0f\u4e8b\u52a1>\u4e8b\u52a1\u67e5\u8be2\u201d\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"InvoiceDeleteValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
    }

    private Map<String, List<String>> getECUnFinishInvoiceIds() {
        ArrayList<String> idList = new ArrayList<String>(64);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            idList.add(bill.getString("id"));
        }
        HashMap<String, List<String>> unFinishedTxInfoMap = new HashMap<String, List<String>>(64);
        Map unfinishedTxBusinessInfo = TxCheckUtil.loadUnfinishedTxBusinessInfo(idList);
        if (ObjectUtils.isEmpty((Object)unfinishedTxBusinessInfo)) {
            return unFinishedTxInfoMap;
        }
        for (Map.Entry entrySet : unfinishedTxBusinessInfo.entrySet()) {
            String txBizNo = (String)entrySet.getKey();
            List billIds = (List)entrySet.getValue();
            for (String billId : billIds) {
                List txBizNos = unFinishedTxInfoMap.getOrDefault(billId, new ArrayList(8));
                txBizNos.add(txBizNo);
                unFinishedTxInfoMap.put(billId, txBizNos);
            }
        }
        return unFinishedTxInfoMap;
    }
}

