/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class VerifyRecordUnVerifyValidator
extends AbstractValidator {
    private static Long PURWRITEOFFTYPE_ID = 1363765058710014976L;
    private static Long PURWFSCHEME_LINKBILL_ID = 1363851625696857088L;
    private Map<String, List<DynamicObject>> wfTypeRecordMap = new HashMap<String, List<DynamicObject>>(16);
    private Set<ExtendedDataEntity> billDataEntitySet = new HashSet<ExtendedDataEntity>(16);

    public void validate() {
        HashSet<String> chargeOffRelation = new HashSet<String>(16);
        chargeOffRelation.add("finarwrittenoff");
        chargeOffRelation.add("saloutwrittenoff");
        chargeOffRelation.add("salreturnwrittenoff");
        chargeOffRelation.add("finapwrittenoff");
        chargeOffRelation.add("purwrittenoff");
        chargeOffRelation.add("purreturnwrittenoff");
        chargeOffRelation.add("purrecedwrittenoff");
        boolean isCheckPurUnWf = true;
        DBRoute route = new DBRoute("scm");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fkey,fvalue from t_im_invdbparam where fkey = 'closepurunwfcheck'", new Object[0]);
        DataSet paramSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)route, (SqlBuilder)sqlBuilder);
        for (Row param : paramSet) {
            String value = param.getString("fvalue");
            if (value == null || !"1".equals(value)) continue;
            isCheckPurUnWf = false;
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            String verifyType;
            DynamicObject billInfo = extendedDataEntity.getDataEntity();
            int verifySeq = billInfo.getInt("verifyseq");
            String verifyreLation = billInfo.getString("verifyrelation");
            if (isCheckPurUnWf && "cal_purwfrecord".equals(this.entityKey) && "auto".equals(verifyType = billInfo.getString("verifytype"))) {
                DynamicObject wfType = billInfo.getDynamicObject("writeofftypeid");
                DynamicObject wfScheme = billInfo.getDynamicObject("wfscheme");
                if (wfType != null && Long.compare(PURWRITEOFFTYPE_ID, wfType.getLong("id")) == 0 && wfScheme != null && Long.compare(PURWFSCHEME_LINKBILL_ID, wfScheme.getLong("id")) == 0) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5e8f\u53f7\u201c%1$s\u201d\uff0c\u5173\u8054\u5173\u7cfb\u751f\u6210\u7684\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u6838\u9500\uff0c\u8bf7\u901a\u8fc7\u53cd\u5ba1\u6838\u4e1a\u52a1\u5355\u636e\u5904\u7406\u3002", (String)"VerifyRecordUnVerifyValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), verifySeq));
                    continue;
                }
            }
            DynamicObjectCollection entrys = billInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                boolean isWrittenOff = entry.getBoolean("e_iswrittenoff");
                boolean hadWrittenOff = entry.getBoolean("e_hadwrittenoff");
                if (isWrittenOff || chargeOffRelation.contains(verifyreLation)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5e8f\u53f7\u201c%1$s\u201d\uff0c\u51b2\u9500\u7684\u6838\u9500\u8bb0\u5f55\u65e0\u6cd5\u53cd\u6838\u9500\u3002", (String)"VerifyRecordUnVerifyValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), verifySeq));
                    break;
                }
                if (!hadWrittenOff) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6838\u9500\u5e8f\u53f7\u201c%1$s\u201d\uff0c\u88ab\u51b2\u9500\u7684\u6838\u9500\u8bb0\u5f55\u65e0\u6cd5\u53cd\u6838\u9500\u3002", (String)"VerifyRecordUnVerifyValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), verifySeq));
                break;
            }
            this.collectRedBlueRecords(extendedDataEntity);
        }
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (isCQConfig.booleanValue()) {
            for (Map.Entry<String, List<DynamicObject>> entry : this.wfTypeRecordMap.entrySet()) {
                this.purSelfUnverifyCheck(entry.getValue());
            }
        }
    }

    private void collectRedBlueRecords(ExtendedDataEntity extendedDataEntity) {
        DynamicObject billInfo = extendedDataEntity.getDataEntity();
        String verifyRelation = billInfo.getString("verifyrelation");
        if ("purself".equals(verifyRelation)) {
            List<DynamicObject> purSelfRecord = this.wfTypeRecordMap.get("purself");
            if (purSelfRecord == null) {
                purSelfRecord = new ArrayList<DynamicObject>(16);
            }
            purSelfRecord.add(billInfo);
            this.billDataEntitySet.add(extendedDataEntity);
            this.wfTypeRecordMap.put("purself", purSelfRecord);
        } else if ("ominself".equals(verifyRelation)) {
            List<DynamicObject> ominSelfRecord = this.wfTypeRecordMap.get("purself");
            if (ominSelfRecord == null) {
                ominSelfRecord = new ArrayList<DynamicObject>(16);
            }
            ominSelfRecord.add(billInfo);
            this.billDataEntitySet.add(extendedDataEntity);
            this.wfTypeRecordMap.put("purself", ominSelfRecord);
        } else if ("appurreced".equals(verifyRelation) && "im_purreceivebill".equals(((DynamicObject)billInfo.getDynamicObjectCollection("entry").get(0)).getDynamicObject("e_billtype").getString("number"))) {
            List<DynamicObject> appurSelfRecord = this.wfTypeRecordMap.get("appurreced");
            if (appurSelfRecord == null) {
                appurSelfRecord = new ArrayList<DynamicObject>(16);
            }
            appurSelfRecord.add(billInfo);
            this.billDataEntitySet.add(extendedDataEntity);
            this.wfTypeRecordMap.put("purself", appurSelfRecord);
        }
    }

    private void purSelfUnverifyCheck(List<DynamicObject> purSelfList) {
        if (EmptyUtils.isNotEmpty(purSelfList)) {
            HashSet asstactIds = new HashSet(64);
            purSelfList.forEach(entry -> asstactIds.add(entry.getLong("asstact.id")));
            ArrayList ispremiumIds = new ArrayList(64);
            DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
            Arrays.stream(suppliers).filter(supplier -> supplier.getBoolean("issuppcolla")).forEach(supplier -> ispremiumIds.add(supplier.getLong("id")));
            if (ispremiumIds.size() > 0) {
                HashMap<Long, List<Long>> dataMap = new HashMap<Long, List<Long>>(64);
                HashMap<Long, String> billIdToBillNoMapping = new HashMap<Long, String>(64);
                for (DynamicObject purSelf : purSelfList) {
                    long asstactId = purSelf.getLong("asstact.id");
                    if (!ispremiumIds.contains(asstactId)) continue;
                    this.buildParamAndMapping(dataMap, purSelf, billIdToBillNoMapping);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(64);
                paramMap.put("billIds", dataMap);
                paramMap.put("entityName", purSelfList.get(0).getDynamicObject("billtype").getString("number"));
                paramMap.put("entryKey", "billentry");
                try (TXHandle tx = TX.requiresNew((String)"unVerifyinvokeScm");){
                    Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{paramMap});
                    if (resultMap.size() > 0 && !((Boolean)resultMap.get("succed")).booleanValue()) {
                        Map resultDataMap = (Map)resultMap.get("data");
                        HashSet noWriteoffEntryIds = new HashSet(16);
                        for (List entryIds : resultDataMap.values()) {
                            noWriteoffEntryIds.addAll(entryIds);
                        }
                        for (ExtendedDataEntity extendedDataEntity : this.billDataEntitySet) {
                            DynamicObject bill = extendedDataEntity.getDataEntity();
                            Long mainBillEntryId = bill.getLong("billentryid");
                            Long assistBillEntryId = ((DynamicObject)bill.getDynamicObjectCollection("entry").get(0)).getLong("e_billentryid");
                            if (!noWriteoffEntryIds.contains(mainBillEntryId) && !noWriteoffEntryIds.contains(assistBillEntryId)) continue;
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5931\u8d25\uff0c\u6240\u9009\u8bb0\u5f55\u5df2\u7531\u4f9b\u5e94\u5546\u534f\u540c\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u53cd\u6838\u9500\u3002", (String)"VerifyRecordUnVerifyValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                        }
                    }
                }
            }
        }
    }

    private void buildParamAndMapping(Map<Long, List<Long>> dataMap, DynamicObject purSelf, Map<Long, String> billIdToBillNoMapping) {
        List<Long> entryIds;
        Long billId = purSelf.getLong("billid");
        Long entryId = purSelf.getLong("billentryid");
        String billNo = purSelf.getString("billno");
        if (dataMap.get(billId) != null) {
            entryIds = dataMap.get(billId);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        } else {
            entryIds = new ArrayList<Long>(8);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        }
        DynamicObjectCollection entry = purSelf.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            List<Long> entryIds2;
            billId = row.getLong("e_billid");
            entryId = row.getLong("e_billentryid");
            billNo = row.getString("e_billno");
            if (dataMap.get(billId) != null) {
                entryIds2 = dataMap.get(billId);
                entryIds2.add(entryId);
                dataMap.put(billId, entryIds2);
                billIdToBillNoMapping.put(billId, billNo);
                continue;
            }
            entryIds2 = new ArrayList<Long>(8);
            entryIds2.add(entryId);
            dataMap.put(billId, entryIds2);
            billIdToBillNoMapping.put(billId, billNo);
        }
    }
}

