/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WriteOffBillValidator
extends AbstractValidator {
    private List<Long> writeOffBillPks;

    public WriteOffBillValidator(List<Long> writeOffBillPks) {
        this.writeOffBillPks = writeOffBillPks;
    }

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String entityKey = datas[0].getDataEntity().getDataEntityType().getName();
        boolean isAr = "ar_finarbill".equals(entityKey);
        List<ExtendedDataEntity> writtenOffDataEntities = Stream.of(datas).filter(data -> data.getDataEntity().getBoolean("iswrittenoff")).collect(Collectors.toList());
        if (writtenOffDataEntities.size() == 0) {
            return;
        }
        List writtenOffBills = writtenOffDataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List srcBillIds = writtenOffBills.stream().map(writtenOffBill -> writtenOffBill.getString("sourcebillid")).collect(Collectors.toList());
        long[] srcBillIdArray = srcBillIds.stream().mapToLong(Long::parseLong).toArray();
        QFilter qf = new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE);
        qf.and(new QFilter("sourcebillid", "in", isAr ? srcBillIds : (Object)srcBillIdArray));
        DynamicObjectCollection writeOffBills = QueryServiceHelper.query((String)entityKey, (String)"id,billno,sourcebillid,billstatus", (QFilter[])new QFilter[]{qf});
        DynamicObjectCollection nonAuditSrcBills = QueryServiceHelper.query((String)entityKey, (String)"id,billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcBillIdArray)});
        HashMap<Long, String> nonAuditSrcBillNos = new HashMap<Long, String>(16);
        for (DynamicObject srcBill : nonAuditSrcBills) {
            if ("C".equals(srcBill.getString("billstatus"))) continue;
            nonAuditSrcBillNos.put(srcBill.getLong("id"), srcBill.getString("billno"));
        }
        List sourceBillIds = writeOffBills.stream().map(writeOffBill -> writeOffBill.getLong("sourcebillid")).collect(Collectors.toList());
        List writeOffIds = writeOffBills.stream().map(writeOffBill -> writeOffBill.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.sourcebillid", "in", (Object)srcBillIdArray);
        qFilter.and("billstatus", "!=", (Object)"D");
        String liquidationKey = isAr ? "ar_liquidation" : "ap_liquidation";
        DynamicObjectCollection liquidationBills = QueryServiceHelper.query((String)liquidationKey, (String)"entryentity.sourcebillid", (QFilter[])new QFilter[]{qFilter});
        Set liquidationSourceBillIds = liquidationBills.stream().map(li -> li.getLong("entryentity.sourcebillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity writtenOffDataEntity : writtenOffDataEntities) {
            DynamicObject finBill = writtenOffDataEntity.getDataEntity();
            Long srcBillId = null;
            try {
                srcBillId = finBill.getLong("sourcebillid");
            }
            catch (KDBizException exp) {
                this.addErrorMessage(writtenOffDataEntity, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e\u8f6c\u6362\u5173\u7cfb\u4e2d\u7684\u6e90\u5355ID\u3002", (String)"WriteOffBillValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (nonAuditSrcBillNos.get(srcBillId) != null) {
                this.addErrorMessage(writtenOffDataEntity, ResManager.loadKDString((String)"\u88ab\u51b2\u9500\u7684\u5355\u636e\u201c%s\u201d\u4e0d\u662f\u5ba1\u6838\u6001\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"WriteOffBillValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{nonAuditSrcBillNos.get(srcBillId)}));
            }
            if (sourceBillIds.contains(srcBillId) && !writeOffIds.contains(finBill.getLong("id"))) {
                this.addErrorMessage(writtenOffDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u51b2\u9500\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"WriteOffBillValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (!liquidationSourceBillIds.contains(srcBillId)) continue;
            this.addErrorMessage(writtenOffDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8fdb\u884c\u8fc7\u6e05\u7406\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"WriteOffBillValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.writeOffBillPks.addAll(writeOffIds);
        this.writtenOffBillBookDateValidator(writtenOffDataEntities, srcBillIdArray, entityKey);
    }

    private void writtenOffBillBookDateValidator(List<ExtendedDataEntity> writtenOffDataEntities, long[] sourcebillIds, String entityKey) {
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)entityKey, (String)"id,bookdate,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourcebillIds)});
        HashMap<Long, Date> srcBillBookDateMap = new HashMap<Long, Date>(64);
        HashSet<Long> orgIds = new HashSet<Long>(sourceBills.size());
        HashMap currentDateMap = new HashMap(64);
        for (DynamicObject sourceBill : sourceBills) {
            srcBillBookDateMap.put(sourceBill.getLong("id"), sourceBill.getDate("bookdate"));
            orgIds.add(sourceBill.getLong("org"));
        }
        String closeAccountEntity = "ap_finapbill".equals(entityKey) ? "ap_closeaccount" : "ar_closeaccount";
        DynamicObjectCollection closeAccounts = QueryServiceHelper.query((String)closeAccountEntity, (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        closeAccounts.stream().forEach(closeAccount -> currentDateMap.put(closeAccount.getLong("org"), closeAccount.getDate("currentdate")));
        for (ExtendedDataEntity writtenOffDataEntity : writtenOffDataEntities) {
            DynamicObject writtenOffBill = writtenOffDataEntity.getDataEntity();
            Date writtenOffBillBookDate = writtenOffBill.getDate("bookdate");
            Date writtenOffBillBizdate = writtenOffBill.getDate("bizdate");
            Date currentDate = (Date)currentDateMap.get(writtenOffBill.getLong("org.id"));
            long sourceBillId = "ar_finarbill".equals(entityKey) ? Long.parseLong(writtenOffBill.getString("sourcebillid")) : writtenOffBill.getLong("sourcebillid");
            Date sourceBillBookDate = (Date)srcBillBookDateMap.get(sourceBillId);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (writtenOffBillBookDate == null || writtenOffBillBookDate.before(writtenOffBillBizdate)) {
                String message = writtenOffBillBookDate == null ? "" : simpleDateFormat.format(writtenOffBillBookDate);
                this.addErrorMessage(writtenOffDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u51b2\u9500\u65e5\u671f\u201c%2$s\u201d\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"WriteOffBillValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), message, simpleDateFormat.format(writtenOffBillBizdate)));
                continue;
            }
            if (sourceBillBookDate != null) {
                try {
                    sourceBillBookDate = simpleDateFormat.parse(simpleDateFormat.format(sourceBillBookDate));
                    writtenOffBillBookDate = simpleDateFormat.parse(simpleDateFormat.format(writtenOffBillBookDate));
                }
                catch (ParseException e) {
                    this.addErrorMessage(writtenOffDataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"WriteOffBillValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                    continue;
                }
                if (writtenOffBillBookDate.before(sourceBillBookDate)) {
                    this.addErrorMessage(writtenOffDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u6e90\u5355\u8bb0\u8d26\u65e5\u671f\u201c%2$s\u201d\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"WriteOffBillValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]), simpleDateFormat.format(writtenOffBillBookDate), simpleDateFormat.format(sourceBillBookDate)));
                    continue;
                }
            }
            if (currentDate == null || !writtenOffBillBookDate.before(currentDate)) continue;
            this.addErrorMessage(writtenOffDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u5c0f\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u201c%2$s\u201d\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"WriteOffBillValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]), simpleDateFormat.format(writtenOffBillBookDate), simpleDateFormat.format(currentDate)));
        }
    }
}

