/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.amount;

import kd.fi.arapcommon.validator.amount.AmountAbsGreaterThanEqualsValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountAbsLessThanEqualsValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountEqualsValidateStrategy;
import kd.fi.arapcommon.validator.amount.AmountGreaterThanEqualsValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountGreaterThanValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountLessThanEqualsValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountLessThanValidatorStrategy;
import kd.fi.arapcommon.validator.amount.AmountSameDirectionValidatorStrategy;
import kd.fi.arapcommon.validator.amount.LocalAmtNotZeroValidateStrategy;
import kd.fi.arapcommon.validator.amount.NotNullValidateStrategy;
import kd.fi.arapcommon.validator.amount.NotTanspayValidateStrategy;
import kd.fi.arapcommon.validator.amount.NotTransferValidateStrategy;
import kd.fi.arapcommon.validator.amount.ValidateStrategy;

public enum AmountValidator {
    AMOUNT_EQUALS(new AmountEqualsValidateStrategy()),
    AMOUNT_GREATER_THAN(new AmountGreaterThanValidatorStrategy()),
    AMOUNT_LESS_THAN(new AmountLessThanValidatorStrategy()),
    AMOUNT_GREATER_THAN_EQUALS(new AmountGreaterThanEqualsValidatorStrategy()),
    AMOUNT_LESS_THAN_EQUALS(new AmountLessThanEqualsValidatorStrategy()),
    AMOUNT_SAME_DIRECTION(new AmountSameDirectionValidatorStrategy()),
    AMOUNT_ABS_GREATER_THAN_EQUALS(new AmountAbsGreaterThanEqualsValidatorStrategy()),
    AMOUNT_ABS_LESS_THAN_EQUALS(new AmountAbsLessThanEqualsValidatorStrategy()),
    NOTTANSPAY_AND_AMOUNT_EQUALS(new NotTanspayValidateStrategy(new AmountEqualsValidateStrategy())),
    NOTTRANSFER_AND_AMOUNT_EQUALS(new NotTransferValidateStrategy(new AmountEqualsValidateStrategy())),
    NOT_NULL_AND_AMOUNT_LESS_THAN_EQUALS(new NotNullValidateStrategy(new AmountLessThanEqualsValidatorStrategy())),
    NOT_NULL_AND_LOCAL_AMOUNT_NOT_ZERO(new LocalAmtNotZeroValidateStrategy());

    private final ValidateStrategy strategy;

    private AmountValidator(ValidateStrategy strategy) {
        this.strategy = strategy;
    }

    public ValidateStrategy instance() {
        return this.strategy;
    }
}

