/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator.paysecurity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.ToleranceMatchService;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.paysecurity.AbstractBusBillPaySecurityValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import org.apache.commons.lang.StringUtils;

public class FinArExcessBusValidator
extends AbstractBusBillPaySecurityValidator {
    protected boolean useToleranceScheme() {
        return "true".equals(StdConfig.get("busPaysecurityUseTolerance"));
    }

    @Override
    protected boolean needSetPayproperty() {
        return true;
    }

    @Override
    protected void validataPayproperty(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam> busValidatorParams) {
        DynamicObject execcontrol = QueryServiceHelper.queryOne((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0131"}), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (execcontrol != null) {
            super.validataPayproperty(results, currentEntryIdToBusEntryIds, busValidatorParams);
        }
    }

    @Override
    protected void validateAmt(List<BusValidatorResult> results, Map<Long, Long> currentEntryIdToBusEntryIds, Map<Long, AbstractBusBillPaySecurityValidator.BusValidatorParam> busValidatorParams, String operateKey) {
        if (this.useToleranceScheme()) {
            logger.info("use tolerancescheme");
            super.validateAmt(results, currentEntryIdToBusEntryIds, busValidatorParams, operateKey);
        } else {
            Long orgId;
            logger.info("use system param");
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            for (BusValidatorResult result : results) {
                orgIds.add(result.getOrgId());
            }
            Map<Long, Map<String, Object>> toleranceMap = SystemParameterHelper.batchGetAppParameters(true, orgIds, "ar_035", "ar_036");
            HashMap<Long, BigDecimal> orgTolerances = new HashMap<Long, BigDecimal>(16);
            for (Map.Entry<Long, Map<String, Object>> entrySet : toleranceMap.entrySet()) {
                orgId = entrySet.getKey();
                Map<String, Object> parameters = entrySet.getValue();
                boolean ar_035 = (Boolean)parameters.get("ar_035");
                if (!ar_035) continue;
                BigDecimal tolerance = parameters.get("ar_036") == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(parameters.get("ar_036")));
                orgTolerances.put(orgId, tolerance);
            }
            if (orgTolerances.size() == 0) {
                return;
            }
            for (BusValidatorResult result : results) {
                AbstractBusBillPaySecurityValidator.BusValidatorParam param;
                Long entryId;
                Long srcBusEntryId;
                orgId = result.getOrgId();
                BigDecimal tolerance = (BigDecimal)orgTolerances.get(orgId);
                if (tolerance == null || (srcBusEntryId = currentEntryIdToBusEntryIds.get(entryId = result.getEntryId())) == null || (param = busValidatorParams.get(srcBusEntryId)) == null) continue;
                result.setSrcBusNo(param.getBillNo());
                BigDecimal busAmt = param.getAmount();
                BigDecimal sumAmt = param.getSumAmount();
                if (sumAmt.abs().compareTo(busAmt.abs().add(tolerance)) <= 0) continue;
            }
        }
    }

    @Override
    protected String getMessage(BusValidatorResult result, String validateType) {
        if ("price".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u6536\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5355\u4ef7\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinArExcessBusValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        if ("amount".equals(validateType)) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u6536\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u6536\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u91d1\u989d\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinArExcessBusValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        }
        return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u76d1\u6d4b\u5230\u8d85\u989d\u786e\u8ba4\u8d22\u52a1\u5e94\u6536\u5355\u3002\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u6536\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u6570\u91cf\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinArExcessBusValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
    }

    @Override
    protected void setPayPropertyMessage(BusValidatorResult result) {
        result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u9700\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArExcessBusValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo()));
    }

    @Override
    protected void setDirectionMessage(BusValidatorResult result, List<Integer> seqs) {
        if (result.isBasedonAmt()) {
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u5b58\u5728\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u7684\u660e\u7ec6\u884c\uff08\u7b2c%2$s\u884c\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArExcessBusValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), StringUtils.join(seqs, (String)"\u3001")));
        } else {
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s:\u5b58\u5728\u4e0e\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u6570\u91cf\u65b9\u5411\u4e0d\u4e00\u81f4\u7684\u660e\u7ec6\u884c\uff08\u7b2c%2$s\u884c\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinArExcessBusValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), StringUtils.join(seqs, (String)"\u3001")));
        }
    }

    @Override
    protected Map<String, Object> getToleranceResult(List<Map<String, Object>> toleranceParams, String validateType) {
        ToleranceMatchService service = new ToleranceMatchService();
        if ("price".equals(validateType)) {
            return service.getAllResult("ar_finarbill", "ar_busbill", "e_unitprice", "e_unitprice", toleranceParams);
        }
        if ("amount".equals(validateType)) {
            return service.getAllResult("ar_finarbill", "ar_busbill", "e_amount", "e_amount", toleranceParams);
        }
        return service.getAllResult("ar_finarbill", "ar_busbill", "e_quantity", "e_quantity", toleranceParams);
    }

    protected void writeAmtMessage(BusValidatorResult result) {
        String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u6682\u4f30\u5e94\u6536\u5355%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u6536\u5355\u3001\u624b\u5de5\u51b2\u56de\u7684\u6682\u4f30\u5e94\u6536\u51b2\u56de\u5355\u91d1\u989d\u7d2f\u8ba1\u503c\u4e0e\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91>\u516c\u5171\u8bbe\u7f6e>\u53c2\u6570\u914d\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u5e94\u6536-\u542f\u7528\u6682\u4f30\u5f00\u7968\u8d85\u989d\u63a7\u5236\u4fee\u6539\u6216\u914d\u7f6e\u5bb9\u5dee\u8303\u56f4\u3002", (String)"FinArExcessBusValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), result.getBillNo(), result.getSeq(), result.getSrcBusNo());
        if (result.getMessage() == null) {
            result.setMessage(message);
        } else {
            result.setMessage(result.getMessage() + '\n' + message);
        }
    }

    @Override
    protected void initValidataLevel() {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0093", "SZJK-PRE-0110", "SZJK-PRE-0111"})});
        for (DynamicObject ctrl : execcontrols) {
            String number = ctrl.getString("number");
            if ("SZJK-PRE-0093".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataQty = true;
                continue;
            }
            if ("SZJK-PRE-0111".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataPrice = true;
                continue;
            }
            if (!"SZJK-PRE-0110".equals(number) || !ctrl.getBoolean("enable")) continue;
            this.isValidataAmt = true;
        }
    }

    @Override
    protected String getTargetEntity() {
        return "ar_finarbill";
    }

    @Override
    protected String getSrcEntity() {
        return "ar_busbill";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("istransfer", "=", (Object)Boolean.FALSE).and(new QFilter("ispremium", "=", (Object)Boolean.FALSE)).and(new QFilter("billtype.number", "!=", (Object)"arfin_borrowar_BT_S"));
    }

    @Override
    protected String getSelector() {
        return "id,billno,org,sourcebilltype,payproperty.isbasedonamt isbasedonamt,entry.e_quantity qty,entry.e_unitprice price,entry.id entryid,entry.seq seq,entry.e_recamount taxamt,entry.e_amount amount,entry.e_srcid srcbillid,entry.e_srcentryid srcentryid";
    }
}

