/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.vo;

import java.io.Serializable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;

public class Result
implements Serializable {
    private static final String SUCCESS_CODE = "0";
    private static final String FAIL_CODE = "999";
    private String code;
    private String errorInfo;
    private Object data;

    public static Result success() {
        return new Result(SUCCESS_CODE);
    }

    public static Result success(Object data) {
        Result result = new Result(SUCCESS_CODE);
        result.setData(data);
        return result;
    }

    public static Result fail(String code, String errorInfo) {
        return new Result(code, errorInfo);
    }

    public static Result ex(Throwable ex) {
        Result result = new Result();
        if (ex instanceof KDBizException) {
            result.setErrorInfo(ex.getMessage());
        } else {
            result.setErrorInfo("the system is error : " + ex.getMessage());
        }
        if (ex instanceof KDException && !StringUtils.isEmpty((CharSequence)((KDException)ex).getErrorCode().getCode())) {
            result.setCode(((KDException)ex).getErrorCode().toString());
        } else {
            result.setCode(FAIL_CODE);
        }
        return result;
    }

    public Result() {
    }

    public Result(String code) {
        this.code = code;
    }

    public Result(String code, String errorInfo) {
        this.code = code;
        this.errorInfo = errorInfo;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code='" + this.code + '\'' + ", errorInfo='" + this.errorInfo + '\'' + ", data=" + this.data + '}';
    }
}

