/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.vo.BusBillWoffFieldVo;

public class BusBillUpgradeService {
    public static final String selector = "unwoffnotaxamt,unwoffnotaxlocamt,unwofftax,unwofftaxlocal,taxlocamt,amount,tax,localamt,entry.e_srcentryid,entry.e_amount,entry.e_localamt,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal,entry.e_invoicednotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxamt,entry.e_uninvnotaxlocalamt,entry.e_taxlocalamt,entry.e_tax";

    public static void upgrade(Set<Long> busIds, boolean isAr) {
        String entityName = isAr ? "ar_busbill" : "ap_busbill";
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", busIds)});
        BusBillUpgradeService.upgradeWoffFields(busBills, isAr);
        BusBillUpgradeService.upgradeInvoiceFields(busBills, isAr);
        SaveServiceHelper.save((DynamicObject[])busBills);
    }

    public static void upgradeWoffFields(DynamicObject[] busBills, boolean isAr) {
        String entityName = isAr ? "ar_busbill" : "ap_busbill";
        for (DynamicObject busBill : busBills) {
            busBill.set("unwoffnotaxamt", (Object)busBill.getBigDecimal("amount"));
            busBill.set("unwoffnotaxlocamt", (Object)busBill.getBigDecimal("localamt"));
            busBill.set("unwofftax", (Object)busBill.getBigDecimal("tax"));
            busBill.set("unwofftaxlocal", (Object)busBill.getBigDecimal("taxlocamt"));
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_unwoffnotaxamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_unwoffnotaxlocamt", (Object)entry.getBigDecimal("e_localamt"));
                entry.set("e_unwofftax", (Object)entry.getBigDecimal("e_tax"));
                entry.set("e_unwofftaxlocal", (Object)entry.getBigDecimal("e_taxlocalamt"));
            }
        }
        List busIds = Arrays.stream(busBills).map(v -> String.valueOf(v.getLong("id"))).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcebillid", "in", busIds).and(new QFilter("writeoffbusiness", "=", (Object)Boolean.FALSE)).and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection woffBills = QueryServiceHelper.query((String)entityName, (String)"entry.e_srcentryid,entry.e_amount,entry.e_tax,entry.e_taxlocalamt,entry.e_localamt", (QFilter[])new QFilter[]{filter});
        HashMap<Long, BusBillWoffFieldVo> woffMap = new HashMap<Long, BusBillWoffFieldVo>(2);
        for (DynamicObject woffBill : woffBills) {
            Long entryId = woffBill.getLong("entry.e_srcentryid");
            BusBillWoffFieldVo vo = (BusBillWoffFieldVo)woffMap.get(entryId);
            if (vo == null) {
                vo = new BusBillWoffFieldVo();
                vo.setEntryId(entryId);
                vo.setUnWoffAmt(woffBill.getBigDecimal("entry.e_amount"));
                vo.setUnWoffLocAmt(woffBill.getBigDecimal("entry.e_localamt"));
                vo.setUnWoffTax(woffBill.getBigDecimal("entry.e_tax"));
                vo.setUnWoffLocTax(woffBill.getBigDecimal("entry.e_taxlocalamt"));
                woffMap.put(entryId, vo);
                continue;
            }
            vo.setUnWoffAmt(vo.getUnWoffAmt().add(woffBill.getBigDecimal("entry.e_amount")));
            vo.setUnWoffLocAmt(vo.getUnWoffLocAmt().add(woffBill.getBigDecimal("entry.e_localamt")));
            vo.setUnWoffTax(vo.getUnWoffTax().add(woffBill.getBigDecimal("entry.e_tax")));
            vo.setUnWoffLocTax(vo.getUnWoffLocTax().add(woffBill.getBigDecimal("entry.e_taxlocalamt")));
        }
        for (DynamicObject busBill : busBills) {
            BigDecimal unWoffAmt = BigDecimal.ZERO;
            BigDecimal unWoffLocAmt = BigDecimal.ZERO;
            BigDecimal unWoffTax = BigDecimal.ZERO;
            BigDecimal unWoffLocTax = BigDecimal.ZERO;
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal e_unwofftaxlocal;
                BigDecimal e_unwofftax;
                BigDecimal e_unwoffnotaxlocamt;
                BigDecimal e_unwoffnotaxamt;
                Long entryId = entry.getLong("id");
                BusBillWoffFieldVo woffEntry = (BusBillWoffFieldVo)woffMap.get(entryId);
                if (woffEntry == null) {
                    e_unwoffnotaxamt = entry.getBigDecimal("e_amount");
                    e_unwoffnotaxlocamt = entry.getBigDecimal("e_localamt");
                    e_unwofftax = entry.getBigDecimal("e_tax");
                    e_unwofftaxlocal = entry.getBigDecimal("e_taxlocalamt");
                } else {
                    e_unwoffnotaxamt = entry.getBigDecimal("e_amount").add(woffEntry.getUnWoffAmt());
                    e_unwoffnotaxlocamt = entry.getBigDecimal("e_localamt").add(woffEntry.getUnWoffLocAmt());
                    e_unwofftax = entry.getBigDecimal("e_tax").add(woffEntry.getUnWoffTax());
                    e_unwofftaxlocal = entry.getBigDecimal("e_taxlocalamt").add(woffEntry.getUnWoffLocTax());
                }
                entry.set("e_unwoffnotaxamt", (Object)e_unwoffnotaxamt);
                entry.set("e_unwoffnotaxlocamt", (Object)e_unwoffnotaxlocamt);
                entry.set("e_unwofftax", (Object)e_unwofftax);
                entry.set("e_unwofftaxlocal", (Object)e_unwofftaxlocal);
                unWoffAmt = unWoffAmt.add(e_unwoffnotaxamt);
                unWoffLocAmt = unWoffLocAmt.add(e_unwoffnotaxlocamt);
                unWoffTax = unWoffTax.add(e_unwofftax);
                unWoffLocTax = unWoffLocTax.add(e_unwofftaxlocal);
            }
            busBill.set("unwoffnotaxamt", (Object)unWoffAmt);
            busBill.set("unwoffnotaxlocamt", (Object)unWoffLocAmt);
            busBill.set("unwofftax", (Object)unWoffTax);
            busBill.set("unwofftaxlocal", (Object)unWoffLocTax);
        }
    }

    public static void upgradeInvoiceFields(DynamicObject[] busBills, boolean isAr) {
        Object vo;
        Long srcEntryId;
        DynamicObjectCollection entrys;
        HashMap<Long, Object> finMap = new HashMap<Long, Object>(2);
        String finEntity = isAr ? "ar_finarbill" : "ap_finapbill";
        String selectors = isAr ? "entry.e_srcentryid,entry.e_amount,entry.e_localamt" : "detailentry.e_sourcebillentryid,detailentry.e_amount,detailentry.e_amountbase";
        String srcEntryIdField = isAr ? "entry.e_srcentryid" : "detailentry.e_sourcebillentryid";
        String amtField = isAr ? "entry.e_amount" : "detailentry.e_amount";
        String locAmtField = isAr ? "entry.e_localamt" : "detailentry.e_amountbase";
        ArrayList<Long> busEntryIds = new ArrayList<Long>(2);
        ArrayList<String> busEntryIdStr = new ArrayList<String>(2);
        ArrayList<Long> srcEntryIds = new ArrayList<Long>(((DynamicObject[])busBills).length);
        ArrayList<String> srcEntryIdStr = new ArrayList<String>(((DynamicObject[])busBills).length);
        QFilter qFilter = busBills;
        int n = ((DynamicObject[])qFilter).length;
        for (int i = 0; i < n; ++i) {
            DynamicObject busbill = qFilter[i];
            entrys = busbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long entryId = entry.getLong("id");
                busEntryIds.add(entryId);
                busEntryIdStr.add(String.valueOf(entryId));
                Long srcEntryId2 = entry.getLong("e_srcentryid");
                if (srcEntryId2 != null && srcEntryId2 != 0L) {
                    srcEntryIds.add(srcEntryId2);
                    srcEntryIdStr.add(String.valueOf(srcEntryId2));
                }
                entry.set("e_invoicednotaxamt", (Object)BigDecimal.ZERO);
                entry.set("e_invnotaxlocalamt", (Object)BigDecimal.ZERO);
                entry.set("e_uninvnotaxamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_localamt"));
            }
        }
        if (srcEntryIds.size() > 0) {
            QFilter sameSrcQFilter = isAr ? new QFilter("entry.e_srcentryid", "in", srcEntryIds).and(new QFilter("billstatus", "=", (Object)"C")) : new QFilter("detailentry.e_sourcebillentryid", "in", srcEntryIdStr).and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection finEntrys = QueryServiceHelper.query((String)finEntity, (String)selectors, (QFilter[])new QFilter[]{sameSrcQFilter});
            for (DynamicObject finEntry : finEntrys) {
                srcEntryId = isAr ? Long.valueOf(finEntry.getLong(srcEntryIdField)) : Long.valueOf(finEntry.getString(srcEntryIdField));
                vo = (BusBillWoffFieldVo)finMap.get(srcEntryId);
                if (vo == null) {
                    vo = new BusBillWoffFieldVo();
                    ((BusBillWoffFieldVo)vo).setEntryId(srcEntryId);
                    ((BusBillWoffFieldVo)vo).setInvAmt(finEntry.getBigDecimal(amtField));
                    ((BusBillWoffFieldVo)vo).setInvLocAmt(finEntry.getBigDecimal(locAmtField));
                    finMap.put(srcEntryId, vo);
                    continue;
                }
                ((BusBillWoffFieldVo)vo).setInvAmt(((BusBillWoffFieldVo)vo).getInvAmt().add(finEntry.getBigDecimal(amtField)));
                ((BusBillWoffFieldVo)vo).setInvLocAmt(((BusBillWoffFieldVo)vo).getInvLocAmt().add(finEntry.getBigDecimal(locAmtField)));
            }
        }
        for (DynamicObject busbill : busBills) {
            entrys = busbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long srcEntryId3 = entry.getLong("e_srcentryid");
                BusBillWoffFieldVo vo2 = (BusBillWoffFieldVo)finMap.get(srcEntryId3);
                if (vo2 == null) continue;
                entry.set("e_invoicednotaxamt", (Object)entry.getBigDecimal("e_invoicednotaxamt").add(vo2.getInvAmt()));
                entry.set("e_invnotaxlocalamt", (Object)entry.getBigDecimal("e_invnotaxlocalamt").add(vo2.getInvLocAmt()));
                entry.set("e_uninvnotaxamt", (Object)entry.getBigDecimal("e_uninvnotaxamt").subtract(vo2.getInvAmt()));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_uninvnotaxlocalamt").subtract(vo2.getInvLocAmt()));
            }
        }
        finMap.clear();
        QFilter directQFilter = isAr ? new QFilter("entry.e_srcentryid", "in", busEntryIds).and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)) : new QFilter("detailentry.e_sourcebillentryid", "in", busEntryIdStr).and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection direcFinBills = QueryServiceHelper.query((String)finEntity, (String)selectors, (QFilter[])new QFilter[]{directQFilter});
        for (DynamicObject finBill : direcFinBills) {
            srcEntryId = isAr ? Long.valueOf(finBill.getLong(srcEntryIdField)) : Long.valueOf(finBill.getString(srcEntryIdField));
            vo = (BusBillWoffFieldVo)finMap.get(srcEntryId);
            if (vo == null) {
                vo = new BusBillWoffFieldVo();
                ((BusBillWoffFieldVo)vo).setEntryId(srcEntryId);
                ((BusBillWoffFieldVo)vo).setInvAmt(finBill.getBigDecimal(amtField));
                ((BusBillWoffFieldVo)vo).setInvLocAmt(finBill.getBigDecimal(locAmtField));
                finMap.put(srcEntryId, vo);
                continue;
            }
            ((BusBillWoffFieldVo)vo).setInvAmt(((BusBillWoffFieldVo)vo).getInvAmt().add(finBill.getBigDecimal(amtField)));
            ((BusBillWoffFieldVo)vo).setInvLocAmt(((BusBillWoffFieldVo)vo).getInvLocAmt().add(finBill.getBigDecimal(locAmtField)));
        }
        for (Iterator busbill : busBills) {
            DynamicObjectCollection entrys2 = busbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys2) {
                Long entryId = entry.getLong("id");
                BusBillWoffFieldVo vo3 = (BusBillWoffFieldVo)finMap.get(entryId);
                if (vo3 == null) continue;
                entry.set("e_invoicednotaxamt", (Object)entry.getBigDecimal("e_invoicednotaxamt").add(vo3.getInvAmt()));
                entry.set("e_invnotaxlocalamt", (Object)entry.getBigDecimal("e_invnotaxlocalamt").add(vo3.getInvLocAmt()));
                entry.set("e_uninvnotaxamt", (Object)entry.getBigDecimal("e_uninvnotaxamt").subtract(vo3.getInvAmt()));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_uninvnotaxlocalamt").subtract(vo3.getInvLocAmt()));
            }
        }
    }
}

