/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.WriteBackBillQueryHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusBillWriteBack
extends AbstractWriteBackPlugIn {
    private boolean isAr = false;

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("ar_busbill".equals(e.getSrcMainType().getName())) {
            this.isAr = true;
        }
        List lst = e.getFieldKeys();
        lst.add("id");
        lst.add("unwoffamt");
        lst.add("unwofflocamt");
        lst.add("unwoffnotaxamt");
        lst.add("unwoffnotaxlocamt");
        lst.add("unwofftax");
        lst.add("unwofftaxlocal");
        lst.add("entry.id");
        lst.add("e_unwoffqty");
        lst.add("e_unwoffamt");
        lst.add("e_unwoffnotaxamt");
        lst.add("e_unwoffnotaxlocamt");
        lst.add("e_unwofftax");
        lst.add("e_unwofftaxlocal");
        lst.add("e_unwofflocamt");
        lst.add("isselfwoff");
        lst.add("isadjust");
        lst.add("writeoffbusiness");
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        DynamicObject[] srcDataEntities = e.getSrcDataEntities();
        if ("Delete".equals(this.getOpType())) {
            this.indirectSrcBusBillWriteBack(srcDataEntities);
        }
        this.updateBusWriteOff(srcDataEntities);
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        super.beforeSaveSourceBill(e);
        if (!Arrays.asList("Draft", "Save").contains(this.getOpType())) {
            return;
        }
        this.indirectSrcBusBillWriteBack(e.getSrcDataEntities());
    }

    private void indirectSrcBusBillWriteBack(DynamicObject[] srcBills) {
        List<DynamicObject> woffSrcBills = this.listWoffSrcBills(srcBills);
        if (EmptyUtils.isEmpty(woffSrcBills)) {
            return;
        }
        Map<Long, List<DynamicObject>> srcBillIdToIndirectSrcBusBillList = this.listIndirectSrcBusBillEntity(woffSrcBills);
        String opType = this.getOpType();
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"id, number, name");
        Date currentDate = new Date();
        for (DynamicObject woffSrcBill : woffSrcBills) {
            List<DynamicObject> indirectSrcBusBillList = srcBillIdToIndirectSrcBusBillList.get(woffSrcBill.getLong("id"));
            if (EmptyUtils.isEmpty(indirectSrcBusBillList)) {
                return;
            }
            this.executeWriteBack(woffSrcBill, indirectSrcBusBillList, opType, currentUser, currentDate);
            SaveServiceHelper.update((DynamicObject[])indirectSrcBusBillList.toArray(new DynamicObject[0]));
        }
    }

    private void updateBusWriteOff(DynamicObject[] srcDataEntities) {
        DynamicObject[] woffSrcBills;
        ArrayList<DynamicObject> needUpdateBusBill = new ArrayList<DynamicObject>(64);
        String entityName = this.isAr ? "ar_busbill" : "ap_busbill";
        HashSet<Long> busBillIds = new HashSet<Long>(srcDataEntities.length);
        for (DynamicObject woffSrcBill : srcDataEntities) {
            if (!entityName.equals(woffSrcBill.getDataEntityType().getName())) continue;
            busBillIds.add(woffSrcBill.getLong("id"));
        }
        for (DynamicObject woffSrcBill : woffSrcBills = BusinessDataServiceHelper.load((String)entityName, (String)"writeoffbusiness,isadjust,entry.e_unwoffqty", (QFilter[])new QFilter[]{new QFilter("id", "in", busBillIds)})) {
            boolean unwoffQtyZero = true;
            DynamicObjectCollection entry = woffSrcBill.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                if (BigDecimal.ZERO.compareTo(detail.getBigDecimal("e_unwoffqty")) == 0) continue;
                unwoffQtyZero = false;
                break;
            }
            woffSrcBill.set("writeoffbusiness", (Object)(woffSrcBill.getBoolean("isadjust") && unwoffQtyZero ? 1 : 0));
            needUpdateBusBill.add(woffSrcBill);
        }
        if (!needUpdateBusBill.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBusBill.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> listWoffSrcBills(DynamicObject[] srcBills) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        String entityName = this.isAr ? "ar_busbill" : "ap_busbill";
        for (DynamicObject srcBill : srcBills) {
            if (!entityName.equals(srcBill.getDataEntityType().getName()) || !srcBill.getBoolean("isadjust")) continue;
            result.add(srcBill);
        }
        DynamicObject[] dataResult = BusinessDataServiceHelper.load((String)entityName, (String)WriteBackBillQueryHelper.getSelectField(entityName), (QFilter[])new QFilter[]{new QFilter("id", "in", result.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList()))});
        return Arrays.asList(dataResult);
    }

    private void executeWriteBack(DynamicObject targetBusBill, List<DynamicObject> indirectSrcBusBillList, String opType, DynamicObject currentUser, Date currentDate) {
        boolean reverse = !"Delete".equals(opType);
        for (DynamicObject indirectSrcBusBill : indirectSrcBusBillList) {
            this.executeEntryWriteBack(targetBusBill, indirectSrcBusBill, reverse);
            this.headAmtSummarize(indirectSrcBusBill);
            indirectSrcBusBill.set("modifier", (Object)currentUser);
            indirectSrcBusBill.set("modifytime", (Object)currentDate);
        }
    }

    private void headAmtSummarize(DynamicObject indirectSrcBusBill) {
        BigDecimal headUnWoffAmt = BigDecimal.ZERO;
        BigDecimal headUnWoffLocalAmt = BigDecimal.ZERO;
        BigDecimal headUnWoffNoTaxAmt = BigDecimal.ZERO;
        BigDecimal headUnWoffNoTaxAmtLocal = BigDecimal.ZERO;
        BigDecimal headUnWoffTax = BigDecimal.ZERO;
        BigDecimal headUnWoffTaxLocal = BigDecimal.ZERO;
        for (DynamicObject indirectSrcEntry : indirectSrcBusBill.getDynamicObjectCollection("entry")) {
            headUnWoffAmt = headUnWoffAmt.add(indirectSrcEntry.getBigDecimal("e_unwoffamt"));
            headUnWoffLocalAmt = headUnWoffLocalAmt.add(indirectSrcEntry.getBigDecimal("e_unwofflocamt"));
            headUnWoffNoTaxAmt = headUnWoffNoTaxAmt.add(indirectSrcEntry.getBigDecimal("e_unwoffnotaxamt"));
            headUnWoffNoTaxAmtLocal = headUnWoffNoTaxAmtLocal.add(indirectSrcEntry.getBigDecimal("e_unwoffnotaxlocamt"));
            headUnWoffTax = headUnWoffTax.add(indirectSrcEntry.getBigDecimal("e_unwofftax"));
            headUnWoffTaxLocal = headUnWoffTaxLocal.add(indirectSrcEntry.getBigDecimal("e_unwofftaxlocal"));
        }
        indirectSrcBusBill.set("unwoffamt", (Object)headUnWoffAmt);
        indirectSrcBusBill.set("unwofflocamt", (Object)headUnWoffLocalAmt);
        indirectSrcBusBill.set("unwoffnotaxamt", (Object)headUnWoffNoTaxAmt);
        indirectSrcBusBill.set("unwoffnotaxlocamt", (Object)headUnWoffNoTaxAmtLocal);
        indirectSrcBusBill.set("unwofftax", (Object)headUnWoffTax);
        indirectSrcBusBill.set("unwofftaxlocal", (Object)headUnWoffTaxLocal);
    }

    private void executeEntryWriteBack(DynamicObject targetBusBill, DynamicObject indirectSrcBusBill, boolean reverse) {
        String busEntityKey = this.isAr ? "ar_busbill" : "ap_busbill";
        DynamicObjectCollection detailEntryCollection = targetBusBill.getDynamicObjectCollection("entry");
        Map<Long, Long> entryIdToSourceEntryIdMap = BOTPHelper.getSourceEntryIdsMap(busEntityKey, "entry", (Long[])detailEntryCollection.stream().map(entry -> entry.getLong("id")).toArray(Long[]::new), indirectSrcBusBill.getLong("id"));
        Map indirectSrcEntryIdMap = indirectSrcBusBill.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(entry -> entry.getLong("id"), Function.identity()));
        DynamicObject payProperty = targetBusBill.getDynamicObject("payproperty");
        for (DynamicObject targetEntry : targetBusBill.getDynamicObjectCollection("entry")) {
            long indirectSrcEntryId = entryIdToSourceEntryIdMap.get(targetEntry.getLong("id"));
            DynamicObject indirectSrcEntry = (DynamicObject)indirectSrcEntryIdMap.get(indirectSrcEntryId);
            if (EmptyUtils.isEmpty(indirectSrcEntry)) continue;
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwoffamt", reverse);
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwofflocamt", reverse);
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwoffnotaxamt", reverse);
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwoffnotaxlocamt", reverse);
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwofftax", reverse);
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwofftaxlocal", reverse);
            this.setUnWoffQty(reverse, payProperty, targetEntry, indirectSrcEntry);
            this.setWoffSwitch(indirectSrcEntry, reverse);
        }
    }

    private void setUnWoffQty(boolean reverse, DynamicObject payProperty, DynamicObject targetEntry, DynamicObject indirectSrcEntry) {
        BigDecimal quantity = indirectSrcEntry.getBigDecimal("e_quantity");
        boolean baseOnAmt = false;
        if (payProperty != null) {
            baseOnAmt = payProperty.getBoolean("isbasedonamt");
        }
        boolean present = targetEntry.getBoolean("e_ispresent");
        BigDecimal unitprice = targetEntry.getBigDecimal("e_unitprice");
        if (baseOnAmt) {
            if (present || unitprice.compareTo(BigDecimal.ZERO) == 0) {
                indirectSrcEntry.set("e_unwoffqty", (Object)(reverse ? quantity : BigDecimal.ZERO));
            } else {
                indirectSrcEntry.set("e_unwoffqty", (Object)(EmptyUtils.isEmpty(indirectSrcEntry.getBigDecimal("e_unwoffamt")) ? BigDecimal.ZERO : quantity));
            }
        } else {
            this.propertyWriteBack(targetEntry, indirectSrcEntry, "e_unwoffqty", reverse);
        }
    }

    private void setWoffSwitch(DynamicObject targetEntry, boolean reverse) {
        if (reverse) {
            targetEntry.set("e_iswriteoff", (Object)Boolean.FALSE);
            return;
        }
        boolean present = targetEntry.getBoolean("e_ispresent");
        BigDecimal unWoffAmt = targetEntry.getBigDecimal("e_unwofflocamt");
        BigDecimal unWoffQty = targetEntry.getBigDecimal("e_unwoffqty");
        Boolean writeOff = Boolean.FALSE;
        if (!present && BigDecimal.ZERO.compareTo(unWoffAmt) == 0) {
            writeOff = Boolean.TRUE;
        }
        if (present && BigDecimal.ZERO.compareTo(unWoffQty) == 0) {
            writeOff = Boolean.TRUE;
        }
        targetEntry.set("e_iswriteoff", (Object)writeOff);
    }

    private void propertyWriteBack(DynamicObject target, DynamicObject source, String propertyName, boolean reverse) {
        BigDecimal sourceAmt = source.getBigDecimal(propertyName);
        BigDecimal targetAmt = target.getBigDecimal(propertyName);
        BigDecimal result = sourceAmt.add(targetAmt);
        if (reverse) {
            result = sourceAmt.subtract(targetAmt);
        }
        source.set(propertyName, (Object)result);
    }

    private Map<Long, List<DynamicObject>> listIndirectSrcBusBillEntity(List<DynamicObject> srcBusBillList) {
        String busEntityKey = this.isAr ? "ar_busbill" : "ap_busbill";
        HashSet<Long> billIds = new HashSet<Long>(8);
        HashSet<Long> billEntryIds = new HashSet<Long>(8);
        for (DynamicObject srcBusBill : srcBusBillList) {
            billIds.add(srcBusBill.getLong("id"));
            DynamicObjectCollection entryColl = srcBusBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                billEntryIds.add(entry.getLong("id"));
            }
        }
        Map<Long, List<Long>> busSrcBillIds = BOTPHelper.loadNearUpBillIds(busEntityKey, "entry", billIds.toArray(new Long[0]), billEntryIds.toArray(new Long[0]), busEntityKey);
        if (EmptyUtils.isEmpty(busSrcBillIds)) {
            return Collections.emptyMap();
        }
        HashSet indirectSrcBusBillIds = new HashSet(16);
        busSrcBillIds.values().forEach(indirectSrcBusBillIds::addAll);
        DynamicObject[] indirectSrcBillList = BusinessDataServiceHelper.load((String)busEntityKey, (String)WriteBackBillQueryHelper.getSelectField(busEntityKey), (QFilter[])new QFilter("id", "in", indirectSrcBusBillIds).toArray());
        Map indirectSrcBillMap = Arrays.stream(indirectSrcBillList).collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, List<Long>> entry : busSrcBillIds.entrySet()) {
            HashSet value = new HashSet(entry.getValue());
            ArrayList<DynamicObject> resultValues = new ArrayList<DynamicObject>(16);
            for (Long id : value) {
                DynamicObject resultValue = (DynamicObject)indirectSrcBillMap.get(id);
                if (EmptyUtils.isEmpty(resultValue)) continue;
                resultValues.add(resultValue);
            }
            result.put(entry.getKey(), resultValues);
        }
        return result;
    }
}

