/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.util.ArrayList;
import java.util.List;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.ISettleWBService;

public abstract class AbstractSettleWBService
implements ISettleWBService {
    @Override
    public abstract void writeBack(List<SettleRecordVO> var1, SettleSchemeVO var2);

    @Override
    public void writeBackAsst(List<SettleRecordEntryVO> entryVOList, SettleSchemeVO scheme) {
        this.writeBack(this.convert2SRList(entryVOList), scheme);
    }

    protected List<SettleRecordVO> convert2SRList(List<SettleRecordEntryVO> entryVOList) {
        ArrayList<SettleRecordVO> srList = new ArrayList<SettleRecordVO>(entryVOList.size());
        SettleRecordVO sr = null;
        for (SettleRecordEntryVO entry : entryVOList) {
            sr = new SettleRecordVO();
            sr.setMainBillId(entry.getBillId());
            sr.setMainBillEntryId(entry.getBillEntryId());
            sr.setTotalSettleAmt(entry.getSettleAmt());
            sr.setLocalTotalSettleamt(entry.getLocalSettleAmt());
            sr.setExchangeRate(entry.getExchangeRate());
            sr.setSettleType(entry.getSettleType());
            sr.setSettleEntry(entry.getSettleEntry());
            sr.setAutoSettleType(entry.getAutoSettleType());
            sr.setMainVo(false);
            sr.setBillEntity(entry.getBillEntity());
            srList.add(sr);
        }
        return srList;
    }

    protected void repairSettleRecord(List<SettleRecordEntryVO> entryVOList, List<SettleRecordVO> settleRecordVOS) {
        int length = entryVOList.size();
        for (int i = 0; i < length; ++i) {
            entryVOList.get(i).setLocalSettleAmt(settleRecordVOS.get(i).getLocalTotalSettleamt());
        }
    }

    protected boolean needWBLock(SettleRecordVO result, SettleSchemeVO scheme, String ... possibleSources) {
        boolean needWBLock = false;
        if (scheme.isSettle()) {
            if (!(scheme.isOnlyByBotp() || scheme.isTransferPay() || scheme.isLiquidateSettle() || scheme.isClaim())) {
                needWBLock = true;
            }
            if (scheme.isAdjust()) {
                needWBLock = true;
            }
            if (SettleRelationEnum.APWRITEOFF.getValue().equals(scheme.getSettleRelation()) || SettleRelationEnum.ARWRITEOFF.getValue().equals(scheme.getSettleRelation())) {
                needWBLock = true;
            }
        } else if (SettleTypeEnum.MANUAL.getValue().equals(result.getSettleType()) || SettleTypeEnum.MATCH.getValue().equals(result.getSettleType()) || scheme.isUnSettleByListOP() || !this.isBotpSettleRecord(result, scheme, possibleSources)) {
            needWBLock = true;
        }
        return needWBLock;
    }

    private boolean isBotpSettleRecord(SettleRecordVO result, SettleSchemeVO scheme, String ... possibleSources) {
        boolean isBotpSettle = false;
        String autoSettleType = result.getAutoSettleType();
        if ("1".equals(autoSettleType) || "5".equals(autoSettleType)) {
            isBotpSettle = true;
        } else if ("0".equals(autoSettleType)) {
            isBotpSettle = !ArApHelper.verifyByCoreBill(result.getSettleType(), scheme.getAsstBillId(), scheme.getAsstEntity(), possibleSources);
        }
        return isBotpSettle;
    }
}

