/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.EntryWBTypeEnum;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.PaySettle4ScmcHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.freeze.UnSettleFreezeService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.entry.ApMaterialEntryWBService;
import kd.fi.arapcommon.writeback.entry.ApPlanEntryWBService;
import kd.fi.arapcommon.writeback.entry.EntryWBParam;
import kd.fi.arapcommon.writeback.entry.PrePlanWBService;
import kd.fi.arapcommon.writeback.settle.AbstractSettleWBService;

public class FinApSettleWBService
extends AbstractSettleWBService {
    private static final Log logger = LogFactory.getLog(FinApSettleWBService.class);
    private Map<Long, EntryWBParam> preParamMap;
    protected ApMaterialEntryWBService materialWBService;
    protected ApPlanEntryWBService planWBService;
    protected PrePlanWBService prePlanWBService;
    private int count = 0;

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        logger.info("FinApSettleWBService writeback as main start");
        this.writeBack0(voList, scheme);
        logger.info("FinApSettleWBService writeback as main end");
    }

    @Override
    public void writeBackAsst(List<SettleRecordEntryVO> entryVOList, SettleSchemeVO scheme) {
        logger.info("FinApSettleWBService writeback as asst start");
        List<SettleRecordVO> settleRecordVOS = this.writeBack0(this.convert2SRList(entryVOList), scheme);
        this.repairSettleRecord(entryVOList, settleRecordVOS);
        logger.info("FinApSettleWBService writeback as asst end");
    }

    private List<SettleRecordVO> writeBack0(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        this.initWBService();
        HashSet<Long> billIdSet = new HashSet<Long>(64);
        for (SettleRecordVO result : voList) {
            billIdSet.add(result.getMainBillId());
        }
        if (scheme.getSettleEntryParam() == 0) {
            scheme.setSettleEntryParam(voList.get(0).getSettleEntry());
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> apBillEntryMap = new HashMap<Long, DynamicObject>(64);
        boolean settleByMaterial = SettleEntryEnum.DETAIL.getValue() == voList.get(0).getSettleEntry();
        for (DynamicObject bill : apBills) {
            apBillMap.put(bill.getLong("id"), bill);
            if (!settleByMaterial) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                apBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        this.initPreParamMap(apBillMap, scheme);
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(64);
        logger.info("FinApSettleWBService writeback entry start");
        for (SettleRecordVO result : voList) {
            long mainBillId = result.getMainBillId();
            long mainBillEntryId = result.getMainBillEntryId();
            DynamicObject bill = (DynamicObject)apBillMap.get(mainBillId);
            if (bill == null) continue;
            if (!result.getEntrys().isEmpty()) {
                scheme.setAsstBillId(result.getEntrys().get(0).getBillId());
                scheme.setAsstEntity(result.getEntrys().get(0).getBillEntity());
            }
            this.wbHead(bill, result, scheme);
            DynamicObject entry = (DynamicObject)apBillEntryMap.get(mainBillEntryId);
            this.processCoreBillParam(rowList, bill, entry, result, scheme);
            boolean isWBLock = this.needWBLock(result, scheme, "ap_finapbill");
            this.wbPlanEntry(bill, result, scheme, isWBLock);
            this.wbMaterialEntry(bill, entry, result, scheme, isWBLock);
        }
        logger.info("FinApSettleWBService writeback entry end");
        Collection<DynamicObject> objColl = apBillMap.values();
        logger.info("FinApSettleWBService writeback afterWriteBack start");
        this.afterWriteBack(rowList, objColl, scheme);
        logger.info("FinApSettleWBService writeback afterWriteBack end");
        logger.info("FinApSettleWBService writeback ICallOrderConInvoker start");
        Settle4ScmcHelper.newWriteBackPurAndCon(voList, apBills, scheme, null);
        logger.info("FinApSettleWBService writeback ICallOrderConInvoker end");
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        if (!scheme.isSettle()) {
            Set<Long> apBillIds = objColl.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            UnSettleFreezeService service = new UnSettleFreezeService();
            service.freeze(apBillIds, true);
        }
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("settlescheme", SerializationUtils.toJsonString((Object)scheme));
            OperationResult afterSettleResut = OperationServiceHelper.executeOperate((String)"aftersettle", (String)"ap_finapbill", (DynamicObject[])objColl.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult(afterSettleResut);
        }
        catch (Exception e) {
            logger.error("aftersettle Exception:" + e);
        }
        return voList;
    }

    protected void initWBService() {
        this.materialWBService = BeanFactory.getBean(ApMaterialEntryWBService.class, new Object[0]);
        this.planWBService = BeanFactory.getBean(ApPlanEntryWBService.class, new Object[0]);
        this.prePlanWBService = BeanFactory.getBean(PrePlanWBService.class, new Object[0]);
    }

    protected void wbMaterialEntry(DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        int asstSettleEntryParam;
        int settleParam = scheme.getSettleEntryParam();
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(scheme.getSettleRelation()) && (asstSettleEntryParam = result.getSettleEntry()) != 0) {
            settleParam = asstSettleEntryParam;
        }
        if (1 == settleParam) {
            this.wbMaterialEntryById(bill, entry, result, scheme, isWBLock);
        } else {
            this.wbMaterialEntryByStrategy(bill, result, scheme, isWBLock);
        }
    }

    protected void wbMaterialEntryById(DynamicObject bill, DynamicObject detailEntry, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        boolean isUnSettleDisposeAll;
        if (detailEntry == null) {
            return;
        }
        BigDecimal settleAmt = result.getTotalSettleAmt();
        BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
        if (!scheme.isSettle()) {
            settleAmt = settleAmt.negate();
            localSettleAmt = localSettleAmt.negate();
        }
        detailEntry.set("settledamt", (Object)detailEntry.getBigDecimal("settledamt").add(settleAmt));
        detailEntry.set("unsettleamt", (Object)detailEntry.getBigDecimal("unsettleamt").subtract(settleAmt));
        boolean isSettleDisposeAll = detailEntry.getBigDecimal("unsettleamt").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = detailEntry.getBigDecimal("settledamt").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            result.setLocalTotalSettleamt(detailEntry.getBigDecimal("e_pricetaxtotalbase").subtract(detailEntry.getBigDecimal("settledamtbase")));
            detailEntry.set("settledamtbase", (Object)detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            detailEntry.set("unsettleamtbase", (Object)BigDecimal.ZERO);
        } else if (isUnSettleDisposeAll) {
            detailEntry.set("settledamtbase", (Object)BigDecimal.ZERO);
            detailEntry.set("unsettleamtbase", (Object)detailEntry.getBigDecimal("e_pricetaxtotalbase"));
        } else {
            detailEntry.set("settledamtbase", (Object)detailEntry.getBigDecimal("settledamtbase").add(localSettleAmt));
            detailEntry.set("unsettleamtbase", (Object)detailEntry.getBigDecimal("unsettleamtbase").subtract(localSettleAmt));
        }
        if (isWBLock) {
            detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").add(settleAmt));
            detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").subtract(settleAmt));
        }
    }

    @Deprecated
    protected void wbMaterialEntry(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        if (1 != scheme.getSettleEntryParam()) {
            this.wbMaterialEntryById(bill, result, scheme);
            this.wbMaterialEntryByStrategy(bill, result, scheme, isWBLock);
        }
    }

    @Deprecated
    protected void wbMaterialEntryById(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme) {
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
        long billEntryId = result.getMainBillEntryId();
        boolean needWBLock = this.needWBLock(result, scheme, "ap_finapbill");
        for (DynamicObject detailEntry : detailColl) {
            if (detailEntry.getLong("id") != billEntryId) continue;
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleamt = result.getLocalTotalSettleamt();
            if (!scheme.isSettle()) {
                settleAmt = settleAmt.negate();
                localSettleamt = localSettleamt.negate();
            }
            detailEntry.set("settledamt", (Object)detailEntry.getBigDecimal("settledamt").add(settleAmt));
            if (detailEntry.getBigDecimal("settledamt").compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("settledamtbase", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("settledamtbase", (Object)detailEntry.getBigDecimal("settledamtbase").add(localSettleamt));
            }
            detailEntry.set("unsettleamt", (Object)detailEntry.getBigDecimal("unsettleamt").subtract(settleAmt));
            if (detailEntry.getBigDecimal("unsettleamt").compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("unsettleamtbase", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("unsettleamtbase", (Object)detailEntry.getBigDecimal("unsettleamtbase").subtract(localSettleamt));
            }
            if (!needWBLock) continue;
            detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").add(settleAmt));
            detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").subtract(settleAmt));
        }
    }

    protected void wbMaterialEntryByStrategy(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        BigDecimal settleAmt = result.getTotalSettleAmt();
        BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
        if (!scheme.isSettle()) {
            settleAmt = settleAmt.negate();
            localSettleAmt = localSettleAmt.negate();
        }
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject currency = bill.getDynamicObject("currency");
        int scale = currency == null ? 2 : currency.getInt("amtprecision");
        DynamicObject basecurrency = bill.getDynamicObject("basecurrency");
        int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
        String quotation = bill.getString("quotation");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("detailentry");
        List noPresenEntries = entries.stream().filter(entry -> entry.getBigDecimal("e_pricetaxtotal").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        BigDecimal headAmt = bill.getBigDecimal("pricetaxtotal");
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        BigDecimal remainPlanLockAmt = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntries) {
            remainPlanLockAmt = remainPlanLockAmt.add(planEntry.getBigDecimal("planlockedamt"));
        }
        boolean isWriteBackLockAll = remainPlanLockAmt.compareTo(BigDecimal.ZERO) == 0;
        int entryCount = 0;
        BigDecimal remainSettleAmt = settleAmt;
        BigDecimal remainLocalSettleAmt = localSettleAmt;
        BigDecimal remainLockAmt = settleAmt;
        for (DynamicObject entry2 : noPresenEntries) {
            ++entryCount;
            BigDecimal entryAmt = entry2.getBigDecimal("e_pricetaxtotal");
            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
            BigDecimal curSettleAmt = settleAmt.multiply(proportion).setScale(scale, RoundingMode.HALF_UP);
            if (isSettleDisposeAll) {
                entry2.set("unsettleamt", (Object)BigDecimal.ZERO);
                entry2.set("settledamt", (Object)entryAmt);
                entry2.set("unsettleamtbase", (Object)BigDecimal.ZERO);
                entry2.set("settledamtbase", (Object)entry2.getBigDecimal("e_pricetaxtotalbase"));
            } else if (isUnSettleDisposeAll) {
                entry2.set("unsettleamt", (Object)entryAmt);
                entry2.set("settledamt", (Object)BigDecimal.ZERO);
                entry2.set("unsettleamtbase", (Object)entry2.getBigDecimal("e_pricetaxtotalbase"));
                entry2.set("settledamtbase", (Object)BigDecimal.ZERO);
            } else if (entryCount == noPresenEntries.size()) {
                entry2.set("unsettleamt", (Object)entry2.getBigDecimal("unsettleamt").subtract(remainSettleAmt));
                entry2.set("settledamt", (Object)entry2.getBigDecimal("settledamt").add(remainSettleAmt));
                entry2.set("unsettleamtbase", (Object)entry2.getBigDecimal("unsettleamtbase").subtract(remainLocalSettleAmt));
                entry2.set("settledamtbase", (Object)entry2.getBigDecimal("settledamtbase").add(remainLocalSettleAmt));
            } else {
                entry2.set("unsettleamt", (Object)entry2.getBigDecimal("unsettleamt").subtract(curSettleAmt));
                entry2.set("settledamt", (Object)entry2.getBigDecimal("settledamt").add(curSettleAmt));
                BigDecimal curLocalSettleAmt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, baseScale);
                entry2.set("unsettleamtbase", (Object)entry2.getBigDecimal("unsettleamtbase").subtract(curLocalSettleAmt));
                entry2.set("settledamtbase", (Object)entry2.getBigDecimal("settledamtbase").add(curLocalSettleAmt));
                remainSettleAmt = remainSettleAmt.subtract(curSettleAmt);
                remainLocalSettleAmt = remainLocalSettleAmt.subtract(curLocalSettleAmt);
            }
            if (!isWBLock) continue;
            if (isSettleDisposeAll) {
                entry2.set("unlockamt", (Object)BigDecimal.ZERO);
                entry2.set("lockedamt", (Object)entryAmt);
                continue;
            }
            if (isUnSettleDisposeAll && isWriteBackLockAll) {
                entry2.set("unlockamt", (Object)entryAmt);
                entry2.set("lockedamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (entryCount == noPresenEntries.size()) {
                entry2.set("unlockamt", (Object)entry2.getBigDecimal("unlockamt").subtract(remainLockAmt));
                entry2.set("lockedamt", (Object)entry2.getBigDecimal("lockedamt").add(remainLockAmt));
                continue;
            }
            entry2.set("unlockamt", (Object)entry2.getBigDecimal("unlockamt").subtract(curSettleAmt));
            entry2.set("lockedamt", (Object)entry2.getBigDecimal("lockedamt").add(curSettleAmt));
            remainLockAmt = remainLockAmt.subtract(curSettleAmt);
        }
    }

    protected void wbPlanEntry(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        int asstSettleEntryParam;
        int settleParam = scheme.getSettleEntryParam();
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(scheme.getSettleRelation()) && (asstSettleEntryParam = result.getSettleEntry()) != 0) {
            settleParam = asstSettleEntryParam;
        }
        if (2 == settleParam) {
            this.wbPlanEntryById(bill, result, scheme, isWBLock);
        } else {
            this.wbPlanEntryByStrategy(bill, result, scheme, isWBLock);
        }
    }

    protected void wbPlanEntryById(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        DynamicObjectCollection planColl = bill.getDynamicObjectCollection("planentity");
        long billEntryId = result.getMainBillEntryId();
        for (DynamicObject planEntry : planColl) {
            boolean isUnSettleDisposeAll;
            if (planEntry.getLong("id") != billEntryId) continue;
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!scheme.isSettle()) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
            planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
            boolean isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
            boolean bl = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
            if (isSettleDisposeAll) {
                result.setLocalTotalSettleamt(planEntry.getBigDecimal("planpricetaxloc").subtract(planEntry.getBigDecimal("plansettledlocamt")));
                planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
            } else if (isUnSettleDisposeAll) {
                planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
            } else {
                planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
                planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
            }
            if (!isWBLock) continue;
            planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
            planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
        }
    }

    protected void wbPlanEntryByStrategy(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme, boolean isWBLock) {
        EntryWBParam preParam = this.preParamMap.get(bill.getLong("id"));
        if (preParam != null) {
            this.prePlanWBService.execute(bill, preParam);
        }
        if (scheme.isSettle()) {
            this.wbPlanEntryByMaterialOfSettle(bill, result.getTotalSettleAmt(), result.getLocalTotalSettleamt(), isWBLock);
        } else {
            this.wbPlanEntryByMaterialOfUnSettle(bill, result.getTotalSettleAmt().negate(), result.getLocalTotalSettleamt().negate(), isWBLock);
        }
        if (preParam != null) {
            preParam.setForward(!preParam.isForward());
            this.prePlanWBService.execute(bill, preParam);
            preParam.setForward(!preParam.isForward());
        }
    }

    private void wbPlanEntryByMaterialOfSettle(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock) {
        block10: {
            DynamicObjectCollection planEntries;
            block9: {
                boolean isSettleDisposeAll;
                boolean isZeroSettle;
                planEntries = bill.getDynamicObjectCollection("planentity");
                boolean bl = isZeroSettle = bill.getBigDecimal("pricetaxtotal").compareTo(BigDecimal.ZERO) == 0;
                if (!isZeroSettle) break block9;
                DynamicObject planEntry = (DynamicObject)planEntries.get(0);
                planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
                planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
                boolean bl2 = isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                } else {
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
                }
                if (!isWBLock) break block10;
                planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
                planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
                break block10;
            }
            BigDecimal remainLocalSettleAmt = BigDecimal.ZERO;
            boolean needSpecialHandle = planEntries.size() == 1;
            for (DynamicObject planEntry : planEntries) {
                boolean isSettleDisposeAll;
                BigDecimal unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                BigDecimal direction = new BigDecimal(settleAmt.signum());
                BigDecimal curSettleAmt = BigDecimal.ZERO;
                if (needSpecialHandle) {
                    curSettleAmt = settleAmt;
                } else if (unSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                    curSettleAmt = (unSettleAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt.abs() : unSettleAmt.abs()).multiply(direction);
                }
                if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                planEntry.set("unplansettleamt", (Object)unSettleAmt.subtract(curSettleAmt));
                planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(curSettleAmt));
                boolean bl = isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    remainLocalSettleAmt = remainLocalSettleAmt.add(planEntry.getBigDecimal("unplansettlelocamt"));
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
                } else {
                    BigDecimal curSettleAmtLocal = localSettleAmt.subtract(remainLocalSettleAmt);
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(curSettleAmtLocal));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(curSettleAmtLocal));
                }
                if (isWBLock) {
                    planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curSettleAmt));
                    planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curSettleAmt));
                }
                if ((settleAmt = settleAmt.subtract(curSettleAmt)).compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
        }
    }

    private void wbPlanEntryByMaterialOfUnSettle(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock) {
        boolean isZeroUnSettle;
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        boolean bl = isZeroUnSettle = bill.getBigDecimal("pricetaxtotal").compareTo(BigDecimal.ZERO) == 0;
        if (isZeroUnSettle) {
            boolean isUnSettleDisposeAll;
            DynamicObject planEntry = (DynamicObject)planEntries.get(0);
            planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
            planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
            boolean bl2 = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
            if (isUnSettleDisposeAll) {
                planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
            } else {
                planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
                planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
            }
            if (isWBLock) {
                planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
                planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
            }
        } else {
            BigDecimal remainLocalSettleAmt = BigDecimal.ZERO;
            boolean needSpecialHandle = planEntries.size() == 1;
            for (int i = planEntries.size() - 1; i >= 0; --i) {
                boolean isUnSettleDisposeAll;
                DynamicObject planEntry = (DynamicObject)planEntries.get(i);
                BigDecimal settlePlanAmt = planEntry.getBigDecimal("plansettledamt");
                BigDecimal direction = new BigDecimal(settleAmt.signum());
                BigDecimal curSettleAmt = BigDecimal.ZERO;
                if (needSpecialHandle) {
                    curSettleAmt = settleAmt;
                } else if (settlePlanAmt.compareTo(BigDecimal.ZERO) != 0) {
                    curSettleAmt = (settlePlanAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt.abs() : settlePlanAmt.abs()).multiply(direction);
                }
                if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(curSettleAmt));
                planEntry.set("plansettledamt", (Object)settlePlanAmt.add(curSettleAmt));
                boolean bl3 = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
                if (isUnSettleDisposeAll) {
                    remainLocalSettleAmt = remainLocalSettleAmt.add(planEntry.getBigDecimal("plansettledlocamt"));
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal curSettleAmtLocal = localSettleAmt.subtract(remainLocalSettleAmt.negate());
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(curSettleAmtLocal));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(curSettleAmtLocal));
                }
                if (isWBLock) {
                    planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curSettleAmt));
                    planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curSettleAmt));
                }
                if ((settleAmt = settleAmt.subtract(curSettleAmt)).compareTo(BigDecimal.ZERO) == 0) break;
            }
        }
    }

    protected void wbHead(DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme) {
        boolean isUnSettleDisposeAll;
        BigDecimal settleAmt = result.getTotalSettleAmt();
        BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
        if (!scheme.isSettle()) {
            settleAmt = settleAmt.negate();
            localSettleAmt = localSettleAmt.negate();
        }
        bill.set("unsettleamount", (Object)bill.getBigDecimal("unsettleamount").subtract(settleAmt));
        bill.set("settleamount", (Object)bill.getBigDecimal("settleamount").add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)BigDecimal.ZERO);
            bill.set("settleamountbase", (Object)bill.getBigDecimal("pricetaxtotalbase"));
        } else if (isUnSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("pricetaxtotalbase"));
            bill.set("settleamountbase", (Object)BigDecimal.ZERO);
        } else {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("unsettleamountbase").subtract(localSettleAmt));
            bill.set("settleamountbase", (Object)bill.getBigDecimal("settleamountbase").add(localSettleAmt));
        }
    }

    protected void processCoreBillParam(List<Map<String, Object>> rowList, DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme) {
        String settleRelation = result.getSettleRela();
        if (!ObjectUtils.isEmpty((Object)settleRelation) && (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation))) {
            long mainBillEntryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            if (!scheme.isSettle()) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject currency = bill.getDynamicObject("currency");
            if (1 == scheme.getSettleEntryParam()) {
                if (entry == null) {
                    return;
                }
                String corebillType = entry.getString("corebilltype");
                String corebillNo = entry.getString("corebillno");
                long corebillId = entry.getLong("corebillid");
                if (corebillId != 0L && !ObjectUtils.isEmpty((Object)corebillType) && !ObjectUtils.isEmpty((Object)corebillNo)) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", entry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", mainBillEntryId);
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    row.put("paidamount", settleAmt);
                    rowList.add(row);
                }
            } else {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
                BigDecimal headAmt = bill.getBigDecimal("pricetaxtotal");
                BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
                BigDecimal disposeAmt = BigDecimal.ZERO;
                int count = 0;
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailColl) {
                    String corebillType = detailEntry.getString("corebilltype");
                    String corebillNo = detailEntry.getString("corebillno");
                    long corebillId = detailEntry.getLong("corebillid");
                    BigDecimal entryAmt = detailEntry.getBigDecimal("e_pricetaxtotal");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    if (headUnSettle.compareTo(headAmt) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("settledamt") : detailEntry.getBigDecimal("settledamt").negate();
                    } else if (headUnSettle.compareTo(BigDecimal.ZERO) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("unsettleamt") : detailEntry.getBigDecimal("unsettleamt").negate();
                    } else if (++count == detailColl.size()) {
                        disposeAmt = remainDisposeAmount;
                    } else {
                        BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                        disposeAmt = settleAmt.multiply(proportion).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", detailEntry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", mainBillEntryId);
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    row.put("paidamount", disposeAmt);
                    rowList.add(row);
                }
            }
        }
    }

    public void processCoreBillNewParam(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme) {
        this.processCoreBillParamByApSelf(assactInterMap, bill, entry, result, scheme);
        this.processCoreBillByApBillMain(assactInterMap, bill, entry, result, scheme);
        this.processCoreBillByApBillAsst(assactInterMap, bill, entry, result, scheme);
    }

    protected void processCoreBillByApBillMain(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme) {
        String settleRelation = result.getSettleRela();
        if (ObjectUtils.isEmpty((Object)settleRelation) || !result.isMainVo() || !SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.PAYTRANS.getValue().equals(settleRelation) && !SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.APLIQUIDATIONSETTLE.getValue().equals(settleRelation) || bill.getBoolean("istanspay")) {
            return;
        }
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
        List<Map<String, Object>> paramList = scheme.getParamList();
        DynamicObject currency = bill.getDynamicObject("currency");
        long asstactId = bill.getLong("asstact.id");
        long orgId = bill.getLong("org.id");
        Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
        List<SettleRecordEntryVO> recordEntryVOS = result.getEntrys();
        BigDecimal entrySettleTotal = BigDecimal.ZERO;
        for (SettleRecordEntryVO entryVO : recordEntryVOS) {
            entrySettleTotal = entrySettleTotal.add(entryVO.getSettleAmt());
        }
        BigDecimal totalSettleAmt = result.getTotalSettleAmt();
        if (1 == scheme.getSettleEntryParam()) {
            if (entry == null) {
                logger.info("processCoreBillByApBillMain settleEntry==1 but entry==null");
                return;
            }
            String coreBillType = entry.getString("corebilltype");
            long coreBillId = entry.getLong("corebillid");
            long coreBillEntryId = entry.getLong("corebillentryid");
            long conBillId = entry.getLong("e_conbillid");
            long conBillEntryId = entry.getLong("e_conbillentryid");
            if (!("pm_purorderbill".equals(coreBillType) || "sctm_scpo".equals(coreBillType) || "conm_purcontract".equals(coreBillType))) {
                return;
            }
            if (0L == conBillId && 0L == coreBillId) {
                return;
            }
            BigDecimal remainingAmt = totalSettleAmt;
            for (int i = 0; i < recordEntryVOS.size(); ++i) {
                SettleRecordEntryVO recordEntryVO = recordEntryVOS.get(i);
                BigDecimal recordEntrySettleAmt = totalSettleAmt;
                if (i == recordEntryVOS.size() - 1) {
                    recordEntrySettleAmt = remainingAmt;
                } else {
                    recordEntrySettleAmt = totalSettleAmt.multiply(recordEntryVO.getSettleAmt()).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    remainingAmt = remainingAmt.subtract(recordEntrySettleAmt);
                }
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("apbill_mainbillentity", coreBillType);
                param.put("apbill_mainbillid", coreBillId);
                param.put("apbill_mainbillentryid", coreBillEntryId);
                param.put("internal_company", isExistInternal);
                param.put("settleorgid", orgId);
                param.put("supplierid", asstactId);
                param.put("mainBillEntity", coreBillType);
                param.put("mainBillID", coreBillId);
                param.put("mainBillEntryID", coreBillEntryId);
                param.put("contractID", conBillId);
                param.put("contractEntryID", conBillEntryId);
                param.put("internalAsst", isExistInternal);
                param.put("settleOrgID", orgId);
                param.put("asstactID", asstactId);
                param.put("accessType", "AP");
                param.put("amount", scheme.isSettle() ? recordEntrySettleAmt : recordEntrySettleAmt.negate());
                param.put("settleRelation", settleRelation);
                param.put("ArApBillId", bill.getLong("id"));
                param.put("asst_record_id", recordEntryVO.getBillId());
                param.put("asst_record_entryid", recordEntryVO.getBillEntryId());
                param.put("asst_record_entity", recordEntryVO.getBillEntity());
                paramList.add(param);
            }
        } else {
            this.count = 0;
            for (DynamicObject detailEntry : detailColl) {
                if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                ++this.count;
            }
            BigDecimal remainDisDetailAmt = totalSettleAmt;
            HashMap<Long, BigDecimal> recordEntryUseAmtMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject detailEntry : detailColl) {
                BigDecimal detailSettleAmt = this.allocationAmtByPlan(detailEntry, bill, remainDisDetailAmt, totalSettleAmt);
                remainDisDetailAmt = remainDisDetailAmt.subtract(detailSettleAmt);
                String coreBillType = detailEntry.getString("corebilltype");
                long coreBillId = detailEntry.getLong("corebillid");
                long coreBillEntryId = detailEntry.getLong("corebillentryid");
                long conBillId = detailEntry.getLong("e_conbillid");
                long conBillEntryId = detailEntry.getLong("e_conbillentryid");
                if (BigDecimal.ZERO.compareTo(detailSettleAmt) == 0 || !"pm_purorderbill".equals(coreBillType) && !"sctm_scpo".equals(coreBillType) && !"conm_purcontract".equals(coreBillType) || 0L == conBillId && 0L == coreBillId) continue;
                BigDecimal remainSettleEntryAmt = detailSettleAmt;
                for (int i = 0; i < recordEntryVOS.size(); ++i) {
                    SettleRecordEntryVO recordEntryVO = recordEntryVOS.get(i);
                    BigDecimal entrySettleAmt = recordEntryVO.getSettleAmt();
                    long asstBillEntryId = recordEntryVO.getBillEntryId();
                    BigDecimal recordEntryUseAmt = recordEntryUseAmtMap.getOrDefault(asstBillEntryId, BigDecimal.ZERO);
                    BigDecimal disposeAmt = detailSettleAmt;
                    disposeAmt = this.count == 0 ? (entrySettleAmt.signum() != totalSettleAmt.signum() ? entrySettleAmt.negate().subtract(recordEntryUseAmt) : entrySettleAmt.subtract(recordEntryUseAmt)) : (i == recordEntryVOS.size() - 1 ? remainSettleEntryAmt : detailSettleAmt.multiply(entrySettleAmt).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                    if (disposeAmt.abs().add(recordEntryUseAmt.abs()).compareTo(entrySettleAmt.abs()) > 0) {
                        disposeAmt = totalSettleAmt.signum() != entrySettleAmt.signum() ? entrySettleAmt.abs().subtract(recordEntryUseAmt.abs()).negate() : entrySettleAmt.subtract(recordEntryUseAmt);
                    }
                    remainSettleEntryAmt = remainSettleEntryAmt.subtract(disposeAmt);
                    recordEntryUseAmtMap.put(asstBillEntryId, disposeAmt.add(recordEntryUseAmt));
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    param.put("apbill_mainbillentity", coreBillType);
                    param.put("apbill_mainbillid", coreBillId);
                    param.put("apbill_mainbillentryid", coreBillEntryId);
                    param.put("internal_company", isExistInternal);
                    param.put("settleorgid", orgId);
                    param.put("supplierid", asstactId);
                    param.put("mainBillEntity", coreBillType);
                    param.put("mainBillID", coreBillId);
                    param.put("mainBillEntryID", coreBillEntryId);
                    param.put("contractID", conBillId);
                    param.put("contractEntryID", conBillEntryId);
                    param.put("internalAsst", isExistInternal);
                    param.put("settleOrgID", orgId);
                    param.put("accessType", "AP");
                    param.put("asstactID", asstactId);
                    param.put("amount", scheme.isSettle() ? disposeAmt : disposeAmt.negate());
                    param.put("settleRelation", settleRelation);
                    param.put("ArApBillId", bill.getLong("id"));
                    param.put("asst_record_id", recordEntryVO.getBillId());
                    param.put("asst_record_entryid", asstBillEntryId);
                    param.put("asst_record_entity", recordEntryVO.getBillEntity());
                    paramList.add(param);
                }
            }
        }
    }

    protected void processCoreBillByApBillAsst(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme) {
        String settleRelation = scheme.getSettleRelation();
        if (result.isMainVo() || bill.getBoolean("istanspay") || !SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation)) {
            return;
        }
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
        BigDecimal recordEntrySettleAmt = result.getTotalSettleAmt();
        long orgId = bill.getLong("org.id");
        long asstactId = bill.getLong("asstact.id");
        Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
        List<Map<String, Object>> paramList = scheme.getParamList();
        if (1 == scheme.getSettleEntryParam()) {
            if (entry == null) {
                logger.info("processCoreBillByApBillAsst settleEntry==1 but entry==null");
                return;
            }
            String coreBillType = entry.getString("corebilltype");
            if (!("pm_purorderbill".equals(coreBillType) || "sctm_scpo".equals(coreBillType) || "conm_purcontract".equals(coreBillType))) {
                return;
            }
            long coreBillId = entry.getLong("corebillid");
            long coreBillEntryId = entry.getLong("corebillentryid");
            long conBillId = entry.getLong("e_conbillid");
            long conBillEntryId = entry.getLong("e_conbillentryid");
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("internal_company", isExistInternal);
            param.put("settleorgid", orgId);
            param.put("supplierid", asstactId);
            param.put("apbill_mainbillentity", coreBillType);
            param.put("apbill_mainbillid", coreBillId);
            param.put("apbill_mainbillentryid", coreBillEntryId);
            param.put("mainBillEntity", coreBillType);
            param.put("mainBillID", coreBillId);
            param.put("mainBillEntryID", coreBillEntryId);
            param.put("contractID", conBillId);
            param.put("contractEntryID", conBillEntryId);
            param.put("internalAsst", isExistInternal);
            param.put("asstactID", asstactId);
            param.put("settleOrgID", orgId);
            param.put("accessType", "AP");
            param.put("amount", scheme.isSettle() ? recordEntrySettleAmt : recordEntrySettleAmt.negate());
            param.put("settleRelation", settleRelation);
            paramList.add(param);
        } else {
            this.count = 0;
            for (DynamicObject detailEntry : detailColl) {
                if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                ++this.count;
            }
            BigDecimal remainDisposeAmount = recordEntrySettleAmt;
            for (DynamicObject detailEntry : detailColl) {
                BigDecimal disposeAmt = this.allocationAmtByPlan(detailEntry, bill, remainDisposeAmount, recordEntrySettleAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                String coreBillType = detailEntry.getString("corebilltype");
                long coreBillId = detailEntry.getLong("corebillid");
                long coreBillEntryId = detailEntry.getLong("corebillentryid");
                long conBillId = detailEntry.getLong("e_conbillid");
                long conBillEntryId = detailEntry.getLong("e_conbillentryid");
                if (BigDecimal.ZERO.compareTo(disposeAmt) == 0 || !"pm_purorderbill".equals(coreBillType) && !"sctm_scpo".equals(coreBillType) && !"conm_purcontract".equals(coreBillType)) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("internal_company", isExistInternal);
                param.put("settleorgid", orgId);
                param.put("supplierid", asstactId);
                param.put("apbill_mainbillentity", coreBillType);
                param.put("apbill_mainbillid", coreBillId);
                param.put("apbill_mainbillentryid", coreBillEntryId);
                param.put("mainBillEntity", coreBillType);
                param.put("mainBillID", coreBillId);
                param.put("mainBillEntryID", coreBillEntryId);
                param.put("contractID", conBillId);
                param.put("contractEntryID", conBillEntryId);
                param.put("internalAsst", isExistInternal);
                param.put("asstactID", asstactId);
                param.put("settleOrgID", orgId);
                param.put("accessType", "AP");
                param.put("amount", scheme.isSettle() ? disposeAmt : disposeAmt.negate());
                param.put("settleRelation", settleRelation);
                paramList.add(param);
            }
        }
    }

    protected void processCoreBillParamByApSelf(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleRecordVO result, SettleSchemeVO scheme) {
        List paramList = scheme.getParamList().stream().filter(param -> SettleRelationEnum.APSELF.getValue().equals(param.get("settleRelation"))).collect(Collectors.toList());
        if (!(SettleRelationEnum.APSELF.getValue().equals(result.getSettleRela()) && result.isMainVo() || result.getSettleRela() == null && !paramList.isEmpty() && !result.isMainVo())) {
            return;
        }
        BigDecimal settleAmt = result.getTotalSettleAmt();
        long asstactId = bill.getLong("asstact.id");
        long orgId = bill.getLong("org.id");
        if (result.isMainVo()) {
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            List<SettleRecordEntryVO> recordEntryVOS = result.getEntrys();
            HashSet<String> uniqueEntryKeys = new HashSet<String>(recordEntryVOS.size());
            for (SettleRecordEntryVO entryVO : recordEntryVOS) {
                uniqueEntryKeys.add(entryVO.getBillId() + "_" + entryVO.getBillEntryId());
            }
            if (1 == scheme.getSettleEntryParam()) {
                BigDecimal amount;
                if (entry == null) {
                    logger.info("processCoreBillParamByApSelf settleEntry==1 but entry==null");
                    return;
                }
                String coreBillType = entry.getString("corebilltype");
                long coreBillId = entry.getLong("corebillid");
                long coreBillEntryId = entry.getLong("corebillentryid");
                long conBillId = entry.getLong("e_conbillid");
                long conBillEntryId = entry.getLong("e_conbillentryid");
                BigDecimal bigDecimal = amount = scheme.isSettle() ? settleAmt.negate() : settleAmt;
                if (!("pm_purorderbill".equals(coreBillType) || "sctm_scpo".equals(coreBillType) || "conm_purcontract".equals(coreBillType))) {
                    return;
                }
                HashMap<String, Object> param2 = new HashMap<String, Object>(16);
                if (coreBillId != 0L && coreBillEntryId != 0L && ("pm_purorderbill".equals(coreBillType) || "sctm_scpo".equals(coreBillType))) {
                    param2.put("mainbillid", coreBillId);
                    param2.put("mainbillentryid", coreBillEntryId);
                    param2.put("mainbillentity", coreBillType);
                    param2.put("internal_company", isExistInternal);
                    param2.put("settleorgid", orgId);
                    param2.put("supplierid", asstactId);
                    param2.put("baseqty", BigDecimal.ZERO);
                    param2.put("qty", BigDecimal.ZERO);
                }
                if (conBillId != 0L && conBillEntryId != 0L) {
                    param2.put("apinternalasst", isExistInternal);
                    param2.put("apasstactid", asstactId);
                    param2.put("apsettleorgid", orgId);
                    param2.put("apMainBillEntity", coreBillType);
                    param2.put("poid", coreBillId);
                    param2.put("poentryid", coreBillEntryId);
                    param2.put("baseqty", BigDecimal.ZERO);
                    param2.put("conbillentity", entry.getString("e_conbillentity.number"));
                    param2.put("conbillid", conBillId);
                    param2.put("conbillentryid", conBillEntryId);
                }
                param2.put("amount", amount);
                param2.put("uniqueEntryKeys", uniqueEntryKeys);
                param2.put("settleRelation", result.getSettleRela());
                param2.put("ArApBillId", bill.getLong("id"));
                scheme.getParamList().add(param2);
            } else {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
                this.count = 0;
                for (Object detailEntry : detailColl) {
                    if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                    ++this.count;
                }
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailColl) {
                    String coreBillType = detailEntry.getString("corebilltype");
                    BigDecimal disposeAmt = this.allocationAmtByPlan(detailEntry, bill, remainDisposeAmount, settleAmt);
                    remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    if (BigDecimal.ZERO.compareTo(disposeAmt) == 0 || !"pm_purorderbill".equals(coreBillType) && !"sctm_scpo".equals(coreBillType) && !"conm_purcontract".equals(coreBillType)) continue;
                    long coreBillId = detailEntry.getLong("corebillid");
                    long coreBillEntryId = detailEntry.getLong("corebillentryid");
                    long conBillId = detailEntry.getLong("e_conbillid");
                    long conBillEntryId = detailEntry.getLong("e_conbillentryid");
                    disposeAmt = scheme.isSettle() ? disposeAmt.negate() : disposeAmt;
                    HashMap<String, Object> param3 = new HashMap<String, Object>(16);
                    if (coreBillId != 0L && coreBillEntryId != 0L && ("pm_purorderbill".equals(coreBillType) || "sctm_scpo".equals(coreBillType))) {
                        param3.put("mainbillid", coreBillId);
                        param3.put("mainbillentryid", coreBillEntryId);
                        param3.put("mainbillentity", coreBillType);
                        param3.put("internal_company", isExistInternal);
                        param3.put("settleorgid", orgId);
                        param3.put("supplierid", asstactId);
                        param3.put("baseqty", BigDecimal.ZERO);
                        param3.put("qty", BigDecimal.ZERO);
                    }
                    param3.put("apinternalasst", isExistInternal);
                    param3.put("apasstactid", asstactId);
                    param3.put("apsettleorgid", orgId);
                    param3.put("apMainBillEntity", coreBillType);
                    param3.put("poid", coreBillId);
                    param3.put("poentryid", coreBillEntryId);
                    param3.put("baseqty", BigDecimal.ZERO);
                    param3.put("conbillentity", detailEntry.getString("e_conbillentity.number"));
                    param3.put("conbillid", conBillId);
                    param3.put("conbillentryid", conBillEntryId);
                    param3.put("amount", disposeAmt);
                    param3.put("uniqueEntryKeys", uniqueEntryKeys);
                    param3.put("settleRelation", result.getSettleRela());
                    param3.put("ArApBillId", bill.getLong("id"));
                    scheme.getParamList().add(param3);
                }
            }
        } else {
            String uniqueEntryKey = result.getMainBillId() + "_" + result.getMainBillEntryId();
            boolean isNotWriteBack = false;
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                long coreBillId = detail.getLong("corebillid");
                long coreBillEntryId = detail.getLong("corebillentryid");
                if (0L == coreBillId && 0L == coreBillEntryId) continue;
                isNotWriteBack = true;
            }
            ArrayList<Map<String, Object>> tempParamList = new ArrayList<Map<String, Object>>(paramList.size());
            for (Map param4 : paramList) {
                Set uniqueEntryKeys = (Set)param4.get("uniqueEntryKeys");
                if (isNotWriteBack && uniqueEntryKeys.contains(uniqueEntryKey)) continue;
                tempParamList.add(param4);
            }
            scheme.setParamList(tempParamList);
        }
    }

    private BigDecimal allocationAmtByPlan(DynamicObject detailEntry, DynamicObject bill, BigDecimal remainDisposeAmount, BigDecimal allocationAllAmt) {
        BigDecimal disposeAmt = BigDecimal.ZERO;
        if (detailEntry == null || bill == null) {
            return disposeAmt;
        }
        DynamicObject currency = bill.getDynamicObject("currency");
        BigDecimal headAmt = bill.getBigDecimal("pricetaxtotal");
        BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
        BigDecimal entryAmt = detailEntry.getBigDecimal("e_pricetaxtotal");
        if (entryAmt.compareTo(BigDecimal.ZERO) == 0) {
            return disposeAmt;
        }
        --this.count;
        disposeAmt = headUnSettle.compareTo(headAmt) == 0 ? detailEntry.getBigDecimal("settledamt") : (headUnSettle.compareTo(BigDecimal.ZERO) == 0 ? detailEntry.getBigDecimal("unsettleamt") : (this.count == 0 ? remainDisposeAmount : allocationAllAmt.multiply(entryAmt).divide(headAmt, currency.getInt("amtprecision"), RoundingMode.HALF_UP)));
        return disposeAmt;
    }

    @Deprecated
    protected void processCoreBillParam(List<Map<String, Object>> rowList, DynamicObject bill, SettleRecordVO result, SettleSchemeVO scheme) {
        block13: {
            String settleRelation = result.getSettleRela();
            if (ObjectUtils.isEmpty((Object)settleRelation) || !SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) && !SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) break block13;
            long mainBillEntryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            if (!scheme.isSettle()) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject currency = bill.getDynamicObject("currency");
            if (1 == scheme.getSettleEntryParam()) {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailColl) {
                    long entryId = detailEntry.getLong("id");
                    if (mainBillEntryId != entryId) continue;
                    String corebillType = detailEntry.getString("corebilltype");
                    String corebillNo = detailEntry.getString("corebillno");
                    long corebillId = detailEntry.getLong("corebillid");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", detailEntry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", mainBillEntryId);
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
                        settleAmt = settleAmt.negate();
                    }
                    row.put("paidamount", settleAmt);
                    rowList.add(row);
                }
            } else {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("detailentry");
                BigDecimal headAmt = bill.getBigDecimal("pricetaxtotal");
                BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
                BigDecimal disposeAmt = BigDecimal.ZERO;
                int count = 0;
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailColl) {
                    String corebillType = detailEntry.getString("corebilltype");
                    String corebillNo = detailEntry.getString("corebillno");
                    long corebillId = detailEntry.getLong("corebillid");
                    BigDecimal entryAmt = detailEntry.getBigDecimal("e_pricetaxtotal");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    if (headUnSettle.compareTo(headAmt) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("settledamt") : detailEntry.getBigDecimal("settledamt").negate();
                    } else if (headUnSettle.compareTo(BigDecimal.ZERO) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("unsettleamt") : detailEntry.getBigDecimal("unsettleamt").negate();
                    } else if (++count == detailColl.size()) {
                        disposeAmt = remainDisposeAmount;
                    } else {
                        BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                        disposeAmt = settleAmt.multiply(proportion).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", detailEntry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", mainBillEntryId);
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    if (SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
                        disposeAmt = disposeAmt.negate();
                    }
                    row.put("paidamount", disposeAmt);
                    rowList.add(row);
                }
            }
        }
    }

    protected void afterWriteBack(List<Map<String, Object>> rowList, Collection<DynamicObject> objColl, SettleSchemeVO scheme) {
        for (DynamicObject bill : objColl) {
            bill.set("settlestatus", (Object)this.getBillSettleStatus(bill));
        }
        this.disposeFeeBill(objColl, scheme);
        PaySettle4ScmcHelper.disposeCoreBillExceptScmc(rowList, scheme.isSettle());
        OpLogServiceHelper.addLog(scheme.isSettle() ? "settle" : "unsettle", (Object)scheme.toString(), objColl.toArray(new DynamicObject[0]), false);
    }

    protected void disposeFeeBill(Collection<DynamicObject> objColl, SettleSchemeVO scheme) {
        boolean settle = scheme.isSettle();
        logger.info("disposeFeeBill start");
        PaySettle4ScmcHelper.disposeFeeBill(objColl, settle);
        logger.info("disposeFeeBill end");
    }

    private String getBillSettleStatus(DynamicObject bill) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("detailentry");
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal("unsettleamt");
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal("settledamt");
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }

    protected List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(50);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("settlestatus");
        selector.add("currency");
        selector.add("pricetaxtotal");
        selector.add("pricetaxtotalbase");
        selector.add("settleamount");
        selector.add("settleamountbase");
        selector.add("unsettleamount");
        selector.add("unsettleamountbase");
        selector.add("exchangerate");
        selector.add("premiumamt");
        selector.add("basecurrency");
        selector.add("quotation");
        selector.add("e_pricetaxtotal");
        selector.add("e_pricetaxtotalbase");
        selector.add("settledamt");
        selector.add("settledamtbase");
        selector.add("unsettleamt");
        selector.add("unsettleamtbase");
        selector.add("lockedamt");
        selector.add("unlockamt");
        selector.add("sourcebilltype");
        selector.add("e_sourcebillid");
        selector.add("e_sourcebillentryid");
        selector.add("corebilltype");
        selector.add("corebillno");
        selector.add("corebillid");
        selector.add("corebillentryid");
        selector.add("planpricetax");
        selector.add("planpricetaxloc");
        selector.add("unplansettleamt");
        selector.add("unplansettlelocamt");
        selector.add("plansettledamt");
        selector.add("plansettledlocamt");
        selector.add("planlockedamt");
        selector.add("unplanlockamt");
        selector.add("e_baseunitqty");
        selector.add("quantity");
        selector.add("e_conbillentity");
        selector.add("e_conbillid");
        selector.add("e_conbillentryid");
        selector.add("ispresent");
        selector.add("istanspay");
        selector.add("e_expensebillids_tag");
        selector.add("settleversion");
        return selector;
    }

    private void initPreParamMap(Map<Long, DynamicObject> apBillMap, SettleSchemeVO scheme) {
        block6: {
            List<Long> preSettledPks;
            DynamicObjectCollection result;
            this.preParamMap = new HashMap<Long, EntryWBParam>(apBillMap.size());
            boolean settle = scheme.isSettle();
            if (settle && 2 == scheme.getSettleEntryParam()) {
                return;
            }
            ArrayList<Long> apBillIds = new ArrayList<Long>(apBillMap.size());
            Set<Map.Entry<Long, DynamicObject>> entrySet = apBillMap.entrySet();
            for (Map.Entry<Long, DynamicObject> entry : entrySet) {
                DynamicObject bill = entry.getValue();
                if (bill.getBigDecimal("premiumamt").compareTo(BigDecimal.ZERO) == 0) continue;
                apBillIds.add(entry.getKey());
            }
            if (apBillIds.isEmpty()) break block6;
            QFilter settleFilter = new QFilter("mainbillid", "in", apBillIds);
            settleFilter.and(new QFilter("settlerelation", "=", (Object)SettleRelationEnum.PREMSETTLE.getValue()));
            if (settle) {
                result = QueryServiceHelper.query((String)"ap_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long apBillId : apBillIds) {
                    if (preSettledPks.contains(apBillId)) continue;
                    DynamicObject apBill = apBillMap.get(apBillId);
                    int basePrecison = apBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(true);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(apBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(apBill.getBigDecimal("premiumamt").multiply(apBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                    this.preParamMap.put(apBillId, param);
                }
            } else {
                settleFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
                result = QueryServiceHelper.query((String)"ap_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long apBillId : apBillIds) {
                    if (!preSettledPks.contains(apBillId)) continue;
                    DynamicObject apBill = apBillMap.get(apBillId);
                    int basePrecison = apBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(false);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(apBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(apBill.getBigDecimal("premiumamt").multiply(apBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                    this.preParamMap.put(apBillId, param);
                }
            }
        }
    }
}

