/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.EntryWBTypeEnum;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.PaySettle4ScmcHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.entry.EntryWBParam;
import kd.fi.arapcommon.writeback.entry.PrePlanWBService;
import kd.fi.arapcommon.writeback.settle.AbstractSettleWBService;

public class FinArSettleWBService
extends AbstractSettleWBService {
    private static final Log logger = LogFactory.getLog(FinArSettleWBService.class);
    public static final FinArSettleWBService INSTANCE = new FinArSettleWBService();
    private Map<Long, EntryWBParam> preParamMap;
    protected PrePlanWBService prePlanWBService;
    private int count = 0;

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        logger.info("FinArSettleWBService writeback as main start");
        this.writeBack(voList, scheme, true);
        logger.info("FinArSettleWBService writeback as main end");
    }

    @Override
    public void writeBackAsst(List<SettleRecordEntryVO> entryVOList, SettleSchemeVO scheme) {
        logger.info("FinArSettleWBService writeback as asst start");
        List<SettleRecordVO> settleRecordVOS = this.writeBack(this.convert2SRList(entryVOList), scheme, false);
        this.repairSettleRecord(entryVOList, settleRecordVOS);
        logger.info("FinArSettleWBService writeback as asst end");
    }

    private List<SettleRecordVO> writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme, boolean isMain) {
        this.prePlanWBService = BeanFactory.getBean(PrePlanWBService.class, new Object[0]);
        HashSet<Long> billIdSet = new HashSet<Long>(voList.size());
        for (SettleRecordVO result : voList) {
            billIdSet.add(result.getMainBillId());
        }
        if (scheme.getSettleEntryParam() == 0) {
            scheme.setSettleEntryParam(voList.get(0).getSettleEntry());
        }
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", this.getDisposeSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, DynamicObject> arBillMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> arBillEntryMap = new HashMap<Long, DynamicObject>(64);
        boolean isSettleByMaterial = SettleEntryEnum.DETAIL.getValue() == voList.get(0).getSettleEntry();
        for (DynamicObject arBill : arBills) {
            DynamicObjectCollection entries;
            arBillMap.put(arBill.getLong("id"), arBill);
            if (isSettleByMaterial) {
                entries = arBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    arBillEntryMap.put(entry.getLong("id"), entry);
                }
                continue;
            }
            entries = arBill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                arBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        boolean isSettle = scheme.isSettle();
        Set<Long> recEntryIdSet = this.getConfirmRecSet(voList);
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(voList.size());
        this.initPreParamMap(arBillMap, scheme);
        logger.info("FinArSettleWBService writeback entry start");
        for (SettleRecordVO result : voList) {
            DynamicObject bill;
            long mainBillId = result.getMainBillId();
            long mainBillEntryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!result.getEntrys().isEmpty()) {
                scheme.setAsstBillId(result.getEntrys().get(0).getBillId());
                scheme.setAsstEntity(result.getEntrys().get(0).getBillEntity());
            }
            if (!isSettle) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            if ((bill = (DynamicObject)arBillMap.get(mainBillId)) == null) continue;
            DynamicObject entry = (DynamicObject)arBillEntryMap.get(mainBillEntryId);
            this.wbHead(bill, settleAmt, localSettleAmt);
            if (isMain) {
                this.processCoreBillParam(rowList, bill, settleAmt, (DynamicObject)arBillEntryMap.get(mainBillEntryId), scheme, result, recEntryIdSet);
            }
            this.wbEntry(bill, entry, settleAmt, localSettleAmt, isSettleByMaterial, isSettle, this.needWBLock(result, scheme, "ar_finarbill"), result);
        }
        logger.info("FinArSettleWBService writeback entry end");
        for (DynamicObject bill : arBills) {
            bill.set("settlestatus", (Object)this.getBillSettleStatus(bill));
        }
        logger.info("FinArSettleWBService writeback ICallOrderConInvoker start");
        Settle4ScmcHelper.newWriteBackPurAndCon(voList, arBills, scheme, null);
        logger.info("FinArSettleWBService writeback ICallOrderConInvoker end");
        DynamicObject[] dynamicObjects = arBillMap.values().toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        logger.info("FinArSettleWBService writeback coreBill start");
        if (isMain) {
            PaySettle4ScmcHelper.disposeCoreBillExceptScmc(rowList, isSettle);
        }
        logger.info("FinArSettleWBService writeback coreBill end");
        logger.info("FinArSettleWBService writeback reservebaddebt start");
        ArrayList<DynamicObject> needReserveArBills = new ArrayList<DynamicObject>(8);
        for (Map.Entry arBillEntrySet : arBillMap.entrySet()) {
            DynamicObject arBill = (DynamicObject)arBillEntrySet.getValue();
            if (!arBill.getBoolean("isperiod")) continue;
            needReserveArBills.add(arBill);
        }
        if (needReserveArBills.size() > 0) {
            this.disposeReserveBill(needReserveArBills);
        }
        logger.info("FinArSettleWBService writeback reservebaddebt end");
        OpLogServiceHelper.addLog(isSettle ? "settle" : "unsettle", (Object)scheme.toString(), dynamicObjects, false);
        return voList;
    }

    private void initPreParamMap(Map<Long, DynamicObject> arBillMap, SettleSchemeVO scheme) {
        block6: {
            List<Long> preSettledPks;
            DynamicObjectCollection result;
            this.preParamMap = new HashMap<Long, EntryWBParam>(arBillMap.size());
            boolean settle = scheme.isSettle();
            if (settle && 2 == scheme.getSettleEntryParam()) {
                return;
            }
            ArrayList<Long> arBillIds = new ArrayList<Long>(arBillMap.size());
            Set<Map.Entry<Long, DynamicObject>> entrySet = arBillMap.entrySet();
            for (Map.Entry<Long, DynamicObject> entry : entrySet) {
                DynamicObject bill = entry.getValue();
                if (bill.getBigDecimal("premiumamt").compareTo(BigDecimal.ZERO) == 0) continue;
                arBillIds.add(entry.getKey());
            }
            if (arBillIds.isEmpty()) break block6;
            QFilter settleFilter = new QFilter("mainbillid", "in", arBillIds);
            settleFilter.and(new QFilter("settlerelation", "=", (Object)SettleRelationEnum.ARPREMSETTLE.getValue()));
            if (settle) {
                result = QueryServiceHelper.query((String)"ar_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long arBillId : arBillIds) {
                    if (preSettledPks.contains(arBillId)) continue;
                    DynamicObject arBill = arBillMap.get(arBillId);
                    int basePrecison = arBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(true);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(arBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(arBill.getBigDecimal("premiumamt").multiply(arBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                    this.preParamMap.put(arBillId, param);
                }
            } else {
                settleFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
                result = QueryServiceHelper.query((String)"ar_settlerecord", (String)"mainbillid as id", (QFilter[])settleFilter.toArray(), (String)"");
                preSettledPks = ArApHelper.getPks(result);
                for (Long arBillId : arBillIds) {
                    if (!preSettledPks.contains(arBillId)) continue;
                    DynamicObject arBill = arBillMap.get(arBillId);
                    int basePrecison = arBill.getInt("basecurrency.amtprecision");
                    EntryWBParam param = new EntryWBParam();
                    param.setForward(false);
                    param.setWbType(EntryWBTypeEnum.SETTLE.getValue());
                    param.setWbAmt(arBill.getBigDecimal("premiumamt"));
                    param.setWbLocalAmt(arBill.getBigDecimal("premiumamt").multiply(arBill.getBigDecimal("exchangerate").setScale(basePrecison, RoundingMode.HALF_UP)));
                    this.preParamMap.put(arBillId, param);
                }
            }
        }
    }

    private void wbHead(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt) {
        boolean isUnSettleDisposeAll;
        bill.set("unsettleamount", (Object)bill.getBigDecimal("unsettleamount").subtract(settleAmt));
        bill.set("settleamount", (Object)bill.getBigDecimal("settleamount").add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set("unsettlelocalamt", (Object)BigDecimal.ZERO);
            bill.set("settlelocalamt", (Object)bill.getBigDecimal("reclocalamt"));
        } else if (isUnSettleDisposeAll) {
            bill.set("unsettlelocalamt", (Object)bill.getBigDecimal("reclocalamt"));
            bill.set("settlelocalamt", (Object)BigDecimal.ZERO);
        } else {
            bill.set("unsettlelocalamt", (Object)bill.getBigDecimal("unsettlelocalamt").subtract(localSettleAmt));
            bill.set("settlelocalamt", (Object)bill.getBigDecimal("settlelocalamt").add(localSettleAmt));
        }
    }

    private void wbEntry(DynamicObject bill, DynamicObject entry, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isSettleByMaterial, boolean isSettle, boolean isWBLock, SettleRecordVO result) {
        if (isSettleByMaterial) {
            this.wbEntryByMaterial(bill, entry, settleAmt, localSettleAmt, isSettle, isWBLock, result);
        } else {
            this.wbEntryByPlan(bill, entry, settleAmt, localSettleAmt, isWBLock, result);
        }
    }

    private void wbEntryByMaterial(DynamicObject bill, DynamicObject detailEntry, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isSettle, boolean isWBLock, SettleRecordVO result) {
        this.wbDetailEntryByMaterial(detailEntry, settleAmt, localSettleAmt, isWBLock, result);
        EntryWBParam preParam = this.preParamMap.get(bill.getLong("id"));
        if (preParam != null) {
            this.prePlanWBService.execute(bill, preParam);
        }
        if (isSettle) {
            this.wbPlanEntryByMaterialOfSettle(bill, settleAmt, localSettleAmt, isWBLock);
        } else {
            this.wbPlanEntryByMaterialOfUnSettle(bill, settleAmt, localSettleAmt, isWBLock);
        }
        if (preParam != null) {
            preParam.setForward(!preParam.isForward());
            this.prePlanWBService.execute(bill, preParam);
            preParam.setForward(!preParam.isForward());
        }
    }

    private void wbEntryByPlan(DynamicObject bill, DynamicObject planEntry, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock, SettleRecordVO result) {
        this.wbPlanEntryByPlan(planEntry, settleAmt, localSettleAmt, isWBLock, result);
        this.wbDetailEntryByPlan(bill, settleAmt, localSettleAmt, isWBLock);
    }

    private void wbDetailEntryByMaterial(DynamicObject detailEntry, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock, SettleRecordVO result) {
        boolean isUnSettleDisposeAll;
        detailEntry.set("e_settledamt", (Object)detailEntry.getBigDecimal("e_settledamt").add(settleAmt));
        detailEntry.set("e_unsettleamt", (Object)detailEntry.getBigDecimal("e_unsettleamt").subtract(settleAmt));
        boolean isSettleDisposeAll = detailEntry.getBigDecimal("e_unsettleamt").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = detailEntry.getBigDecimal("e_settledamt").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            result.setLocalTotalSettleamt(detailEntry.getBigDecimal("e_reclocalamt").subtract(detailEntry.getBigDecimal("e_settledlocalamt")));
            detailEntry.set("e_settledlocalamt", (Object)detailEntry.getBigDecimal("e_reclocalamt"));
            detailEntry.set("e_unsettlelocalamt", (Object)BigDecimal.ZERO);
        } else if (isUnSettleDisposeAll) {
            detailEntry.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unsettlelocalamt", (Object)detailEntry.getBigDecimal("e_reclocalamt"));
        } else {
            detailEntry.set("e_settledlocalamt", (Object)detailEntry.getBigDecimal("e_settledlocalamt").add(localSettleAmt));
            detailEntry.set("e_unsettlelocalamt", (Object)detailEntry.getBigDecimal("e_unsettlelocalamt").subtract(localSettleAmt));
        }
        if (isWBLock) {
            detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(settleAmt));
            detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(settleAmt));
        }
    }

    private void wbPlanEntryByMaterialOfSettle(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock) {
        block10: {
            DynamicObjectCollection planEntries;
            block9: {
                boolean isSettleDisposeAll;
                boolean isZeroSettle;
                planEntries = bill.getDynamicObjectCollection("planentity");
                boolean bl = isZeroSettle = bill.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0;
                if (!isZeroSettle) break block9;
                DynamicObject planEntry = (DynamicObject)planEntries.get(0);
                planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
                planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
                boolean bl2 = isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                } else {
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
                }
                if (!isWBLock) break block10;
                planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
                planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
                break block10;
            }
            BigDecimal remainLocalSettleAmt = BigDecimal.ZERO;
            boolean needSpecialHandle = planEntries.size() == 1;
            for (DynamicObject planEntry : planEntries) {
                boolean isSettleDisposeAll;
                BigDecimal unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                BigDecimal direction = new BigDecimal(settleAmt.signum());
                BigDecimal curSettleAmt = BigDecimal.ZERO;
                if (needSpecialHandle) {
                    curSettleAmt = settleAmt;
                } else if (unSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                    curSettleAmt = (unSettleAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt.abs() : unSettleAmt.abs()).multiply(direction);
                }
                if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                planEntry.set("unplansettleamt", (Object)unSettleAmt.subtract(curSettleAmt));
                planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(curSettleAmt));
                boolean bl = isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    remainLocalSettleAmt = remainLocalSettleAmt.add(planEntry.getBigDecimal("unplansettlelocamt"));
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
                } else {
                    BigDecimal curSettleAmtLocal = localSettleAmt.subtract(remainLocalSettleAmt);
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(curSettleAmtLocal));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(curSettleAmtLocal));
                }
                if (isWBLock) {
                    planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curSettleAmt));
                    planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curSettleAmt));
                }
                if ((settleAmt = settleAmt.subtract(curSettleAmt)).compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
        }
    }

    private void wbPlanEntryByMaterialOfUnSettle(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock) {
        boolean isZeroUnSettle;
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        boolean bl = isZeroUnSettle = bill.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0;
        if (isZeroUnSettle) {
            boolean isUnSettleDisposeAll;
            DynamicObject planEntry = (DynamicObject)planEntries.get(0);
            planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
            planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
            boolean bl2 = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
            if (isUnSettleDisposeAll) {
                planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
            } else {
                planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
                planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
            }
            if (isWBLock) {
                planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
                planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
            }
        } else {
            BigDecimal remainLocalSettleAmt = BigDecimal.ZERO;
            boolean needSpecialHandle = planEntries.size() == 1;
            for (int i = planEntries.size() - 1; i >= 0; --i) {
                boolean isUnSettleDisposeAll;
                DynamicObject planEntry = (DynamicObject)planEntries.get(i);
                BigDecimal settlePlanAmt = planEntry.getBigDecimal("plansettledamt");
                BigDecimal direction = new BigDecimal(settleAmt.signum());
                BigDecimal curSettleAmt = BigDecimal.ZERO;
                if (needSpecialHandle) {
                    curSettleAmt = settleAmt;
                } else if (settlePlanAmt.compareTo(BigDecimal.ZERO) != 0) {
                    curSettleAmt = (settlePlanAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt.abs() : settlePlanAmt.abs()).multiply(direction);
                }
                if (curSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(curSettleAmt));
                planEntry.set("plansettledamt", (Object)settlePlanAmt.add(curSettleAmt));
                boolean bl3 = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
                if (isUnSettleDisposeAll) {
                    remainLocalSettleAmt = remainLocalSettleAmt.add(planEntry.getBigDecimal("plansettledlocamt"));
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal curSettleAmtLocal = localSettleAmt.subtract(remainLocalSettleAmt.negate());
                    planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(curSettleAmtLocal));
                    planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(curSettleAmtLocal));
                }
                if (isWBLock) {
                    planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curSettleAmt));
                    planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curSettleAmt));
                }
                if ((settleAmt = settleAmt.subtract(curSettleAmt)).compareTo(BigDecimal.ZERO) == 0) break;
            }
        }
    }

    private void wbPlanEntryByPlan(DynamicObject planEntry, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock, SettleRecordVO result) {
        boolean isUnSettleDisposeAll;
        planEntry.set("plansettledamt", (Object)planEntry.getBigDecimal("plansettledamt").add(settleAmt));
        planEntry.set("unplansettleamt", (Object)planEntry.getBigDecimal("unplansettleamt").subtract(settleAmt));
        boolean isSettleDisposeAll = planEntry.getBigDecimal("unplansettleamt").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = planEntry.getBigDecimal("plansettledamt").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            result.setLocalTotalSettleamt(planEntry.getBigDecimal("planpricetaxloc").subtract(planEntry.getBigDecimal("plansettledlocamt")));
            planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
            planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
        } else if (isUnSettleDisposeAll) {
            planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
            planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("planpricetaxloc"));
        } else {
            planEntry.set("plansettledlocamt", (Object)planEntry.getBigDecimal("plansettledlocamt").add(localSettleAmt));
            planEntry.set("unplansettlelocamt", (Object)planEntry.getBigDecimal("unplansettlelocamt").subtract(localSettleAmt));
        }
        if (isWBLock) {
            planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(settleAmt));
            planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(settleAmt));
        }
    }

    private void wbDetailEntryByPlan(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt, boolean isWBLock) {
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject currency = bill.getDynamicObject("currency");
        int scale = currency == null ? 2 : currency.getInt("amtprecision");
        DynamicObject basecurrency = bill.getDynamicObject("basecurrency");
        int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
        String quotation = bill.getString("quotation");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        List noPresenEntries = entries.stream().filter(entry -> entry.getBigDecimal("e_recamount").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        BigDecimal headAmt = bill.getBigDecimal("recamount");
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        BigDecimal remainPlanLockAmt = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntries) {
            remainPlanLockAmt = remainPlanLockAmt.add(planEntry.getBigDecimal("planlockedamt"));
        }
        boolean isWriteBackLockAll = remainPlanLockAmt.compareTo(BigDecimal.ZERO) == 0;
        int entryCount = 0;
        BigDecimal remainSettleAmt = settleAmt;
        BigDecimal remainLocalSettleAmt = localSettleAmt;
        BigDecimal remainLockAmt = settleAmt;
        for (DynamicObject entry2 : noPresenEntries) {
            ++entryCount;
            BigDecimal entryAmt = entry2.getBigDecimal("e_recamount");
            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
            BigDecimal curSettleAmt = settleAmt.multiply(proportion).setScale(scale, RoundingMode.HALF_UP);
            if (isSettleDisposeAll) {
                entry2.set("e_unsettleamt", (Object)BigDecimal.ZERO);
                entry2.set("e_settledamt", (Object)entryAmt);
                entry2.set("e_unsettlelocalamt", (Object)BigDecimal.ZERO);
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_reclocalamt"));
            } else if (isUnSettleDisposeAll) {
                entry2.set("e_unsettleamt", (Object)entryAmt);
                entry2.set("e_settledamt", (Object)BigDecimal.ZERO);
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_reclocalamt"));
                entry2.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
            } else if (entryCount == noPresenEntries.size()) {
                entry2.set("e_unsettleamt", (Object)entry2.getBigDecimal("e_unsettleamt").subtract(remainSettleAmt));
                entry2.set("e_settledamt", (Object)entry2.getBigDecimal("e_settledamt").add(remainSettleAmt));
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_unsettlelocalamt").subtract(remainLocalSettleAmt));
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_settledlocalamt").add(remainLocalSettleAmt));
            } else {
                entry2.set("e_unsettleamt", (Object)entry2.getBigDecimal("e_unsettleamt").subtract(curSettleAmt));
                entry2.set("e_settledamt", (Object)entry2.getBigDecimal("e_settledamt").add(curSettleAmt));
                BigDecimal curLocalSettleAmt = CommonSettleServiceHelper.getLocamtByQuotation(quotation, curSettleAmt, exchangeRate, baseScale);
                entry2.set("e_unsettlelocalamt", (Object)entry2.getBigDecimal("e_unsettlelocalamt").subtract(curLocalSettleAmt));
                entry2.set("e_settledlocalamt", (Object)entry2.getBigDecimal("e_settledlocalamt").add(curLocalSettleAmt));
                remainSettleAmt = remainSettleAmt.subtract(curSettleAmt);
                remainLocalSettleAmt = remainLocalSettleAmt.subtract(curLocalSettleAmt);
            }
            if (!isWBLock) continue;
            if (isSettleDisposeAll) {
                entry2.set("e_unlockamt", (Object)BigDecimal.ZERO);
                entry2.set("e_lockedamt", (Object)entryAmt);
                continue;
            }
            if (isUnSettleDisposeAll && isWriteBackLockAll) {
                entry2.set("e_unlockamt", (Object)entryAmt);
                entry2.set("e_lockedamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (entryCount == noPresenEntries.size()) {
                entry2.set("e_unlockamt", (Object)entry2.getBigDecimal("e_unlockamt").subtract(remainLockAmt));
                entry2.set("e_lockedamt", (Object)entry2.getBigDecimal("e_lockedamt").add(remainLockAmt));
                continue;
            }
            entry2.set("e_unlockamt", (Object)entry2.getBigDecimal("e_unlockamt").subtract(curSettleAmt));
            entry2.set("e_lockedamt", (Object)entry2.getBigDecimal("e_lockedamt").add(curSettleAmt));
            remainLockAmt = remainLockAmt.subtract(curSettleAmt);
        }
    }

    private List<String> getDisposeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("settlestatus");
        selector.add("currency");
        selector.add("billtype");
        selector.add("sourcebillid");
        selector.add("basecurrency");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("asstacttype");
        selector.add("istransfer");
        selector.add("asstact");
        selector.add("recamount");
        selector.add("reclocalamt");
        selector.add("unsettleamount");
        selector.add("unsettlelocalamt");
        selector.add("settleamount");
        selector.add("settlelocalamt");
        selector.add("isperiod");
        selector.add("isbaddebt");
        selector.add("e_recamount");
        selector.add("e_reclocalamt");
        selector.add("e_unlockamt");
        selector.add("e_lockedamt");
        selector.add("e_unsettleamt");
        selector.add("e_unsettlelocalamt");
        selector.add("e_settledamt");
        selector.add("e_settledlocalamt");
        selector.add("e_corebilltype");
        selector.add("e_corebillno");
        selector.add("corebillid");
        selector.add("corebillentryid");
        selector.add("planpricetax");
        selector.add("planpricetaxloc");
        selector.add("unplanlockamt");
        selector.add("planlockedamt");
        selector.add("unplansettleamt");
        selector.add("unplansettlelocamt");
        selector.add("plansettledamt");
        selector.add("plansettledlocamt");
        selector.add("e_conbillentity");
        selector.add("e_conbillid");
        selector.add("e_conbillentryid");
        selector.add("e_ispresent");
        selector.add("settleversion");
        selector.add("ispremium");
        selector.add("premiumamt");
        return selector;
    }

    @Deprecated
    public void processCoreBillNewParam(Map<Long, Boolean> assactInterMap, DynamicObject billInfo, DynamicObject entryInfo, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        this.processSalOrderParamByArSelf(assactInterMap, billInfo, entryInfo, scheme, result, recEntryIdSet);
        this.processCoreBillByArBillMain(assactInterMap, billInfo, entryInfo, scheme, result, recEntryIdSet);
        this.processCoreBillByArBillAsst(assactInterMap, billInfo, entryInfo, scheme, result, recEntryIdSet);
    }

    private void processCoreBillByArBillMain(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        String settleRelation = result.getSettleRela();
        if (!(!ObjectUtils.isEmpty((Object)settleRelation) && result.isMainVo() && (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARTRANSFER.getValue().equals(settleRelation) || SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.BADDEBTLOSS.getValue().equals(settleRelation)) && !bill.getBoolean("istransfer"))) {
            return;
        }
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
        List<Map<String, Object>> paramList = scheme.getParamList();
        DynamicObject currency = bill.getDynamicObject("currency");
        Long asstactId = bill.getLong("asstact.id");
        Long orgId = bill.getLong("org.id");
        Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
        List<SettleRecordEntryVO> recordEntryVOS = result.getEntrys();
        BigDecimal entrySettleTotal = BigDecimal.ZERO;
        for (SettleRecordEntryVO entryVO : recordEntryVOS) {
            entrySettleTotal = entrySettleTotal.add(entryVO.getSettleAmt());
        }
        BigDecimal totalSettleAmt = result.getTotalSettleAmt();
        if (1 == scheme.getSettleEntryParam()) {
            if (entry == null) {
                logger.info("processCoreBillByArBillMain settleEntry==1 but entry==null");
                return;
            }
            String coreBillType = entry.getString("e_corebilltype");
            Long coreBillId = entry.getLong("corebillid");
            Long coreBillEntryId = entry.getLong("corebillentryid");
            Long conBillId = entry.getLong("e_conbillid");
            Long conBillEntryId = entry.getLong("e_conbillentryid");
            if (!"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) {
                return;
            }
            if (0L == conBillId && 0L == coreBillId) {
                return;
            }
            BigDecimal remainingAmt = totalSettleAmt;
            for (int i = 0; i < recordEntryVOS.size(); ++i) {
                SettleRecordEntryVO recordEntryVO = recordEntryVOS.get(i);
                BigDecimal recordEntrySettleAmt = totalSettleAmt;
                if (i == recordEntryVOS.size() - 1) {
                    recordEntrySettleAmt = remainingAmt;
                } else {
                    recordEntrySettleAmt = totalSettleAmt.multiply(recordEntryVO.getSettleAmt()).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    remainingAmt = remainingAmt.subtract(recordEntrySettleAmt);
                }
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("settleRelation", settleRelation);
                param.put("arMainBillEntity", coreBillType);
                param.put("arMainBillID", coreBillId);
                param.put("arMainBillEntryID", coreBillEntryId);
                param.put("internalAsst", isExistInternal);
                param.put("asstactID", asstactId);
                param.put("settleOrgID", orgId);
                param.put("accessType", "AR");
                param.put("contractID", conBillId);
                param.put("contractEntryID", conBillEntryId);
                param.put("amount", scheme.isSettle() ? recordEntrySettleAmt : recordEntrySettleAmt.negate());
                param.put("ArApBillId", bill.getLong("id"));
                param.put("asst_record_id", recordEntryVO.getBillId());
                param.put("asst_record_entryid", recordEntryVO.getBillEntryId());
                param.put("asst_record_entity", recordEntryVO.getBillEntity());
                paramList.add(param);
            }
        } else {
            this.count = 0;
            for (DynamicObject detailEntry : detailColl) {
                if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_recamount")) == 0) continue;
                ++this.count;
            }
            BigDecimal remainDisDetailAmt = totalSettleAmt;
            HashMap<Long, BigDecimal> curSettleAmtMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject detailEntry : detailColl) {
                BigDecimal detailSettleAmt = this.allocationAmtByPlan(detailEntry, bill, remainDisDetailAmt, totalSettleAmt);
                remainDisDetailAmt = remainDisDetailAmt.subtract(detailSettleAmt);
                String coreBillType = detailEntry.getString("e_corebilltype");
                Long coreBillId = detailEntry.getLong("corebillid");
                Long coreBillEntryId = detailEntry.getLong("corebillentryid");
                Long conBillId = detailEntry.getLong("e_conbillid");
                Long conBillEntryId = detailEntry.getLong("e_conbillentryid");
                if (BigDecimal.ZERO.compareTo(detailSettleAmt) == 0 || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType) || 0L == conBillId && 0L == coreBillId) continue;
                BigDecimal remainSettleEntryAmt = detailSettleAmt;
                for (int i = 0; i < recordEntryVOS.size(); ++i) {
                    SettleRecordEntryVO recordEntryVO = recordEntryVOS.get(i);
                    BigDecimal entrySettleAmt = recordEntryVO.getSettleAmt();
                    long asstBillEntryId = recordEntryVO.getBillEntryId();
                    BigDecimal recordEntryUseAmt = curSettleAmtMap.getOrDefault(asstBillEntryId, BigDecimal.ZERO);
                    BigDecimal disposeAmt = detailSettleAmt;
                    disposeAmt = this.count == 0 ? (entrySettleAmt.signum() != totalSettleAmt.signum() ? entrySettleAmt.negate().subtract(recordEntryUseAmt) : entrySettleAmt.subtract(recordEntryUseAmt)) : (i == recordEntryVOS.size() - 1 ? remainSettleEntryAmt : detailSettleAmt.multiply(entrySettleAmt).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                    if (disposeAmt.abs().add(recordEntryUseAmt.abs()).compareTo(entrySettleAmt.abs()) > 0) {
                        disposeAmt = totalSettleAmt.signum() != entrySettleAmt.signum() ? entrySettleAmt.abs().subtract(recordEntryUseAmt.abs()).negate() : entrySettleAmt.subtract(recordEntryUseAmt);
                    }
                    remainSettleEntryAmt = remainSettleEntryAmt.subtract(disposeAmt);
                    curSettleAmtMap.put(asstBillEntryId, disposeAmt.add(recordEntryUseAmt));
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    param.put("settleRelation", settleRelation);
                    param.put("arMainBillEntity", coreBillType);
                    param.put("arMainBillID", coreBillId);
                    param.put("arMainBillEntryID", coreBillEntryId);
                    param.put("internalAsst", isExistInternal);
                    param.put("asstactID", asstactId);
                    param.put("settleOrgID", orgId);
                    param.put("accessType", "AR");
                    param.put("contractID", conBillId);
                    param.put("contractEntryID", conBillEntryId);
                    param.put("amount", scheme.isSettle() ? disposeAmt : disposeAmt.negate());
                    param.put("ArApBillId", bill.getLong("id"));
                    param.put("asst_record_id", recordEntryVO.getBillId());
                    param.put("asst_record_entryid", asstBillEntryId);
                    param.put("asst_record_entity", recordEntryVO.getBillEntity());
                    paramList.add(param);
                }
            }
        }
    }

    private BigDecimal allocationAmtByPlan(DynamicObject detailEntry, DynamicObject bill, BigDecimal remainDisposeAmount, BigDecimal allocationAllAmt) {
        BigDecimal disposeAmt = BigDecimal.ZERO;
        if (detailEntry == null || bill == null) {
            return disposeAmt;
        }
        DynamicObject currency = bill.getDynamicObject("currency");
        BigDecimal headAmt = bill.getBigDecimal("recamount");
        BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
        BigDecimal entryAmt = detailEntry.getBigDecimal("e_recamount");
        if (entryAmt.compareTo(BigDecimal.ZERO) == 0) {
            return disposeAmt;
        }
        --this.count;
        disposeAmt = headUnSettle.compareTo(headAmt) == 0 ? detailEntry.getBigDecimal("e_settledamt") : (headUnSettle.compareTo(BigDecimal.ZERO) == 0 ? detailEntry.getBigDecimal("e_unsettleamt") : (this.count == 0 ? remainDisposeAmount : allocationAllAmt.multiply(entryAmt).divide(headAmt, currency.getInt("amtprecision"), RoundingMode.HALF_UP)));
        return disposeAmt;
    }

    protected void processCoreBillByArBillAsst(Map<Long, Boolean> assactInterMap, DynamicObject bill, DynamicObject entry, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        String settleRelation = scheme.getSettleRelation();
        if (result.isMainVo() || bill.getBoolean("istransfer") || !SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
            return;
        }
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
        List<Map<String, Object>> paramList = scheme.getParamList();
        DynamicObject currency = bill.getDynamicObject("currency");
        Long asstactId = bill.getLong("asstact.id");
        Long orgId = bill.getLong("org.id");
        Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
        BigDecimal recordEntrySettleAmt = result.getTotalSettleAmt();
        if (1 == scheme.getSettleEntryParam()) {
            if (entry == null) {
                logger.info("processCoreBillByArBillAsst settleEntry==1 but entry==null");
                return;
            }
            String coreBillType = entry.getString("e_corebilltype");
            if (!"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) {
                return;
            }
            Long coreBillId = entry.getLong("corebillid");
            Long coreBillEntryId = entry.getLong("corebillentryid");
            Long conBillId = entry.getLong("e_conbillid");
            Long conBillEntryId = entry.getLong("e_conbillentryid");
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("settleRelation", settleRelation);
            param.put("arMainBillEntity", coreBillType);
            param.put("arMainBillID", coreBillId);
            param.put("arMainBillEntryID", coreBillEntryId);
            param.put("internalAsst", isExistInternal);
            param.put("asstactID", asstactId);
            param.put("settleOrgID", orgId);
            param.put("accessType", "AR");
            param.put("contractID", conBillId);
            param.put("contractEntryID", conBillEntryId);
            BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
            logger.info("processCoreBillByArBillAsst material confirmAmt:" + confirmAmt);
            recordEntrySettleAmt = recordEntrySettleAmt.subtract(confirmAmt);
            param.put("amount", scheme.isSettle() ? recordEntrySettleAmt : recordEntrySettleAmt.negate());
            param.put("ArApBillId", bill.getLong("id"));
            paramList.add(param);
        } else {
            this.count = 0;
            for (DynamicObject detailEntry : detailColl) {
                if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_recamount")) == 0) continue;
                ++this.count;
            }
            BigDecimal remainDisposeAmount = recordEntrySettleAmt;
            for (DynamicObject detailEntry : detailColl) {
                BigDecimal disposeAmt = this.allocationAmtByPlan(detailEntry, bill, remainDisposeAmount, recordEntrySettleAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                String coreBillType = detailEntry.getString("e_corebilltype");
                Long coreBillId = detailEntry.getLong("corebillid");
                Long coreBillEntryId = detailEntry.getLong("corebillentryid");
                Long conBillId = detailEntry.getLong("e_conbillid");
                Long conBillEntryId = detailEntry.getLong("e_conbillentryid");
                if (BigDecimal.ZERO.compareTo(disposeAmt) == 0 || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("settleRelation", settleRelation);
                param.put("arMainBillEntity", coreBillType);
                param.put("arMainBillID", coreBillId);
                param.put("arMainBillEntryID", coreBillEntryId);
                param.put("internalAsst", isExistInternal);
                param.put("asstactID", asstactId);
                param.put("settleOrgID", orgId);
                param.put("accessType", "AR");
                param.put("contractID", conBillId);
                param.put("contractEntryID", conBillEntryId);
                param.put("amount", scheme.isSettle() ? disposeAmt : disposeAmt.negate());
                param.put("ArApBillId", bill.getLong("id"));
                paramList.add(param);
            }
        }
    }

    private void processSalOrderParamByArSelf(Map<Long, Boolean> assactInterMap, DynamicObject billInfo, DynamicObject entryInfo, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        List arSelfParamList = scheme.getParamList().stream().filter(param -> SettleRelationEnum.ARSELF.getValue().equals(param.get("settleRelation"))).collect(Collectors.toList());
        String settleRelation = result.getSettleRela();
        if (!(SettleRelationEnum.ARSELF.getValue().equals(result.getSettleRela()) && result.isMainVo() || result.getSettleRela() == null && !arSelfParamList.isEmpty() && !result.isMainVo())) {
            return;
        }
        List<Map<String, Object>> paramList = scheme.getParamList();
        BigDecimal settleAmt = result.getTotalSettleAmt();
        boolean isMainVo = result.isMainVo();
        if (isMainVo) {
            List<SettleRecordEntryVO> recordEntryVOS = result.getEntrys();
            ArrayList<String> uniqueEntryKeys = new ArrayList<String>(recordEntryVOS.size());
            for (SettleRecordEntryVO entryVO : recordEntryVOS) {
                uniqueEntryKeys.add(entryVO.getBillId() + "_" + entryVO.getBillEntryId());
            }
            Long settleOrgId = billInfo.getLong("org.id");
            Long asstactId = billInfo.getLong("asstact.id");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObject currency = billInfo.getDynamicObject("currency");
            if (1 == result.getSettleEntry()) {
                if (entryInfo == null) {
                    logger.info("processSalOrderParam settleEntry==1 but entry==null");
                    return;
                }
                String coreBillType = entryInfo.getString("e_corebilltype");
                Long coreBillId = entryInfo.getLong("corebillid");
                Long coreBillEntryId = entryInfo.getLong("corebillentryid");
                Long conbillId = entryInfo.getLong("e_conbillid");
                Long conbillentryid = entryInfo.getLong("e_conbillentryid");
                String conbillentity = entryInfo.getString("e_conbillentity.number");
                if (coreBillId != 0L && coreBillEntryId != 0L && ("sm_salorder".equals(coreBillType) || "conm_salcontract".equals(coreBillType))) {
                    HashMap<String, Object> map = new HashMap<String, Object>(8);
                    map.put("settleRelation", settleRelation);
                    map.put("arinternalasst", isExistInternal);
                    map.put("arasstactid", asstactId);
                    map.put("arsettleorgid", settleOrgId);
                    map.put("arMainBillEntity", coreBillType);
                    map.put("soid", coreBillId);
                    map.put("soentryid", coreBillEntryId);
                    map.put("baseqty", BigDecimal.ZERO);
                    BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                    logger.info("processSalOrderParam material confirmAmt:" + confirmAmt);
                    settleAmt = settleAmt.subtract(confirmAmt);
                    BigDecimal amount = scheme.isSettle() ? settleAmt.negate() : settleAmt;
                    map.put("amount", amount);
                    map.put("conbillentity", conbillentity);
                    map.put("conbillid", conbillId);
                    map.put("conbillentryid", conbillentryid);
                    map.put("uniqueEntryKeys", uniqueEntryKeys);
                    map.put("ArApBillId", billInfo.getLong("id"));
                    paramList.add(map);
                }
            } else {
                DynamicObjectCollection detailColl = billInfo.getDynamicObjectCollection("entry");
                List detailList = detailColl.stream().filter(entry -> !entry.getBoolean("e_ispresent")).collect(Collectors.toList());
                BigDecimal headAmt = billInfo.getBigDecimal("recamount");
                BigDecimal headUnSettle = billInfo.getBigDecimal("unsettleamount");
                BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                logger.info("processSalOrderParam plan confirmAmt:" + confirmAmt);
                settleAmt = settleAmt.subtract(confirmAmt);
                headUnSettle = headUnSettle.add(confirmAmt);
                int count = 0;
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailList) {
                    BigDecimal disposeAmt;
                    BigDecimal entryAmt = detailEntry.getBigDecimal("e_recamount");
                    String coreBillType = detailEntry.getString("e_corebilltype");
                    Long coreBillId = detailEntry.getLong("corebillid");
                    Long coreBillEntryId = detailEntry.getLong("corebillentryid");
                    Long conbillId = detailEntry.getLong("e_conbillid");
                    Long conbillentryid = detailEntry.getLong("e_conbillentryid");
                    String conbillentity = detailEntry.getString("e_conbillentity.number");
                    if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
                    if (headUnSettle.compareTo(headAmt) == 0) {
                        disposeAmt = detailEntry.getBigDecimal("e_settledamt");
                    } else if (headUnSettle.compareTo(BigDecimal.ZERO) == 0) {
                        disposeAmt = detailEntry.getBigDecimal("e_unsettleamt");
                    } else if (++count == detailList.size()) {
                        disposeAmt = remainDisposeAmount;
                    } else {
                        BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                        disposeAmt = settleAmt.multiply(proportion).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    }
                    disposeAmt = scheme.isSettle() ? disposeAmt.negate() : disposeAmt;
                    HashMap<String, Object> map = new HashMap<String, Object>(8);
                    map.put("settleRelation", settleRelation);
                    map.put("arinternalasst", isExistInternal);
                    map.put("arasstactid", asstactId);
                    map.put("arsettleorgid", settleOrgId);
                    map.put("arMainBillEntity", coreBillType);
                    map.put("soid", coreBillId);
                    map.put("soentryid", coreBillEntryId);
                    map.put("baseqty", BigDecimal.ZERO);
                    map.put("amount", disposeAmt);
                    map.put("conbillentity", conbillentity);
                    map.put("conbillid", conbillId);
                    map.put("conbillentryid", conbillentryid);
                    map.put("uniqueEntryKeys", uniqueEntryKeys);
                    map.put("ArApBillId", billInfo.getLong("id"));
                    paramList.add(map);
                }
            }
        } else {
            String uniqueEntryKey = result.getMainBillId() + "_" + result.getMainBillEntryId();
            boolean isNotWriteBack = false;
            DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entry2 : entryCol) {
                Long coreBillId = entry2.getLong("corebillid");
                Long coreBillEntryId = entry2.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                isNotWriteBack = true;
            }
            ArrayList<Map<String, Object>> tempParamList = new ArrayList<Map<String, Object>>(paramList.size());
            for (Map param2 : arSelfParamList) {
                List uniqueEntryKeys = (List)param2.get("uniqueEntryKeys");
                if (isNotWriteBack && uniqueEntryKeys.contains(uniqueEntryKey)) continue;
                tempParamList.add(param2);
            }
            scheme.setParamList(tempParamList);
        }
    }

    public void processCoreBillParam(List<Map<String, Object>> rowList, DynamicObject bill, BigDecimal settleAmt, DynamicObject entry, SettleSchemeVO scheme, SettleRecordVO result, Set<Long> recEntryIdSet) {
        String settleRelation = result.getSettleRela();
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation)) {
            DynamicObject currency = bill.getDynamicObject("currency");
            if (1 == result.getSettleEntry()) {
                if (entry == null) {
                    return;
                }
                String corebillType = entry.getString("e_corebilltype");
                String corebillNo = entry.getString("e_corebillno");
                long corebillId = entry.getLong("corebillid");
                if (corebillId != 0L && !ObjectUtils.isEmpty((Object)corebillType) && !ObjectUtils.isEmpty((Object)corebillNo)) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", entry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", entry.getLong("id"));
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                    settleAmt = settleAmt.subtract(confirmAmt);
                    row.put("paidamount", settleAmt);
                    row.put("confirmlogo", Boolean.FALSE);
                    rowList.add(row);
                }
            } else {
                DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
                BigDecimal headAmt = bill.getBigDecimal("recamount");
                BigDecimal headUnSettle = bill.getBigDecimal("unsettleamount");
                BigDecimal confirmAmt = this.getConfirmAmt(settleRelation, scheme, recEntryIdSet, result, currency);
                settleAmt = settleAmt.subtract(confirmAmt);
                headUnSettle = headUnSettle.add(confirmAmt);
                int count = 0;
                BigDecimal remainDisposeAmount = settleAmt;
                for (DynamicObject detailEntry : detailColl) {
                    BigDecimal disposeAmt;
                    BigDecimal entryAmt = detailEntry.getBigDecimal("e_recamount");
                    String corebillType = detailEntry.getString("e_corebilltype");
                    String corebillNo = detailEntry.getString("e_corebillno");
                    long corebillId = detailEntry.getLong("corebillid");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    if (headUnSettle.compareTo(headAmt) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("e_settledamt") : detailEntry.getBigDecimal("e_settledamt").negate();
                    } else if (headUnSettle.compareTo(BigDecimal.ZERO) == 0) {
                        disposeAmt = scheme.isSettle() ? detailEntry.getBigDecimal("e_unsettleamt") : detailEntry.getBigDecimal("e_unsettleamt").negate();
                    } else if (++count == detailColl.size()) {
                        disposeAmt = remainDisposeAmount;
                    } else {
                        BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                        disposeAmt = settleAmt.multiply(proportion).setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", detailEntry.getLong("corebillentryid"));
                    row.put("apbillid", bill.getLong("id"));
                    row.put("apbillentryid", detailEntry.getLong("id"));
                    row.put("currencyid", currency.getLong("id"));
                    row.put("orgid", bill.getLong("org.id"));
                    row.put("asstactid", bill.getLong("asstact.id"));
                    row.put("asstacttype", bill.getString("asstacttype"));
                    row.put("paidamount", disposeAmt);
                    row.put("confirmlogo", Boolean.FALSE);
                    rowList.add(row);
                }
            }
        }
    }

    private BigDecimal getConfirmAmt(String settleRelation, SettleSchemeVO scheme, Set<Long> recEntryIdSet, SettleRecordVO result, DynamicObject currency) {
        BigDecimal confirmAmt = BigDecimal.ZERO;
        if (!SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            return confirmAmt;
        }
        List<SettleRecordEntryVO> entrys = result.getEntrys();
        if (entrys.get(0).getCurrencyId() != currency.getLong("id")) {
            return confirmAmt;
        }
        for (SettleRecordEntryVO entry : entrys) {
            long billEntryId = entry.getBillEntryId();
            if (!recEntryIdSet.contains(billEntryId)) continue;
            confirmAmt = confirmAmt.add(entry.getSettleAmt());
        }
        return scheme.isSettle() ? confirmAmt : confirmAmt.negate();
    }

    private void disposeReserveBill(List<DynamicObject> periodBills) {
        DynamicObject[] initReserves;
        HashMap<Long, DynamicObject> needReverseBillMap = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject wbAfterBill : periodBills) {
            needReverseBillMap.put(wbAfterBill.getLong("id"), wbAfterBill);
        }
        if (needReverseBillMap.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", needReverseBillMap.keySet());
        for (DynamicObject initReserve : initReserves = BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)"id, sourcebillid, unsettleamt, unsettlelocalamt, baddebtreserveamt, referencerate", (QFilter[])new QFilter[]{qFilter})) {
            long finArBillId = initReserve.getLong("sourcebillid");
            DynamicObject bill = (DynamicObject)needReverseBillMap.get(finArBillId);
            initReserve.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamount"));
            BigDecimal unSettleLocAmt = bill.getBigDecimal("unsettlelocalamt");
            initReserve.set("unsettlelocalamt", (Object)unSettleLocAmt);
            int precision = bill.getBigDecimal("exchangerate").scale();
            if (unSettleLocAmt.compareTo(BigDecimal.ZERO) != 0) {
                initReserve.set("referencerate", (Object)initReserve.getBigDecimal("baddebtreserveamt").divide(initReserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
                continue;
            }
            initReserve.set("referencerate", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])initReserves);
    }

    private Set<Long> getConfirmRecSet(List<SettleRecordVO> voList) {
        HashSet<Long> idSet = new HashSet<Long>(64);
        String settleRela = voList.get(0).getSettleRela();
        if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRela)) {
            for (SettleRecordVO result : voList) {
                List<SettleRecordEntryVO> entrys = result.getEntrys();
                for (SettleRecordEntryVO entry : entrys) {
                    idSet.add(entry.getBillId());
                }
            }
            DynamicObjectCollection recColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("confirmlogo", "=", (Object)Boolean.TRUE), new QFilter("entry.e_corebilltype", "=", (Object)"sm_salorder")});
            DynamicObjectCollection recScmColl = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("entry.e_matchselltag", "=", (Object)Boolean.TRUE)});
            recColl.addAll((Collection)recScmColl);
            idSet.clear();
            for (DynamicObject rec : recColl) {
                idSet.add(rec.getLong("entry.id"));
            }
            logger.info("getConfirmRecSet idSet:" + idSet);
        }
        return idSet;
    }

    private String getBillSettleStatus(DynamicObject bill) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("entry");
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal("e_unsettleamt");
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }
}

