/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.writeback.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.AbstractSettleWBService;

public class PayBillSettleWBService
extends AbstractSettleWBService {
    private static final Log logger = LogFactory.getLog(PayBillSettleWBService.class);
    private static final String PAY_ENTITY = "cas_paybill";
    private static final String PAID_ENTITY = "ap_paidbill";

    @Override
    public void writeBack(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        logger.info("PayBillSettleWBService writeback as main start");
        if (ObjectUtils.isEmpty(voList) || scheme == null) {
            return;
        }
        List<SettleRecordVO> receivedSRList = voList.stream().filter(sr -> PAID_ENTITY.equals(sr.getBillEntity())).collect(Collectors.toList());
        this.writeBackPaid(receivedSRList, scheme);
        List<SettleRecordVO> paySRList = voList.stream().filter(sr -> PAY_ENTITY.equals(sr.getBillEntity())).collect(Collectors.toList());
        DynamicObject[] bills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(paySRList)) {
            Set billIds = paySRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            bills = BusinessDataServiceHelper.load((String)PAY_ENTITY, (String)String.join((CharSequence)",", this.getPayWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        this.writeBackPay(paySRList, bills, scheme);
        logger.info("PayBillSettleWBService writeback as main end");
    }

    @Override
    public void writeBackAsst(List<SettleRecordEntryVO> entryVOList, SettleSchemeVO scheme) {
        logger.info("PayBillSettleWBService writeback as asst start");
        if (ObjectUtils.isEmpty(entryVOList) || scheme == null) {
            return;
        }
        List<SettleRecordEntryVO> paidSREntryList = entryVOList.stream().filter(sre -> PAID_ENTITY.equals(sre.getBillEntity())).collect(Collectors.toList());
        List<SettleRecordVO> paidSRList = this.convert2SRList(paidSREntryList);
        DynamicObject[] paidBills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(paidSRList)) {
            Set paidBillIds = paidSRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            paidBills = BusinessDataServiceHelper.load((String)PAID_ENTITY, (String)String.join((CharSequence)",", this.getPaidWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", paidBillIds)});
        }
        paidSRList = this.writeBackPaid(paidSRList, paidBills, scheme);
        int paidSRCount = 0;
        for (SettleRecordEntryVO settleRecordEntryVO : entryVOList) {
            if (!PAID_ENTITY.equals(settleRecordEntryVO.getBillEntity())) continue;
            settleRecordEntryVO.setLocalSettleAmt(paidSRList.get(paidSRCount).getLocalTotalSettleamt());
            ++paidSRCount;
        }
        List<SettleRecordEntryVO> paySREntryList = entryVOList.stream().filter(sre -> PAY_ENTITY.equals(sre.getBillEntity())).collect(Collectors.toList());
        List<SettleRecordVO> paySRList = this.convert2SRList(paySREntryList);
        DynamicObject[] casPayBills = new DynamicObject[]{};
        if (!ObjectUtils.isEmpty(paySRList)) {
            Set casPayBillIds = paySRList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
            casPayBills = BusinessDataServiceHelper.load((String)PAY_ENTITY, (String)String.join((CharSequence)",", this.getPayWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", casPayBillIds)});
        }
        paySRList = this.writeBackPay(paySRList, casPayBills, scheme);
        int paySRCount = 0;
        for (SettleRecordEntryVO settleRecordEntryVO : entryVOList) {
            if (!PAY_ENTITY.equals(settleRecordEntryVO.getBillEntity())) continue;
            settleRecordEntryVO.setLocalSettleAmt(paySRList.get(paySRCount).getLocalTotalSettleamt());
            ++paySRCount;
        }
        logger.info("PayBillSettleWBService writeback as asst end");
    }

    protected List<SettleRecordVO> writeBackPay(List<SettleRecordVO> voList, DynamicObject[] bills, SettleSchemeVO scheme) {
        QFilter sourceTypeFilter;
        QFilter billStatusFilter;
        QFilter entryIdFilter;
        QFilter idFilter;
        DynamicObjectCollection applyBills;
        if (ObjectUtils.isEmpty(voList) || ObjectUtils.isEmpty((Object[])bills)) {
            return voList;
        }
        HashMap<Long, DynamicObject> payBillEntryMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> payBillMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject bill : bills) {
            String billstatus = bill.getString("billstatus");
            String billno = bill.getString("billno");
            if (scheme.isUnSettleByWriteOff() && !"D".equals(billstatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\uff1a%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u4ed8\u6b3e\u3002", (String)"PayBillSettleWBService_0", (String)"fi-arapcommon", (Object[])new Object[]{billno}));
            }
            payBillMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                payBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        boolean isExistHeadProp = this.isExistHeadProp(bills[0]);
        boolean isSettle = scheme.isSettle();
        HashSet<Long> needDeleteBOTPApPayIds = new HashSet<Long>(64);
        HashSet<Long> needDeleteBOTPArPayIds = new HashSet<Long>(64);
        HashSet<Long> srcTypeIsPayApplyIds = new HashSet<Long>(64);
        HashSet<Long> needClosePayApplyIds = new HashSet<Long>(64);
        HashSet<Long> needClosePayApplyEntryIds = new HashSet<Long>(64);
        HashSet<Long> srcTypeIsPayApplyEntryIds = new HashSet<Long>(64);
        HashSet<Long> sourceIds = new HashSet<Long>(64);
        for (SettleRecordVO result : voList) {
            boolean isUnSettleDisposeAll;
            long entryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal localSettleAmt = result.getLocalTotalSettleamt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
                localSettleAmt = localSettleAmt.negate();
            }
            if (isExistHeadProp) {
                DynamicObject bill = (DynamicObject)payBillMap.get(result.getMainBillId());
                this.wbHead(bill, settleAmt, localSettleAmt);
            }
            DynamicObject entry = (DynamicObject)payBillEntryMap.get(entryId);
            boolean needWBLock = this.needWBLock(result, scheme, "ap_finapbill");
            if (needWBLock) {
                entry.set("e_lockamt", (Object)entry.getBigDecimal("e_lockamt").add(settleAmt));
                entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").subtract(settleAmt));
            }
            entry.set("e_settledamt", (Object)entry.getBigDecimal("e_settledamt").add(settleAmt));
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_unsettledamt").subtract(settleAmt));
            boolean isSettleDisposeAll = entry.getBigDecimal("e_unsettledamt").compareTo(BigDecimal.ZERO) == 0;
            boolean bl = isUnSettleDisposeAll = entry.getBigDecimal("e_settledamt").compareTo(BigDecimal.ZERO) == 0;
            if (isSettleDisposeAll) {
                result.setLocalTotalSettleamt(entry.getBigDecimal("e_payablelocamt").subtract(entry.getBigDecimal("e_settledlocalamt")));
                entry.set("e_settledlocalamt", (Object)entry.getBigDecimal("e_payablelocamt"));
                entry.set("e_unsettledlocalamt", (Object)BigDecimal.ZERO);
            } else if (isUnSettleDisposeAll) {
                entry.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
                entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_payablelocamt"));
            } else {
                entry.set("e_settledlocalamt", (Object)entry.getBigDecimal("e_settledlocalamt").add(localSettleAmt));
                entry.set("e_unsettledlocalamt", (Object)entry.getBigDecimal("e_unsettledlocalamt").subtract(localSettleAmt));
            }
            Long billId = result.getMainBillId();
            DynamicObject payBill = (DynamicObject)payBillMap.get(billId);
            String settleType = result.getSettleType();
            String autoSettleType = result.getAutoSettleType();
            if ((this.isNeedDeleteBOTP(isSettle, settleType, autoSettleType, scheme) || scheme.isUnSettleByWriteOff()) && "ap_payapply".equals(payBill.getString("sourcebilltype")) && result.getMainBillEntryId() == entry.getLong("id")) {
                needClosePayApplyIds.add(entry.getLong("e_sourcebillid"));
                needClosePayApplyEntryIds.add(entry.getLong("e_sourcebillentryid"));
            }
            if (!this.isNeedDeleteBOTP(isSettle, settleType, autoSettleType, scheme)) continue;
            if ("ap_payapply".equals(payBill.getString("sourcebilltype"))) {
                srcTypeIsPayApplyIds.add(entry.getLong("e_sourcebillid"));
                srcTypeIsPayApplyEntryIds.add(entry.getLong("e_sourcebillentryid"));
                continue;
            }
            if ("ap_finapbill".equals(payBill.getString("sourcebilltype"))) {
                needDeleteBOTPApPayIds.add(billId);
                sourceIds.add(entry.getLong("e_sourcebillid"));
                continue;
            }
            if (!"ar_finarbill".equals(payBill.getString("sourcebilltype"))) continue;
            needDeleteBOTPArPayIds.add(billId);
            sourceIds.add(entry.getLong("e_sourcebillid"));
        }
        if (isExistHeadProp) {
            this.wbHeadSettleStatus(bills);
        }
        logger.info("PayBillSettleWBService writeback ICallOrderConInvoker start");
        Settle4ScmcHelper.newWriteBackPurAndCon(voList, bills, scheme, null);
        logger.info("PayBillSettleWBService writeback ICallOrderConInvoker end");
        SaveServiceHelper.save((DynamicObject[])bills);
        if (!scheme.isSettle() && needClosePayApplyIds.size() > 0 && needClosePayApplyEntryIds.size() > 0 && EmptyUtils.isNotEmpty(applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,entry.id", (QFilter[])new QFilter[]{idFilter = new QFilter("id", "in", needClosePayApplyIds), entryIdFilter = new QFilter("entry.id", "in", needClosePayApplyEntryIds), billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"C", "E"}), sourceTypeFilter = new QFilter("sourcebilltype", "in", Arrays.asList("ap_finapbill", "ar_finarbill"))}))) {
            Object[] applyBillId = new Long[applyBills.size()];
            HashSet<Long> applyBillEntryId = new HashSet<Long>(applyBills.size());
            int i = 0;
            for (DynamicObject applyBill : applyBills) {
                applyBillId[i++] = applyBill.getLong("id");
                applyBillEntryId.add(applyBill.getLong("entry.id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_ignoremodify", "true");
            if (applyBillEntryId.size() > 0) {
                option.setVariableValue("selectrows", SerializationUtils.toJsonString(applyBillEntryId));
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"closepay", (String)"ap_payapply", (Object[])applyBillId, (OperateOption)option);
            OperationHelper.assertResult(operationResult);
        }
        if (needDeleteBOTPApPayIds.size() > 0) {
            this.deleteBOTPRelation(PAY_ENTITY, "ap_finapbill", needDeleteBOTPApPayIds, sourceIds);
        }
        if (needDeleteBOTPArPayIds.size() > 0) {
            this.deleteBOTPRelation(PAY_ENTITY, "ar_finarbill", needDeleteBOTPArPayIds, sourceIds);
        }
        if (srcTypeIsPayApplyIds.size() > 0) {
            this.deletePayApplyBOTPRelation("ap_payapply", "ap_finapbill", srcTypeIsPayApplyIds, srcTypeIsPayApplyEntryIds);
            this.deletePayApplyBOTPRelation("ap_payapply", "ar_finarbill", srcTypeIsPayApplyIds, srcTypeIsPayApplyEntryIds);
        }
        return voList;
    }

    private void wbHead(DynamicObject bill, BigDecimal settleAmt, BigDecimal localSettleAmt) {
        boolean isUnSettleDisposeAll;
        bill.set("unsettleamount", (Object)bill.getBigDecimal("unsettleamount").subtract(settleAmt));
        bill.set("settleamount", (Object)bill.getBigDecimal("settleamount").add(settleAmt));
        boolean isSettleDisposeAll = bill.getBigDecimal("unsettleamount").compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isUnSettleDisposeAll = bill.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0;
        if (isSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)BigDecimal.ZERO);
            bill.set("settleamountbase", (Object)bill.getBigDecimal("localamt"));
        } else if (isUnSettleDisposeAll) {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("localamt"));
            bill.set("settleamountbase", (Object)BigDecimal.ZERO);
        } else {
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("unsettleamountbase").subtract(localSettleAmt));
            bill.set("settleamountbase", (Object)bill.getBigDecimal("settleamountbase").add(localSettleAmt));
        }
    }

    private void wbHeadSettleStatus(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            String settleStatus = "partsettle";
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            boolean settled = true;
            for (DynamicObject entry : entries) {
                BigDecimal unsettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                settled = false;
                break;
            }
            if (settled) {
                settleStatus = "settled";
            }
            boolean unSettle = true;
            for (DynamicObject entry : entries) {
                BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
                if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                unSettle = false;
                break;
            }
            if (unSettle) {
                settleStatus = "unsettle";
            }
            bill.set("settlestatus", (Object)settleStatus);
        }
    }

    @Deprecated
    protected List<SettleRecordVO> writeBackPay(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList)) {
            return voList;
        }
        Set billIds = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)PAY_ENTITY, (String)String.join((CharSequence)",", this.getPayWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        return this.writeBackPay(voList, bills, scheme);
    }

    protected void writeBackPaid(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList)) {
            return;
        }
        Set billIds = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)PAID_ENTITY, (String)String.join((CharSequence)",", this.getPaidWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        this.writeBackPaid(voList, bills, scheme);
    }

    protected List<SettleRecordVO> writeBackPaid(List<SettleRecordVO> voList, DynamicObject[] bills, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(voList) || ObjectUtils.isEmpty((Object[])bills)) {
            return voList;
        }
        HashMap<Long, DynamicObject[]> billEntryMap = new HashMap<Long, DynamicObject[]>(64);
        HashSet<Long> billIds = new HashSet<Long>(8);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject[] entry : entrys) {
                billEntryMap.put(entry.getLong("id"), entry);
            }
            billIds.add(bill.getLong("id"));
        }
        QFilter filterForMain = new QFilter("mainbillid", "in", billIds);
        String selectors = CommonSettleServiceHelper.getSettleRecordSelector();
        DynamicObject[] resultForMain = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)selectors, (QFilter[])filterForMain.toArray());
        QFilter filterForAsst = new QFilter("entry.billid", "in", billIds);
        DynamicObject[] resultForAsst = SettleRecordQueryHelper.getSettleRecords("ap_settlerecord", selectors, PAID_ENTITY, new Object[]{billIds}, filterForAsst);
        HashMap<Long, BigDecimal> billEntryToLocalAmtMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject result : resultForMain) {
            Long entryId = result.getLong("mainbillentryid");
            BigDecimal localSettleAmt = result.getBigDecimal("localtotalsettleamt");
            billEntryToLocalAmtMap.merge(entryId, localSettleAmt, BigDecimal::add);
        }
        for (DynamicObject result : resultForAsst) {
            DynamicObjectCollection entries = result.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("billentryid");
                BigDecimal localSettleAmt = entry.getBigDecimal("localsettleamt");
                billEntryToLocalAmtMap.merge(entryId, localSettleAmt, BigDecimal::add);
            }
        }
        boolean isSettle = scheme.isSettle();
        for (SettleRecordVO result : voList) {
            DynamicObject entry;
            long entryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            entry = (DynamicObject)billEntryMap.get(entryId);
            entry.set("e_settledamt", (Object)entry.getBigDecimal("e_settledamt").add(settleAmt));
            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_unsettledamt").subtract(settleAmt));
            if (entry.getBigDecimal("e_unsettledamt").compareTo(BigDecimal.ZERO) == 0) {
                if (billEntryToLocalAmtMap.get(entryId) != null) {
                    result.setLocalTotalSettleamt(entry.getBigDecimal("e_localamt").subtract((BigDecimal)billEntryToLocalAmtMap.get(entryId)));
                } else {
                    result.setLocalTotalSettleamt(entry.getBigDecimal("e_localamt"));
                }
            } else {
                billEntryToLocalAmtMap.merge(entryId, result.getLocalTotalSettleamt(), BigDecimal::add);
            }
            entry.set("e_modifier", (Object)RequestContext.get().getCurrUserId());
            entry.set("e_modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        return voList;
    }

    @Override
    protected boolean needWBLock(SettleRecordVO result, SettleSchemeVO scheme, String ... possibleSources) {
        boolean needWBLock = super.needWBLock(result, scheme, possibleSources);
        if (scheme.isUnSettleByReturn() && !needWBLock) {
            needWBLock = true;
        }
        return needWBLock;
    }

    @Deprecated
    private boolean isExistSettleLocalProp(DynamicObject bill) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        return EntityMetadataUtils.isExistProperty(entry, "e_settledlocalamt") && EntityMetadataUtils.isExistProperty(entry, "e_unsettledlocalamt");
    }

    private boolean isExistHeadProp(DynamicObject bill) {
        if (bill == null) {
            return false;
        }
        return EntityMetadataUtils.isExistProperty(bill, "settlestatus");
    }

    private boolean isNeedDeleteBOTP(boolean isSettle, String settleType, String autoSettleType, SettleSchemeVO scheme) {
        return !isSettle && scheme.isUnSettleByListOP() && (SettleTypeEnum.AUTO.getValue().equals(settleType) && ("1".equals(autoSettleType) || "0".equals(autoSettleType)) || SettleTypeEnum.MANUAL.getValue().equals(settleType));
    }

    private void deleteBOTPRelation(String tarEntity, String srcEntity, Set<Long> needDeleteBOTPIds, Set<Long> sourceIds) {
        Map<Long, List<Long>> srcApBillMap = BOTPHelper.loadNearUpBillIds(tarEntity, srcEntity, needDeleteBOTPIds.toArray(new Long[0]));
        Set<Map.Entry<Long, List<Long>>> apEntries = srcApBillMap.entrySet();
        for (Map.Entry<Long, List<Long>> entry : apEntries) {
            Long billId = entry.getKey();
            HashSet srcBillIds = new HashSet(entry.getValue());
            for (Long srcBillId : srcBillIds) {
                if (!sourceIds.contains(srcBillId)) continue;
                BOTPHelper.deleteRelation(tarEntity, billId, srcBillId);
            }
        }
    }

    private void deletePayApplyBOTPRelation(String tarEntity, String srcEntity, Set<Long> srcTypeIsPayApplyIds, Set<Long> srcTypeIsPayApplyEntryIds) {
        Object key;
        Map<BFRowId, BFRowId> payApplyMap = BOTPHelper.loadTarToSrcBFRowMapByTarEntry(tarEntity, srcTypeIsPayApplyIds.toArray(new Long[0]), srcTypeIsPayApplyEntryIds.toArray(new Long[0]), srcEntity);
        HashMap tempPayApplyMap = new HashMap(payApplyMap.size());
        for (Map.Entry<BFRowId, BFRowId> entry : payApplyMap.entrySet()) {
            key = entry.getKey();
            BFRowId value = entry.getValue();
            Set setValue = (Set)tempPayApplyMap.get(key.getBillId());
            if (setValue != null) {
                setValue.add(value.getBillId());
                continue;
            }
            HashSet<Long> apSet = new HashSet<Long>(64);
            apSet.add(value.getBillId());
            tempPayApplyMap.put(key.getBillId(), apSet);
        }
        for (Map.Entry<Object, Object> entry : tempPayApplyMap.entrySet()) {
            key = (Long)entry.getKey();
            Set setValue = (Set)entry.getValue();
            for (Long value : setValue) {
                BOTPHelper.deleteRelation(tarEntity, (Long)key, value);
            }
        }
    }

    protected List<String> getPayWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(20);
        selector.add("e_payablelocamt");
        selector.add("e_lockamt");
        selector.add("e_unlockamt");
        selector.add("e_settledamt");
        selector.add("e_settledlocalamt");
        selector.add("e_unsettledamt");
        selector.add("e_unsettledlocalamt");
        selector.add("sourcebilltype");
        selector.add("e_sourcebillid");
        selector.add("e_sourcebillentryid");
        selector.add("paymenttype");
        selector.add("billstatus");
        selector.add("sourcebilltype");
        selector.add("e_corebilltype");
        selector.add("e_corebillno");
        selector.add("e_corebillentryseq");
        selector.add("e_corebillid");
        selector.add("e_corebillentryid");
        selector.add("settleorg");
        selector.add("currency");
        selector.add("payee");
        selector.add("conbillid");
        selector.add("conbillentryid");
        selector.add("settlestatus");
        selector.add("unsettleamount");
        selector.add("unsettleamountbase");
        selector.add("settleamount");
        selector.add("settleamountbase");
        selector.add("localamt");
        selector.add("e_paymenttype");
        selector.add("billno");
        return selector;
    }

    protected List<String> getPaidWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("e_settledamt");
        selector.add("e_unsettledamt");
        selector.add("e_localamt");
        selector.add("e_modifier");
        selector.add("e_modifytime");
        selector.add("paymenttype");
        selector.add("billstatus");
        selector.add("e_corebilltype");
        return selector;
    }
}

