/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.AccountVersionUtil;

public class AccountRepairPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog((String)"AccountRepair");
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"gl");
    private static final String[] REPAIREITEM = new String[]{"repairrepeat", "cleancahce", "backuptable"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), REPAIREITEM);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setShortCuts();
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        if (e.getEventName().equalsIgnoreCase("shortCuts")) {
            String key;
            switch (key = e.getEventArgs()) {
                case "[16,77]": {
                    this.getView().setVisible(Boolean.valueOf(true), REPAIREITEM);
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        switch (itemkey) {
            case "repairless1": {
                this.repairless();
                break;
            }
            case "repairrepeat": {
                this.repairrepeat();
                break;
            }
            case "repairlessall": {
                this.repairlessAll(rootOrgId);
                break;
            }
            case "repairlessone": {
                this.repairlessOne(rootOrgId);
                break;
            }
            case "backuptable": {
                this.backUpTable();
                break;
            }
            case "repairlacklast": {
                this.repairLackLastVersion(rootOrgId);
                break;
            }
            case "repairlackbegin": {
                this.repairLackBeginVer(rootOrgId);
                break;
            }
            case "fixusereg": {
                this.fixUsereg();
                break;
            }
            case "cleancahce": {
                this.cleanCache();
                break;
            }
            case "fixdata2": {
                this.fixdata2(rootOrgId);
                break;
            }
            case "fixdata3": {
                this.repairUsereg();
                break;
            }
            case "fixdata5": {
                this.fixdata5(rootOrgId);
                break;
            }
            case "assignall": {
                this.assignAll(rootOrgId);
                break;
            }
        }
    }

    private void repairrepeat() {
        String sql = "select a.faccounttableid,a.fnumber fnumber,a.fmasterid,u.fuseorgid,count(fnumber)  from t_bd_account_u u inner join t_bd_account a  on a.fid=u.fdataid  where  a.fenddate=? group by a.faccounttableid,a.fmasterid,a.fnumber,u.fuseorgid  having count(a.fnumber) >1 order by a.faccounttableid,u.fuseorgid, a.fnumber";
        ArrayList<AccountUsereg> regList = new ArrayList<AccountUsereg>(100);
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DB_ROUTE, (String)sql, (Object[])new Object[]{AccountVersionUtil.getEndDate()});){
            Map<Long, TreeNode> orgMap = this.getOrgTreeMapFunc();
            for (Row row : ds) {
                AccountUsereg usereg = this.build(row.getLong("fuseorgid"), row.getLong("faccounttableid"), row.getString("fnumber"), row.getLong("fmasterid"), orgMap);
                regList.add(usereg);
            }
        }
        ArrayList<Data> exclude = new ArrayList<Data>(100);
        ArrayList<Object[]> rem = new ArrayList<Object[]>(100);
        block23: for (AccountUsereg reg : regList) {
            List<Data> create = reg.getCreatted();
            if (create.isEmpty()) {
                long orgid = 0L;
                boolean begin = false;
                List<Data> list = reg.getAssign();
                for (int i = list.size() - 1; i >= 0; --i) {
                    if (!(begin || orgid != 0L && list.get((int)i).createorgid != orgid)) {
                        orgid = list.get((int)i).createorgid;
                        continue;
                    }
                    exclude.add(list.get(i));
                    begin = true;
                }
                continue;
            }
            exclude.addAll(reg.getAssign());
            if (create.size() <= 1 || !reg.isDel) continue;
            if (!reg.isLeaf) {
                this.updateLeaf(create);
            }
            int succSize = 0;
            for (int i = 0; i < create.size(); ++i) {
                OperationResult result = null;
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("createOrg", String.valueOf(create.get((int)i).createorgid));
                    result = OperationServiceHelper.executeOperate((String)"noverdelete", (String)"bd_accountview", (Object[])new Object[]{create.get((int)i).dataid}, (OperateOption)operateOption);
                    if (result.isSuccess()) {
                        rem.add(new Object[]{create.get((int)i).dataid});
                        ++succSize;
                    }
                    if (succSize < create.size() - 1) continue;
                    continue block23;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String insert = "insert into t_bd_accountexc(fuseorgid,fdataid,fcreateorgid) values (?,?,?)";
        String delSql = "delete from t_bd_accountexc where fdataid=? and fuseorgid=? ";
        HashSet<Long> orgIds = new HashSet<Long>(10);
        ArrayList<Object[]> insParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> delParams = new ArrayList<Object[]>(10);
        for (Data data : exclude) {
            Object[] p = new Object[]{data.useorgid, data.dataid, data.createorgid};
            insParams.add(p);
            Object[] d = new Object[]{data.dataid, data.useorgid};
            delParams.add(d);
            orgIds.add(data.useorgid);
        }
        if (!delParams.isEmpty()) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"repair");){
                try {
                    DB.executeBatch((DBRoute)DB_ROUTE, (String)delSql, delParams);
                    DB.executeBatch((DBRoute)DB_ROUTE, (String)insert, insParams);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (!rem.isEmpty()) {
            String delRegSql = "delete from t_bd_accountusereg where fdataid=? ";
            String string = "delete from t_bd_accountexc where fdataid=? ";
            DB.executeBatch((DBRoute)DB_ROUTE, (String)delRegSql, rem);
            DB.executeBatch((DBRoute)DB_ROUTE, (String)string, rem);
        }
        ArrayList singletonList = new ArrayList(1);
        BaseDataService baseDataService = new BaseDataService();
        orgIds.stream().forEach(x -> {
            singletonList.clear();
            singletonList.add(x);
            baseDataService.clearBaseDataFilterCache("bd_accountview", x);
            BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", (List)singletonList);
        });
        this.getView().showTipNotification("fix success");
    }

    private void updateLeaf(List<Data> create) {
        int i = 0;
        StringBuilder updateSql = new StringBuilder("update t_bd_account set fparentid=");
        for (Data cre : create) {
            if (i == 0) {
                updateSql.append(cre.dataid).append(" where forgid=").append(cre.useorgid).append(" and fparentid in (");
            } else {
                updateSql.append(cre.dataid).append(",");
            }
            ++i;
        }
        updateSql.setLength(updateSql.length() - 1);
        updateSql.append(")");
        DB.execute((DBRoute)DB_ROUTE, (String)updateSql.toString());
    }

    private AccountUsereg build(long useorgId, long accttableId, String number, Long fmasterid, Map<Long, TreeNode> orgMap) {
        Object[] param = new Object[]{useorgId, accttableId, number, fmasterid, AccountVersionUtil.getEndDate()};
        String checkdata = "select fuseorgid,a.fcreateorgid,fdataid,a.fstartdate,a.fenddate,a.fisleaf from t_bd_account_u reg inner join t_bd_account a on a.fid=reg.fdataid where reg.fuseorgid=? and a.faccounttableid = ? and a.fnumber= ? and a.fmasterid=? and a.fenddate=?";
        AccountUsereg usereg = new AccountUsereg();
        try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DB_ROUTE, (String)checkdata, (Object[])param);){
            for (Row row : ds) {
                if (row.getLong("fuseorgid").equals(row.getLong("fcreateorgid"))) {
                    usereg.getCreatted().add(new Data(0, row.getLong("fuseorgid"), row.getLong("fcreateorgid"), row.getLong("fdataid")));
                    if (row.getDate("fstartdate").compareTo(AccountVersionUtil.getInitBeginDate()) != 0 || row.getDate("fenddate").compareTo(AccountVersionUtil.getEndDate()) != 0) {
                        usereg.setDel(false);
                    }
                    if (!row.getBoolean("fisleaf").booleanValue()) continue;
                    usereg.setLeaf(true);
                    continue;
                }
                long createorgid = row.getLong("fcreateorgid");
                TreeNode node = orgMap.get(createorgid);
                usereg.getAssign().add(new Data(node.getLevel(), row.getLong("fuseorgid"), createorgid, row.getLong("fdataid")));
            }
        }
        usereg.sort();
        return usereg;
    }

    private void cleanCache() {
        ThreadService.execute(() -> {
            String sql = "select fuseorgid from t_bd_accountusereg group by fuseorgid";
            BaseDataService baseDataService = new BaseDataService();
            ArrayList<Long> singletonList = new ArrayList<Long>(1);
            try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DB_ROUTE, (String)sql);){
                for (Row row : ds) {
                    singletonList.clear();
                    singletonList.add(row.getLong("fuseorgid"));
                    baseDataService.clearBaseDataFilterCache("bd_accountview", row.getLong("fuseorgid"));
                    BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", singletonList);
                }
            }
        }, (TaskType)TaskType.FIBD_ACCOUNT_ASYNC_CLEAN_CACHE_TASK);
    }

    private void repairLackLastVersion(long rootOrgId) {
        long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (useorgId != rootOrgId) {
            Date maxDate = AccountVersionUtil.getEndDate();
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useorgId);
            HashMap<String, Long> map = new HashMap<String, Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bd_accountview", (String)"id, number, startdate, createorg, enddate", (QFilter[])new QFilter[]{qfilter}, (String)"number,startdate");){
                for (Row row : ds) {
                    String number = row.getString("number");
                    Date endDate = row.getDate("enddate");
                    if (endDate == null) continue;
                    if (!map.containsKey(number) && endDate.compareTo(maxDate) != 0) {
                        map.put(number, row.getLong("createorg"));
                    }
                    if (!map.containsKey(number) || endDate.compareTo(maxDate) != 0) continue;
                    map.remove(number);
                }
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(10);
            String sql = "insert into t_bd_accountusereg (fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign, fassignorgid) values (?,?,?,?,?,?,?)";
            String delSql = "delete from t_bd_accountusereg where fdataid=? and fuseorgid=? ";
            ArrayList<Object[]> delParams = new ArrayList<Object[]>(10);
            for (Map.Entry entry : map.entrySet()) {
                String number = (String)entry.getKey();
                Long createOrgId = (Long)entry.getValue();
                QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)createOrgId);
                QFilter fnumber = new QFilter("number", "=", (Object)number);
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accountview", (String)"id,ctrlstrategy", (QFilter[])new QFilter[]{fnumber, forg});
                for (DynamicObject obj : col) {
                    Object[] p = new Object[]{useorgId, obj.getLong("id"), createOrgId, createOrgId, obj.getString("ctrlstrategy"), "1", createOrgId};
                    params.add(p);
                    Object[] d = new Object[]{obj.getLong("id"), useorgId};
                    delParams.add(d);
                }
            }
            if (!delParams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)delSql, delParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", delParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_account_u(fdataid,fuseorgid) values(?,?)", delParams);
            }
        }
        this.getView().showTipNotification("success");
    }

    private void repairLackBeginVer(long rootOrgId) {
        long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (useorgId != rootOrgId) {
            Date initDate = AccountVersionUtil.getInitBeginDate();
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useorgId);
            HashMap<String, Long> map1 = new HashMap<String, Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bd_accountview", (String)"id, number, startdate, createorg, enddate", (QFilter[])new QFilter[]{qfilter}, (String)"number,startdate");){
                String num = "";
                for (Row row : ds) {
                    String number = row.getString("number");
                    if (row.getDate("startdate") == null) continue;
                    if (!num.equals(number) && !map1.containsKey(number) && initDate.compareTo(row.getDate("startdate")) != 0) {
                        map1.put(number, row.getLong("createorg"));
                    }
                    num = number;
                }
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(10);
            String sql = "insert into t_bd_accountusereg (fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign, fassignorgid) values (?,?,?,?,?,?,?)";
            String delSql = "delete from t_bd_accountusereg where fdataid=? and fuseorgid=? ";
            DynamicObject porg = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)useorgId), new QFilter("view", "=", (Object)10)});
            ArrayList<Object[]> delParams = new ArrayList<Object[]>(10);
            for (Map.Entry entry : map1.entrySet()) {
                String number = (String)entry.getKey();
                Long createOrgId = (Long)entry.getValue();
                if (porg == null) continue;
                long porgId = porg.getLong("parent");
                QFilter pids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)porgId);
                QFilter fnumber = new QFilter("number", "=", (Object)number);
                DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accountview", (String)"id,ctrlstrategy", (QFilter[])new QFilter[]{pids, fnumber});
                for (DynamicObject obj : col) {
                    Object[] p = new Object[]{useorgId, obj.getLong("id"), createOrgId, createOrgId, obj.getString("ctrlstrategy"), "1", createOrgId};
                    params.add(p);
                    Object[] d = new Object[]{obj.getLong("id"), useorgId};
                    delParams.add(d);
                }
            }
            if (!delParams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)delSql, delParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_account_u where fdataid = ? and fuseorgid = ?", delParams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_account_u(fdataid,fuseorgid) values(?,?)", delParams);
            }
        }
        this.getView().showTipNotification("success");
    }

    private void fixdata2(long rootOrgId) {
        long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
        String sql = "";
        if (useorgId != rootOrgId) {
            Serializable upparams;
            DataSet dt;
            Object saveid2;
            Object number;
            sql = "select av1.fid id,av1.fnumber num from t_bd_account av1 inner join (select fnumber,fstartdate from t_bd_account where forgid=" + useorgId + " group by fnumber,fstartdate having count(1)>1) av2 on av1.fnumber=av2.fnumber and av1.fstartdate=av2.fstartdate and av1.forgid=" + useorgId + " order by av1.fnumber,av1.fid";
            ArrayList<Long> deleteIds = new ArrayList<Long>(1000);
            HashMap<String, Long> numAndSaveIds = new HashMap<String, Long>(1000);
            try (DataSet dt2 = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
                for (Row row : dt2) {
                    number = row.getString("num");
                    saveid2 = (Long)numAndSaveIds.get(number);
                    if (saveid2 == null) {
                        saveid2 = row.getLong("id");
                        numAndSaveIds.put((String)number, (Long)saveid2);
                        continue;
                    }
                    deleteIds.add(row.getLong("id"));
                }
            }
            ArrayList tempIds = new ArrayList(500);
            for (int i = 0; i < deleteIds.size(); ++i) {
                if (tempIds.size() <= 500) {
                    tempIds.add(deleteIds.get(i));
                    continue;
                }
                ArrayList<Long> voucheracctIds = new ArrayList<Long>(500);
                dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"entries.account", (QFilter[])new QFilter[]{new QFilter("entries.account", "in", tempIds)}, null);
                number = null;
                try {
                    for (Object row : dt) {
                        voucheracctIds.add(row.getLong("entries.account"));
                    }
                }
                catch (Throwable saveid2) {
                    number = saveid2;
                    throw saveid2;
                }
                finally {
                    if (dt != null) {
                        if (number != null) {
                            try {
                                dt.close();
                            }
                            catch (Throwable saveid2) {
                                ((Throwable)number).addSuppressed(saveid2);
                            }
                        } else {
                            dt.close();
                        }
                    }
                }
                tempIds.removeAll(voucheracctIds);
                upparams = new ArrayList(1000);
                DataSet dt3 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,number,parent,parent.number", (QFilter[])new QFilter[]{new QFilter("parent", "in", tempIds), new QFilter("id", "not in", tempIds)}, null);
                saveid2 = null;
                try {
                    Object row;
                    row = dt3.iterator();
                    while (row.hasNext()) {
                        Row row2 = (Row)row.next();
                        String pnum = row2.getString("parent.number");
                        Long pid = (Long)numAndSaveIds.get(pnum);
                        if (pid == null) continue;
                        upparams.add(new Object[]{pid, row2.getLong("id")});
                    }
                }
                catch (Throwable row) {
                    saveid2 = row;
                    throw row;
                }
                finally {
                    if (dt3 != null) {
                        if (saveid2 != null) {
                            try {
                                dt3.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)saveid2).addSuppressed(row);
                            }
                        } else {
                            dt3.close();
                        }
                    }
                }
                ArrayList<Object[]> useregparams = new ArrayList<Object[]>(500);
                for (Long tempId : tempIds) {
                    useregparams.add(new Object[]{tempId});
                }
                if (!upparams.isEmpty()) {
                    this.executeSql("update t_bd_account set fparentid = ? where fid = ?", (List<Object[]>)((Object)upparams));
                }
                if (!tempIds.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"), (Object[])tempIds.toArray());
                }
                if (!useregparams.isEmpty()) {
                    this.executeSql("delete from t_bd_accountusereg where fdataid = ?", useregparams);
                    this.executeSql("delete from t_bd_account_u where fdataid = ?", useregparams);
                    this.executeSql("delete from t_bd_accountexc where fdataid = ?", useregparams);
                }
                tempIds.clear();
                tempIds.add(deleteIds.get(i));
            }
            if (!tempIds.isEmpty()) {
                ArrayList<Long> voucheracctIds = new ArrayList<Long>(500);
                DataSet dt4 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"entries.account", (QFilter[])new QFilter[]{new QFilter("entries.account", "in", tempIds)}, null);
                upparams = null;
                try {
                    for (Object row : dt4) {
                        voucheracctIds.add(row.getLong("entries.account"));
                    }
                }
                catch (Throwable throwable) {
                    upparams = throwable;
                    throw throwable;
                }
                finally {
                    if (dt4 != null) {
                        if (upparams != null) {
                            try {
                                dt4.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)upparams).addSuppressed(throwable);
                            }
                        } else {
                            dt4.close();
                        }
                    }
                }
                tempIds.removeAll(voucheracctIds);
                ArrayList<Object[]> upparams2 = new ArrayList<Object[]>(1000);
                dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,number,parent,parent.number", (QFilter[])new QFilter[]{new QFilter("parent", "in", tempIds), new QFilter("id", "not in", tempIds)}, null);
                Iterator iterator = null;
                try {
                    for (Object row : dt) {
                        String pnum = row.getString("parent.number");
                        Long pid = (Long)numAndSaveIds.get(pnum);
                        if (pid == null) continue;
                        upparams2.add(new Object[]{pid, row.getLong("id")});
                    }
                }
                catch (Throwable row) {
                    iterator = row;
                    throw row;
                }
                finally {
                    if (dt != null) {
                        if (iterator != null) {
                            try {
                                dt.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)((Object)iterator)).addSuppressed(row);
                            }
                        } else {
                            dt.close();
                        }
                    }
                }
                ArrayList<Object[]> useregparams = new ArrayList<Object[]>(500);
                for (Long tempId : tempIds) {
                    useregparams.add(new Object[]{tempId});
                }
                if (!upparams2.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_bd_account set fparentid = ? where fid = ?", upparams2);
                }
                if (!tempIds.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"), (Object[])tempIds.toArray());
                }
                if (!useregparams.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountusereg where fdataid = ?", useregparams);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_account_u where fdataid = ?", useregparams);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountexc where fdataid = ?", useregparams);
                }
            }
        }
        this.getView().showTipNotification("success");
    }

    private void fixUsereg() {
        String sql = "update t_bd_accountusereg set fisassign='0',fassignorgid=0 where fuseorgid=fcreateorgid";
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql);
    }

    private void repairUsereg() {
        String sql = "select t1.fcreateorgid orgid,t1.fid id,t1.fctrlstrategy ctr from t_bd_account t1 where  t1.fctrlstrategy<>'5'  and not exists (select 1 from t_bd_accountusereg t2 where t1.fid=t2.fdataid and t1.fcreateorgid=t2.fcreateorgid and t1.fcreateorgid=t2.fuseorgid)";
        String insertSql = "insert into t_bd_accountusereg(fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid) values(?,?,?,?,?,?,?)";
        try (DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
            ArrayList<Object[]> regparams = new ArrayList<Object[]>(1000);
            for (Row row : dt) {
                regparams.add(new Object[]{row.getLong("orgid"), row.getLong("id"), row.getLong("orgid"), row.getLong("orgid"), row.getString("ctr"), 0, 0});
                if (regparams.size() != 500) continue;
                this.executeSql(insertSql, regparams);
                regparams.clear();
            }
            if (!regparams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertSql, regparams);
            }
        }
        this.getView().showTipNotification("success");
    }

    private void fixdata5(long rootOrgId) {
        long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (useorgId != rootOrgId) {
            Object object;
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useorgId);
            HashMap<String, Set> numDates = new HashMap<String, Set>(1000);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"startdate,number", (QFilter[])new QFilter[]{ids}, (String)"number");){
                object = dt.iterator();
                while (object.hasNext()) {
                    Row row;
                    numDates.computeIfAbsent(row.getString("number"), k -> new HashSet()).add((row = (Row)object.next()).getDate("startdate") == null ? "0" : sf.format(row.getDate("startdate")));
                }
            }
            ArrayList<Object[]> deleparams = new ArrayList<Object[]>(1000);
            DataSet dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)("select acct.fnumber num,acct.fstartdate startdate,exc.fdataid dataid,exc.fuseorgid useorgid from t_bd_accountexc exc left join t_bd_account acct on exc.fdataid=acct.fid where exc.fuseorgid=" + useorgId));
            object = null;
            try {
                for (Row row : dt) {
                    String num = row.getString("num");
                    Set dates = (Set)numDates.get(num);
                    if (dates != null && (dates == null || dates.contains(row.getDate("startdate") == null ? "0" : sf.format(row.getDate("startdate"))))) continue;
                    deleparams.add(new Object[]{row.getLong("useorgid"), row.getLong("dataid")});
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dt != null) {
                    if (object != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            if (!deleparams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountexc where fuseorgid = ? and fdataid = ?", deleparams);
            }
        }
        this.getView().showTipNotification("success");
    }

    private void assignAll(long rootOrgId) {
        DynamicObject porg;
        long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (useorgId != rootOrgId && (porg = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)useorgId), new QFilter("view", "=", (Object)10)})) != null) {
            Object row2;
            long porgId = porg.getLong("parent");
            QFilter pids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)porgId);
            HashMap<String, Set> pnumAccts = new HashMap<String, Set>(1000);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"ctrlstrategy,number,id,createorg", (QFilter[])new QFilter[]{pids}, (String)"number");){
                for (Object row2 : dt) {
                    pnumAccts.computeIfAbsent(row2.getString("number"), k -> new HashSet()).add(new AcctInfo(new Object[]{row2.getLong("id"), row2.getLong("createorg"), row2.getString("ctrlstrategy")}));
                }
            }
            HashMap<String, Set> numAccts = new HashMap<String, Set>(1000);
            QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)useorgId);
            DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"ctrlstrategy,number,id,createorg", (QFilter[])new QFilter[]{ids}, (String)"number");
            row2 = null;
            try {
                for (Row row3 : dt) {
                    numAccts.computeIfAbsent(row3.getString("number"), k -> new HashSet()).add(new AcctInfo(new Object[]{row3.getLong("id"), row3.getLong("createorg"), row3.getString("ctrlstrategy")}));
                }
            }
            catch (Throwable throwable) {
                row2 = throwable;
                throw throwable;
            }
            finally {
                if (dt != null) {
                    if (row2 != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)row2).addSuppressed(throwable);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
            ArrayList<Object[]> delparams = new ArrayList<Object[]>(1000);
            for (Map.Entry pnumAcctsEntry : pnumAccts.entrySet()) {
                String pnum = (String)pnumAcctsEntry.getKey();
                if (numAccts.get(pnum) != null) continue;
                Set accts = (Set)pnumAcctsEntry.getValue();
                for (AcctInfo acct : accts) {
                    Object[] acctarrs = acct.getParam();
                    if ("7".equals(String.valueOf(acctarrs[2])) || "5".equals(String.valueOf(acctarrs[2])) || "6".equals(String.valueOf(acctarrs[2]))) continue;
                    params.add(new Object[]{useorgId, acctarrs[0], acctarrs[1], acctarrs[1], acctarrs[2], 1, porgId});
                    delparams.add(new Object[]{useorgId, acctarrs[0]});
                }
            }
            if (!delparams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_accountusereg where fuseorgid = ? and fdataid = ?", delparams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_accountusereg(fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid) values(?,?,?,?,?,?,?)", params);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_bd_account_u where fuseorgid = ? and fdataid = ?", delparams);
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"insert into t_bd_account_u(fuseorgid,fdataid) values(?,?)", delparams);
            }
        }
        this.getView().showTipNotification("success");
    }

    private void executeSql(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, params);
    }

    private void backUpTable() {
        Calendar now = Calendar.getInstance();
        String suffix = "_" + now.get(1) + now.get(2) + now.get(5);
        this.backUpTableFunc("t_bd_account", suffix);
        this.backUpTableFunc("t_bd_accountusereg", suffix);
        this.backUpTableFunc("t_bd_accountexc", suffix);
        this.getView().showTipNotification("success");
    }

    private void backUpTableFunc(String tableName, String backup) {
        String backupTableName = tableName + backup;
        logger.info(String.format("\u5907\u4efd[%s]\u8868\u6570\u636e\u5230[%s]", tableName, backupTableName));
        DB.execute((DBRoute)DB_ROUTE, (String)String.format("/*dialect*/CREATE TABLE %s LIKE %s", backupTableName, tableName));
        DB.execute((DBRoute)DB_ROUTE, (String)String.format("/*dialect*/insert into %s select * from %s", backupTableName, tableName));
    }

    private void repairlessOne(long rootOrgId) {
        this.getView().showTipNotification("start");
        long orgNodeChildrenId = Long.parseLong(this.getPageCache().get("createOrg"));
        if (orgNodeChildrenId == rootOrgId) {
            return;
        }
        logger.info("repairless0100  start");
        Map<Long, TreeNode> orgMap = this.getOrgTreeMapFunc();
        this.repairless0100Rcursive(orgNodeChildrenId, orgMap);
    }

    private void repairlessAll(long rootOrgId) {
        this.getView().showTipNotification("start");
        ThreadService.execute(() -> {
            try {
                this.repairless0100Thread(rootOrgId);
            }
            catch (Exception e) {
                logger.error("repairless0100 " + e.getMessage());
            }
        }, (TaskType)TaskType.FIBD_ACCOUNT_ASYNC_REPAIR_ALL_TASK);
    }

    private void repairless0100Thread(long rootOrgId) {
        logger.info("repairless0100  start");
        Map<Long, TreeNode> orgMap = this.getOrgTreeMapFunc();
        Set orgIds = (Set)DB.query((DBRoute)DB_ROUTE, (String)"select distinct fuseorgid from t_bd_account_u ", (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> orgIds = new HashSet<Long>(100);
                while (rs.next()) {
                    orgIds.add(rs.getLong("fuseorgid"));
                }
                return orgIds;
            }
        });
        int i = 0;
        for (Long orgId : orgIds) {
            logger.info("\u603b\u5171\u6709" + orgIds.size() + "\u5bb6\u7ec4\u7ec7\uff0c\u4fee\u590drepairless0100 \u7b2c" + ++i + "\u5bb6, orgid " + orgId);
            if (orgId == null || orgId.compareTo(0L) == 0 || orgId.compareTo(rootOrgId) == 0 || !orgMap.containsKey(orgId)) continue;
            this.repairless0100Rcursive(orgId, orgMap);
        }
    }

    private void repairless0100Rcursive(Long orgNodeChildrenId, Map<Long, TreeNode> orgMap) {
        logger.info("repairless0100  start");
        TreeNode orgNodeParent = orgMap.get(orgNodeChildrenId);
        long orgId = orgNodeParent.getParentid();
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache("bd_accountview", Long.valueOf(orgId));
        ArrayList<Long> orgParentids = new ArrayList<Long>(2);
        orgParentids.add(orgId);
        orgParentids.add(orgNodeChildrenId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", orgParentids);
        ArrayList<Long> acctountSqlParams = new ArrayList<Long>(10);
        StringBuilder acctountSql = new StringBuilder();
        acctountSql.append(" select oav.fnumber,oav.faccounttableid ");
        acctountSql.append(" from t_bd_account_u u ");
        acctountSql.append(" inner join t_bd_account oav on oav.fid=u.fdataid ");
        acctountSql.append(" where u.fuseorgid=? ");
        acctountSqlParams.add(OrgUnitServiceHelper.getRootOrgId());
        acctountSql.append(" and oav.fenddate=to_date('2999-12-31') ");
        acctountSql.append(" and not exists (  ");
        acctountSql.append(" \tselect av.fnumber ");
        acctountSql.append(" \tfrom t_bd_account_u u ");
        acctountSql.append(" \tinner join t_bd_account av on av.fid=u.fdataid  ");
        acctountSql.append(" \twhere u.fuseorgid=? ");
        acctountSqlParams.add(orgNodeChildrenId);
        acctountSql.append(" \tand fenddate=to_date('2999-12-31') ");
        acctountSql.append(" \tand oav.fnumber=av.fnumber ");
        acctountSql.append(" \tand oav.faccounttableid = av.faccounttableid ");
        acctountSql.append(" ) and oav.fenable='1' and oav.fk_oct_businesstype='01'  ");
        DB.query((DBRoute)DB_ROUTE, (String)acctountSql.toString(), (Object[])acctountSqlParams.toArray(), rs -> {
            while (rs.next()) {
                this.repairless(orgNodeChildrenId, rs.getString("fnumber"), rs.getLong("faccounttableid"), orgMap);
            }
            return null;
        });
        baseDataService.clearBaseDataFilterCache("bd_accountview", orgNodeChildrenId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)"bd_accountview", orgParentids);
    }

    private Map<Long, TreeNode> getOrgTreeMapFunc() {
        return (Map)DB.query((DBRoute)DBRoute.base, (String)"select forgid,fparentid,flevel from t_org_structure where fviewid=10", (ResultSetHandler)new ResultSetHandler<Map<Long, TreeNode>>(){

            public Map<Long, TreeNode> handle(ResultSet rs) throws Exception {
                HashMap<Long, TreeNode> orgMap = new HashMap<Long, TreeNode>(100);
                while (rs.next()) {
                    orgMap.put(rs.getLong("forgid"), new TreeNode(rs.getLong("forgid"), rs.getLong("fparentid"), rs.getInt("flevel")));
                }
                for (Map.Entry entry : orgMap.entrySet()) {
                    long parentId = ((TreeNode)entry.getValue()).getParentid();
                    ((TreeNode)entry.getValue()).setParent((TreeNode)orgMap.get(parentId));
                }
                return orgMap;
            }
        });
    }

    private void repairless() {
        Map<Long, TreeNode> orgMap = this.getOrgTreeMapFunc();
        Set orgIds = (Set)DB.query((DBRoute)DB_ROUTE, (String)"select distinct fuseorgid from t_bd_account_u ", (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> orgIds = new HashSet<Long>(10);
                while (rs.next()) {
                    orgIds.add(rs.getLong("fuseorgid"));
                }
                return orgIds;
            }
        });
        for (Long orgId : orgIds) {
            this.repairless(orgId, orgMap);
        }
    }

    private void repairless(final long orgId, final Map<Long, TreeNode> orgMap) {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct t.fnumber,t.faccounttableid from (SELECT p.fnumber,u.fuseorgid,a.faccounttableid FROM t_bd_account a inner JOIN t_bd_account_u u ON u.fdataid=a.fid inner JOIN t_bd_account p on p.fid =a.fparentid where a.fenddate=to_date('2999-12-31') and u.fuseorgid=? ) t where not exists (SELECT 1 FROM t_bd_account a inner JOIN t_bd_account_u u ON u.fdataid=a.fid where t.fnumber = a.fnumber and t.faccounttableid = a.faccounttableid and t.fuseorgid=u.fuseorgid and a.fenddate=to_date('2999-12-31') and u.fuseorgid=?)");
        DB.query((DBRoute)DB_ROUTE, (String)sql.toString(), (Object[])new Object[]{orgId, orgId}, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    AccountRepairPlugin.this.repairless(orgId, rs.getString("fnumber"), rs.getLong("faccounttableid"), orgMap);
                }
                return null;
            }
        });
    }

    private void repairless(final long orgId, final String account, final long accountTableId, final Map<Long, TreeNode> orgMap) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ex.fdataid,ex.fcreateorgid from t_bd_accountexc ex inner join t_bd_account av on av.fid=ex.fdataid where ex.fuseorgid=? and av.fnumber=? and av.faccounttableid=?");
        DB.query((DBRoute)DB_ROUTE, (String)sql.toString(), (Object[])new Object[]{orgId, account, accountTableId}, (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                int level = 0;
                long dataid = 0L;
                while (rs.next()) {
                    TreeNode org = (TreeNode)orgMap.get(rs.getLong("fcreateorgid"));
                    if (org != null && org.getLevel() > level) {
                        level = org.getLevel();
                        dataid = rs.getLong("fdataid");
                        continue;
                    }
                    if (level != 0) continue;
                    dataid = rs.getLong("fdataid");
                }
                try {
                    if (dataid != 0L) {
                        AccountRepairPlugin.this.delExc(orgId, dataid);
                    } else {
                        AccountRepairPlugin.this.insertUseReg(orgId, account, accountTableId, orgMap);
                    }
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
                return null;
            }
        });
    }

    private void delExc(long orgId, long dataid) {
        DB.update((DBRoute)DB_ROUTE, (String)"delete from t_bd_accountexc where fdataid=? and fuseorgid=?", (Object[])new Object[]{dataid, orgId});
        logger.info("repairless:delete t_bd_accountexc{dataid:" + dataid + ";useorgid:" + orgId);
    }

    private void insertUseReg(long orgId, String account, long accountTableId, Map<Long, TreeNode> orgs) {
        ArrayList<Long> pOrgIds = new ArrayList<Long>(10);
        this.recursiveParentOrgById(orgId, orgs, pOrgIds);
        if (pOrgIds.isEmpty()) {
            return;
        }
        Long assignOrgId = (Long)pOrgIds.get(0);
        ArrayList<Object> acctountSqlParams = new ArrayList<Object>(10);
        StringBuilder acctountSql = new StringBuilder();
        acctountSql.append(" select a.fid,a.fcreateOrgId,a.fctrlstrategy,a.faccounttableid ");
        acctountSql.append(" from  t_bd_account a ");
        acctountSql.append(" inner join t_bd_account_u u on a.fid=u.fdataid and a.fcreateOrgId=u.fuseorgid ");
        acctountSql.append(" where a.faccounttableid= ?  ");
        acctountSqlParams.add(accountTableId);
        acctountSql.append(" and a.fnumber =? ");
        acctountSqlParams.add(account);
        acctountSql.append(" and a.fcreateorgid in ( ");
        pOrgIds.forEach(k -> acctountSql.append("?,"));
        acctountSql.deleteCharAt(acctountSql.length() - 1).append(" ) ");
        acctountSqlParams.addAll(pOrgIds);
        Map orgidAcccountnoDataids = (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)acctountSql.toString(), (Object[])acctountSqlParams.toArray(), rs -> {
            HashMap<Long, ArrayList<Object[]>> returnObjs = new HashMap<Long, ArrayList<Object[]>>(16);
            while (rs.next()) {
                long fcreateorgid = rs.getLong("fcreateorgid");
                Object[] dataObj = new Object[]{orgId, rs.getLong("fid"), fcreateorgid, fcreateorgid, rs.getString("fctrlstrategy"), "1", assignOrgId};
                ArrayList<Object[]> set = (ArrayList<Object[]>)returnObjs.get(fcreateorgid);
                if (set == null) {
                    set = new ArrayList<Object[]>(10);
                    returnObjs.put(fcreateorgid, set);
                }
                set.add(dataObj);
            }
            return returnObjs;
        });
        if (orgidAcccountnoDataids.size() > 0) {
            for (Long pOrgId : pOrgIds) {
                if (!orgidAcccountnoDataids.containsKey(pOrgId)) continue;
                List useRegParams = (List)orgidAcccountnoDataids.get(pOrgId);
                this.updateReg(useRegParams);
                break;
            }
        }
    }

    private void updateReg(List<Object[]> useRegParams) {
        String deleteUseRegSql = "delete from t_bd_accountusereg where fdataid = ? and fcreateorgid = ? and fuseorgid = ?";
        String insertUseRegSql = "insert into t_bd_accountusereg(fuseorgid,fdataid,fcreateorgid,fadminorgid,fctrlstrategy,fisassign,fassignorgid) values(?,?,?,?,?,?,?)";
        ArrayList<Object[]> delParams = new ArrayList<Object[]>(useRegParams.size());
        for (Object[] param : useRegParams) {
            delParams.add(new Object[]{param[1], param[2], param[0]});
            logger.info("repairless:insert accountusereg{dataid:" + param[1] + ";useorgid:" + param[0]);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)deleteUseRegSql, delParams);
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertUseRegSql, new ArrayList<Object[]>(useRegParams));
    }

    private void recursiveParentOrgById(long orgId, Map<Long, TreeNode> orgs, List<Long> pOrgIds) {
        long parentid;
        TreeNode node = orgs.get(orgId);
        if (null != node && (parentid = node.getParentid()) > 0L) {
            pOrgIds.add(parentid);
            this.recursiveParentOrgById(parentid, orgs, pOrgIds);
        }
    }

    static class TreeNode {
        private long id;
        private long parentid;
        private TreeNode parent;
        private int level;
        private List<TreeNode> children = new ArrayList<TreeNode>(10);

        TreeNode(long id, long parentid, int level) {
            this.id = id;
            this.parentid = parentid;
            this.level = level;
        }

        long getId() {
            return this.id;
        }

        void setId(long id) {
            this.id = id;
        }

        long getParentid() {
            return this.parentid;
        }

        public int getLevel() {
            return this.level;
        }

        void setParent(TreeNode parent) {
            this.parent = parent;
        }

        TreeNode getParent() {
            return this.parent;
        }

        List<TreeNode> getChildren() {
            return this.children;
        }

        void addChild(TreeNode child) {
            this.children.add(child);
        }
    }

    static class AcctInfo {
        private Object[] param;

        AcctInfo(Object[] param) {
            this.param = param;
        }

        protected Object[] getParam() {
            return this.param;
        }
    }

    static class Data {
        int level;
        long useorgid;
        long createorgid;
        long dataid;

        Data(int level, long useorgid, long createorgid, long dataid) {
            this.level = level;
            this.useorgid = useorgid;
            this.createorgid = createorgid;
            this.dataid = dataid;
        }

        public int getLevel() {
            return this.level;
        }

        public long getUseorgid() {
            return this.useorgid;
        }

        public long getCreateorgid() {
            return this.createorgid;
        }

        public long getDataid() {
            return this.dataid;
        }
    }

    static class AccountUsereg {
        List<Data> assign = new ArrayList<Data>(100);
        List<Data> creatted = new ArrayList<Data>(10);
        boolean isDel = true;
        boolean isLeaf = false;

        AccountUsereg() {
        }

        public List<Data> getAssign() {
            return this.assign;
        }

        public List<Data> getCreatted() {
            return this.creatted;
        }

        public void setDel(boolean isDel) {
            this.isDel = isDel;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public void sort() {
            this.assign.sort((a, b) -> Integer.compare(a.level, b.level));
        }
    }
}

