/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountTableUtil;

public class AccountTableEdit
extends AbstractBillPlugIn
implements ClickListener {
    private static final String ORGFUNCTIONKEY = "orgfunction";
    private static final boolean unable = false;
    private static final String NEED_CLEAN_VALUE_SOURCE = "needClean";

    public void initialize() {
        super.initialize();
        Map map = EntityMetadataCache.getDataEntityType((String)"bd_accounttable").getAllFields();
        OrgProp pro = (OrgProp)map.get("org");
        if (pro == null) {
            return;
        }
        if (this.getPageCache() != null && this.getPageCache().get(ORGFUNCTIONKEY) != null) {
            pro.setOrgFunc(this.getPageCache().get(ORGFUNCTIONKEY));
        } else {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_accountview");
            if (ctrlview != null) {
                String treetype = ctrlview.getString("treetype");
                pro.setOrgFunc(treetype);
                this.getPageCache().put(ORGFUNCTIONKEY, treetype);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long deforgid = OrgUnitServiceHelper.getRootOrgId();
        this.getModel().setValue("org", (Object)deforgid);
        this.getModel().setValue("createorg", (Object)deforgid);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object id = this.getModel().getValue("id");
        int comAssistCount = this.getModel().getEntryRowCount("comassistentry");
        boolean exists = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])new QFilter[]{new QFilter("accounttable", "=", id)});
        if (exists && comAssistCount > 0) {
            for (int i = 0; i < comAssistCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"comassistnumber", "comassistname", "isbalance", "valuesourcetype", "valuesource", "valuesource", "assistantvaluesource"});
            }
        } else {
            for (int i = 0; i < comAssistCount; ++i) {
                String valueSourceType = (String)this.getModel().getValue("valuesourcetype", i);
                this.setValueSourceEnable(valueSourceType, i);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IFormView view = this.getView();
        long id = (Long)view.getModel().getValue("id");
        DataSet accts = QueryServiceHelper.queryDataSet((String)"kd.fi.bd.formplugin.AccountTableEdit.afterLoadData", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter("accounttable", "=", (Object)id).toArray(), null, (int)1);
        boolean isextendpnum = (Boolean)this.getModel().getValue("isextendpnum");
        if (accts.hasNext()) {
            if (!isextendpnum) {
                view.setEnable(Boolean.valueOf(isextendpnum), new String[]{"isextendpnum"});
            }
            view.setEnable(Boolean.valueOf(false), new String[]{"seperator"});
            view.setEnable(Boolean.valueOf(false), new String[]{"isinternational"});
            view.setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        this.getModel().setValue("createorg", this.getModel().getValue("org"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IPageCache pageCache = this.getPageCache();
        IDataModel dobj = this.getModel();
        if ("accountlevel".equals(propertyName)) {
            String accountlevelValue = dobj.getValue("accountlevel").toString();
            if ("".equals(accountlevelValue)) {
                return;
            }
            if (accountlevelValue.contains("-")) {
                Boolean isCorrectFormat = this.isCorrectFormat(accountlevelValue);
                if (isCorrectFormat.booleanValue()) {
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u683c\u5f0f\u4e0d\u5bf9", (String)"AccountTableEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean isDigit = this.isDigit(accountlevelValue);
            if (!isDigit.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"AccountTableEdit_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            String newValue = this.changeFormat(accountlevelValue);
            dobj.setValue("accountlevel", (Object)newValue);
        } else if ("valuesourcetype".equals(propertyName)) {
            this.setValueSourceEnable((String)e.getChangeSet()[0].getNewValue(), rowIndex);
            if (pageCache.get(NEED_CLEAN_VALUE_SOURCE + rowIndex) == null) {
                this.getModel().setValue("valuesource", null, rowIndex);
                this.getModel().setValue("assistantvaluesource", null, rowIndex);
            } else {
                pageCache.remove(NEED_CLEAN_VALUE_SOURCE + rowIndex);
            }
        } else if ("assistantvaluesource".equals(propertyName) && e.getChangeSet()[0].getNewValue() != null) {
            if (!"2".equals(e.getChangeSet()[0].getDataEntity().getString("valuesourcetype"))) {
                pageCache.put(NEED_CLEAN_VALUE_SOURCE + rowIndex, "false");
            }
            this.getModel().setValue("valuesourcetype", (Object)"2", rowIndex);
        } else if ("org".equals(propertyName)) {
            this.getModel().setValue("createorg", e.getChangeSet()[0].getNewValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        LicenseCheckResult checkResult;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            String accountlevelValue = this.getModel().getValue("accountlevel").toString();
            String[] strs = accountlevelValue.split("-");
            int maxSize = strs.length;
            this.getModel().setValue("maxlevel", (Object)maxSize);
        } else if ((args.getSource() instanceof NewEntry || source instanceof DeleteEntry) && !(checkResult = AccountTableUtil.getHasLicense()).getHasLicense().booleanValue()) {
            args.setCancel(Boolean.TRUE.booleanValue());
            this.getView().showForm(FormShowParameter.fromJsonString((String)checkResult.getCancelFormShowParameter()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit valueSourceEdit = (BasedataEdit)this.getControl("valuesource");
        valueSourceEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParam.getListFilterParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            qFilters.add(new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel"}));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("comassistentry");
            HashSet valueSourceIdSet = new HashSet(8);
            entryEntity.forEach(row -> valueSourceIdSet.add(row.getString("valuesource_id")));
            if (CollectionUtils.isNotEmpty(valueSourceIdSet)) {
                qFilters.add(new QFilter("id", "not in", valueSourceIdSet));
            }
            listFilterParameter.getQFilters().addAll(qFilters);
        });
        BasedataEdit assistantValSourceEdit = (BasedataEdit)this.getControl("assistantvaluesource");
        assistantValSourceEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParam.getListFilterParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("comassistentry");
            HashSet assistantValSourceIdSet = new HashSet(8);
            entryEntity.forEach(row -> assistantValSourceIdSet.add(row.getLong("assistantvaluesource_id")));
            if (CollectionUtils.isNotEmpty(assistantValSourceIdSet)) {
                qFilters.add(new QFilter("id", "not in", assistantValSourceIdSet));
            }
            listFilterParameter.getQFilters().addAll(qFilters);
        });
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List orgIds = PermissionServiceHelper.getAllPermissionOrgs((Long)RequestContext.get().getCurrUserId(), (String)"fibd", (String)"bd_accounttable", (String)"47150e89000000ac");
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)orgIds));
            }
        });
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("comassistentry".equals(e.getEntryProp().getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.setValueSourceEnable("1", rowIndex);
            if (rowIndex == 0) {
                this.getModel().setValue("isbalance", (Object)Boolean.TRUE, rowIndex);
            }
        }
    }

    private Boolean isCorrectFormat(String str) {
        if (!this.isDigit(String.valueOf(str.charAt(str.length() - 1))).booleanValue()) {
            return false;
        }
        for (int i = 0; i < str.length(); i += 2) {
            if (this.isDigit(String.valueOf(str.charAt(i))).booleanValue()) continue;
            return false;
        }
        for (int j = 1; j < str.length() - 1; j += 2) {
            if ("-".equals(String.valueOf(str.charAt(j)))) continue;
            return false;
        }
        return true;
    }

    private String changeFormat(String str) {
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < str.length() - 1; ++i) {
            stb.append(str.charAt(i));
            stb.append('-');
        }
        stb.append(str.charAt(str.length() - 1));
        return stb.toString();
    }

    private Boolean isDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void setValueSourceEnable(String valueSourceType, int rowIndex) {
        if ("1".equals(valueSourceType)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"valuesource"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"assistantvaluesource"});
        } else if ("2".equals(valueSourceType)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"assistantvaluesource"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"valuesource"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"valuesource", "assistantvaluesource"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

