/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.formplugin.account.AccListDataProvider;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.ContextUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AccountTreeList
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(AccountTreeList.class);
    private boolean isClickSearch = false;
    protected static final String ISVERSION = "isversion";
    private static final String ACCOUNTTABLE_ID = "accounttable.id";
    private static final String ACCOUNTTABLE_NUMBER = "accounttable.number";
    private static final String USEORG_ID = "useorg.id";
    private static final String DEFORG = "deforg";
    private static final String PARENTID = "parent.id";
    private static final String CACHEKEY_ACCOUNTTABLEID = "accTableId";
    private static final String CACHEKEY_LASTORGID = "lastorgId";
    private static final String PC_FILTERVALUES = "filtercontainerap_cachedFilterValues";
    private int checkitementrySize = 0;
    private int currencyentrySize = 0;

    public void beforeClick(BeforeClickEvent e) {
        super.beforeClick(e);
        String accTableId = this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID);
        if (accTableId == null || this.parseAccountTableIdToLong(accTableId) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"AccountTreeList_11", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private static String getTableComboItemKey(long orgId) {
        return String.format("TableComboItem+%d", orgId);
    }

    private FilterContainerFilterValues getFilterValue() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        IPageCache pageCache = (IPageCache)filterContainer.getView().getService(IPageCache.class);
        String filterValueStr = pageCache.get(PC_FILTERVALUES);
        if (filterValueStr == null) {
            return null;
        }
        return FilterContainerFilterValues.deSerialize((String)filterValueStr);
    }

    private Long getCustomFilterId(String fieldName) {
        Long result = null;
        FilterContainerFilterValues filterValues = this.getFilterValue();
        if (filterValues == null) {
            return result;
        }
        FilterKeyValueCollections otherFilterValues = filterValues.getOtherFilterValues();
        if (otherFilterValues != null && otherFilterValues.getFilterKey().equalsIgnoreCase("customfilter")) {
            List filterValuesList = otherFilterValues.createFilterValuesList();
            for (Map map : filterValuesList) {
                List values;
                List name = (List)map.get("FieldName");
                if (!name.get(0).equals(fieldName) || (values = (List)map.get("Value")).isEmpty()) continue;
                String value = (String)values.get(0);
                if (StringUtils.isBlank((CharSequence)value)) {
                    return null;
                }
                result = Long.valueOf(value);
            }
        }
        return result;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues;
        List customfilterList;
        this.isClickSearch = true;
        Long customFilterOrgId = this.getCustomFilterId(USEORG_ID);
        Long customFilterTableId = this.getCustomFilterId(ACCOUNTTABLE_ID);
        ListShowParameter par = (ListShowParameter)this.getView().getFormShowParameter();
        if ("bd_accountversion".equals(par.getBillFormId())) {
            this.getPageCache().put("resetfilter", "1");
        }
        if ((customfilterList = (List)(filterValues = args.getSearchClickEvent().getFilterValues()).get("customfilter")) != null && !customfilterList.isEmpty()) {
            for (Map filed : customfilterList) {
                String customFilterTableIdStr;
                String filedName = ((List)filed.get("FieldName")).get(0).toString();
                if (!ACCOUNTTABLE_ID.equals(filedName)) continue;
                List fastlist = (List)filterValues.get("fastfilter");
                if (fastlist != null && !fastlist.isEmpty()) {
                    return;
                }
                if (((List)filed.get("Value")).isEmpty()) {
                    return;
                }
                IPageCache pageCache = this.getPageCache();
                if (customFilterOrgId == null) {
                    String deforg = this.getPageCache().get(DEFORG);
                    if (deforg == null) {
                        return;
                    }
                    customFilterOrgId = Long.valueOf(deforg);
                }
                String lastOrgId = pageCache.get(CACHEKEY_LASTORGID);
                String lastTableId = pageCache.get(CACHEKEY_ACCOUNTTABLEID);
                String curTable = customFilterTableIdStr = String.valueOf(customFilterTableId);
                if (lastOrgId != null && !lastOrgId.equals(String.valueOf(customFilterOrgId))) {
                    pageCache.put(CACHEKEY_LASTORGID, String.valueOf(customFilterOrgId));
                    List<ComboItem> comboItems = this.getAccountTableComboItems(customFilterOrgId);
                    if (comboItems.isEmpty()) {
                        return;
                    }
                    boolean isContainTable = false;
                    for (ComboItem comboItem : comboItems) {
                        String value = comboItem.getValue();
                        if (!value.equals(customFilterTableIdStr)) continue;
                        isContainTable = true;
                        break;
                    }
                    if (!isContainTable) {
                        List values = (List)filed.get("Value");
                        values.clear();
                        curTable = comboItems.get(0).getValue();
                        values.add(curTable);
                    }
                }
                pageCache.put(CACHEKEY_ACCOUNTTABLEID, curTable);
                if (null != lastTableId && lastTableId.equals(curTable)) continue;
                this.setTreeListFilter(curTable);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "accounttable.id": 
            case "accounttable.number": {
                Long customFilterOrgId = this.getCustomFilterId(USEORG_ID);
                List<ComboItem> tables = this.getAccountTableComboItems(customFilterOrgId == null ? Long.parseLong(String.valueOf(this.getContainer().get("useorg"))) : customFilterOrgId);
                ArrayList<Long> tableIds = new ArrayList<Long>(tables.size());
                for (ComboItem table : tables) {
                    tableIds.add(Long.valueOf(table.getValue()));
                }
                args.getQfilters().add(new QFilter("id", "in", tableIds));
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Long deforgId = 0L;
        Long customFilterOrgId = this.getCustomFilterId(USEORG_ID);
        List columnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        boolean hasOrgColumn = false;
        for (Object filterColumn : columnList) {
            if (!USEORG_ID.equals(filterColumn.getFieldName())) continue;
            hasOrgColumn = true;
        }
        if (!hasOrgColumn) {
            String deforg = this.getPageCache().get(DEFORG);
            if (deforg == null) {
                deforg = BDUtil.getDefaultUseOrg((List)BDUtil.getAllUseOrg((String)"bd_accountview"));
                if (deforg != null) {
                    this.getPageCache().put(DEFORG, deforg);
                    deforgId = Long.valueOf(deforg);
                }
            } else {
                deforgId = Long.valueOf(deforg);
            }
        }
        String defaultAccTableId = null;
        block9: for (FilterColumn filterColumn : columnList) {
            switch (filterColumn.getFieldName()) {
                case "accounttable.id": {
                    Object versiontable;
                    if (((ListShowParameter)this.getView().getFormShowParameter()).isLookUp() || this.isClickSearch) break;
                    Long selectedOrg = customFilterOrgId == null ? deforgId : customFilterOrgId;
                    Object versionorg = this.getView().getFormShowParameter().getCustomParam("versionlistorg");
                    if (versionorg != null) {
                        selectedOrg = Long.parseLong(String.valueOf(versionorg));
                        this.getPageCache().put("createOrg", String.valueOf(versionorg));
                    }
                    if ((versiontable = this.getView().getFormShowParameter().getCustomParam("versionlisttable")) != null) {
                        defaultAccTableId = String.valueOf(versiontable);
                    }
                    List<ComboItem> comboItems = this.getAccountTableComboItems(selectedOrg);
                    List accountTableIds = null;
                    ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
                    if (controlFilters != null) {
                        accountTableIds = controlFilters.getFilter(ACCOUNTTABLE_ID);
                    }
                    String accountTableId = "";
                    if (accountTableIds != null && !accountTableIds.isEmpty()) {
                        accountTableId = String.valueOf(accountTableIds.get(0));
                    }
                    if (comboItems.isEmpty()) continue block9;
                    CommonFilterColumn tableColumn = (CommonFilterColumn)filterColumn;
                    tableColumn.setComboItems(comboItems);
                    String v = comboItems.get(0).getValue();
                    if (v == null) continue block9;
                    if (defaultAccTableId == null) {
                        String finalAccountTableId = accountTableId;
                        long count = comboItems.stream().filter(comboItem -> comboItem.getValue().equals(finalAccountTableId)).count();
                        defaultAccTableId = count > 0L ? finalAccountTableId : v;
                    }
                    tableColumn.setDefaultValue(defaultAccTableId);
                    String lastTableid = this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID);
                    if (lastTableid != null) continue block9;
                    this.getPageCache().put(CACHEKEY_ACCOUNTTABLEID, defaultAccTableId);
                    this.getPageCache().put(CACHEKEY_LASTORGID, String.valueOf(selectedOrg));
                    FilterContainer fgv = (FilterContainer)this.getControl("filtercontainerap");
                    FilterKeyValueCollections fast = fgv.getCachedFilterValues().getFastFilterValues();
                    if (fast != null && (fast == null || !fast.getFilterValueCollection().isEmpty())) continue block9;
                    this.setTreeListFilter(defaultAccTableId);
                    break;
                }
                case "useorg.id": {
                    Optional<String> orgIdRes;
                    Object versionorg;
                    List defOrgIds = filterColumn.getDefaultValues();
                    if (!defOrgIds.isEmpty()) {
                        deforgId = Long.valueOf(String.valueOf(defOrgIds.get(0)));
                    }
                    if ((versionorg = this.getView().getFormShowParameter().getCustomParam("versionlistorg")) == null) {
                        versionorg = this.getView().getFormShowParameter().getCustomParam("imicdimension_bos_org");
                    }
                    if ((orgIdRes = this.getOrg()).isPresent()) {
                        versionorg = orgIdRes.get();
                    }
                    if (versionorg == null) break;
                    CommonFilterColumn orgColumn = (CommonFilterColumn)filterColumn;
                    orgColumn.setDefaultValue(String.valueOf(versionorg));
                    BDUtil.loadMissId((List)((CommonFilterColumn)filterColumn).getComboItems(), (String)String.valueOf(versionorg));
                    String customfilterSer = this.getPageCache().get("customfilter");
                    if (StringUtils.isEmpty((CharSequence)customfilterSer)) break;
                    List customfilters = (List)SerializationUtils.fromJsonString((String)customfilterSer, List.class);
                    block10: for (Map filter : customfilters) {
                        List nameFieds = (List)filter.get("FieldName");
                        if (nameFieds == null) continue;
                        for (Object name : nameFieds) {
                            if (!USEORG_ID.equals(String.valueOf(name))) continue;
                            filter.put("Value", filterColumn.getDefaultValues());
                            continue block10;
                        }
                    }
                    this.getPageCache().put("customfilter", SerializationUtils.toJsonString((Object)customfilters));
                }
            }
        }
        List fastFilterColumns = args.getFilterContainerInitEvent().getFastFilterColumns();
        Optional<FilterColumn> numberFastFilter = fastFilterColumns.stream().filter(x -> "number".equals(x.getFieldName())).findFirst();
        String numberFilterValues = this.getView().getFormShowParameter().getCustomParams().getOrDefault("versionlistfilters", "");
        if (numberFastFilter.isPresent() && StringUtils.isNotEmpty((CharSequence)numberFilterValues)) {
            numberFastFilter.get().setDefaultValues((Object[])numberFilterValues.split(","));
        }
    }

    private Optional<String> getOrg() {
        ControlFilter controlFilter;
        ControlFilters controlFilters = this.getControlFilters();
        if (Objects.nonNull(controlFilters) && Objects.nonNull(controlFilter = controlFilters.getCurrentControlFilter())) {
            String field = controlFilter.getFieldName();
            List values = controlFilter.getValue();
            if (field.equals(USEORG_ID) && !CollectionUtils.isEmpty((Collection)values)) {
                return Optional.of(values.get(0).toString());
            }
        }
        return Optional.empty();
    }

    private List<ComboItem> getAccountTableComboItems(long orgId) {
        IPageCache cache = this.getPageCache();
        String value = cache.get(AccountTreeList.getTableComboItemKey(orgId));
        ArrayList<ComboItem> coms = new ArrayList();
        if (value == null) {
            List orgIds = BDUtil.getAllSuperiorOrgIds((Object)orgId, (boolean)true);
            if (!orgIds.isEmpty()) {
                QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
                QFilter enableFilter = new QFilter("enable", "=", (Object)true);
                try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter[]{orgFilter, enableFilter}, null);){
                    while (tableSet.hasNext()) {
                        kd.bos.algo.Row row = tableSet.next();
                        ComboItem com = new ComboItem(new LocaleString(row.getString("name")), String.valueOf(row.getLong("id")));
                        coms.add(com);
                    }
                }
            }
            cache.put(AccountTreeList.getTableComboItemKey(orgId), SerializationUtils.serializeToBase64(coms));
        } else {
            coms = (List)SerializationUtils.deSerializeFromBase64((String)value);
        }
        return coms;
    }

    private void setTreeListFilter(String accTableId) {
        ListView listView = (ListView)this.getView();
        TreeListView treeListView = (TreeListView)listView.getTreeListView();
        TreeListModel listModel = (TreeListModel)treeListView.getTreeModel();
        QFilter filter = new QFilter("accounttableid", "=", (Object)this.parseAccountTableIdToLong(accTableId));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(filter);
        listModel.setTreeFilter(qFilters);
        treeListView.getTreeModel().setCurrentNodeId((Object)"8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        treeListView.refreshTreeView();
    }

    public void initialize() {
        super.initialize();
        ListShowParameter par = (ListShowParameter)this.getView().getFormShowParameter();
        if ("bd_accountversion".equals(par.getBillFormId())) {
            HashMap<String, Boolean> props = new HashMap<String, Boolean>(1);
            props.put("defaultcollapse", true);
            this.getView().updateControlMetadata("splitpanelap", props);
        }
    }

    public void initializeTree(EventObject e) {
        FilterContainer fgv;
        FilterKeyValueCollections fast;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String accountTableId = "";
        for (QFilter q : param.getListFilterParameter().getQFilters()) {
            if (!"accounttable".equals(q.getProperty()) && !ACCOUNTTABLE_ID.equals(q.getProperty()) && !"accounttable_id".equals(q.getProperty()) || !(q.getValue() instanceof Long)) continue;
            accountTableId = q.getValue() + "";
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)accountTableId) && ((fast = (fgv = (FilterContainer)this.getControl("filtercontainerap")).getCachedFilterValues().getFastFilterValues()) == null || fast != null && fast.getFilterValueCollection().isEmpty())) {
            TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
            List treeFilter = treeListModel.getTreeFilter();
            treeFilter.add(new QFilter("accounttableid", "=", (Object)this.parseAccountTableIdToLong(accountTableId)));
            treeListModel.setTreeFilter(treeFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter par = (ListShowParameter)this.getView().getFormShowParameter();
        if ("bd_accountversion".equals(par.getBillFormId())) {
            if (par.getCustomParam("versionlistfilters") != null && this.getPageCache().get("resetfilter") == null) {
                List qfs = e.getQFilters();
                String numStr = (String)par.getCustomParam("versionlistfilters");
                String[] pks = numStr.split(",");
                qfs.add(new QFilter("number", "in", (Object)pks));
                int removeIndex = -1;
                for (int i = 0; i < qfs.size(); ++i) {
                    if (!((QFilter)qfs.get(i)).getProperty().startsWith("inner join T_BD_Account_U")) continue;
                    removeIndex = i;
                    break;
                }
                if (removeIndex != -1) {
                    qfs.remove(removeIndex);
                    Object versionlistorg = par.getCustomParam("versionlistorg");
                    if (versionlistorg != null) {
                        QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)Long.parseLong(String.valueOf(versionlistorg)));
                        qfs.add(qids);
                    }
                }
            }
        } else {
            Object acctField = par.getCustomParam("acct_filter");
            if (acctField == null) {
                QFilter qdate = new QFilter("enddate", ">=", (Object)AccountVersionUtil.getEndDate());
                e.getQFilters().add(qdate);
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String accounttableId = this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID);
        if (accounttableId != null) {
            this.getTreeModel().getTreeFilter().add(new QFilter("accounttableid", "=", (Object)this.parseAccountTableIdToLong(this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID))));
        }
    }

    private Long parseAccountTableIdToLong(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return Long.valueOf(id);
        }
        return 0L;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"selfdom", "addassgrps"});
        this.addClickListeners(new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        super.beforeItemClick(evt);
        switch (key = evt.getItemKey()) {
            case "versioned": {
                String entity = ((AbstractListView)this.getView()).getEntityTypeId();
                List createOrgs = BaseDataServiceHelper.getBdCtrlOrgs((String)entity);
                long useOrgId = Long.parseLong(this.getPageCache().get("createOrg"));
                if (createOrgs.isEmpty()) break;
                if (this.getPageCache().get("createOrg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"AccountTreeList_14", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (createOrgs.contains(useOrgId) || createOrgs.size() <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u7684\u201c\u63a7\u5236\u89c4\u5219\u201d\u5904\u6dfb\u52a0\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AccountTreeList_10", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        switch (key) {
            case "versioned": {
                Map<String, Object> listFilterMap = this.getContainer();
                if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)Long.parseLong(String.valueOf(listFilterMap.get("useorg"))), (String)"10", (String)"fibd", (String)"bd_accountview", (String)"1==F6LDJNGM9") == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4f1a\u8ba1\u79d1\u76ee\u201d\u7684\u201c\u79d1\u76ee\u7248\u672c\u5316\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountTreeList_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccountTreeList_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u540c\u65f6\u5bf9\u591a\u4e2a\u79d1\u76ee\u7248\u672c\u5316\u3002", (String)"AccountTreeList_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.size() != 1) break;
                DynamicObject[] dyos = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                if (dyos.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"AccountTreeList_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseShowParameter par = new BaseShowParameter();
                par.setFormId("bd_accountview");
                par.setPkId(rows.getPrimaryKeyValues()[0]);
                par.setStatus(OperationStatus.EDIT);
                par.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                par.setCustomParam(ISVERSION, (Object)true);
                par.setCustomParam("isPersonalizeData", (Object)Boolean.TRUE);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ISVERSION);
                par.setCloseCallBack(callBack);
                this.getView().showForm((FormShowParameter)par);
                break;
            }
            case "versionlist": {
                Map<String, Object> listFilterMap = this.getContainer();
                if (PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)Long.parseLong(String.valueOf(listFilterMap.get("useorg"))), (String)"10", (String)"fibd", (String)"bd_accountview", (String)"1==F6LDJNGM9") == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4f1a\u8ba1\u79d1\u76ee\u201d\u7684\u201c\u79d1\u76ee\u7248\u672c\u5316\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountTreeList_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccountTreeList_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (rows.size() < 1) break;
                ListShowParameter par = new ListShowParameter();
                par.setBillFormId("bd_accountversion");
                par.setFormId("bos_templatetreelist");
                ArrayList<String> numbers = new ArrayList<String>();
                for (ListSelectedRow row : rows) {
                    numbers.add(row.getNumber());
                }
                String numStr = StringUtils.join((Object[])numbers.toArray(), (String)",");
                par.setCustomParam("versionlistorg", listFilterMap.get("useorg"));
                par.setCustomParam("versionlistfilters", (Object)numStr);
                par.setCustomParam("versionlisttable", listFilterMap.get(CACHEKEY_ACCOUNTTABLEID));
                par.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)par);
                break;
            }
            case "addassgrps": {
                listView = (IListView)this.getView();
                rows = listView.getSelectedRows();
                if (rows.isEmpty()) break;
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bd_addassgrps");
                formShowParameter.setCustomParam("ids", (Object)rows.getPrimaryKeyValues());
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "updateleafs": 
            case "v_clearcache": {
                String entity = ((AbstractListView)this.getView()).getEntityTypeId();
                entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
                long useorgId = Long.parseLong(this.getPageCache().get("createOrg"));
                BaseDataService baseDataService = new BaseDataService();
                baseDataService.clearBaseDataFilterCache(entity, Long.valueOf(useorgId));
                ArrayList<Long> orgIDList = new ArrayList<Long>(1);
                orgIDList.add(useorgId);
                BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIDList);
                this.reload();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58\u5b8c\u6210\u3002", (String)"AccountTreeList_13", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "cleancache1": {
                String lastTableId = this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID);
                String lockKey = "assignlock" + lastTableId;
                AppCache.get((String)"gl").remove(lockKey);
                AppCache.get((String)"gl").remove(lockKey + "msg");
                break;
            }
            case "cleancache2": {
                DLock.forceUnlock((String[])new String[]{"assignlock" + this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID)});
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        Object[] selectRows = evt.getListSelectedRowCollection().getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)selectRows);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent.id,accounttype,iscash,isbank,iscashequivalent", (QFilter[])new QFilter[]{filter});
        HashMap<String, String> acctMap = new HashMap<String, String>();
        for (DynamicObject account : accounts) {
            acctMap.put("accounttype", account.getString("accounttype"));
        }
        this.getPageCache().put("accountTypeMap", (String)acctMap.get("accounttype"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        ListShowParameter par = (ListShowParameter)this.getView().getFormShowParameter();
        Long orgId = this.getCustomFilterId(USEORG_ID) != null ? this.getCustomFilterId(USEORG_ID) : Long.parseLong(String.valueOf(this.getContainer().get("useorg")));
        Long accounttableId = Long.valueOf(this.getPageCache().get(CACHEKEY_ACCOUNTTABLEID));
        Object[] ids = selectedRows.getPrimaryKeyValues();
        switch (keyName) {
            case "new": {
                this.beforeNewValidate(args, selectedRows);
                break;
            }
            case "delete": {
                if (ids.length <= 0) break;
                String str = this.getPageCache().get("parentAcctsSet");
                Set acctSet = str == null ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)str, HashSet.class);
                QFilter filter = new QFilter("id", "in", (Object)ids);
                DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent.id", (QFilter[])new QFilter[]{filter});
                for (DynamicObject account : accounts) {
                    if (0L == account.getLong(PARENTID)) continue;
                    acctSet.add(account.getLong(PARENTID));
                }
                HashSet<Long> accountIds = new HashSet<Long>(ids.length);
                for (Object id : ids) {
                    accountIds.add(Long.parseLong(id.toString()));
                }
                AccountOperationLogUtil.initRawOperationLog((Long)orgId, (AccountOperationType)AccountOperationType.DELETE, (Long)accounttableId, accountIds);
                AccountOperationLogUtil.setOperationLog(operationLog -> operationLog.setOldAccounts(new ArrayList(accounts)));
                this.getPageCache().put("parentAcctsSet", SerializationUtils.toJsonString(acctSet));
                break;
            }
            case "versiondelete": {
                HashSet<Long> accountIds = new HashSet<Long>(ids.length);
                for (Object id : ids) {
                    accountIds.add(Long.parseLong(id.toString()));
                }
                AccountOperationLogUtil.initRawOperationLog((Long)orgId, (AccountOperationType)AccountOperationType.VERSION_DELETE, (Long)accounttableId, accountIds);
                operateInfo.setConfirmTypes(ConfirmTypes.Delete);
                operateInfo.getOption().setVariableValue("createOrg", String.valueOf(this.getContainer().get("useorg")));
                break;
            }
            case "disable_all": {
                operateInfo.getOption().setVariableValue("createOrg", String.valueOf(this.getContainer().get("useorg")));
                operateInfo.getOption().setVariableValue("useorg", String.valueOf(this.getContainer().get("useorg")));
                operateInfo.getOption().setVariableValue("accounttable", String.valueOf(this.getContainer().get(CACHEKEY_ACCOUNTTABLEID)));
                break;
            }
            case "enable_all": {
                operateInfo.getOption().setVariableValue("createOrg", String.valueOf(this.getContainer().get("useorg")));
                operateInfo.getOption().setVariableValue("useorg", String.valueOf(this.getContainer().get("useorg")));
                operateInfo.getOption().setVariableValue("accounttable", String.valueOf(this.getContainer().get(CACHEKEY_ACCOUNTTABLEID)));
                break;
            }
            case "refresh": {
                if (!"bd_accountversion".equals(par.getBillFormId())) break;
                break;
            }
            case "updatevoucher": {
                operateInfo.getOption().setVariableValue("useorg", String.valueOf(this.getContainer().get("useorg")));
                operateInfo.getOption().setVariableValue("accounttable", String.valueOf(this.getContainer().get(CACHEKEY_ACCOUNTTABLEID)));
                break;
            }
        }
    }

    private void beforeNewValidate(BeforeDoOperationEventArgs args, ListSelectedRowCollection selectedRows) {
        IPageCache pageCache;
        String accFilter;
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        if (treeview != null) {
            List accTypeId = treeview.getTreeState().getSelectedNodes();
            treeview.getModel();
            if (!accTypeId.isEmpty()) {
                Map accTypeMap = (Map)accTypeId.get(0);
                if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(accTypeMap.get("id"))) {
                    Object isParent = accTypeMap.get("isParent");
                    if (isParent != null && ((Boolean)isParent).booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountTreeList_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                        args.setCancel(Boolean.TRUE.booleanValue());
                    }
                } else if (selectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u7c7b\u578b\u3002", (String)"AccountTreeList_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
            }
        }
        if ((accFilter = (pageCache = (IPageCache)this.getView().getService(IPageCache.class)).get(CACHEKEY_ACCOUNTTABLEID)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"AccountTreeList_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("delete".equals(key)) {
            DynamicObject[] parentAccts;
            AccountOperationLogUtil.updateFailedEntry((OperationResult)afterDoOperationEventArgs.getOperationResult());
            AccountOperationLogUtil.persistLog();
            String str = this.getPageCache().get("parentAcctsSet");
            Set acctSet = (Set)SerializationUtils.fromJsonString((String)str, HashSet.class);
            QFilter parentIdf = new QFilter("parent", "in", (Object)acctSet);
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent.id", (QFilter[])new QFilter[]{parentIdf});
            for (DynamicObject acct : accounts) {
                acctSet.remove(acct.getLong(PARENTID));
            }
            List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("id", "in", (Object)acctSet).toArray(), (String)"id", (int)-1);
            for (DynamicObject pacct : parentAccts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"isleaf,level,orgcontrollevel,createorg,accounttable,number", (QFilter[])new QFilter("id", "in", (Object)ids).toArray())) {
                pacct.set("isleaf", (Object)Boolean.TRUE);
                pacct.set("orgcontrollevel", (Object)pacct.getString("level"));
            }
            SaveServiceHelper.save((DynamicObject[])parentAccts);
            if (parentAccts.length > 0) {
                DynamicObject[] childParentAccts;
                HashSet<String> pNumbers = new HashSet<String>(10);
                Long createorgid = parentAccts[0].getLong("createorg_id");
                Long accountTableId = parentAccts[0].getLong("accounttable_id");
                List allChildrenOrgIds = BDUtil.getAllSubordinateOrgs((Object)createorgid, (boolean)false);
                for (DynamicObject parentAcct : parentAccts) {
                    pNumbers.add(parentAcct.getString("number"));
                }
                HashSet childParentAcctIds = new HashSet(10);
                BatchProcessUtil.batchProcess((Collection)allChildrenOrgIds, orgIds -> {
                    List childParentAcctIdLists = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("createorg_id", "in", orgIds), new QFilter("accounttable_id", "=", (Object)accountTableId), new QFilter("number", "in", (Object)pNumbers)}, null, (int)-1);
                    childParentAcctIds.addAll(childParentAcctIdLists);
                    return null;
                });
                DynamicObjectCollection childParentAccounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent.id", (QFilter[])new QFilter[]{new QFilter("parent", "in", childParentAcctIds)});
                for (DynamicObject acct : childParentAccounts) {
                    childParentAcctIds.remove(acct.getLong(PARENTID));
                }
                for (DynamicObject pacct : childParentAccts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"isleaf,level,orgcontrollevel", (QFilter[])new QFilter("id", "in", childParentAcctIds).toArray())) {
                    pacct.set("isleaf", (Object)Boolean.TRUE);
                    pacct.set("orgcontrollevel", (Object)pacct.getString("level"));
                }
                SaveServiceHelper.save((DynamicObject[])childParentAccts);
            }
            this.getPageCache().remove("parentAcctsSet");
        } else if ("versiondelete".equals(key)) {
            AccountOperationLogUtil.updateFailedEntry((OperationResult)afterDoOperationEventArgs.getOperationResult());
            AccountOperationLogUtil.persistLog();
            this.getView().invokeOperation("refresh");
        }
        if ("new".equals(key) || "modify".equals(key)) {
            IListView view = (IListView)this.getView();
            view.clearSelection();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String callBackId;
        super.closedCallBack(closedCallBackEvent);
        switch (callBackId = closedCallBackEvent.getActionId()) {
            case "isversion": {
                ((IListView)this.getView()).refresh();
                BillList billList = (BillList)this.getControl("billlistap");
                billList.clearSelection();
                billList.refresh();
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AccListDataProvider(this.getView()));
        super.beforeCreateListDataProvider(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        if (controlFilters != null) {
            List accountTableIds = controlFilters.getFilter(ACCOUNTTABLE_ID);
            List accountTableNumbers = controlFilters.getFilter(ACCOUNTTABLE_NUMBER);
            if (CollectionUtils.isEmpty((Collection)accountTableIds) && !CollectionUtils.isEmpty((Collection)accountTableNumbers)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u754c\u9762\u4e0d\u5141\u8bb8\u65b0\u589e\u79d1\u76ee\uff0c\u8bf7\u4f7f\u7528\u5e38\u7528\u6761\u4ef6\u67e5\u8be2\u540e\u65b0\u589e\u3002", (String)"AccountTreeList_15", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        Object iscopy = e.getParameter().getCustomParams().get("iscopy");
        BillShowParameter parameter = e.getParameter();
        Map map = parameter.getCustomParams();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Map<String, Object> container = this.getContainer();
        if (!selectedRows.isEmpty()) {
            map.put("parent", selectedRows.getPrimaryKeyValues()[0]);
            Object useorgId = container.get("useorg");
            map.put("org", useorgId);
        }
        if (!"true".equals(String.valueOf(iscopy))) {
            map.putAll(container);
            TreeView tree = (TreeView)this.getControl("treeview");
            List accTypeId = tree.getTreeState().getSelectedNodes();
            if (accTypeId == null || accTypeId.isEmpty() || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(((Map)accTypeId.get(0)).get("id"))) {
                map.put("accounttype", this.getPageCache().get("accountTypeMap"));
            } else {
                map.put("accounttype", ((Map)accTypeId.get(0)).get("id"));
            }
        } else {
            map.put(CACHEKEY_ACCOUNTTABLEID, container.get(CACHEKEY_ACCOUNTTABLEID));
        }
        ListShowParameter listpar = (ListShowParameter)this.getView().getFormShowParameter();
        if ("bd_accountversion".equals(listpar.getBillFormId())) {
            parameter.setCustomParam("versionlist", (Object)"1");
        }
        parameter.setCustomParams(map);
    }

    private Map<String, Object> getContainer() {
        List fs;
        String deforg;
        HashMap<String, Object> map = new HashMap<String, Object>();
        FilterContainer fgv = (FilterContainer)this.getControl("filtercontainerap");
        Map selectedValues = fgv.getSelectedValues();
        Object useorgId = selectedValues.get(USEORG_ID);
        if (useorgId == null && (useorgId = this.getPageCache().get("createOrg")) == null && (deforg = this.getPageCache().get(DEFORG)) != null) {
            useorgId = Long.valueOf(deforg);
        }
        map.put("useorg", useorgId);
        Object tableId = selectedValues.get(ACCOUNTTABLE_ID);
        if (tableId == null && (fs = ((IListView)this.getView()).getControlFilters().getFilter(ACCOUNTTABLE_ID)) != null && !fs.isEmpty()) {
            tableId = fs.get(0);
        }
        map.put(CACHEKEY_ACCOUNTTABLEID, tableId);
        return map;
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        DynamicObject[] accounts;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        Collections.addAll(qFilters, e.getFilters());
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            if (primaryKeyValues.length == 1) {
                qFilters.add(new QFilter("id", "=", primaryKeyValues[0]));
            } else {
                qFilters.add(new QFilter("id", "in", (Object)primaryKeyValues));
            }
        }
        for (DynamicObject account : accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"fid,checkitementry,checkitementry.fasstactitemid,currencyentry,currencyentry.fcurrencyid", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
            DynamicObjectCollection checkitementry = account.getDynamicObjectCollection("checkitementry");
            DynamicObjectCollection currencyentry = account.getDynamicObjectCollection("currencyentry");
            if (checkitementry.size() > this.checkitementrySize) {
                this.checkitementrySize = checkitementry.size();
            }
            if (currencyentry.size() <= this.currencyentrySize) continue;
            this.currencyentrySize = currencyentry.size();
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        Cell rowCell;
        Cell oldcell;
        Iterator cellIteratorSecond;
        Row rowSecond;
        Sheet sheet;
        Throwable throwable;
        FileInputStream in;
        File file = e.getFile();
        if (file == null) {
            return;
        }
        String fileName = e.getFileName();
        String fileNamel = ResManager.loadKDString((String)"\u6309\u5217\u5bfc\u5165", (String)"AccountBatchImportPlugin_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        String fileNameOld = ResManager.loadKDString((String)"\u6309\u5217\u5f15\u5165", (String)"AccountBatchImportPlugin_5", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        if (!fileName.contains(fileNamel) && !fileName.contains(fileNameOld)) {
            super.afterExportFile(e);
            return;
        }
        HashSet<Integer> asstactitemColsIndexSet = new HashSet<Integer>(10);
        HashSet<Integer> currencyColsIndexSet = new HashSet<Integer>(10);
        HashMap<Integer, Object> asstactitemColsMap = new HashMap<Integer, Object>(16);
        HashMap<Integer, Object> currencyColsMap = new HashMap<Integer, Object>(16);
        HashMap<Integer, Comment> currencyCommentColsMap = new HashMap<Integer, Comment>(16);
        HashMap<Integer, CellStyle> currencyCellStyleColsMap = new HashMap<Integer, CellStyle>(16);
        int itemcolsMix = 0;
        int itemcolsMax = 0;
        int currencycolsMix = 0;
        int currencycolsMax = 0;
        try {
            in = new FileInputStream(file);
            throwable = null;
            try {
                XSSFWorkbook wb2 = new XSSFWorkbook((InputStream)in);
                sheet = wb2.getSheetAt(0);
                rowSecond = sheet.getRow(2);
                cellIteratorSecond = rowSecond.cellIterator();
                while (cellIteratorSecond.hasNext()) {
                    Cell cell = (Cell)cellIteratorSecond.next();
                    String string = cell.getStringCellValue();
                    int colIndex = cell.getColumnIndex();
                    if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
                    if ("checkitementry_id".equals(string) || "asstactitem.number".equals(string) || "asstactitem.name".equals(string) || "isrequire".equals(string) || "isdetail".equals(string) || "enaccheck".equals(string)) {
                        asstactitemColsIndexSet.add(colIndex);
                        asstactitemColsMap.put(colIndex, cell);
                        continue;
                    }
                    if (!"currency.number".equals(string) && !"currency.name".equals(string)) continue;
                    currencyColsIndexSet.add(colIndex);
                    currencyColsMap.put(colIndex, cell);
                }
                for (Integer n : asstactitemColsIndexSet) {
                    if (itemcolsMix == 0 || itemcolsMix > n) {
                        itemcolsMix = n;
                    }
                    if (itemcolsMax >= n) continue;
                    itemcolsMax = n;
                }
                for (Integer n : currencyColsIndexSet) {
                    if (currencycolsMix == 0 || currencycolsMix > n) {
                        currencycolsMix = n;
                    }
                    if (currencycolsMax >= n) continue;
                    currencycolsMax = n;
                }
                Row rowThird = sheet.getRow(3);
                for (Integer index : currencyColsIndexSet) {
                    Cell cell = rowThird.getCell(index.intValue());
                    currencyCommentColsMap.put(index, cell.getCellComment());
                    currencyCellStyleColsMap.put(index, cell.getCellStyle());
                }
                wb2.close();
            }
            catch (Throwable wb2) {
                throwable = wb2;
                throw wb2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable wb2) {
                            throwable.addSuppressed(wb2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Throwable ex) {
            LOGGER.error(ex);
            throw new KDBizException(ex.getMessage());
        }
        if (this.checkitementrySize > 1) {
            try {
                in = new FileInputStream(file);
                throwable = null;
                try {
                    XSSFWorkbook wb3 = new XSSFWorkbook((InputStream)in);
                    sheet = wb3.getSheetAt(0);
                    rowSecond = sheet.getRow(2);
                    int size = asstactitemColsIndexSet.size();
                    short lastCellNum = rowSecond.getLastCellNum();
                    int n = size * (this.checkitementrySize - 1);
                    for (int i = itemcolsMax + 1; i < lastCellNum; ++i) {
                        for (Object row : sheet) {
                            Cell oldcell2 = row.getCell(i);
                            if (oldcell2 == null) continue;
                            Cell rowCell2 = row.createCell(i + n);
                            rowCell2.setCellValue(oldcell2.getStringCellValue());
                            rowCell2.getCellStyle().cloneStyleFrom(oldcell2.getCellStyle());
                            row.removeCell(oldcell2);
                        }
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    for (int i = 1; i < this.checkitementrySize; ++i) {
                        for (Integer index : asstactitemColsIndexSet) {
                            oldcell = (Cell)asstactitemColsMap.get(index);
                            if (oldcell == null) continue;
                            rowCell = rowSecond.createCell(index + size * i);
                            rowCell.setCellValue(oldcell.getStringCellValue());
                            rowCell.getCellStyle().cloneStyleFrom(oldcell.getCellStyle());
                        }
                    }
                    wb3.write((OutputStream)out);
                    wb3.close();
                    out.close();
                }
                catch (Throwable wb3) {
                    throwable = wb3;
                    throw wb3;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable wb3) {
                                throwable.addSuppressed(wb3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                LOGGER.error(ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (this.currencyentrySize > 1) {
            currencyColsIndexSet.clear();
            currencyColsMap.clear();
            try {
                in = new FileInputStream(file);
                throwable = null;
                try {
                    XSSFWorkbook wb4 = new XSSFWorkbook((InputStream)in);
                    sheet = wb4.getSheetAt(0);
                    rowSecond = sheet.getRow(2);
                    cellIteratorSecond = rowSecond.cellIterator();
                    while (cellIteratorSecond.hasNext()) {
                        Cell cell = (Cell)cellIteratorSecond.next();
                        String string = cell.getStringCellValue();
                        int colIndex = cell.getColumnIndex();
                        if (!StringUtils.isNotEmpty((CharSequence)string) || !"currency.number".equals(string) && !"currency.name".equals(string)) continue;
                        currencyColsIndexSet.add(colIndex);
                        currencyColsMap.put(colIndex, cell);
                    }
                    for (Integer n : currencyColsIndexSet) {
                        if (currencycolsMix == 0 || currencycolsMix > n) {
                            currencycolsMix = n;
                        }
                        if (currencycolsMax >= n) continue;
                        currencycolsMax = n;
                    }
                    int size = currencyColsIndexSet.size();
                    short s = rowSecond.getLastCellNum();
                    int columnsSize = size * (this.currencyentrySize - 1);
                    for (int i = currencycolsMax + 1; i < s; ++i) {
                        for (Object row : sheet) {
                            oldcell = row.getCell(i);
                            if (oldcell == null) continue;
                            rowCell = row.createCell(i + columnsSize);
                            rowCell.setCellValue(oldcell.getStringCellValue());
                            rowCell.getCellStyle().cloneStyleFrom(oldcell.getCellStyle());
                            row.removeCell(oldcell);
                        }
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    for (int i = 1; i < this.currencyentrySize; ++i) {
                        for (Integer index : currencyColsIndexSet) {
                            Cell oldcell3 = (Cell)currencyColsMap.get(index);
                            if (oldcell3 == null) continue;
                            Cell rowCell3 = rowSecond.createCell(index + size * i);
                            rowCell3.setCellValue(oldcell3.getStringCellValue());
                            rowCell3.getCellStyle().cloneStyleFrom(oldcell3.getCellStyle());
                        }
                    }
                    wb4.write((OutputStream)out);
                    wb4.close();
                    out.close();
                }
                catch (Throwable wb4) {
                    throwable = wb4;
                    throw wb4;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable wb4) {
                                throwable.addSuppressed(wb4);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                LOGGER.error(ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (this.checkitementrySize > 1 || this.currencyentrySize > 1) {
            try {
                in = new FileInputStream(file);
                throwable = null;
                try {
                    XSSFWorkbook wb = new XSSFWorkbook((InputStream)in);
                    sheet = wb.getSheetAt(0);
                    asstactitemColsMap = new HashMap(16);
                    currencyColsMap = new HashMap(16);
                    int asstitemRow = 0;
                    int currRowNum = 0;
                    int itemOrCurrencyColsMix = itemcolsMix;
                    if (itemOrCurrencyColsMix == 0) {
                        itemOrCurrencyColsMix = currencycolsMix;
                    }
                    while (currRowNum <= sheet.getLastRowNum()) {
                        Cell rowCell2;
                        Row row = sheet.getRow(currRowNum);
                        if (row == null) {
                            ++currRowNum;
                            continue;
                        }
                        if (currRowNum < 3) {
                            ++currRowNum;
                            continue;
                        }
                        if (currRowNum == 3) {
                            Comment comment;
                            ClientAnchor oldAnchor;
                            Comment oldcellComment;
                            Iterator cellIterator = row.cellIterator();
                            while (cellIterator.hasNext()) {
                                Cell cell = (Cell)cellIterator.next();
                                int colIndex = cell.getColumnIndex();
                                if (asstactitemColsIndexSet.contains(colIndex)) {
                                    asstactitemColsMap.put(colIndex, cell);
                                }
                                if (!currencyColsIndexSet.contains(colIndex)) continue;
                                currencyColsMap.put(colIndex, cell);
                            }
                            int size = asstactitemColsIndexSet.size();
                            for (int i = 1; i < this.checkitementrySize; ++i) {
                                for (Integer index : asstactitemColsIndexSet) {
                                    Cell oldcell4 = (Cell)asstactitemColsMap.get(index);
                                    if (oldcell4 == null) continue;
                                    Cell rowCell5 = row.createCell(index + size * i);
                                    rowCell5.setCellValue(oldcell4.getStringCellValue());
                                    CellStyle cs = wb.createCellStyle();
                                    cs.cloneStyleFrom(oldcell4.getCellStyle());
                                    rowCell5.setCellStyle(cs);
                                    if (oldcell4.getCellComment() == null) continue;
                                    rowCell5.removeCellComment();
                                    ClientAnchor oldAnchor2 = oldcell4.getCellComment().getClientAnchor();
                                    oldAnchor2.setCol1(index + size * i);
                                    oldAnchor2.setCol2(index + size * i + 2);
                                    Comment comment2 = sheet.createDrawingPatriarch().createCellComment(oldAnchor2);
                                    comment2.setString(oldcell4.getCellComment().getString());
                                    rowCell5.setCellComment(comment2);
                                }
                            }
                            int currencyColsSize = currencyColsIndexSet.size();
                            if (this.currencyentrySize > 0) {
                                for (Map.Entry oldCellStyleEntry : currencyCellStyleColsMap.entrySet()) {
                                    int oldIndex;
                                    int index = oldIndex = ((Integer)oldCellStyleEntry.getKey()).intValue();
                                    if (this.checkitementrySize > 1) {
                                        index = oldIndex + asstactitemColsIndexSet.size() * (this.checkitementrySize - 1);
                                    }
                                    Cell rowCell6 = row.getCell(index);
                                    CellStyle oldCellStyle = (CellStyle)oldCellStyleEntry.getValue();
                                    CellStyle cs = wb.createCellStyle();
                                    cs.cloneStyleFrom(oldCellStyle);
                                    rowCell6.setCellStyle(cs);
                                    oldcellComment = (Comment)currencyCommentColsMap.get(oldIndex);
                                    if (oldcellComment == null) continue;
                                    rowCell6.removeCellComment();
                                    oldAnchor = oldcellComment.getClientAnchor();
                                    oldAnchor.setCol1(index);
                                    oldAnchor.setCol2(index + 2);
                                    comment = sheet.createDrawingPatriarch().createCellComment(oldAnchor);
                                    comment.setString(oldcellComment.getString());
                                    rowCell6.setCellComment(comment);
                                }
                            }
                            for (int i = 1; i < this.currencyentrySize; ++i) {
                                for (Integer index : currencyColsIndexSet) {
                                    Cell oldcell5 = (Cell)currencyColsMap.get(index);
                                    if (oldcell5 == null) continue;
                                    int oldIndex = index;
                                    if (this.checkitementrySize > 1) {
                                        oldIndex = index - asstactitemColsIndexSet.size() * (this.checkitementrySize - 1);
                                    }
                                    Cell rowCell4 = row.createCell(index + currencyColsSize * i);
                                    rowCell4.setCellValue(oldcell5.getStringCellValue());
                                    CellStyle olcCellStyle = (CellStyle)currencyCellStyleColsMap.get(oldIndex);
                                    if (olcCellStyle != null) {
                                        CellStyle cs = wb.createCellStyle();
                                        cs.cloneStyleFrom(olcCellStyle);
                                        rowCell4.setCellStyle(cs);
                                    }
                                    if ((oldcellComment = (Comment)currencyCommentColsMap.get(oldIndex)) == null) continue;
                                    rowCell4.removeCellComment();
                                    oldAnchor = oldcellComment.getClientAnchor();
                                    oldAnchor.setCol1(index + currencyColsSize * i);
                                    oldAnchor.setCol2(index + currencyColsSize * i + 2);
                                    comment = sheet.createDrawingPatriarch().createCellComment(oldAnchor);
                                    comment.setString(oldcellComment.getString());
                                    rowCell4.setCellComment(comment);
                                }
                            }
                            ++currRowNum;
                            continue;
                        }
                        if (currRowNum <= 3) continue;
                        boolean isSameOne = true;
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            String cellValue;
                            Cell cell = (Cell)cellIterator.next();
                            int colIndex = cell.getColumnIndex();
                            if (colIndex >= itemOrCurrencyColsMix || (cellValue = cell.getStringCellValue()).isEmpty()) continue;
                            isSameOne = false;
                        }
                        if (!isSameOne) {
                            asstitemRow = 0;
                            ++currRowNum;
                            continue;
                        }
                        asstactitemColsMap = new HashMap(16);
                        currencyColsMap = new HashMap(16);
                        cellIterator = row.cellIterator();
                        ++asstitemRow;
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            int colIndex = cell.getColumnIndex();
                            if (asstactitemColsIndexSet.contains(colIndex)) {
                                asstactitemColsMap.put(colIndex, cell);
                            }
                            if (!currencyColsIndexSet.contains(colIndex)) continue;
                            currencyColsMap.put(colIndex, cell);
                        }
                        int rowNum = row.getRowNum();
                        Row rowCurrent = sheet.getRow(rowNum - 1);
                        if (asstactitemColsMap.size() > 0) {
                            int size = asstactitemColsIndexSet.size();
                            for (Integer index : asstactitemColsIndexSet) {
                                Cell oldcell6 = (Cell)asstactitemColsMap.get(index);
                                if (oldcell6 == null) continue;
                                rowCell2 = rowCurrent.createCell(index + size * asstitemRow);
                                rowCell2.setCellValue(oldcell6.getStringCellValue());
                                rowCell2.getCellStyle().cloneStyleFrom(oldcell6.getCellStyle());
                            }
                        }
                        if (currencyColsMap.size() > 0) {
                            int currencyColsSize = currencyColsIndexSet.size();
                            for (Integer index : currencyColsIndexSet) {
                                Cell oldcell7 = (Cell)currencyColsMap.get(index);
                                if (oldcell7 == null) continue;
                                rowCell2 = rowCurrent.createCell(index + currencyColsSize * asstitemRow);
                                rowCell2.setCellValue(oldcell7.getStringCellValue());
                                rowCell2.getCellStyle().cloneStyleFrom(oldcell7.getCellStyle());
                            }
                        }
                        if (rowNum < sheet.getLastRowNum()) {
                            sheet.shiftRows(rowNum + 1, sheet.getLastRowNum(), -1);
                            continue;
                        }
                        sheet.removeRow(row);
                        ++currRowNum;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    wb.write((OutputStream)fileOutputStream);
                    wb.close();
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                LOGGER.error(ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }
}

