/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.ContextUtil;

public class AccounttableList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter customerFilter = this.setCustomerFilter();
        if (null != customerFilter) {
            e.getQFilters().add(customerFilter);
        }
    }

    private QFilter setCustomerFilter() {
        List orgIds;
        HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fibd", (String)"bd_accounttable", (String)"47150e89000000ac");
        if (!permOrgResult.hasAllOrgPerm() && !(orgIds = permOrgResult.getHasPermOrgs()).isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>();
            Set<Long> allParentOrgIds = this.getAllParentOrgs(orgIds, true);
            try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id", (QFilter[])new QFilter("org", "in", allParentOrgIds).toArray(), null);){
                while (tableSet.hasNext()) {
                    Row row = tableSet.next();
                    ids.add(row.getLong("id"));
                }
            }
            return new QFilter("id", "in", ids);
        }
        return null;
    }

    private Set<Long> getDirectOrgIds(Collection<Long> orgIds) {
        HashSet<Long> result = new HashSet<Long>();
        if (orgIds.isEmpty()) {
            return result;
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        QFilter f3 = new QFilter("org", "in", orgIds);
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                long parentId = row.getLong("parent");
                if (parentId == 0L) continue;
                result.add(parentId);
            }
        }
        return result;
    }

    private Set<Long> getAllParentOrgs(Collection<Long> orgIds, boolean containSelf) {
        HashSet<Object> allParentOrgs = containSelf ? new HashSet<Long>(orgIds) : new HashSet();
        Set<Long> directOrg = this.getDirectOrgIds(orgIds);
        allParentOrgs.addAll(directOrg);
        while (!directOrg.isEmpty()) {
            directOrg = this.getDirectOrgIds(directOrg);
            allParentOrgs.addAll(directOrg);
        }
        return allParentOrgs;
    }
}

