/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.consts.MappingTypeEnum;
import kd.fi.bd.formplugin.info.AssgrepCompareInfo;

public class AssgrepCompareFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AssgrepCompareFormPlugin.class);
    private static final String FIELD_SRC_ACCOUNT = "srcaccount";
    private static final String FIELD_SRC_ACCOUNT_TABLE = "srcaccounttable";
    private static final String FIELD_ACT = "actfield";
    private static final String FIELD_ASSGREP = "assgrepfield";
    private static final String FIELD_GROUP = "fieldgroup";
    private static final String ENTRY_COMPARE = "compareentry";
    private static final int MAX_INDEX = 9;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit srcAccount = (MulBasedataEdit)this.getView().getControl(FIELD_SRC_ACCOUNT);
        srcAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Long srcActTableId = (Long)param.getCustomParam("srcActTableId");
        this.getModel().setValue(FIELD_SRC_ACCOUNT_TABLE, (Object)srcActTableId);
        String mappingType = (String)param.getCustomParam("mappingType");
        if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            MulBasedataEdit srcAccount = (MulBasedataEdit)this.getControl(FIELD_SRC_ACCOUNT);
            srcAccount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee", (String)"AccountMappingEditPlugin_21", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_COMPARE);
            entry.setColumnProperty("fieldgroup0", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee", (String)"AccountMappingEditPlugin_21", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        }
        this.showFieldGroup(mappingType);
        this.loadData(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (key == null) {
            return;
        }
        if (FIELD_SRC_ACCOUNT.equals(key)) {
            FormShowParameter param = this.getView().getFormShowParameter();
            Long srcAccountTableId = (Long)param.getCustomParam("srcActTableId");
            if (srcAccountTableId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u4ece\u9875\u9762\u53c2\u6570\u4e2d\u53d6\u5230\u6e90\u79d1\u76ee\u8868id\u3002", (String)"AssgrepCompareFormPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String orgIdStr = (String)param.getCustomParam("orgId");
            if (orgIdStr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u4ece\u9875\u9762\u53c2\u6570\u4e2d\u53d6\u5230\u7ec4\u7ec7id\u3002", (String)"AssgrepCompareFormPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgId = Long.valueOf(orgIdStr);
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            List qFilters = filterParam.getQFilters();
            qFilters.add(new QFilter("accounttable", "=", (Object)srcAccountTableId));
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
            qFilters.add(new QFilter("id", "in", this.getAccountIdList()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (FIELD_SRC_ACCOUNT.equals(propName)) {
            this.loadData(true);
        }
    }

    private void showFieldGroup(String mappingType) {
        FormShowParameter param = this.getView().getFormShowParameter();
        List goalActTableIdList = (List)param.getCustomParam("goalActTableId");
        Map<Long, Integer> fieldIndexMap = this.getActTableFieldIndexMap();
        HashMap<Long, String> actTableNameMap = new HashMap(8);
        if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            actTableNameMap = this.getActTableNameMap();
        }
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_COMPARE);
        for (int i = 1; i <= 9; ++i) {
            entry.setColumnProperty(FIELD_GROUP + i, "vi", (Object)false);
        }
        for (Long id : goalActTableIdList) {
            int index = fieldIndexMap.get(id);
            entry.setColumnProperty(FIELD_GROUP + index, "vi", (Object)true);
            entry.setColumnProperty(FIELD_GROUP + index, "header", (Object)this.setGoalActHeaderName(actTableNameMap, id, mappingType));
        }
    }

    private void loadData(boolean isPropChanged) {
        this.getModel().deleteEntryData(ENTRY_COMPARE);
        List<AssgrepCompareInfo> compareInfoList = this.getCompareInfoList();
        if (compareInfoList.isEmpty()) {
            return;
        }
        HashSet<Integer> rowIndexSet = new HashSet<Integer>(compareInfoList.size());
        for (AssgrepCompareInfo compareInfo : compareInfoList) {
            int rowIndex = compareInfo.getRowIndex();
            rowIndexSet.add(rowIndex);
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_COMPARE, rowIndexSet.size());
        int rowIndex = -1;
        int compareInfoRowIndex = -1;
        for (AssgrepCompareInfo compareInfo : compareInfoList) {
            if (compareInfoRowIndex == -1 || compareInfoRowIndex != compareInfo.getRowIndex()) {
                compareInfoRowIndex = compareInfo.getRowIndex();
                ++rowIndex;
            }
            Long srcAccountId = compareInfo.getSrcAccountId();
            List<Long> srcAssgrepIdList = compareInfo.getSrcAssgrepIdList();
            this.getModel().setValue("actfield0", (Object)srcAccountId, rowIndex);
            this.getModel().setValue("assgrepfield0", (Object)srcAssgrepIdList.toArray(), rowIndex);
            Long goalActTableId = compareInfo.getGoalActTableId();
            if (goalActTableId == null) continue;
            Long goalAccountId = compareInfo.getGoalAccountId();
            List<Long> goalAssgrepIdList = compareInfo.getGoalAssgrepIdList();
            this.getModel().setValue(this.getGoalActFieldKey(goalActTableId), (Object)goalAccountId, rowIndex);
            this.getModel().setValue(this.getGoalAssrepFieldKey(goalActTableId), (Object)goalAssgrepIdList.toArray(), rowIndex);
        }
    }

    private Map<Long, String> getActTableNameMap() {
        FormShowParameter param = this.getView().getFormShowParameter();
        List goalActTableIdList = (List)param.getCustomParam("goalActTableId");
        QFilter idFilter = new QFilter("id", "in", (Object)goalActTableIdList);
        DynamicObjectCollection actTables = QueryServiceHelper.query((String)"bd_accounttable", (String)"id, name", (QFilter[])new QFilter[]{idFilter});
        HashMap<Long, String> actTableNameMap = new HashMap<Long, String>(8);
        for (DynamicObject actTable : actTables) {
            long id = actTable.getLong("id");
            String name = actTable.getString("name");
            actTableNameMap.put(id, name);
        }
        return actTableNameMap;
    }

    private List<AssgrepCompareInfo> getCompareInfoList() {
        DynamicObjectCollection srcAccountList = (DynamicObjectCollection)this.getModel().getValue(FIELD_SRC_ACCOUNT);
        ArrayList<Long> srcActIdList = new ArrayList<Long>();
        for (DynamicObject srcAccount : srcAccountList) {
            DynamicObject account = srcAccount.getDynamicObject("fbasedataid");
            srcActIdList.add(account.getLong("id"));
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        JSONArray compareInfoJsonObj = (JSONArray)param.getCustomParam("assgrepCompareInfo");
        ArrayList<AssgrepCompareInfo> compareInfoList = new ArrayList<AssgrepCompareInfo>();
        compareInfoJsonObj.forEach(json -> {
            try {
                String jsonStr = json.toString();
                AssgrepCompareInfo compareInfo = (AssgrepCompareInfo)JSONUtils.cast((String)jsonStr, AssgrepCompareInfo.class);
                if (srcAccountList.isEmpty() || srcActIdList.contains(compareInfo.getSrcAccountId())) {
                    compareInfoList.add(compareInfo);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        });
        return compareInfoList;
    }

    private String getGoalActFieldKey(Long actTableId) {
        Map<Long, Integer> map = this.getActTableFieldIndexMap();
        if (!map.containsKey(actTableId)) {
            return "";
        }
        int index = map.get(actTableId);
        return FIELD_ACT + index;
    }

    private String getGoalAssrepFieldKey(Long actTableId) {
        Map<Long, Integer> map = this.getActTableFieldIndexMap();
        if (!map.containsKey(actTableId)) {
            return "";
        }
        int index = map.get(actTableId);
        return FIELD_ASSGREP + index;
    }

    private Map<Long, Integer> getActTableFieldIndexMap() {
        FormShowParameter param = this.getView().getFormShowParameter();
        List goalActTableIdList = (List)param.getCustomParam("goalActTableId");
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(8);
        int cnt = 1;
        for (Long id : goalActTableIdList) {
            map.put(id, cnt++);
        }
        return map;
    }

    private List<Long> getAccountIdList() {
        FormShowParameter param = this.getView().getFormShowParameter();
        JSONArray compareInfoJsonObj = (JSONArray)param.getCustomParam("assgrepCompareInfo");
        ArrayList<Long> actIdList = new ArrayList<Long>();
        compareInfoJsonObj.forEach(json -> {
            try {
                String jsonStr = json.toString();
                AssgrepCompareInfo compareInfo = (AssgrepCompareInfo)JSONUtils.cast((String)jsonStr, AssgrepCompareInfo.class);
                actIdList.add(compareInfo.getSrcAccountId());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        });
        return actIdList;
    }

    private LocaleString setGoalActHeaderName(Map<Long, String> actTableNameMap, Long id, String mappingType) {
        if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            return new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee", (String)"AccountMappingEditPlugin_22", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        return new LocaleString(actTableNameMap.get(id));
    }
}

