/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FIBDIndexCreatedPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"periodsum", "accounttablesum", "exchangesum", "booksum", "accountsyssum"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (DataSet periodSet = QueryServiceHelper.queryDataSet((String)"fi.bd.index.period", (String)"bd_period_type", (String)"id", null, null);
             DataSet accounttableSet = QueryServiceHelper.queryDataSet((String)"fi.bd.index.accounttable", (String)"bd_accounttable", (String)"id", null, null);
             DataSet exratetableSet = QueryServiceHelper.queryDataSet((String)"fi.bd.index.exratetable", (String)"bd_exratetable", (String)"id", null, null);
             DataSet accsysSet = QueryServiceHelper.queryDataSet((String)"fi.bd.index.accsys", (String)"bd_accountingsys", (String)"id", null, null);
             DataSet accountbookSet = QueryServiceHelper.queryDataSet((String)"fi.bd.index.accountbook", (String)"gl_accountbook", (String)"id", null, null);){
            Integer periodCount = periodSet.count("id", false);
            Label periodSum = (Label)this.getControl("periodsum");
            periodSum.setText(periodCount.toString());
            Integer accounttableCount = accounttableSet.count("id", false);
            Label accounttableSum = (Label)this.getControl("accounttablesum");
            accounttableSum.setText(accounttableCount.toString());
            Integer exratetableCount = exratetableSet.count("id", false);
            Label exratetableSum = (Label)this.getControl("exchangesum");
            exratetableSum.setText(exratetableCount.toString());
            Integer accsysCount = accsysSet.count("id", false);
            Label accsysSum = (Label)this.getControl("accountsyssum");
            accsysSum.setText(accsysCount.toString());
            Integer accountbookCount = accountbookSet.count("id", false);
            Label accountbookSum = (Label)this.getControl("booksum");
            accountbookSum.setText(accountbookCount.toString());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.startsWith("period")) {
            this.showList("bd_periodoutline_tree");
        } else if (key.startsWith("accounttable")) {
            this.showList("bd_accounttable");
        } else if (key.startsWith("exchange")) {
            this.showList("bd_exrate_tree");
        } else if (key.startsWith("book")) {
            this.showList("gl_accountbook");
        } else if (key.startsWith("accountsys")) {
            this.showList("bd_accountingsys");
        }
    }

    private void showList(String billFormID) {
        ListShowParameter para = new ListShowParameter();
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setBillFormId(billFormID);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)billFormID);
        para.setFormId(formConfig.getListFormId());
        this.getView().showForm((FormShowParameter)para);
    }
}

