/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BDUtil;

public class SystemStateControlPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String acctOrg = "fisaccounting";
    private static final String assetOrg = "fisasset";
    private static final String bankrollOrg = "fisbankroll";
    private static final String settlementOrg = "fissettlement";

    public void registerListener(EventObject e) {
        OrgEdit f7Edit = (OrgEdit)this.getView().getControl("org2");
        f7Edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit f7Edit2 = (OrgEdit)this.getView().getControl("org1");
        f7Edit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("orgtype1", (Object)"10");
        this.getModel().setValue("orgtype2", (Object)"10");
        int glCount = this.getGLOrgSize();
        Label glControl = (Label)this.getControl("glenable");
        glControl.setText(String.valueOf(glCount));
        this.setPieChart();
        this.setEntryData("10", null);
    }

    private void setEntryData(String orgType, DynamicObject org) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("org", new Object[0]);
        tvs.addField("orgtype", new Object[0]);
        tvs.addField("startperiod", new Object[0]);
        tvs.addField("curperiod", new Object[0]);
        tvs.addField("settle", new Object[0]);
        String orgTypeName = this.getOrgTypeName(orgType);
        List<Long> orgIds = this.getSelectOrg(orgType, org);
        if (orgType.equals("10")) {
            QFilter forg = new QFilter("org", "in", orgIds).and(new QFilter("bookstype.accounttype", "=", (Object)"1"));
            DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,curperiod,startperiod,org,bookstype", (QFilter[])forg.toArray(), (String)"org");
            for (DynamicObject obj : col) {
                if (obj.getString("startperiod") == null || obj.getString("startperiod").trim().equals("") || obj.getString("startperiod").equals("0")) continue;
                QFilter glfilter = new QFilter("company", "=", (Object)obj.getLong("org"));
                DynamicObject glOrg = QueryServiceHelper.queryOne((String)"gl_closebooktimedata", (String)"id, company,closeday", (QFilter[])glfilter.toArray());
                Date nextCloseTime = null;
                if (glOrg != null) {
                    int closeTime = glOrg.getInt("closeday");
                    Calendar cal = Calendar.getInstance();
                    if (cal.get(5) > closeTime) {
                        cal.set(2, cal.get(2) + 1);
                        cal.set(5, closeTime);
                    } else {
                        cal.set(5, closeTime);
                    }
                    nextCloseTime = cal.getTime();
                }
                tvs.addRow(new Object[]{obj.getString("org"), orgTypeName, obj.getString("startperiod"), obj.getString("curperiod"), nextCloseTime});
                DynamicObjectCollection bizOrgCol = BDUtil.getBizOrgFromAccSys((Long)obj.getLong("org"));
                for (DynamicObject obj3 : bizOrgCol) {
                    QFilter filter = new QFilter("org", "in", (Object)obj3.getLong("fromorg")).and(new QFilter("orgtype", "=", (Object)obj3.getString("orgtype")));
                    DynamicObject bizOrg = QueryServiceHelper.queryOne((String)"bd_systemstatus", (String)"id,startperiod,curperiod", (QFilter[])filter.toArray());
                    String startperiod = "";
                    String curperiod = "";
                    if (bizOrg != null) {
                        startperiod = bizOrg.getString("startperiod");
                        curperiod = bizOrg.getString("curperiod");
                    }
                    tvs.addRow(new Object[]{obj3.getString("fromorg"), this.getOrgTypeName(obj3.getString("orgtype")), startperiod, curperiod, null});
                }
            }
        } else {
            QFilter filter = new QFilter("org", "in", orgIds).and(new QFilter("orgtype", "=", (Object)orgType));
            DynamicObjectCollection bizOrg = QueryServiceHelper.query((String)"bd_systemstatus", (String)"id,org,orgtype,startperiod,curperiod", (QFilter[])filter.toArray(), (String)"org");
            for (DynamicObject obj : bizOrg) {
                tvs.addRow(new Object[]{obj.getString("org"), orgTypeName, null, null, null});
            }
        }
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String getOrgTypeName(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("10", ResManager.loadKDString((String)"\u603b\u8d26", (String)"SystemStateControlPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("01", ResManager.loadKDString((String)"\u884c\u653f", (String)"SystemStateControlPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("02", ResManager.loadKDString((String)"\u91c7\u8d2d", (String)"SystemStateControlPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("03", ResManager.loadKDString((String)"\u9500\u552e", (String)"SystemStateControlPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("04", ResManager.loadKDString((String)"\u751f\u4ea7", (String)"SystemStateControlPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("05", ResManager.loadKDString((String)"\u4ed3\u5b58", (String)"SystemStateControlPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("06", ResManager.loadKDString((String)"\u8d28\u68c0", (String)"SystemStateControlPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("07", ResManager.loadKDString((String)"\u7ed3\u7b97", (String)"SystemStateControlPlugin_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("08", ResManager.loadKDString((String)"\u8d44\u91d1", (String)"SystemStateControlPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("09", ResManager.loadKDString((String)"\u8d44\u4ea7", (String)"SystemStateControlPlugin_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("11", "HR");
        map.put("12", ResManager.loadKDString((String)"\u5171\u4eab", (String)"SystemStateControlPlugin_10", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("13", ResManager.loadKDString((String)"\u9884\u7b97", (String)"SystemStateControlPlugin_11", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("14", ResManager.loadKDString((String)"\u63a7\u5236\u5355\u5143", (String)"SystemStateControlPlugin_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("15", ResManager.loadKDString((String)"\u7ec4\u7ec7\u5355\u5143", (String)"SystemStateControlPlugin_13", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        map.put("16", ResManager.loadKDString((String)"\u4e3b\u6570\u636e", (String)"SystemStateControlPlugin_14", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        return (String)map.get(key);
    }

    private List<Long> getSelectOrg(String orgType, DynamicObject org) {
        List<Long> orgList = new ArrayList<Long>();
        if (org == null) {
            if (orgType.equals("10")) {
                orgList = this.getPermissionOrg(acctOrg);
            } else if (orgType.equals("09")) {
                orgList = this.getPermissionOrg(assetOrg);
            } else if (orgType.equals("08")) {
                orgList = this.getPermissionOrg(bankrollOrg);
            } else if (orgType.equals("07")) {
                orgList = this.getPermissionOrg(settlementOrg);
            }
        } else {
            orgList.add(org.getLong("id"));
        }
        return orgList;
    }

    private void setPieChart() {
        Chart pieChart = (Chart)this.getControl("piechartap");
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(true);
        pieChart.setLegendAlign(XAlign.center, YAlign.bottom);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u7cfb\u7edf\u72b6\u6001\u6574\u4f53\u6982\u51b5", (String)"SystemStateControlPlugin_15", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        ItemValue[] value = this.getPieChartValue();
        series.setData(value);
        series.setRadius("25%", "70%");
        pieChart.bindData(null);
    }

    private int getGLOrgSize() {
        List<Long> orgIds = this.getPermissionOrg(acctOrg);
        QFilter f1 = new QFilter("org", "in", orgIds);
        QFilter f2 = new QFilter("startperiod", "!=", (Object)0);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org", (QFilter[])new QFilter[]{f1, f2});
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject c : col) {
            idSet.add(c.getLong("org"));
        }
        return idSet.size();
    }

    private List<Long> getPermissionOrg(String orgType) {
        QFilter filter = BDUtil.getAcctOrgFilter((String)orgType);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"kd.fi.gl.util.BDUtil.initFilter", (String)"bos_org", (String)"id", (QFilter[])filter.toArray(), null);
        for (DynamicObject obj : orgCol) {
            orgIds.add(obj.getLong("id"));
        }
        return orgIds;
    }

    private ItemValue[] getPieChartValue() {
        ItemValue v1 = new ItemValue(ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7\u7cfb\u7edf", (String)"SystemStateControlPlugin_16", (String)"fi-bd-formplugin", (Object[])new Object[0]), (Number)200, "#2EC6C8");
        ItemValue v2 = new ItemValue(ResManager.loadKDString((String)"\u51fa\u7eb3\u7cfb\u7edf", (String)"SystemStateControlPlugin_17", (String)"fi-bd-formplugin", (Object[])new Object[0]), (Number)300, "#84A2FB");
        ItemValue[] value = new ItemValue[]{v1, v2};
        return value;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals("orgtype2")) {
            String value = (String)e.getChangeSet()[0].getNewValue();
            if (value.equals("")) {
                this.getModel().setValue("org2", null);
                return;
            }
            this.getModel().setValue("org2", null);
            this.setEntryData(value, null);
        } else if (name.equals("org2")) {
            String orgType = (String)this.getModel().getValue("orgtype2");
            DynamicObject org = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.setEntryData(orgType, org);
        }
    }

    public String getOrgType(String value) {
        return value.equals("10") ? acctOrg : (value.equals("09") ? assetOrg : (value.equals("08") ? bankrollOrg : settlementOrg));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit base = (BasedataEdit)e.getSource();
        String key = base.getKey();
        if (key.equals("org2")) {
            this.setOrgFilter(e, "orgtype2", "org2");
        } else if (key.equals("org1")) {
            this.setOrgFilter(e, "orgtype1", "org1");
        }
    }

    private void setOrgFilter(BeforeF7SelectEvent e, String orgtype, String orgId) {
        String orgType = (String)this.getModel().getValue(orgtype);
        if (orgType == null || orgType.isEmpty()) {
            e.setCancel(true);
            return;
        }
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        showParam.setCustomParam("orgFuncId", (Object)orgType);
        String type = this.getOrgType(orgType);
        QFilter filter = BDUtil.getAcctOrgFilter((String)type);
        BasedataEdit org = (BasedataEdit)this.getControl(orgId);
        org.setQFilter(filter);
    }
}

