/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.autoversion.check;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.formplugin.account.autoversion.check.VersionBizCheckRst;
import kd.fi.bd.formplugin.account.autoversion.check.vo.QueryParam;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceMonitor;

public class HasBizOrAlreadyVersionedBySubOrgCheck {
    private Log logger = LogFactory.getLog(HasBizOrAlreadyVersionedBySubOrgCheck.class);
    private VersionBizCheckRst versionBizCheckRst;
    private DynamicObject account;
    private DynamicObject pAccount;
    private List allChildrenOrgIds;

    public HasBizOrAlreadyVersionedBySubOrgCheck(DynamicObject account) {
        this.account = account;
        this.versionBizCheckRst = new VersionBizCheckRst();
    }

    public VersionBizCheckRst check() {
        this.pAccount = this.account.getDynamicObject("parent");
        ArrayList<Long> currCreateOrgIds = new ArrayList<Long>(8);
        currCreateOrgIds.add(this.account.getLong("createorg_id"));
        this.allChildrenOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", currCreateOrgIds, (boolean)true);
        if (DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource((Throwable)new Throwable());
            this.logger.info("HasBizOrAlreadyVersionedBySubOrgCheck_allChildrenOrgIds: {},callSource: {}", (Object)JSONObject.toJSONString((Object)this.allChildrenOrgIds), (Object)callSource);
        }
        HashSet<Long> parentAccountIds = new HashSet<Long>(10);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select u.fuseorgid,u.fdataid from t_bd_account_u as u", new Object[0]);
        sqlBuilder.append("inner join t_bd_account as a on a.fid=u.fdataid", new Object[0]);
        sqlBuilder.append("where a.fnumber = ?", new Object[]{this.pAccount.getString("number")});
        sqlBuilder.append("and a.faccounttableid = ?", new Object[]{this.account.getLong("accounttable_id")});
        sqlBuilder.appendIn("and u.fuseorgid ", this.allChildrenOrgIds);
        HashSet<Object> useOrgIds = new HashSet<Object>(10);
        try (DataSet dataSet = DB.queryDataSet((String)HasBizOrAlreadyVersionedBySubOrgCheck.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                useOrgIds.add(row.get("fuseorgid"));
                parentAccountIds.add(row.getLong("fdataid"));
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select u.fuseorgid,u.fdataid from t_bd_accountusereg as u", new Object[0]);
        sqlBuilder.append("inner join t_bd_account as a on a.fid=u.fdataid", new Object[0]);
        sqlBuilder.append("where a.fnumber = ?", new Object[]{this.pAccount.getString("number")});
        sqlBuilder.append("and a.faccounttableid = ?", new Object[]{this.account.getLong("accounttable_id")});
        sqlBuilder.appendIn("and u.fuseorgid ", this.allChildrenOrgIds);
        dataSet = DB.queryDataSet((String)HasBizOrAlreadyVersionedBySubOrgCheck.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        var6_6 = null;
        try {
            for (Row row : dataSet) {
                parentAccountIds.add(row.getLong("fdataid"));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var6_6 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Set orgIds = useOrgIds.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
        orgIds.retainAll(this.allChildrenOrgIds);
        if (orgIds.size() > 0 && DebugTrace.enable()) {
            String callSource = PerformanceMonitor.parseFullCallSource((Throwable)new Throwable());
            this.logger.info("HasBizOrAlreadyVersionedBySubOrgCheck_assignToOrgids: {},callSource: {}", (Object)JSONObject.toJSONString(orgIds), (Object)callSource);
        }
        orgIds.addAll(this.allChildrenOrgIds);
        HashSet<Long> createOrgIds = new HashSet<Long>(orgIds);
        createOrgIds.remove(this.account.getLong("createorg_id"));
        if (createOrgIds.size() > 0 && this.isVersioned(createOrgIds)) {
            return this.versionBizCheckRst;
        }
        if (orgIds.size() > 0) {
            for (Long l : parentAccountIds) {
                if (!BizHappenUtils.existOnLaterPeriods((long)l, orgIds, (Date)this.account.getDate("startdate"))) continue;
                String resultTip = String.format(ResManager.loadKDString((String)"%s\u79d1\u76ee\u5728\u5f53\u524d\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7\u6709\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u65b0\u589e\u4e0b\u7ea7\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u6216\u521d\u59cb\u5316\u4f59\u989d\u6570\u636e\u540e\u518d\u65b0\u589e\uff0c\u6216\u901a\u8fc7\u7248\u672c\u5316\u65b0\u589e\u4e0b\u7ea7\u79d1\u76ee\u3002", (String)"BizCheckS_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), this.pAccount.getString("number"));
                this.versionBizCheckRst.setSuccess(false);
                this.versionBizCheckRst.setMsg(resultTip);
                return this.versionBizCheckRst;
            }
        }
        if (parentAccountIds.size() > 0) {
            DynamicObject[] parentAccounts;
            for (DynamicObject parentAccount : parentAccounts = BusinessDataServiceHelper.load((Object[])parentAccountIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountview"))) {
                boolean isExitBiz;
                boolean bl = isExitBiz = AccountVersionUtil.isAccountVersionalized((DynamicObject)parentAccount) && parentAccount.getBoolean("isleaf");
                if (!isExitBiz) continue;
                this.versionBizCheckRst.setNeedAssign(true);
                this.versionBizCheckRst.setVersionAddLeaf(true);
                return this.versionBizCheckRst;
            }
            if (BizHappenUtils.batchExist(parentAccountIds, orgIds)) {
                this.versionBizCheckRst.setNeedAssign(true);
                this.versionBizCheckRst.setVersionAddLeaf(true);
                return this.versionBizCheckRst;
            }
        }
        HashSet<String> acctNums = new HashSet<String>(10);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fnumber from t_bd_account_u as u", new Object[0]);
        sqlBuilder.append("inner join t_bd_account as a on a.fid=u.fdataid", new Object[0]);
        sqlBuilder.append("where a.fnumber = ?", new Object[]{this.pAccount.getString("number")});
        sqlBuilder.append("and a.faccounttableid = ?", new Object[]{this.account.getLong("accounttable_id")});
        sqlBuilder.appendIn("and u.fuseorgid ", this.allChildrenOrgIds);
        try (DataSet dataSet = DB.queryDataSet((String)HasBizOrAlreadyVersionedBySubOrgCheck.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                acctNums.add(row.getString("fnumber"));
            }
        }
        if (acctNums.size() > 1) {
            this.versionBizCheckRst.setNeedAssign(true);
            this.versionBizCheckRst.setVersionAddLeaf(true);
        }
        return this.versionBizCheckRst;
    }

    public static Set<Object> queryAssignOrgIdByMasterId(String select, String field, QueryParam param) {
        List<Long> useOrgIdList = param.getAllChildrenOrgIds();
        String useOrgIds = useOrgIdList.toString();
        String sql = String.format(select + "where a.fmasterid = %1s and a.faccounttableid = %2s and reg.fuseorgid in (%3s)", param.getMasterId(), param.getAccountTableId(), useOrgIds.substring(1, useOrgIds.length() - 1));
        HashSet<Object> orgIds = new HashSet<Object>(10);
        try (DataSet dataSet = DB.queryDataSet((String)HasBizOrAlreadyVersionedBySubOrgCheck.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row row : dataSet) {
                orgIds.add(row.get(field));
            }
        }
        return orgIds;
    }

    public boolean isVersioned(Set<Long> createOrgIds) {
        Date startDate = this.account.getDate("startdate");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("createorg_id", "in", createOrgIds));
        qFilters.add(new QFilter("accounttable_id", "=", (Object)this.account.getLong("accounttable_id")));
        qFilters.add(new QFilter("number", "=", (Object)this.account.getDynamicObject("parent").getString("number")));
        qFilters.add(new QFilter("masterid", "=", (Object)this.account.getDynamicObject("parent").getLong("masterid")));
        qFilters.add(new QFilter("startdate", ">", (Object)startDate));
        boolean isVersioned = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (isVersioned) {
            String resultTip = String.format(ResManager.loadKDString((String)"%s\u4e0b\u7ea7\u7ec4\u7ec7\u5df2\u5bf9\u8be5\u79d1\u76ee\u8fdb\u884c\u7248\u672c\u5316\uff0c\u5f53\u524d\u671f\u95f4\u65e0\u6cd5\u518d\u6b21\u7248\u672c\u5316\u3002", (String)"BizCheckS_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), this.pAccount.getString("number"));
            this.versionBizCheckRst.setSuccess(false);
            this.versionBizCheckRst.setMsg(resultTip);
            return true;
        }
        return false;
    }
}

