/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.accounthealth.accountrepair.repair.AccountRepairContext;
import kd.fi.bd.accounthealth.util.AccountPropControlCheckUntil;
import kd.fi.bd.business.service.accountrepair.AccountRepairCommonService;
import kd.fi.bd.enums.AccountPropCategory;
import kd.fi.bd.enums.AccountPropDetail;
import kd.fi.bd.formplugin.account.check.AccountCheckListDataProvider;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PermissonType;

public class AccountCheckListPlugin
extends AbstractListPlugin {
    private static final String ACCOUNTTABLE_ID = "accounttable.id";
    private static final String USEORG_ID = "useorg.id";
    private static final String DEF_ACCTABLEID = "accTableId";
    private static final String CHECK_CATEGORY = "checkcategory";
    private static final String DETAIL_CATEGORY_HELP = "detailcategoryhelp";
    private static final String DETAIL_CATEGORY = "entryentity.detailcategory";
    private static final String TOOLBARAP = "toolbarap";
    private static final String REPAIR_FOR_ACCOUNT = "repairforaccount";
    private static final String CHECK = "check";
    private static final String BILLLISTAP = "billlistap";
    private static final String CHECK_PERM_ITEM_ID = "46/AQF9A0MTP";
    private static final String REPAIR_PERM_ITEM_ID = "46/AXA09RB9O";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TOOLBARAP});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            IPageCache pageCache = this.getPageCache();
            switch (fieldName) {
                case "detailcategoryhelp": {
                    List<String> checkCategorys = this.getCustomFilterValues(CHECK_CATEGORY);
                    String checkCategory = null;
                    if (CollectionUtils.isNotEmpty(checkCategorys)) {
                        checkCategory = checkCategorys.get(0);
                    }
                    ((CommonFilterColumn)filterColumn).setComboItems(this.getDetailComboItems(checkCategory));
                    break;
                }
                case "useorg.id": {
                    String defaultOrg = pageCache.get("orgId");
                    if (defaultOrg == null) {
                        List<Long> orgList = this.getAllUseOrg();
                        if (CollectionUtils.isNotEmpty(orgList)) {
                            long loginOrg = RequestContext.get().getOrgId();
                            defaultOrg = orgList.contains(loginOrg) ? String.valueOf(loginOrg) : String.valueOf(orgList.get(0));
                        }
                        pageCache.put("orgId", defaultOrg);
                    }
                    filterColumn.setDefaultValue(defaultOrg);
                    break;
                }
                case "accounttable.id": {
                    String accTableId = pageCache.get(DEF_ACCTABLEID);
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)accTableId)) {
                        List<ComboItem> comboItems = this.getAccountTableComboItem();
                        if (comboItems.isEmpty()) {
                            return;
                        }
                        accTableId = comboItems.get(0).getValue();
                        pageCache.put(DEF_ACCTABLEID, accTableId);
                    }
                    filterColumn.setDefaultValue(accTableId);
                    break;
                }
            }
        }
    }

    protected List<ComboItem> getDetailComboItems(String checkCategory) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)checkCategory)) {
            for (AccountPropDetail value : AccountPropDetail.values()) {
                comboItems.add(new ComboItem(new LocaleString(value.getName()), value.getType()));
            }
            return comboItems;
        }
        List details = AccountPropDetail.getAccountPropDetails((String)checkCategory);
        details.forEach(accountPropDetail -> comboItems.add(new ComboItem(new LocaleString(accountPropDetail.getName()), accountPropDetail.getType())));
        return comboItems;
    }

    protected List<String> getCustomFilterValues(String fieldName) {
        ControlFilters c = this.getControlFilters();
        if (c == null) {
            return null;
        }
        List result = c.getFilter(fieldName);
        ArrayList<String> ids = new ArrayList<String>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(v.toString());
        }
        return ids;
    }

    public void setFilter(SetFilterEvent e) {
        String checkCategory;
        super.setFilter(e);
        List filters = e.getQFilters();
        this.convertCategorySchemeFilter(filters);
        if (filters.stream().anyMatch(qFilter -> CHECK_CATEGORY.equals(qFilter.getProperty()) && "=".equals(qFilter.getCP())) && filters.stream().noneMatch(qFilter -> DETAIL_CATEGORY_HELP.equals(qFilter.getProperty()))) {
            checkCategory = filters.stream().filter(qFilter -> CHECK_CATEGORY.equals(qFilter.getProperty())).map(y -> y.getValue() == null ? "" : y.getValue().toString()).findFirst().get();
            QFilter filter = new QFilter(DETAIL_CATEGORY, "in", (Object)AccountPropDetail.getAccountPropDetailTypes((String)checkCategory));
            filters.add(filter);
        } else if (filters.stream().anyMatch(qFilter -> CHECK_CATEGORY.equals(qFilter.getProperty()) && "=".equals(qFilter.getCP())) && filters.stream().anyMatch(qFilter -> DETAIL_CATEGORY_HELP.equals(qFilter.getProperty()))) {
            checkCategory = filters.stream().filter(qFilter -> CHECK_CATEGORY.equals(qFilter.getProperty())).map(y -> y.getValue().toString()).findFirst().get();
            String detailCategory = filters.stream().filter(qFilter -> DETAIL_CATEGORY_HELP.equals(qFilter.getProperty())).map(y -> y.getValue().toString()).findFirst().get();
            List details = AccountPropDetail.getAccountPropDetailTypes((String)checkCategory);
            if (!details.contains(detailCategory)) {
                filters.removeIf(qFilter -> DETAIL_CATEGORY_HELP.equals(qFilter.getProperty()));
                QFilter filter = new QFilter(DETAIL_CATEGORY, "in", (Object)AccountPropDetail.getAccountPropDetailTypes((String)checkCategory));
                filters.add(filter);
            }
        }
        for (QFilter qFilter2 : filters) {
            AccountCheckListPlugin.changeFilter(qFilter2);
        }
        filters.removeIf(qFilter -> CHECK_CATEGORY.equals(qFilter.getProperty()));
    }

    private void convertCategorySchemeFilter(List<QFilter> filters) {
        ArrayList<QFilter> resFilter = new ArrayList<QFilter>(filters);
        for (QFilter qFilter : resFilter) {
            if (!CHECK_CATEGORY.equals(qFilter.getProperty())) continue;
            if ("EMPTY".equalsIgnoreCase(qFilter.getValue() == null ? "" : qFilter.getValue().toString())) {
                QFilter filter = new QFilter(DETAIL_CATEGORY, "is null", null);
                filters.add(filter);
                continue;
            }
            switch (qFilter.getCP().toLowerCase()) {
                case "!=": 
                case "<>": {
                    String value = (String)qFilter.getValue();
                    QFilter filter = new QFilter(DETAIL_CATEGORY, "not in", (Object)AccountPropDetail.getAccountPropDetailTypes((String)value));
                    filters.add(filter);
                    break;
                }
                case "in": {
                    List values = (List)qFilter.getValue();
                    ArrayList details = new ArrayList(16);
                    values.forEach(val -> details.addAll(AccountPropDetail.getAccountPropDetailTypes((String)val)));
                    QFilter filter = new QFilter(DETAIL_CATEGORY, "in", details);
                    filters.add(filter);
                    break;
                }
                case "not in": {
                    List values = (List)qFilter.getValue();
                    ArrayList details = new ArrayList(16);
                    values.forEach(val -> details.addAll(AccountPropDetail.getAccountPropDetailTypes((String)val)));
                    QFilter filter = new QFilter(DETAIL_CATEGORY, "not in", details);
                    filters.add(filter);
                    break;
                }
                case "is not null": {
                    filters.removeIf(filter1 -> CHECK_CATEGORY.equals(filter1.getProperty()));
                    break;
                }
            }
        }
    }

    protected List<Long> getAllUseOrg() {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)"fibd", (String)"bd_account_checkresult", (String)PermissonType.VIEW.getPermId());
        if (null == result || !result.hasAllOrgPerm() && result.getHasPermOrgs().size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u79d1\u76ee\u5065\u5eb7\u5de1\u68c0\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountCheckListPlugin_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        if (result.hasAllOrgPerm()) {
            return OrgUnitServiceHelper.getAllOrgByViewId((long)10L, (boolean)true);
        }
        return result.getHasPermOrgs();
    }

    protected List<ComboItem> getAccountTableComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter[]{enableFilter}, null);){
            while (tableSet.hasNext()) {
                Row row = tableSet.next();
                ComboItem com = new ComboItem(new LocaleString(row.getString("name")), String.valueOf(row.getLong("id")));
                comboItems.add(com);
            }
        }
        return comboItems;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AccountCheckListDataProvider());
        super.beforeCreateListDataProvider(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        List orgs = BDUtil.getCustomFilterIds((IFormView)this.getView(), (String)USEORG_ID);
        int batchSize = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.healthcheck.orgsize", (int)5);
        if (CHECK.equals(key)) {
            boolean isOpen = BillParamUtil.getBooleanValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.healthcheck", (boolean)false);
            if (!isOpen) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u672a\u5f00\u542f\u79d1\u76ee\u5065\u5eb7\u5de1\u67e5\u529f\u80fd\uff0c\u6b64\u529f\u80fd\u4e3a\u7070\u5ea6\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e\u540e\u4f7f\u7528\u3002", (String)"AccountCheckListPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (AccountCheckListPlugin.checkPermission(CHECK_PERM_ITEM_ID, orgs)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u79d1\u76ee\u5065\u5eb7\u5de1\u68c0\u201d\u7684\u201c\u5168\u91cf\u68c0\u67e5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountCheckListPlugin_16", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.isFromSchemeFilter()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u754c\u9762\u4e0d\u652f\u6301\u5168\u91cf\u68c0\u67e5\uff0c\u8bf7\u4f7f\u7528\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u5168\u91cf\u68c0\u67e5\u3002", (String)"AccountCheckListPlugin_14", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List accountTable = BDUtil.getCustomFilterIds((IFormView)this.getView(), (String)ACCOUNTTABLE_ID);
            if (CollectionUtils.isEmpty((Collection)accountTable)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u518d\u70b9\u51fb\u5168\u91cf\u68c0\u67e5\u3002", (String)"AccountCheckListPlugin_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String orgNames = AccountCheckListPlugin.loadDisabledOrgName(orgs);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgNames)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08%s\uff09\u5df2\u7981\u7528\u6216\u5c01\u5b58\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\uff0c\u65e0\u9700\u8fdb\u884c\u79d1\u76ee\u5065\u5eb7\u68c0\u67e5\uff0c\u8bf7\u4ec5\u68c0\u67e5\u53ef\u7528\u72b6\u6001\u4e14\u5177\u5907\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\u7684\u7ec4\u7ec7\u3002", (String)"AccountCheckListPlugin_10", (String)"fi-bd-formplugin", (Object[])new Object[]{orgNames}));
                evt.setCancel(true);
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)orgs) && orgs.size() > batchSize) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u64cd\u4f5c\u6700\u591a\u53ea\u80fd\u68c0\u67e5%s\u4e2a\u7ec4\u7ec7\u7684\u79d1\u76ee\uff0c\u8bf7\u51cf\u5c11\u9009\u62e9\u7684\u7ec4\u7ec7\u6570\u91cf\u540e\u518d\u70b9\u51fb\u5168\u91cf\u68c0\u67e5\u3002", (String)"AccountCheckListPlugin_11", (String)"fi-bd-formplugin", (Object[])new Object[]{batchSize}));
                evt.setCancel(true);
                return;
            }
        } else if (evt.getItemKey().equals(REPAIR_FOR_ACCOUNT)) {
            Optional detailPropCheck;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccountCheckListPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List selectRowIds = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", selectRowIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"check_org_enable", (String)"bd_account_checkresult", (String)USEORG_ID, (QFilter[])filter.toArray(), (String)"longnumber", (int)-1);
            HashSet<Long> orgIds = new HashSet<Long>(8);
            for (Row row : dataSet) {
                orgIds.add(row.getLong(USEORG_ID));
            }
            if (AccountCheckListPlugin.checkPermission(REPAIR_PERM_ITEM_ID, new ArrayList<Long>(orgIds))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u79d1\u76ee\u5065\u5eb7\u5de1\u68c0\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountCheckListPlugin_17", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.isFromSchemeFilter()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u754c\u9762\u4e0d\u652f\u6301\u4fee\u6539\uff0c\u8bf7\u4f7f\u7528\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccountCheckListPlugin_19", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<String> checkCategorys = this.getCustomFilterValues(CHECK_CATEGORY);
            if (CollectionUtils.isEmpty(checkCategorys)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u68c0\u67e5\u5927\u7c7b\u540e\u518d\u70b9\u51fb\u4fee\u6539\u3002", (String)"AccountCheckListPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String checkCategory = checkCategorys.get(0);
            List details = AccountPropDetail.getAccountPropDetailTypes((String)checkCategory);
            List<String> detailcategorys = this.getCustomFilterValues(DETAIL_CATEGORY_HELP);
            if (checkCategory.equals(AccountPropCategory.OTHER.getType()) && (CollectionUtils.isEmpty(detailcategorys) || !details.contains(detailcategorys.get(0)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u5927\u7c7b\u4e3a\u201c\u5176\u4ed6\u201d\u6761\u4ef6\u4e0b\u8fdb\u884c\u4fee\u6539\u65f6\uff0c\u8bf7\u9009\u62e9\u8be6\u7ec6\u7684\u201d\u660e\u7ec6\u5206\u7c7b\u201c\u3002", (String)"AccountCheckListPlugin_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (CollectionUtils.isNotEmpty(detailcategorys) && checkCategory.equals(AccountPropCategory.OTHER.getType()) && (detailPropCheck = AccountPropControlCheckUntil.disableRepairPropCheck(detailcategorys)).isPresent()) {
                this.getView().showTipNotification((String)detailPropCheck.get());
                evt.setCancel(true);
                return;
            }
            if (orgIds.size() > batchSize) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u64cd\u4f5c\u6700\u591a\u53ea\u80fd\u4fee\u6539%s\u4e2a\u4f7f\u7528\u7ec4\u7ec7\u7684\u79d1\u76ee\uff0c\u8bf7\u51cf\u5c11\u9009\u62e9\u7684\u6570\u636e\u8303\u56f4\u540e\u518d\u70b9\u51fb\u4fee\u6539\u3002", (String)"AccountCheckListPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[]{batchSize}));
                evt.setCancel(true);
                return;
            }
            String orgNames = AccountCheckListPlugin.loadDisabledOrgName(new ArrayList<Long>(orgIds));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgNames)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08%s\uff09\u5df2\u7981\u7528\u6216\u5c01\u5b58\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\uff0c\u65e0\u9700\u8fdb\u884c\u79d1\u76ee\u4fee\u6539\uff0c\u8bf7\u4ec5\u4fee\u6539\u53ef\u7528\u72b6\u6001\u4e14\u5177\u5907\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\u7684\u7ec4\u7ec7\u3002", (String)"AccountCheckListPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[]{orgNames}));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (CHECK.equals(key)) {
            List orgs = BDUtil.getCustomFilterIds((IFormView)this.getView(), (String)USEORG_ID);
            List accountTable = BDUtil.getCustomFilterIds((IFormView)this.getView(), (String)ACCOUNTTABLE_ID);
            this.dispatch((Long)accountTable.get(0), orgs);
        } else if (REPAIR_FOR_ACCOUNT.equals(key)) {
            List<String> checkCategorys = this.getCustomFilterValues(CHECK_CATEGORY);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            String checkCategory = checkCategorys.get(0);
            List<Object> selectRowIds = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toList());
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            AccountRepairContext ctx = new AccountRepairContext(selectRowIds, checkCategory, Boolean.valueOf(false), userID);
            if (checkCategory.equals(AccountPropCategory.PROP.getType())) {
                this.showConfirm(checkCategory, selectRowIds, ctx);
            }
            if (checkCategory.equals(AccountPropCategory.ASST.getType())) {
                ctx.setRealRepair(Boolean.valueOf(false));
                ctx.setRepairType(AccountPropCategory.PROP.getType());
                List propCheckResults = AccountRepairCommonService.doRepair((AccountRepairContext)ctx);
                if (CollectionUtils.isNotEmpty((Collection)propCheckResults)) {
                    String mess = ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u68c0\u67e5\u5927\u7c7b\u9009\u62e9\u5c5e\u6027\u7c7b\u5e76\u4fee\u6539\u79d1\u76ee\uff0c\u5168\u90e8\u4fee\u6539\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u79d1\u76ee\u7ef4\u5ea6\u7684\u4fee\u6539\u3002", (String)"AccountCheckListPlugin_20", (String)"fi-bd-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(mess);
                    return;
                }
                ctx.setRepairType(AccountPropCategory.ASST.getType());
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("bd_account_version_date");
                HashMap<String, Object> customParamMap = new HashMap<String, Object>(2);
                customParamMap.put("repair_type", checkCategory);
                customParamMap.put("select_row_ids", selectRowIds);
                formShowParameter.setCustomParams(customParamMap);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "version_date");
                formShowParameter.setCloseCallBack(callBack);
                this.getView().showForm(formShowParameter);
            }
            return;
        }
    }

    private void showConfirm(String checkCategory, List<Object> selectRowIds, AccountRepairContext ctx) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bd_account_check_confirm");
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(2);
        customParamMap.put("repair_type", checkCategory);
        customParamMap.put("select_row_ids", selectRowIds);
        formShowParameter.setCustomParams(customParamMap);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "repair_account");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    private void dispatch(long accountTableId, List<Long> orgs) {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("fibd");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName(ResManager.loadKDString((String)"\u68c0\u67e5\u4e2d", (String)"AccountCheckListPlugin_13", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            jobInfo.setTaskClassname("kd.fi.bd.formplugin.account.check.AccountCheckTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            String formNum = this.getModel().getDataEntityType().getName();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getView().getFormShowParameter().getAppId()) ? appIdByFormNum : this.getView().getFormShowParameter().getAppId();
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("pageId", this.getPageCache().getPageId());
            params.put("accountTableId", accountTableId);
            params.put("selectorgs", SerializationUtils.toJsonString(orgs));
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "task_closeCallback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setParentPageId(this.getView().getParentView().getPageId());
            jobFormInfo.setParentPageId(this.getView().getParentView().getPageId());
            jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            jobFormInfo.setClickClassName("kd.fi.bd.formplugin.account.check.AccountCheckClickTask");
            AccountCheckListPlugin.dispatch(jobFormInfo, this.getView());
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    public static void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_account_checkprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("check_jobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        if ("task_closeCallback".equals(e.getActionId()) && (returnData = e.getReturnData()) != null) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result = (Map)returnData;
            if (result.containsKey("taskinfo") && !StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                boolean success = (Boolean)dataMap.get("success");
                if (success) {
                    view.showSuccessNotification(msg, Integer.valueOf(3000));
                } else {
                    view.showErrorNotification(msg);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    protected static void changeFilter(QFilter qFilter) {
        if (DETAIL_CATEGORY_HELP.equals(qFilter.getProperty())) {
            qFilter.__setProperty(DETAIL_CATEGORY);
        }
    }

    protected static String loadDisabledOrgName(List<Long> org) {
        QFilter filter = new QFilter("org", "in", org);
        filter.and(new QFilter("view", "=", (Object)Long.parseLong("10")));
        filter.and(new QFilter("isfreeze", "=", (Object)true).or(new QFilter("org.enable", "=", (Object)false)));
        Map disabledOrgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org.name", (QFilter[])filter.toArray());
        ArrayList<String> orgNameList = new ArrayList<String>(8);
        for (DynamicObject object : disabledOrgs.values()) {
            orgNameList.add(object.getString("org.name"));
        }
        return String.join((CharSequence)",", orgNameList);
    }

    protected static boolean checkPermission(String permItemId, List<Long> orgIds) {
        ArrayList<Long> opOrgs = new ArrayList<Long>(orgIds);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)"fibd", (String)"bd_account_checkresult", (String)permItemId, (boolean)true);
        if (result != null) {
            if (result.hasAllOrgPerm()) {
                result.getHasPermOrgs().addAll(OrgUnitServiceHelper.getAllOrgByViewNumber((String)"10", (boolean)true));
            }
            opOrgs.removeAll(result.getHasPermOrgs());
        }
        return CollectionUtils.isNotEmpty(opOrgs);
    }

    private boolean isFromSchemeFilter() {
        FilterContainerFilterValues cachedFilterValues;
        FilterKeyValueCollections otherFilterValues;
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        return filterContainer != null && (otherFilterValues = (cachedFilterValues = filterContainer.getCachedFilterValues()).getOtherFilterValues()) != null && "schemefilter".equals(cachedFilterValues.getOtherFilterValues().getFilterKey());
    }
}

