/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.formplugin.account.check.event.OrgChangeTypeEnum;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;

public class OrgSaveEventBDRecordServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(OrgSaveEventBDRecordServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        boolean isOpen = BillParamUtil.getBooleanValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.healthcheck", (boolean)false);
        if (!isOpen) {
            return null;
        }
        try {
            JSONObject params = this.getBecEventOperationParams(evt);
            if (params == null) {
                return null;
            }
            ArrayList<DynamicObject> needRecordOrgChangeInfos = new ArrayList<DynamicObject>(8);
            this.getChangedData(params, "update", needRecordOrgChangeInfos);
            if (CollectionUtils.isNotEmpty(needRecordOrgChangeInfos)) {
                SaveServiceHelper.save((DynamicObject[])needRecordOrgChangeInfos.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("OrgSaveEvent exception:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private JSONObject getBecEventOperationParams(KDBizEvent evt) {
        String evtVariables = evt.getVariables();
        if (DebugTrace.enable()) {
            logger.info("OrgSaveEvent params\uff1a" + evtVariables);
        }
        if (StringUtils.isBlank((CharSequence)evtVariables)) {
            return null;
        }
        JSONObject paramJsonObj = JSON.parseObject((String)evtVariables);
        Object opParamJson = paramJsonObj.get((Object)"becEventOperationParams");
        return StringUtils.isBlank((Object)opParamJson) ? null : JSON.parseObject((String)opParamJson.toString());
    }

    private void getChangedData(JSONObject params, String operation, List<DynamicObject> needRecordOrgChangeInfos) {
        JSONObject opJson = params.getJSONObject(operation);
        if (opJson == null) {
            return;
        }
        Set entries = opJson.entrySet();
        for (Map.Entry orgEntry : entries) {
            JSONObject idJson = (JSONObject)orgEntry.getValue();
            JSONObject entityJson = idJson.getJSONObject("structure");
            if (entityJson == null) continue;
            long id = Long.parseLong((String)orgEntry.getKey());
            this.getChangedProperty(id, entityJson, needRecordOrgChangeInfos);
        }
    }

    private void getChangedProperty(long id, JSONObject entityJson, List<DynamicObject> needRecordOrgChangeInfos) {
        JSONObject proJson = entityJson.getJSONObject("property");
        if (proJson == null || proJson.getJSONObject("10") == null) {
            return;
        }
        Set entrySet = proJson.entrySet();
        for (Map.Entry viewEntry : entrySet) {
            Object oldValue;
            Object newValue;
            JSONObject viewJson = (JSONObject)viewEntry.getValue();
            JSONObject parentJson = viewJson.getJSONObject("viewparent");
            if (parentJson == null || !StringUtils.isNotBlank((Object)(newValue = parentJson.get((Object)"newValue"))) || Objects.equals(newValue, oldValue = parentJson.get((Object)"oldValue"))) continue;
            DynamicObject orgChangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_org_changeinfo");
            orgChangeInfo.set("org", (Object)id);
            orgChangeInfo.set("oldparent", (Object)Long.parseLong(oldValue.toString()));
            orgChangeInfo.set("newparent", (Object)Long.parseLong(newValue.toString()));
            orgChangeInfo.set("createtime", (Object)new Date());
            orgChangeInfo.set("type", (Object)OrgChangeTypeEnum.MOVE.getType());
            needRecordOrgChangeInfos.add(orgChangeInfo);
        }
    }
}

