/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accountingsys;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.fi.bd.accsyscache.AccSysModelCacheService;

public class AccountingSysAddViewList
extends AbstractListPlugin {
    private static final String BTNRETURNDATA = "btnreturndata";
    private static final String BTNNEW = "btnnew";
    private static final String BTNDEL = "btndel";
    private static final String BTNREFRESH = "btnrefresh";
    private static final String BD_ACCOUNTINGSYSVIEWSCH = "bd_accountingsysviewsch";
    private static final String BOS_ORG_VIEWSCHEMA = "bos_org_viewschema";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNRETURNDATA, BTNDEL, BTNREFRESH, "clicknew", "clickdelete"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap31", "flexpanelap3"});
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "btnreturndata": {
                this.returnData();
                break;
            }
            case "btnnew": {
                break;
            }
            case "btndel": {
                break;
            }
            case "btnrefresh": {
                this.refreshData();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        evt.getSource();
        if (evt.getSource() instanceof Label) {
            Label lable = (Label)evt.getSource();
            switch (lable.getKey()) {
                case "clicknew": {
                    this.newData();
                    break;
                }
                case "clickdelete": {
                    this.delData();
                }
            }
        }
    }

    private void newData() {
        this.showEditView();
    }

    private void showEditView() {
        this.showEditView(0L);
    }

    private void showEditView(long id) {
        Long accsysid = this.getAccsysId();
        FormShowParameter parameter = new FormShowParameter();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", String.valueOf(id));
        dataMap.put("accsysid", String.valueOf(accsysid));
        parameter.setCustomParams(dataMap);
        parameter.setFormId(BD_ACCOUNTINGSYSVIEWSCH);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeform"));
        this.getView().showForm(parameter);
    }

    private Long getAccsysId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("accsysid");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.refreshData();
    }

    private void delData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection collection = listView.getSelectedRows();
        if (collection.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"AccountingSysAddViewList_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        HashSet<Long> removeIds = new HashSet<Long>();
        StringBuilder builder = new StringBuilder();
        for (ListSelectedRow viewRow : collection) {
            Long viewId = (Long)viewRow.getPrimaryKeyValue();
            DynamicObject viewDyn = QueryServiceHelper.queryOne((String)BD_ACCOUNTINGSYSVIEWSCH, (String)"ismainview", (QFilter[])new QFilter("id", "=", (Object)viewId).toArray());
            if (viewDyn == null || !viewDyn.getBoolean("ismainview")) {
                removeIds.add(viewId);
                continue;
            }
            if (this.hasAccountBookRef(viewId, this.getAccsysId())) {
                builder.append(viewRow.getName()).append(",");
                continue;
            }
            removeIds.add(viewId);
        }
        DeleteServiceHelper.delete((String)BD_ACCOUNTINGSYSVIEWSCH, (QFilter[])new QFilter("id", "in", removeIds).toArray());
        DeleteServiceHelper.delete((String)BOS_ORG_VIEWSCHEMA, (QFilter[])new QFilter("id", "in", removeIds).toArray());
        DeleteServiceHelper.delete((String)BOS_ORG_STRUCTURE, (QFilter[])new QFilter("view", "in", removeIds).toArray());
        listView.refresh();
        list.clearSelection();
        String errorInfo = builder.toString();
        if (!errorInfo.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u89c6\u56fe\u201c%s\u201d\u5b58\u5728\u6838\u7b97\u4f53\u7cfb\u7684\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"AccountingSysAddViewList_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), errorInfo.substring(0, errorInfo.length() - 1)));
        }
        AccSysModelCacheService accSysModelCacheService = new AccSysModelCacheService();
        accSysModelCacheService.clear();
    }

    private boolean hasAccountBookRef(Long viewId, Long accsysId) {
        DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)"org", (QFilter[])new QFilter("view", "=", (Object)viewId).toArray());
        Set orgs = orgDyn.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
        QFilter orgFilter = new QFilter("org", "in", orgs);
        QFilter accsysFilter = new QFilter("accountingsys", "=", (Object)accsysId);
        return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])new QFilter[]{orgFilter, accsysFilter});
    }

    private void refreshData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        listView.refresh();
        list.clearSelection();
    }

    private void returnData() {
        IListView listView = (IListView)this.getView();
        Object selectPK = "";
        if (!listView.getCurrentListAllRowCollection().isEmpty()) {
            selectPK = listView.getSelectedRows().isEmpty() ? listView.getCurrentListAllRowCollection().get(0).getPrimaryKeyValue() : listView.getSelectedRows().get(0).getPrimaryKeyValue();
        }
        this.getView().returnDataToParent(selectPK);
        this.getView().close();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        HyperLinkClickEvent hyperLinkClickEvent = e.getHyperLinkClickEvent();
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        IListView view = (IListView)list.getView();
        String formId = view.getFormShowParameter().getFormId();
        if ("bd_accountingaddviewf7".equals(formId)) {
            e.setCancel(true);
            long pkid = (Long)((IListView)this.getView()).getFocusRowPkId();
            this.showEditView(pkid);
        }
    }
}

