/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accountoplog;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.BDUtil;

public class AccountOpLogList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(AccountOpLogList.class);
    private static final String DEFORG = "deforg";
    private static final String CACHEKEY_ACCOUNTTABLEID = "accTableId";

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Long customFilterOpOrgId = this.getCustomFilterId("oporg");
        Long customFilterTableId = this.getCustomFilterId("accounttable_id");
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilterList = (List)filterValues.get("customfilter");
        if (customfilterList != null && !customfilterList.isEmpty()) {
            for (Map filed : customfilterList) {
                String customFilterTableIdStr;
                String filedName = ((List)filed.get("FieldName")).get(0).toString();
                if (!"accounttable.id".equals(filedName)) continue;
                List fastlist = (List)filterValues.get("fastfilter");
                if (fastlist != null && !fastlist.isEmpty()) {
                    return;
                }
                if (((List)filed.get("Value")).isEmpty()) {
                    return;
                }
                IPageCache pageCache = this.getPageCache();
                if (customFilterOpOrgId == null) {
                    String deforg = this.getPageCache().get(DEFORG);
                    if (deforg == null) {
                        return;
                    }
                    customFilterOpOrgId = Long.valueOf(deforg);
                }
                String lastOrgId = pageCache.get("lastorgId");
                String curTable = customFilterTableIdStr = String.valueOf(customFilterTableId);
                if (lastOrgId != null && !lastOrgId.equals(String.valueOf(customFilterOpOrgId))) {
                    pageCache.put("lastorgId", String.valueOf(customFilterOpOrgId));
                    List<ComboItem> comboItems = this.getAccountTableComboItems(customFilterOpOrgId);
                    if (comboItems.isEmpty()) {
                        return;
                    }
                    boolean isContainTable = false;
                    for (ComboItem comboItem : comboItems) {
                        String value = comboItem.getValue();
                        if (!value.equals(customFilterTableIdStr)) continue;
                        isContainTable = true;
                        break;
                    }
                    if (!isContainTable) {
                        List values = (List)filed.get("Value");
                        values.clear();
                        curTable = comboItems.get(0).getValue();
                        values.add(curTable);
                    }
                }
                pageCache.put(CACHEKEY_ACCOUNTTABLEID, curTable);
            }
        }
    }

    private List<ComboItem> getAccountTableComboItems(long orgId) {
        IPageCache cache = this.getPageCache();
        String value = cache.get(AccountOpLogList.getTableComboItemKey(orgId));
        ArrayList<ComboItem> coms = new ArrayList();
        if (value == null) {
            List orgIds = BDUtil.getAllSuperiorOrgIds((Object)orgId, (boolean)true);
            if (!orgIds.isEmpty()) {
                try (DataSet tableSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id,name", (QFilter[])new QFilter("org", "in", (Object)orgIds).toArray(), null);){
                    while (tableSet.hasNext()) {
                        Row row = tableSet.next();
                        ComboItem com = new ComboItem(new LocaleString(row.getString("name")), String.valueOf(row.getLong("id")));
                        coms.add(com);
                    }
                }
            }
            cache.put(AccountOpLogList.getTableComboItemKey(orgId), SerializationUtils.serializeToBase64(coms));
        } else {
            coms = (List)SerializationUtils.deSerializeFromBase64((String)value);
        }
        return coms;
    }

    private static String getTableComboItemKey(long orgId) {
        return String.format("TableComboItem+%d", orgId);
    }

    private Long getCustomFilterId(String fieldName) {
        Long result = null;
        FilterContainerFilterValues filterValues = this.getFilterValue();
        if (filterValues == null) {
            return result;
        }
        FilterKeyValueCollections otherFilterValues = filterValues.getOtherFilterValues();
        if (otherFilterValues != null && otherFilterValues.getFilterKey().equalsIgnoreCase("customfilter")) {
            List filterValuesList = otherFilterValues.createFilterValuesList();
            for (Map map : filterValuesList) {
                List values;
                List name = (List)map.get("FieldName");
                if (!name.get(0).equals(fieldName) || (values = (List)map.get("Value")).isEmpty()) continue;
                String value = (String)values.get(0);
                if (StringUtils.isBlank((CharSequence)value)) {
                    return null;
                }
                result = Long.valueOf(value);
            }
        }
        return result;
    }

    private FilterContainerFilterValues getFilterValue() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        IPageCache pageCache = (IPageCache)filterContainer.getView().getService(IPageCache.class);
        String filterValueStr = pageCache.get("filtercontainerap_cachedFilterValues");
        if (filterValueStr == null) {
            return null;
        }
        return FilterContainerFilterValues.deSerialize((String)filterValueStr);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean customAndInital = this.isCustomAndInital();
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        for (CommonFilterColumn commFilter : listFilterColumns) {
            String fieldName;
            switch (fieldName = commFilter.getFieldName()) {
                case "oporg.name": {
                    String opOrgId = null;
                    String opOrgFilterId = (String)paramMap.get("oporg");
                    if (opOrgFilterId != null) {
                        if (!"".equals(opOrgFilterId) && !"0".equals(opOrgFilterId)) {
                            opOrgId = opOrgFilterId;
                        }
                        commFilter.setDefaultValue(opOrgId);
                    } else {
                        opOrgId = this.getPageCache().get("defaultOpOrg");
                        if (opOrgId != null) {
                            commFilter.setDefaultValue(opOrgId);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)this.getPageCache().get("is_First")) || opOrgId == null || customAndInital) {
                        opOrgId = ((ComboItem)commFilter.getComboItems().get(0)).getValue();
                        commFilter.setDefaultValue(opOrgId);
                    }
                    this.getPageCache().put("defaultOpOrg", opOrgId);
                    break;
                }
                case "accounttable.name": {
                    String accTableId = ((ComboItem)commFilter.getComboItems().get(0)).getValue();
                    commFilter.setDefaultValue(accTableId);
                    String accTableFilterId = (String)paramMap.get("oporg");
                    if (accTableFilterId != null) {
                        if (!"".equals(accTableFilterId) && !"0".equals(accTableFilterId)) {
                            accTableId = accTableFilterId;
                        }
                        commFilter.setDefaultValue(accTableId);
                    } else {
                        accTableId = this.getPageCache().get("defaultAccTable");
                        if (accTableId != null) {
                            commFilter.setDefaultValue(accTableId);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)this.getPageCache().get("is_First")) || accTableId == null || customAndInital) {
                        accTableId = ((ComboItem)commFilter.getComboItems().get(0)).getValue();
                        commFilter.setDefaultValue(accTableId);
                    }
                    this.getPageCache().put("defaultAccTable", accTableId);
                    break;
                }
                case "opaccountids.fbasedataid.number": {
                    QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get("defaultAccTable")));
                    qFilter.and("createorg_id", "=", (Object)Long.valueOf(this.getPageCache().get("defaultOpOrg")));
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, (String)"number");
                    HashSet<String> accountIds = new HashSet<String>(8);
                    for (Row row : dataSet) {
                        accountIds.add(row.getString("id"));
                    }
                    if (accountIds.isEmpty()) break;
                    commFilter.setDefaultValues(new ArrayList(accountIds));
                    break;
                }
            }
        }
        if (this.getPageCache().get("is_First") == null) {
            this.getPageCache().put("is_First", "false");
        }
    }

    private boolean isCustomAndInital() {
        if (!this.isMatchCondition()) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)this.getPageCache().get("is_First"));
    }

    private boolean isMatchCondition() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        boolean flag = false;
        String key = (String)paramMap.get("source");
        if (key != null) {
            switch (key) {
                case "AccountOpLogList": {
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        super.beforeCreateListDataProvider(e);
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection datas = super.getData(start, limit);
                try {
                    HashMap<Long, Long> accountMap = new HashMap<Long, Long>(8);
                    datas.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.accountname", String.class, (Object)""));
                    HashSet<String> allAccountIds = new HashSet<String>(8);
                    for (DynamicObject data : datas) {
                        if (StringUtils.isNotBlank((CharSequence)data.getString("entryentity.accountid"))) {
                            accountMap.put(data.getLong("entryentity.id"), Long.valueOf(data.getString("entryentity.accountid")));
                        }
                        allAccountIds.add(data.getString("requestid"));
                    }
                    ArrayList<JSONArray> allAccountDys = new ArrayList<JSONArray>(8);
                    if (!CollectionUtils.isEmpty(allAccountIds)) {
                        QFilter reFilter = new QFilter("requestid", "in", allAccountIds);
                        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"bd_account_oplog", (String)"newaccount,oldaccount", (QFilter[])new QFilter[]{reFilter});
                        for (DynamicObject dynamicObject : accountCollection) {
                            String noldAaccount;
                            String newAccount = dynamicObject.getString("newaccount");
                            if (StringUtils.isNotBlank((CharSequence)newAccount)) {
                                allAccountDys.add(JSONObject.parseArray((String)newAccount));
                            }
                            if (!StringUtils.isNotBlank((CharSequence)(noldAaccount = dynamicObject.getString("oldaccount")))) continue;
                            allAccountDys.add(JSONObject.parseArray((String)noldAaccount));
                        }
                    }
                    for (DynamicObject data : datas) {
                        boolean isChange = false;
                        if (!StringUtils.isBlank((Object)data.get("entryentity.number"))) {
                            isChange = true;
                            data.set("entryentity.accountid", data.get("entryentity.number"));
                        }
                        this.dealAccountAndNumber(allAccountDys, data, isChange);
                    }
                }
                catch (Exception e) {
                    log.error("deal with name and number for account exception :" + e.getMessage(), (Throwable)e);
                }
                return datas;
            }

            private void dealAccountAndNumber(List<JSONArray> allAccountDys, DynamicObject data, boolean isChange) throws IOException {
                for (JSONArray accountArray : allAccountDys) {
                    if (isChange || allAccountDys.isEmpty() || !StringUtils.isNotBlank((CharSequence)data.getString("entryentity.accountid"))) continue;
                    for (Object acc : accountArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)acc.toString());
                        Long accountid = jsonObject.getLong("id");
                        if (!data.getString("entryentity.accountid").equalsIgnoreCase(accountid.toString())) continue;
                        String fullName = " ";
                        try {
                            Map fullname = (Map)JSONUtils.cast((String)jsonObject.get((Object)"fullname").toString(), Map.class);
                            fullName = (String)fullname.get("zh_TW");
                        }
                        catch (Exception e) {
                            fullName = jsonObject.get((Object)"fullname").toString();
                        }
                        data.set("entryentity.accountid", (Object)fullName);
                        data.set("entryentity.number", (Object)jsonObject.getLong("number"));
                    }
                }
            }
        });
    }
}

