/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;

public class AccountRefAssgrpSettingPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(AccountRefAssgrpSettingPlugin.class);
    private static final String SEQ = "seq";
    private static final String MUSTINPUT = "mustinput";
    private static final String BASEVALUE_ID = "basevalue_id";
    private static final String TEXTVALUE = "textvalue";
    private static final String TEXT_PROP = "3";
    private static final String BTN_OK = "btnok";
    private static final String VALUESOURCE_NUMBER = "valuesource.number";
    private static final String BOS_ASSISTANTDATA_DETAIL = "bos_assistantdata_detail";
    private static final String BASEDATA_PROP = "1";
    private static final String VALUE_TYPE = "valuetype";
    private static final String ASSIST_TYPE = "assisttype";
    private static final String ENTRYE_NTITY = "entryentity";
    private static final String BASE_VALUE = "basevalue";
    private static final String PARAMS = "params";

    public void afterCreateNewData(EventObject e) {
        List params;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams || customParams.isEmpty() || null == customParams.get(PARAMS)) {
            return;
        }
        try {
            params = (List)JSONUtils.cast((String)customParams.get(PARAMS).toString(), List.class, (Class[])new Class[]{Object[].class});
        }
        catch (IOException exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            throw new KDBizException((Throwable)exp, BosErrorCode.systemError, new Object[0]);
        }
        this.setEntryData(params);
    }

    private void setEntryData(List<Object[]> params) {
        if (null == params || params.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYE_NTITY);
        int index = 0;
        int[] rows = model.batchCreateNewEntryRow(ENTRYE_NTITY, params.size());
        for (Object[] param : params) {
            model.setValue(ASSIST_TYPE, param[0], rows[index]);
            DynamicObject assistType = (DynamicObject)model.getValue(ASSIST_TYPE, rows[index]);
            if (null == assistType) continue;
            model.setValue(MUSTINPUT, param[1], rows[index]);
            String valuetype = assistType.getString(VALUE_TYPE);
            if (TEXT_PROP.equals(valuetype)) {
                model.setValue(TEXTVALUE, param[2], rows[index]);
            } else {
                this.dynamicRefreshBaseDataProp(this.getModel().getDataEntityType(), rows[index]);
                model.setValue(BASE_VALUE, param[2], rows[index]);
            }
            ++index;
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType entitytype = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)entitytype.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            throw new KDBizException((Throwable)exp, BosErrorCode.systemError, new Object[0]);
        }
        this.dynamicRefreshBaseDataProp(newMainType, this.getModel().getEntryCurrentRowIndex(ENTRYE_NTITY));
        e.setNewEntityType(newMainType);
    }

    private void dynamicRefreshBaseDataProp(MainEntityType newMainType, int entryRowIndex) {
        if (null == newMainType || entryRowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject assistType = (DynamicObject)model.getValue(ASSIST_TYPE, entryRowIndex);
        if (null == assistType || TEXT_PROP.equals(assistType.getString(VALUE_TYPE))) {
            return;
        }
        String baseEntityName = BASEDATA_PROP.equals(assistType.getString(VALUE_TYPE)) ? assistType.getString(VALUESOURCE_NUMBER) : BOS_ASSISTANTDATA_DETAIL;
        EntryProp entry = (EntryProp)newMainType.getProperty(ENTRYE_NTITY);
        BasedataProp baseValueProp = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(BASE_VALUE);
        baseValueProp.setBaseEntityId(baseEntityName);
        baseValueProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityName));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYE_NTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(BASE_VALUE);
        long orgId = this.getOrgId();
        if (orgId > 0L) {
            basedataEdit.addBeforeF7SelectListener(evt -> {
                String formId;
                DynamicObject assist;
                int[] selectRows;
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                String billFormId = list.getBillFormId();
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)billFormId, (Long)orgId);
                if (!Objects.isNull(baseDataFilter)) {
                    list.getListFilterParameter().getQFilters().add(baseDataFilter);
                }
                if ((selectRows = entryGrid.getSelectRows()).length > 0 && Objects.nonNull(assist = ((DynamicObject)this.getModel().getEntryEntity(ENTRYE_NTITY).get(selectRows[0])).getDynamicObject(ASSIST_TYPE)) && (formId = assist.getDynamicObject("valuesource").getString("number")).equals(BOS_ASSISTANTDATA_DETAIL)) {
                    long groupId = assist.getLong("assistanttype_id");
                    list.getListFilterParameter().getQFilters().add(new QFilter("group", "=", (Object)groupId));
                }
            });
        }
    }

    public void click(EventObject evt) {
        Button button;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equalsIgnoreCase((button = (Button)source).getKey())) {
            this.checkAndReturnDataToParaent();
        }
    }

    private void checkAndReturnDataToParaent() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYE_NTITY);
        HashMap<Long, Object> values = new HashMap<Long, Object>(entries.size());
        for (DynamicObject row : entries) {
            boolean valueNull;
            Object value;
            if (null == row || null == row.getDynamicObject(ASSIST_TYPE)) continue;
            DynamicObject assistType = row.getDynamicObject(ASSIST_TYPE);
            if (TEXT_PROP.equals(assistType.getString(VALUE_TYPE))) {
                value = row.getString(TEXTVALUE);
                valueNull = StringUtils.isBlank((Object)value);
            } else {
                value = row.get(BASEVALUE_ID);
                boolean bl = valueNull = StringUtils.isBlank((Object)value) || "0".equals(String.valueOf(value));
            }
            if (valueNull && row.getBoolean(MUSTINPUT)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\u503c\u3002", (String)"AccountRefAssgrpSettingPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), row.getString(SEQ)));
                return;
            }
            if (valueNull) continue;
            values.put(assistType.getLong("id"), value);
        }
        this.getView().returnDataToParent(values);
        this.getView().close();
    }

    private long getOrgId() {
        long orgId = 0L;
        IFormView parentView = this.getView().getParentView();
        if (!Objects.isNull(parentView)) {
            orgId = (Long)parentView.getModel().getValue("useorg_id");
        }
        return orgId;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if (this.getNonChange()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (BASE_VALUE.equals(propertyName) && null == changeData.getNewValue()) {
            this.rollBackValue(BASE_VALUE, changeData.getNewValue(), changeData.getRowIndex());
            return;
        }
    }

    private void rollBackValue(String key, Object value, int rowIndex) {
        this.setNonChange(Boolean.TRUE);
        this.getModel().setValue(key, value, rowIndex);
        this.getView().updateView(key, rowIndex);
        this.setNonChange(Boolean.FALSE);
    }

    private void setNonChange(Boolean booleanVal) {
        this.getPageCache().put("non-changed", booleanVal.toString());
    }

    private boolean getNonChange() {
        return Boolean.TRUE.toString().equals(this.getPageCache().get("non-changed"));
    }
}

