/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.format.UserFormatter;
import kd.fi.bd.formplugin.accounttableref.AccountTableRefEditManager;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ClickListener {
    private static final String SAVE = "save";
    private static final String ORG = "org";
    private static final String CALL_BACK_AUTO_MAPPING = "call_back_auto_mapping";
    private static final String CTRL_MAPPING_ENTRY_OPTIONS = "mappingentryoptions";
    private static final String BTN_AUTO_MAPPING = "automapping";
    private static final String UPDATE_ENTRY_ACC = "updateentry";
    private static final String DELETE_ENTRY = "deleteentry";
    private final UserFormatter userFormatter = new UserFormatter();
    private AccountTableRefEditManager manager;

    public void initialize() {
        super.initialize();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CTRL_MAPPING_ENTRY_OPTIONS});
        this.addClickListeners(new String[]{"assgrpdesc"});
        BasedataEdit oldAccountTable = (BasedataEdit)this.getView().getControl("oldacttable");
        oldAccountTable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit newAccountTable = (BasedataEdit)this.getView().getControl("newacttable");
        newAccountTable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit oldAccount = (BasedataEdit)this.getView().getControl("oldaccount");
        oldAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit newAccount = (BasedataEdit)this.getView().getControl("newaccount");
        newAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        long createOrgId = this.getManager().getCreateOrgId();
        if (createOrgId != this.getManager().getUseOrgId()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if (this.getManager().isEnable()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getManager().loadAllOldAssgrpInfo();
        this.getManager().loadAllNewAssgrpInfo();
        this.getManager().loadAllAssgrpDesc();
        long masterId = this.getManager().getMasterId();
        QFilter masterIdFilter = new QFilter("accountref.masterid", "=", (Object)masterId);
        if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])masterIdFilter.toArray())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"oldacttable"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"enabledate"});
        }
    }

    private void loadEntryInfo() {
        if (this.getManager().isEnable()) {
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            this.getManager().loadOldAccounts();
        }
        this.getManager().sortOldAccounts();
        this.getManager().loadAllOldAssgrpInfo();
        this.getManager().loadNewAcccounts();
        this.getManager().loadAllNewAssgrpInfo();
        this.getManager().loadAllAssgrpDesc();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals(SAVE)) {
            Save save;
            String reportPk;
            if (this.getManager().isPersonalizedModify()) {
                this.getManager().loadAllOldAssgrpInfo();
                this.getManager().loadAllNewAssgrpInfo();
            }
            if (StringUtils.isNotBlank((CharSequence)(reportPk = (save = (Save)e.getSource()).getOption().getVariableValue("op_report", "")))) {
                BillShowParameter bill = new BillShowParameter();
                bill.setFormId("bd_refop_report");
                bill.setPkId((Object)Long.parseLong(reportPk));
                bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)bill);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_AUTO_MAPPING.equals(key)) {
            long oldActTableId = this.getManager().getOldAccountTableId();
            if (oldActTableId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u79d1\u76ee\u8868\u3002", (String)"AccountTableRefEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            long newActTableId = this.getManager().getNewAccountTableId();
            if (newActTableId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u79d1\u76ee\u8868\u3002", (String)"AccountTableRefEdit_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            Date date = this.getManager().getDate();
            if (Objects.isNull(date)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u7528\u65e5\u671f\u3002", (String)"AccountTableRefEdit_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u91cd\u65b0\u5bf9\u7167\u5df2\u586b\u79d1\u76ee\uff1f", (String)"AccountTableRefEdit_3", (String)"fi-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_AUTO_MAPPING));
        }
        if (UPDATE_ENTRY_ACC.equals(key)) {
            this.loadEntryInfo();
        }
        if (DELETE_ENTRY.equals(key)) {
            IDataModel model = this.getModel();
            EntryGrid entryGrid = (EntryGrid)this.getControl("mappingentry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5206\u5f55\u6570\u636e\u3002", (String)"AccountTableRefEdit_14", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            model.deleteEntryRows("mappingentry", selectRows);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "assgrpdesc".equals(((TextEdit)source).getKey())) {
            this.showAssgrpSetting();
        }
    }

    /*
     * Exception decompiling
     */
    private void showAssgrpSetting() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map values;
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("bd_assgrprefsetting".equals(actionId) && (returnData = e.getReturnData()) instanceof Map && !(values = (Map)returnData).isEmpty()) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("mappingentry");
            DynamicObject entryRowDO = this.getModel().getEntryRowEntity("mappingentry", entryCurrentRowIndex);
            if (null != entryRowDO) {
                DynamicObjectCollection assgrpEntries = entryRowDO.getDynamicObjectCollection("assgrpentry");
                for (DynamicObject assgrpEntryRowDO : assgrpEntries) {
                    assgrpEntryRowDO.set("value", values.get(assgrpEntryRowDO.getLong("assisttype_id")));
                }
                entryRowDO.set("assgrpentry", (Object)assgrpEntries);
            }
            this.getManager().updateAssgrpDesc(entryCurrentRowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        this.beforeF7SelectManage(evt);
    }

    private void beforeF7SelectManage(BeforeF7SelectEvent evt) {
        Control control = (Control)evt.getSource();
        if (Objects.isNull(control)) {
            return;
        }
        String key = control.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFBuilder qfBuilder = null;
        switch (key) {
            case "oldacttable": {
                qfBuilder = this.oldAccountTableF7FilterBuilder();
                break;
            }
            case "newacttable": {
                qfBuilder = this.newAccountTableF7FilterBuilder();
                break;
            }
            case "newaccount": {
                listShowParameter.setMultiSelect(false);
                qfBuilder = this.newAccountF7FilterBuilder(evt);
                break;
            }
        }
        if (null != qfBuilder) {
            ListFilterParameter filterParam = listShowParameter.getListFilterParameter();
            filterParam.setQFilters(qfBuilder.toList());
        }
    }

    private QFBuilder newAccountF7FilterBuilder(BeforeF7SelectEvent evt) {
        long accountTableId = this.getManager().getNewAccountTableId();
        if (accountTableId <= 0L) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u79d1\u76ee\u8868\u3002", (String)"AccountTableRefEdit_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return null;
        }
        boolean isOnlyLeaf = false;
        DynamicObject oldAccount = this.getManager().getOldAccount(evt.getRow());
        if (!Objects.isNull(oldAccount)) {
            isOnlyLeaf = oldAccount.getBoolean("isleaf");
        }
        return AccountUtils.getAccountFilter((long)this.getManager().getUseOrgId(), (long)accountTableId, (Date)this.getManager().getDate(), (boolean)isOnlyLeaf, null);
    }

    private QFBuilder newAccountTableF7FilterBuilder() {
        return this.accountTableF7FilterBuilder();
    }

    private QFBuilder oldAccountTableF7FilterBuilder() {
        return this.accountTableF7FilterBuilder();
    }

    private QFBuilder accountTableF7FilterBuilder() {
        Long createOrgId = this.getManager().getUseOrgId();
        List superiorOrgIds = BDUtil.getAllSuperiorOrgIds((Object)createOrgId, (boolean)true);
        return new QFBuilder(ORG, "in", (Object)superiorOrgIds);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.getManager().getPropertyChanged()) {
            return;
        }
        this.propertyChangedManage(e.getChangeSet()[0], e.getProperty().getName());
    }

    private void propertyChangedManage(ChangeData changeData, String propertyName) {
        switch (propertyName) {
            case "enabledate": {
                this.dateChanged(changeData);
                break;
            }
            case "oldacttable": {
                this.oldAccountTableChanged();
                break;
            }
            case "newacttable": {
                this.newAccountTableChanged(changeData);
                break;
            }
            case "oldaccount": {
                this.oldAccountChanged(changeData);
                break;
            }
            case "newaccount": {
                this.newAccountChanged(changeData);
                break;
            }
            case "assgrpdesc": {
                this.newAssgrpdescChanged(changeData);
                break;
            }
        }
    }

    private void newAssgrpdescChanged(ChangeData changeData) {
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if (StringUtils.isEmpty((CharSequence)((String)newValue))) {
            if (StringUtils.isEmpty((CharSequence)((String)oldValue))) {
                return;
            }
            int entryCurrentRowIndex = changeData.getRowIndex();
            DynamicObject entryRowDO = this.getModel().getEntryRowEntity("mappingentry", entryCurrentRowIndex);
            if (null != entryRowDO) {
                DynamicObjectCollection assgrpEntries = entryRowDO.getDynamicObjectCollection("assgrpentry");
                for (DynamicObject assgrpEntryRowDO : assgrpEntries) {
                    assgrpEntryRowDO.set("value", null);
                }
                entryRowDO.set("assgrpentry", (Object)assgrpEntries);
            }
            this.getManager().updateAssgrpDesc(entryCurrentRowIndex);
        }
    }

    private void oldAccountChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        this.getManager().updateAssgrpSubEntry(rowIndex);
        this.getManager().loadOldAssgrpInfo(rowIndex);
        this.getManager().updateAssgrpDesc(rowIndex);
        this.getManager().updateIsMapping(rowIndex);
    }

    private void newAccountChanged(ChangeData changeData) {
        Object oldValue = changeData.getOldValue();
        DynamicObject originalNewAccount = (DynamicObject)oldValue;
        int rowIndex = changeData.getRowIndex();
        if (!this.getManager().getCheckVoucher() || this.getManager().getNewAccountModifyEnable(originalNewAccount)) {
            this.getManager().updateAssgrpSubEntry(rowIndex);
            this.getManager().loadNewAssgrpInfo(rowIndex);
            this.getManager().updateAssgrpDesc(rowIndex);
            this.getManager().updateIsMapping(rowIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u76ee\u6807\u79d1\u76ee\u542f\u7528\u65e5\u671f\u540e\uff0c\u51ed\u8bc1\u65e0\u6cd5\u4fee\u6539\u3002", (String)"AccountTableRefEdit_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            this.getManager().rollBackValue("newaccount", originalNewAccount, rowIndex);
        }
    }

    private void oldAccountTableChanged() {
        this.getManager().loadOldAccounts();
        this.getManager().sortOldAccounts();
        this.getManager().loadAllOldAssgrpInfo();
    }

    private void newAccountTableChanged(ChangeData changeData) {
        Object oldValue = changeData.getOldValue();
        DynamicObject originalNewTab = (DynamicObject)oldValue;
        if (!this.getManager().getCheckVoucher() || this.getManager().getNewTabModifyEnable(originalNewTab)) {
            this.getManager().loadNewAcccounts();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u76ee\u6807\u79d1\u76ee\u8868\u542f\u7528\u65e5\u671f\u540e\uff0c\u51ed\u8bc1\u65e0\u6cd5\u4fee\u6539\u3002", (String)"AccountTableRefEdit_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            this.getManager().rollBackValue("newacttable", originalNewTab);
        }
    }

    private void dateChanged(ChangeData changeData) {
        Object oldValue = changeData.getOldValue();
        Date originalDate = (Date)oldValue;
        if (!this.getManager().existsRecord()) {
            this.getManager().loadOldAccounts();
            this.getManager().sortOldAccounts();
            this.getManager().loadAllOldAssgrpInfo();
            this.getManager().loadNewAcccounts();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5bf9\u7167\u5173\u7cfb\u5b58\u5728\u542f\u7528\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4fee\u6539\u542f\u7528\u65e5\u671f\u3002", (String)"AccountTableRefEdit_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            this.getManager().rollBackValue("enabledate", originalDate);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getManager().setName(null);
        this.getManager().setNumber(null);
        this.getManager().getCacheManager().clear();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CALL_BACK_AUTO_MAPPING.equals(callBackId)) {
            MessageBoxResult result = evt.getResult();
            this.getManager().autoMapping(MessageBoxResult.Yes.equals((Object)result));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Map createOrgInfoMap = (Map)sourceData.get("createorg");
        String createOrgNumber = createOrgInfoMap.getOrDefault("number", "");
        DynamicObject createOrgDynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFBuilder("number", "=", (Object)createOrgNumber).toArray());
        if (null == createOrgDynObj) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AccountTableRefEdit_9", (String)"fi-bd-formplugin", (Object[])new Object[0]), createOrgNumber));
        }
        long createOrgId = createOrgDynObj.getLong("id");
        Map srcActTable = (Map)sourceData.get("oldacttable");
        Map tagActTable = (Map)sourceData.get("newacttable");
        String srcActTableNumber = srcActTable.getOrDefault("number", "");
        String tagActTableNumber = tagActTable.getOrDefault("number", "");
        Map accountTableDynObjMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accounttable", (String)"id", (QFilter[])new QFBuilder("number", "in", (Object)new String[]{srcActTableNumber, tagActTableNumber}).toArray());
        Map<String, Long> accountTableNumIdMap = accountTableDynObjMap.values().stream().collect(Collectors.toMap(x -> x.getString("number"), x -> x.getLong("id"), (oldVal, newVal) -> newVal));
        Long srcAccountTableId = accountTableNumIdMap.get(srcActTableNumber);
        if (null == srcAccountTableId) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u79d1\u76ee\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6e90\u79d1\u76ee\u8868\u3002", (String)"AccountTableRefEdit_10", (String)"fi-bd-formplugin", (Object[])new Object[0]), srcActTableNumber));
        }
        Long tagAccountTableId = accountTableNumIdMap.get(tagActTableNumber);
        if (null == tagAccountTableId) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u79d1\u76ee\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u79d1\u76ee\u8868\u3002", (String)"AccountTableRefEdit_11", (String)"fi-bd-formplugin", (Object[])new Object[0]), tagActTableNumber));
        }
        String enableDateStr = (String)sourceData.get("enabledate");
        if (StringUtils.isBlank((CharSequence)enableDateStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u542f\u7528\u65e5\u671f\u662f\u5426\u586b\u5199\u3002", (String)"AccountTableRefEdit_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        Date enableDate = this.userFormatter.parseDate(enableDateStr);
        List mappingInfoEntry = (List)sourceData.get("mappingentry");
        for (Map mappingInfo : mappingInfoEntry) {
            Map srcAccount = (Map)mappingInfo.get("oldaccount");
            String srcActNumber = (String)srcAccount.remove("number");
            Long srcAccountId = this.getAccountId(srcAccountTableId, createOrgId, enableDate, srcActNumber);
            srcAccount.put("id", srcAccountId);
            Map tagAccount = (Map)mappingInfo.get("newaccount");
            if (Objects.isNull(tagAccount)) continue;
            String tagActNumber = (String)tagAccount.remove("number");
            Long tagAccountId = this.getAccountId(tagAccountTableId, createOrgId, enableDate, tagActNumber);
            tagAccount.put("id", tagAccountId);
        }
    }

    private Long getAccountId(long accountTableId, long orgId, Date enableDate, String accountNumber) {
        HashMap<String, Long> accountIdNumMap = new HashMap<String, Long>(1);
        try (DataSet ds = AccountUtils.getAccountDataSet((long)orgId, (long)accountTableId, (Date)enableDate, (boolean)false, (QFilter)new QFilter("number", "=", (Object)accountNumber), (String[])new String[]{"number", "id"});){
            for (Row row : ds) {
                accountIdNumMap.put(row.getString("number"), row.getLong("id"));
            }
        }
        Long accountId = (Long)accountIdNumMap.get(accountNumber);
        if (accountId == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"AccountTableRefEdit_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), accountNumber));
        }
        return accountId;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entries = this.getManager().getEntries();
        HashMap<String, Set> entityNumbers = new HashMap<String, Set>(entries.size());
        ArrayList<String> entryErrorMsgList = new ArrayList<String>();
        for (DynamicObject entry : entries) {
            DynamicObjectCollection assgrpEntries = entry.getDynamicObjectCollection("assgrpentry");
            Iterator iterator = assgrpEntries.iterator();
            for (DynamicObject assgrpEntry : assgrpEntries) {
                DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                if (assistItem == null) {
                    entryErrorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u6838\u7b97\u7ef4\u5ea6\u914d\u7f6e\u7b2c%2$d\u884c\u6839\u636e\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u7f16\u7801\u627e\u5230\u591a\u4e2a\u6216\u672a\u627e\u5230\u5177\u4f53\u7684\u503c\u3002", (String)"AccountTableRefEdit_13", (String)"fi-bd-formplugin", (Object[])new Object[0]), entry.getInt("seq"), assgrpEntry.getInt("seq")));
                    continue;
                }
                String value = assgrpEntry.getString("value");
                String valueType = assistItem.getString("valuetype");
                if (!StringUtils.isNotBlank((CharSequence)value) || "3".equals(valueType)) continue;
                String entityId = "2".equals(valueType) ? "bos_assistantdata_detail" : assistItem.getString("valuesource.number");
                entityNumbers.compute(entityId, (k, v) -> {
                    if (null == v) {
                        v = new HashSet<String>(1);
                    }
                    v.add(value);
                    return v;
                });
            }
        }
        if (!entryErrorMsgList.isEmpty()) {
            throw new KDBizException(String.join((CharSequence)"\\n", entryErrorMsgList.toArray(new String[0])));
        }
        HashMap entityValues = new HashMap(entityNumbers.size());
        QFBuilder qfBuilder = new QFBuilder();
        for (Map.Entry entityNumber : entityNumbers.entrySet()) {
            qfBuilder.clear();
            qfBuilder.add("number", "in", entityNumber.getValue());
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)((String)entityNumber.getKey()), (Long)this.getManager().getCreateOrgId());
            if (!Objects.isNull(baseDataFilter)) {
                qfBuilder.add(baseDataFilter);
            }
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)((String)entityNumber.getKey()), (String)"number", (QFilter[])qfBuilder.toArray());
            Map<String, Long> pkNumbers = loadFromCache.entrySet().stream().collect(Collectors.toMap(x -> ((DynamicObject)x.getValue()).getString("number"), x -> Long.valueOf(x.getKey().toString())));
            entityValues.put(entityNumber.getKey(), pkNumbers);
        }
        for (DynamicObject entry : entries) {
            DynamicObjectCollection assgrpEntries = entry.getDynamicObjectCollection("assgrpentry");
            for (DynamicObject assgrpEntry : assgrpEntries) {
                DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                String value = assgrpEntry.getString("value");
                String valueType = assistItem.getString("valuetype");
                if (!StringUtils.isNotBlank((CharSequence)value) || "3".equals(valueType)) continue;
                String entityId = "2".equals(valueType) ? "bos_assistantdata_detail" : assistItem.getString("valuesource.number");
                Map singleEntityValues = (Map)entityValues.get(entityId);
                if (Objects.isNull(singleEntityValues)) {
                    assgrpEntry.set("value", (Object)"");
                    continue;
                }
                Long id = (Long)singleEntityValues.get(value);
                assgrpEntry.set("value", (Object)id);
            }
        }
    }

    private AccountTableRefEditManager getManager() {
        if (Objects.isNull(this.manager)) {
            this.manager = new AccountTableRefEditManager(this.getView(), this.getModel());
        }
        return this.manager;
    }
}

