/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.formplugin.accounttableref.AccountTableRefEditCacheManager;
import kd.fi.bd.formplugin.accounttableref.AccountTableRefVoucherHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefEditManager {
    private static final String IS_PERSONALIZE_DATA = "isPersonalizeData";
    private static final String NEW_ASSGRP = "newassgrp";
    private static final String OLD_ASSGRP = "oldassgrp";
    private static final String ID_SUFFIX = "_id";
    private static final String USEORG_ID = "useorg_id";
    private final IFormView view;
    private final IDataModel model;
    private final AccountTableRefEditCacheManager cacheManager;

    protected AccountTableRefEditManager(IFormView view, IDataModel model) {
        if (Objects.isNull(model) || Objects.isNull(view) || !view.getEntityId().equalsIgnoreCase("bd_accounttableref")) {
            throw new IllegalArgumentException();
        }
        this.view = view;
        this.model = model;
        this.cacheManager = new AccountTableRefEditCacheManager(view.getPageCache());
    }

    protected IFormView getView() {
        return this.view;
    }

    protected IDataModel getModel() {
        return this.model;
    }

    protected AccountTableRefEditCacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void setName(Object value) {
        this.setValue("name", value);
    }

    protected void setNumber(Object value) {
        this.setValue("number", value);
    }

    protected void setOldAssgrp(Object value, int index) {
        this.setValue(OLD_ASSGRP, value, index);
    }

    protected void setNewAccount(Object value, int index) {
        this.setValue("newaccount", value, index);
    }

    protected void setNewAssgrp(Object value, int index) {
        this.setValue(NEW_ASSGRP, value, index);
    }

    protected void setIsMappingFalse(int index) {
        this.setValue("ismapping", "0", index);
    }

    protected void setIsMappingTrue(int index) {
        this.setValue("ismapping", "1", index);
    }

    protected long getId() {
        return this.getModel().getDataEntity().getLong("id");
    }

    protected long getMasterId() {
        return (Long)this.getValue("masterid");
    }

    protected Date getDate() {
        return (Date)this.getValue("enabledate");
    }

    protected boolean isPersonalizedModify() {
        Object isPersonalizedModify = this.getView().getFormShowParameter().getCustomParam(IS_PERSONALIZE_DATA);
        if (Objects.isNull(isPersonalizedModify) || !(isPersonalizedModify instanceof Boolean)) {
            return false;
        }
        return (Boolean)isPersonalizedModify;
    }

    protected long getCreateOrgId() {
        if (this.isPersonalizedModify()) {
            return this.getUseOrgId();
        }
        return (Long)this.getValue("createorg_id");
    }

    protected long getUseOrgId() {
        IPageCache parentPageCache;
        String orgValue;
        IFormView parentView;
        String parentPageId;
        long useOrgId = (Long)this.getValue(USEORG_ID);
        if (useOrgId == 0L && StringUtils.isNotBlank((CharSequence)(parentPageId = this.getView().getFormShowParameter().getParentPageId())) && !Objects.isNull(parentView = this.getView().getViewNoPlugin(parentPageId)) && StringUtils.isNotBlank((CharSequence)(orgValue = (parentPageCache = parentView.getPageCache()).get("org")))) {
            return Long.parseLong(orgValue);
        }
        return useOrgId;
    }

    protected long getOldAccountTableId() {
        return this.getAccountTableId("oldacttable");
    }

    protected long getNewAccountTableId() {
        return this.getAccountTableId("newacttable");
    }

    protected DynamicObject getNewAccountTable() {
        return (DynamicObject)this.getValue("newacttable");
    }

    private long getAccountTableId(String accountTableFieldKey) {
        DynamicObject accountTableDO = (DynamicObject)this.getValue(accountTableFieldKey);
        return null == accountTableDO ? 0L : accountTableDO.getLong("id");
    }

    protected DynamicObject getOldAccount(int rowIndex) {
        return (DynamicObject)this.getValue("oldaccount", rowIndex);
    }

    protected DynamicObject getNewAccount(int rowIndex) {
        return (DynamicObject)this.getValue("newaccount", rowIndex);
    }

    protected DynamicObject getEntryRowEntity(int rowIndex) {
        return this.getModel().getEntryRowEntity("mappingentry", rowIndex);
    }

    protected DynamicObjectCollection getEntries() {
        return this.getModel().getEntryEntity("mappingentry");
    }

    protected void loadOldAccounts() {
        long orgId = this.getUseOrgId();
        long oldAccountTableId = this.getOldAccountTableId();
        Date date = this.getDate();
        if (orgId == 0L || oldAccountTableId == 0L || Objects.isNull(date)) {
            return;
        }
        List orgAccountDOs = AccountUtils.getAccountDOs((long)orgId, (long)oldAccountTableId, (Date)date, null, (String[])new String[]{"id", "masterid"});
        Map<Long, Long> master2id = orgAccountDOs.stream().collect(Collectors.toMap(x -> x.getLong("masterid"), x -> x.getLong("id"), (oldVal, newVal) -> newVal));
        DynamicObjectCollection entries = this.getEntries();
        int[] deleteRows = entries.stream().filter(x -> null == x.getDynamicObject("oldaccount") || !master2id.containsKey(x.getDynamicObject("oldaccount").getLong("masterid"))).mapToInt(x -> x.getInt("seq") - 1).toArray();
        for (DynamicObject row : entries) {
            long masterId;
            DynamicObject oldAccount = row.getDynamicObject("oldaccount");
            if (Objects.isNull(oldAccount) || !master2id.containsKey(masterId = oldAccount.getLong("masterid"))) continue;
            this.getModel().setValue("oldaccount", (Object)master2id.remove(masterId), row.getInt("seq") - 1);
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.deleteEntryRows("mappingentry", deleteRows);
        abstractFormDataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("oldaccount", new Object[0]);
        Collection<Long> values = master2id.values();
        for (Long id : values) {
            vs.addRow(new Object[]{id});
        }
        abstractFormDataModel.batchCreateNewEntryRow("mappingentry", vs);
        abstractFormDataModel.endInit();
        this.getView().updateView();
    }

    protected void sortOldAccounts() {
        DynamicObjectCollection mappingEntries = this.getEntries();
        mappingEntries.sort((x, y) -> {
            DynamicObject xOldAccount = x.getDynamicObject("oldaccount");
            DynamicObject yOldAccount = y.getDynamicObject("oldaccount");
            if (Objects.isNull(xOldAccount)) {
                return -1;
            }
            if (Objects.isNull(yOldAccount)) {
                return -1;
            }
            String xLongNumber = xOldAccount.getString("longnumber");
            String yLongNumber = yOldAccount.getString("longnumber");
            return xLongNumber.compareTo(yLongNumber);
        });
        int i = 1;
        for (DynamicObject entry : mappingEntries) {
            entry.set("seq", (Object)i++);
        }
        this.getModel().setValue("mappingentry", (Object)mappingEntries);
        this.getView().updateView();
    }

    protected void loadAllOldAssgrpInfo() {
        int entryRowCount = this.getModel().getEntryRowCount("mappingentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.loadOldAssgrpInfo(i);
        }
    }

    protected void loadAllNewAssgrpInfo() {
        int entryRowCount = this.getModel().getEntryRowCount("mappingentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.loadNewAssgrpInfo(i);
        }
    }

    protected void loadOldAssgrpInfo(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        this.setOldAssgrp(this.getAssgrpInfo(this.getOldAccount(rowIndex)), rowIndex);
    }

    protected void loadNewAssgrpInfo(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        this.setNewAssgrp(this.getAssgrpInfo(this.getNewAccount(rowIndex)), rowIndex);
    }

    private String getAssgrpInfo(DynamicObject account) {
        if (Objects.isNull(account)) {
            return "";
        }
        return String.join((CharSequence)"\\", (CharSequence[])account.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getString("asstactitem.name")).toArray(String[]::new));
    }

    protected void loadNewAcccounts() {
        this.setCheckVoucherFalse();
        long orgId = this.getUseOrgId();
        long newAccountTableId = this.getNewAccountTableId();
        Date date = this.getDate();
        if (orgId == 0L || newAccountTableId == 0L || Objects.isNull(date)) {
            return;
        }
        List orgAccountDOs = AccountUtils.getAccountDOs((long)orgId, (long)newAccountTableId, (Date)date, null, (String[])new String[]{"id", "masterid"});
        Map<Long, Long> master2id = orgAccountDOs.stream().collect(Collectors.toMap(x -> x.getLong("masterid"), x -> x.getLong("id"), (oldVal, newVal) -> newVal));
        DynamicObjectCollection entryEntity = this.getEntries();
        for (DynamicObject row : entryEntity) {
            DynamicObject newAccount = row.getDynamicObject("newaccount");
            if (Objects.isNull(newAccount)) continue;
            long masterId = newAccount.getLong("masterid");
            Long newAccountId = master2id.get(masterId) == null ? null : master2id.get(masterId);
            this.setNewAccount(newAccountId, row.getInt("seq") - 1);
        }
        this.getModel().updateCache();
        this.getView().updateView();
        this.setCheckVoucherTrue();
    }

    protected void updateAssgrpSubEntry(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObject entryRowEntity = this.getEntryRowEntity(rowIndex);
        if (null == entryRowEntity) {
            return;
        }
        DynamicObject oldAct = entryRowEntity.getDynamicObject("oldaccount");
        DynamicObject newAct = entryRowEntity.getDynamicObject("newaccount");
        DynamicObjectCollection assgrpEntries = entryRowEntity.getDynamicObjectCollection("assgrpentry");
        if (null != oldAct && null != newAct) {
            HashMap assgrpMap = new HashMap(assgrpEntries.size());
            Map<Long, Boolean> oldAssists2mustInput = oldAct.getDynamicObjectCollection("checkitementry").stream().collect(Collectors.toMap(x -> x.getLong("asstactitem_id"), x -> x.getBoolean("isrequire"), (oldVal, newVal) -> newVal));
            Map<Long, Boolean> newAssists2mustInput = newAct.getDynamicObjectCollection("checkitementry").stream().collect(Collectors.toMap(x -> x.getLong("asstactitem_id"), x -> x.getBoolean("isrequire"), (oldVal, newVal) -> newVal));
            newAssists2mustInput.forEach((assistId, mustInput) -> {
                Boolean oldMustInput = (Boolean)oldAssists2mustInput.get(assistId);
                if (Objects.isNull(oldMustInput) || !oldMustInput.booleanValue() && mustInput.booleanValue()) {
                    assgrpMap.put(assistId, mustInput);
                }
            });
            Iterator iterator = assgrpEntries.iterator();
            while (iterator.hasNext()) {
                DynamicObject assgrpRow = (DynamicObject)iterator.next();
                long assistId2 = assgrpRow.getLong("assisttype_id");
                Boolean mustInput2 = (Boolean)assgrpMap.get(assistId2);
                if (Objects.isNull(mustInput2)) {
                    iterator.remove();
                    continue;
                }
                assgrpMap.remove(assistId2);
                assgrpRow.set("mustinput", (Object)mustInput2);
            }
            for (Map.Entry entry : assgrpMap.entrySet()) {
                DynamicObject newRow = assgrpEntries.addNew();
                newRow.set("assisttype_id", entry.getKey());
                newRow.set("mustinput", entry.getValue());
            }
        } else {
            assgrpEntries.clear();
        }
        this.getView().setEnable(Boolean.valueOf(!assgrpEntries.isEmpty()), rowIndex, new String[]{"assgrpdesc"});
        entryRowEntity.set("assgrpentry", (Object)(assgrpEntries.isEmpty() ? null : assgrpEntries));
    }

    protected void updateAssgrpDesc(int rowIndex) {
        DynamicObject entryRowEntity = this.getEntryRowEntity(rowIndex);
        if (Objects.isNull(entryRowEntity)) {
            return;
        }
        DynamicObjectCollection assgrpEntries = entryRowEntity.getDynamicObjectCollection("assgrpentry");
        DynamicObject newAccDyn = entryRowEntity.getDynamicObject("newaccount");
        if (Objects.isNull(newAccDyn)) {
            this.setValue("assgrpdesc", "", rowIndex);
            return;
        }
        DynamicObjectCollection assistEntryColl = newAccDyn.getDynamicObjectCollection("checkitementry");
        Set<Long> assistIdSet = assistEntryColl.stream().map(x -> x.getLong("asstactitem.id")).collect(Collectors.toSet());
        if (assgrpEntries.isEmpty()) {
            this.setValue("assgrpdesc", "", rowIndex);
            return;
        }
        String desc = this.getDesc(assgrpEntries, assistIdSet);
        this.setValue("assgrpdesc", desc, rowIndex);
    }

    protected void loadAllAssgrpDesc() {
        int count = this.getModel().getEntryRowCount("mappingentry");
        for (int i = 0; i < count; ++i) {
            this.updateAssgrpDesc(i);
        }
    }

    private String getDesc(DynamicObjectCollection entries, Set<Long> assistIdSet) {
        StringBuilder sb = new StringBuilder();
        List assistTypeIds = entries.stream().map(x -> x.getLong("assisttype_id")).collect(Collectors.toList());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", assistTypeIds);
        Map assistTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"name", (QFilter[])qfBuilder.toArray());
        for (DynamicObject row : entries) {
            if (sb.length() > 50) break;
            Long assistTypeId = row.getLong("assisttype_id");
            if (assistIdSet != null && !assistIdSet.contains(assistTypeId)) continue;
            String name = row.getString("assisttype.name");
            if (StringUtils.isBlank((CharSequence)name)) {
                DynamicObject assistType = (DynamicObject)assistTypes.get(assistTypeId);
                if (Objects.isNull(assistType)) continue;
                name = assistType.getString("name");
            }
            sb.append(name);
            sb.append("\uff1a");
            String type = row.getString("assisttype.valuetype");
            String value = row.getString("value");
            String entityId = null;
            if ("1".equals(type)) {
                entityId = row.getString("assisttype.valuesource.id");
            } else if ("2".equals(type)) {
                entityId = "bos_assistantdata_detail";
            }
            if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((CharSequence)value)) {
                DynamicObject valFormDb = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"name, number", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(value)).toArray());
                value = Objects.isNull(valFormDb) ? "" : valFormDb.getString("number") + "-" + valFormDb.getString("name");
            }
            sb.append(value);
            sb.append("\uff1b");
        }
        if (sb.length() > 0) {
            return sb.length() > 50 ? sb.substring(0, 50) : sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    protected void updateIsMapping(int rowIndex) {
        long oldAccountTableId = this.getOldAccountTableId();
        if (oldAccountTableId <= 0L) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        DynamicObject oldAct = (DynamicObject)this.getModel().getValue("oldaccount", rowIndex);
        if (oldAct == null) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        DynamicObject newAct = (DynamicObject)this.getModel().getValue("newaccount", rowIndex);
        if (newAct == null) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        if (!oldAct.getString("longnumber").equals(newAct.getString("longnumber"))) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        if (!oldAct.getString("fullname").equals(newAct.getString("fullname"))) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        if (!oldAct.getBoolean("isleaf") == newAct.getBoolean("isleaf")) {
            this.setIsMappingFalse(rowIndex);
            return;
        }
        this.setIsMappingTrue(rowIndex);
    }

    protected void autoMapping(boolean isCover) {
        long orgId = this.getUseOrgId();
        long newActTableId = this.getNewAccountTableId();
        Date date = this.getDate();
        if (orgId == 0L || newActTableId == 0L || Objects.isNull(date)) {
            return;
        }
        DynamicObjectCollection mappingEntries = this.getEntries();
        List newAccountDOs = AccountUtils.getAccountDOs((long)orgId, (long)newActTableId, (Date)date, null, (String[])new String[]{"id", "longnumber", "fullname", "isleaf"});
        Map<String, DynamicObject> longNumber2newAccount = newAccountDOs.stream().collect(Collectors.toMap(x -> x.getString("longnumber"), x -> x, (oldVal, newVal) -> newVal));
        Map<String, DynamicObject> longNumberAndFullName2newAccount = newAccountDOs.stream().collect(Collectors.toMap(x -> x.getString("longnumber") + x.getString("fullname"), x -> x, (oldVal, newVal) -> newVal));
        for (DynamicObject mappingRow : mappingEntries) {
            DynamicObject oldAccount = mappingRow.getDynamicObject("oldaccount");
            if (oldAccount == null) continue;
            String oldActNumber = oldAccount.getString("longnumber");
            String oldActName = oldAccount.getString("fullname");
            DynamicObject newAccount = mappingRow.getDynamicObject("newaccount");
            if (!isCover && null != newAccount) continue;
            DynamicObject newAccountDO = longNumberAndFullName2newAccount.containsKey(oldActNumber + oldActName) ? longNumber2newAccount.get(oldActNumber) : longNumberAndFullName2newAccount.get(oldActNumber + oldActName);
            int seq = mappingRow.getInt("seq");
            if (null != newAccountDO && oldAccount.getBoolean("isleaf") == newAccountDO.getBoolean("isleaf")) {
                this.setNewAccount(newAccountDO.getLong("id"), seq - 1);
                continue;
            }
            this.setNewAccount(null, seq - 1);
        }
        this.getView().updateView();
    }

    protected void rollBackValue(String field, Object value) {
        this.setPropertyChangedFalse();
        this.setValue(field, value);
        this.setPropertyChangedTrue();
    }

    protected void rollBackValue(String field, Object value, int rowIndex) {
        this.setPropertyChangedFalse();
        this.setValue(field, value, rowIndex);
        this.setPropertyChangedTrue();
    }

    protected boolean isEnable() {
        String isEnableVal = this.getCacheManager().getIsEnableValue();
        if (StringUtils.isBlank((CharSequence)isEnableVal)) {
            long id = this.getId();
            boolean isEnable = false;
            if (id > 0L) {
                QFBuilder builder = new QFBuilder();
                builder.add("accountref", "=", (Object)id);
                builder.add("enablestatus", "in", (Object)new String[]{"C", "E"});
                isEnable = QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])builder.toArray());
                this.getCacheManager().setIsEnableValue(String.valueOf(isEnable));
            }
            return isEnable;
        }
        return Boolean.parseBoolean(isEnableVal);
    }

    protected boolean existsRecord() {
        String existsRecordVal = this.getCacheManager().getExistsRecordValue();
        if (StringUtils.isBlank((CharSequence)existsRecordVal)) {
            long id = this.getId();
            boolean existsRecord = false;
            if (id > 0L) {
                QFBuilder builder = new QFBuilder();
                builder.add("accountref", "=", (Object)id);
                existsRecord = QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])builder.toArray());
                this.getCacheManager().setExistsRecordValue(String.valueOf(existsRecord));
            }
            return existsRecord;
        }
        return Boolean.parseBoolean(existsRecordVal);
    }

    protected boolean getNewTabModifyEnable(DynamicObject originalAccountTable) {
        if (!this.existsRecord()) {
            this.setNewTabModifyEnable(Boolean.TRUE);
            return true;
        }
        String newAccountTableModifyEnableVal = this.getCacheManager().getNewAccountTableModifyEnable();
        if (StringUtils.isNotBlank((CharSequence)newAccountTableModifyEnableVal)) {
            return Objects.equals(Boolean.TRUE.toString(), newAccountTableModifyEnableVal);
        }
        if (Objects.isNull(originalAccountTable)) {
            this.setNewTabModifyEnable(Boolean.TRUE);
            return true;
        }
        boolean accountTableModifyEnable = AccountTableRefVoucherHelper.getAccountTableModifyEnable(this.getId(), this.getUseOrgId(), originalAccountTable.getLong("id"), this.getNewAccountMasterIds(), this.getDate());
        this.setNewTabModifyEnable(accountTableModifyEnable);
        return accountTableModifyEnable;
    }

    protected boolean getNewAccountModifyEnable(DynamicObject originalAccount) {
        if (!this.existsRecord()) {
            return true;
        }
        if (this.getNewTabModifyEnable(this.getNewAccountTable())) {
            return true;
        }
        if (Objects.isNull(originalAccount)) {
            return true;
        }
        return AccountTableRefVoucherHelper.getAccountModifyEnable(this.getId(), this.getUseOrgId(), originalAccount.getLong("masterid"), this.getNewAccountTableId(), this.getDate());
    }

    private List<Long> getNewAccountMasterIds() {
        return this.getEntries().stream().filter(x -> x.getDynamicObject("newaccount") != null).map(x -> x.getLong("newaccount.masterid")).collect(Collectors.toList());
    }

    protected void setNewTabModifyEnable(Boolean value) {
        this.getCacheManager().setNewAccountTableModifyEnable(value.toString());
    }

    protected boolean getCheckVoucher() {
        return this.existsRecord() && !Objects.equals(Boolean.FALSE.toString(), this.getCacheManager().getCheckVoucherValue());
    }

    protected void setCheckVoucherTrue() {
        this.getCacheManager().setCheckVoucherValue(Boolean.TRUE.toString());
    }

    protected void setCheckVoucherFalse() {
        this.getCacheManager().setCheckVoucherValue(Boolean.FALSE.toString());
    }

    protected boolean getPropertyChanged() {
        return !Objects.equals(Boolean.FALSE.toString(), this.getCacheManager().getPropertyChangedValue());
    }

    protected void setPropertyChangedTrue() {
        this.getCacheManager().setPropertyChangedValue(Boolean.TRUE.toString());
    }

    protected void setPropertyChangedFalse() {
        this.getCacheManager().setPropertyChangedValue(Boolean.FALSE.toString());
    }

    private void setValue(String field, Object value) {
        this.getModel().setValue(field, value);
    }

    private void setValue(String field, Object value, int index) {
        this.getModel().setValue(field, value, index);
    }

    private Object getValue(String field) {
        return this.getModel().getValue(field);
    }

    private Object getValue(String field, int index) {
        return this.getModel().getValue(field, index);
    }
}

