/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefList
extends AbstractListPlugin {
    private static final String BALTRANS = "baltrans";
    private static final String REFDELETE = "refdelete";
    private static final String REFREENABLE = "refreenable";
    private static final String OP_KEY = "op_key";
    private static final String ACCOUNT_TABLE_REF_ID = "accountTableRefId";
    private static final String ORG = "org";
    private static final String BD_REFOP_PROGRESS = "bd_refop_progress";
    private static final String REFDISABLE = "refdisable";
    private static final String REFENABLE = "refenable";
    private static final String DATE = "date";
    private static final String ENABLESTATUS = "enablestatus";
    private static final String CALL_BACK_REFOP = "call_back_refop";
    public static final String OP_DELETE = "delete";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        super.beforeCreateListDataProvider(e);
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                super.setListFields(listFields);
                List keys = listFields.stream().map(ListField::getFieldName).collect(Collectors.toList());
                if (!keys.contains("masterid")) {
                    ListField listField = new ListField("masterid");
                    listField.setFieldName("masterid");
                    listFields.add(listField);
                }
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection datas = super.getData(start, limit);
                datas.getDynamicObjectType().getProperties().add((Object)new DynamicSimpleProperty(AccountTableRefList.ENABLESTATUS, String.class, null));
                Map recordDynObjs = BusinessDataServiceHelper.loadFromCache((String)"bd_accttabref_record", (String)String.join((CharSequence)",", AccountTableRefList.ENABLESTATUS, "accountref.masterid", "enabledate"), (QFilter[])new QFilter(AccountTableRefList.ORG, "=", (Object)AccountTableRefList.this.getOrgId()).toArray());
                Map<Long, List<DynamicObject>> masterIdRecords = recordDynObjs.values().stream().collect(Collectors.groupingBy(x -> x.getLong("accountref.masterid")));
                block0: for (DynamicObject data : datas) {
                    data.set(AccountTableRefList.ENABLESTATUS, (Object)ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"AccountTableRefList_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    long masterId = data.getLong("masterid");
                    List<DynamicObject> records = masterIdRecords.get(masterId);
                    if (CollectionUtils.isEmpty(records)) continue;
                    for (DynamicObject record : records) {
                        Date dataDate;
                        Date recordDate = record.getDate("enabledate");
                        if (recordDate.compareTo(dataDate = data.getDate("enabledate")) != 0) continue;
                        String status = record.getString(AccountTableRefList.ENABLESTATUS);
                        if ("C".equals(status)) {
                            data.set(AccountTableRefList.ENABLESTATUS, (Object)ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"AccountTableRefList_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                            continue block0;
                        }
                        data.set(AccountTableRefList.ENABLESTATUS, (Object)ResManager.loadKDString((String)"\u672a\u542f\u7528", (String)"AccountTableRefList_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                        continue block0;
                    }
                }
                return datas;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_DELETE.equals(operateKey)) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            DeleteServiceHelper.delete((String)"bd_refop_report", (QFilter[])new QFBuilder("accttabref", "in", (Object)primaryKeyValues).toArray());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ((REFENABLE.equals(operateKey) || REFDISABLE.equals(operateKey) || REFREENABLE.equals(operateKey) || REFDELETE.equals(operateKey) || BALTRANS.equals(operateKey)) && e.getOperationResult().isSuccess()) {
            this.setOp(operateKey);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u8be5\u64cd\u4f5c\uff1f", (String)"AccountTableRefList_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_REFOP));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (CALL_BACK_REFOP.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            DynamicObject accountTableRefDO = this.getAccountTableRefDO();
            if (null == accountTableRefDO) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u6570\u636e\u3002", (String)"AccountTableRefList_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            long orgId = this.getOrgId();
            long createOrgId = accountTableRefDO.getLong("createorg_id");
            String operateKey = this.getOp();
            if (orgId != createOrgId && !BALTRANS.equals(operateKey)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u521b\u5efa\u7ec4\u7ec7\"%s\"\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AccountTableRefList_4", (String)"fi-bd-formplugin", (Object[])new Object[0]), accountTableRefDO.getString("createorg.name")));
                return;
            }
            Date date = accountTableRefDO.getDate("enabledate");
            String status = this.getEnableStatus(orgId, accountTableRefDO.getLong("masterid"), date);
            if (BALTRANS.equals(operateKey)) {
                if (!Objects.equals("C", status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5bf9\u7167\u5173\u7cfb\uff0c\u518d\u8fdb\u884c\u4f59\u989d\u7ed3\u8f6c\u3002", (String)"AccountTableRefList_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.isBizUnit(orgId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u7ec4\u7ec7\u8fdb\u884c\u4f59\u989d\u7ed3\u8f6c\u3002", (String)"AccountTableRefList_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            FormShowParameter form = new FormShowParameter();
            form.setFormId(BD_REFOP_PROGRESS);
            form.getOpenStyle().setShowType(ShowType.Modal);
            form.setCustomParam(ORG, (Object)orgId);
            form.setCustomParam(ACCOUNT_TABLE_REF_ID, (Object)accountTableRefDO.getLong("masterid"));
            form.setCustomParam(DATE, (Object)SerializationUtils.serializeToBase64((Object)date));
            form.setCustomParam(OP_KEY, (Object)operateKey);
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BD_REFOP_PROGRESS));
            this.getView().showForm(form);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (BD_REFOP_PROGRESS.equals(actionId) && !Objects.isNull(returnData)) {
            IListView view = (IListView)this.getView();
            view.refresh();
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId("bd_refop_report");
            bill.setPkId(returnData);
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)bill);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerAfterSearchClick(e);
        Object filterValue = e.getFilterValue("useorg.id");
        if (filterValue instanceof Long) {
            this.getPageCache().put(ORG, filterValue.toString());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters();
        String customfilterSer = this.getPageCache().get("customfilter");
        if (!Objects.isNull(customfilterSer)) {
            List customFilters = (List)SerializationUtils.fromJsonString((String)customfilterSer, ArrayList.class);
            for (Map customFiter : customFilters) {
                List orgIds;
                List fieldNames = (List)customFiter.get("FieldName");
                if (fieldNames == null || fieldNames.size() == 0 || !"useorg.id".equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0 || orgIds.get(0) == null) continue;
                this.getPageCache().put(ORG, orgIds.get(0).toString());
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        HashMap<String, Set> entityValues = new HashMap<String, Set>(queryValues.length);
        for (DynamicObject queryValue : queryValues) {
            DynamicObjectCollection entries = queryValue.getDynamicObjectCollection("mappingentry");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection assgrpEntries = entry.getDynamicObjectCollection("assgrpentry");
                for (DynamicObject assgrpEntry : assgrpEntries) {
                    DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                    String value = assgrpEntry.getString("value");
                    String valueType = assistItem.getString("valuetype");
                    if (!StringUtils.isNotBlank((CharSequence)value) || "3".equals(valueType)) continue;
                    String entityId = "2".equals(valueType) ? "bos_assistantdata_detail" : assistItem.getString("valuesource.number");
                    entityValues.compute(entityId, (k, v) -> {
                        if (null == v) {
                            v = new HashSet<Long>(1);
                        }
                        v.add(Long.valueOf(value));
                        return v;
                    });
                }
            }
        }
        HashMap entityNumbers = new HashMap(entityValues.size());
        QFBuilder qfBuilder = new QFBuilder();
        for (Map.Entry entityValue : entityValues.entrySet()) {
            qfBuilder.clear();
            qfBuilder.add("id", "in", entityValue.getValue());
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)((String)entityValue.getKey()), (String)"number", (QFilter[])qfBuilder.toArray());
            Map<Long, String> pkNumbers = loadFromCache.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), x -> ((DynamicObject)x.getValue()).getString("number")));
            entityNumbers.put(entityValue.getKey(), pkNumbers);
        }
        for (DynamicObject queryValue : queryValues) {
            DynamicObjectCollection entries = queryValue.getDynamicObjectCollection("mappingentry");
            for (DynamicObject entry : entries) {
                DynamicObjectCollection assgrpEntries = entry.getDynamicObjectCollection("assgrpentry");
                for (DynamicObject assgrpEntry : assgrpEntries) {
                    DynamicObject assistItem = assgrpEntry.getDynamicObject("assisttype");
                    String value = assgrpEntry.getString("value");
                    String valueType = assistItem.getString("valuetype");
                    if (!StringUtils.isNotBlank((CharSequence)value) || "3".equals(valueType)) continue;
                    String entityId = "2".equals(valueType) ? "bos_assistantdata_detail" : assistItem.getString("valuesource.number");
                    Map singleEntityNumbers = (Map)entityNumbers.get(entityId);
                    if (Objects.isNull(singleEntityNumbers)) {
                        assgrpEntry.set("value", (Object)"");
                        continue;
                    }
                    String number = (String)singleEntityNumbers.get(Long.valueOf(value));
                    assgrpEntry.set("value", (Object)number);
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if ("bar_individuation".equals(itemkey)) {
            List useOrgIds;
            if (rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccountTableRefList_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u540c\u65f6\u5bf9\u591a\u4e2a\u79d1\u76ee\u8868\u7248\u672c\u5316\u65b9\u6848\u7ef4\u62a4\u4e2a\u6027\u5316\u6570\u636e\u3002", (String)"AccountTableRefList_8", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            Object accountRefId = rows.getPrimaryKeyValues()[0];
            if (AccountTableRefList.checkCurrRefEnable(accountRefId, useOrgIds = this.getSelectedMainOrgIds())) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ef4\u62a4\u4e2a\u6027\u6570\u636e\uff0c\u8bf7\u5148\u53cd\u542f\u7528\u3002", (String)"AccountTableRefList_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected static boolean checkCurrRefEnable(Object accountRefId, List<Long> useOrgIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select top 1 a.fid from t_bd_accounttableref a ", new Object[0]);
        sqlBuilder.append("  inner join t_bd_accttabref_record b ", new Object[0]);
        sqlBuilder.append(" on a.fmasterid = b.faccountrefid where ", new Object[0]);
        sqlBuilder.append(" a.fid = ? ", new Object[]{accountRefId});
        sqlBuilder.append(" and b.forgid = ? ", new Object[]{useOrgIds.get(0)});
        sqlBuilder.appendIn(" and b.fenablestatus ", (Object[])new String[]{"C", "E"});
        try (DataSet dataSet = DB.queryDataSet((String)AccountTableRefList.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            boolean bl = dataSet.hasNext();
            return bl;
        }
    }

    private long getOrgId() {
        String orgValue = this.getPageCache().get(ORG);
        if (StringUtils.isNotBlank((CharSequence)orgValue)) {
            return Long.parseLong(orgValue);
        }
        return 0L;
    }

    private DynamicObject getAccountTableRefDO() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (!selectedRows.isEmpty()) {
            Object pk = selectedRows.get(0).getPrimaryKeyValue();
            return BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bd_accounttableref", (String)String.join((CharSequence)",", "id", "enabledate", "createorg", "masterid"));
        }
        return null;
    }

    private String getEnableStatus(long orgId, long accountTableRefMasterId, Date date) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "=", (Object)orgId);
        qfBuilder.add("enabledate", "=", (Object)date);
        qfBuilder.add("accountref.masterid", "=", (Object)accountTableRefMasterId);
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accttabref_record", (String)ENABLESTATUS, (QFilter[])qfBuilder.toArray());
        if (Objects.isNull(record)) {
            return "";
        }
        return record.getString(ENABLESTATUS);
    }

    private boolean isBizUnit(long orgId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("isbizunit", "=", (Object)true);
        qfBuilder.add(ORG, "=", (Object)orgId);
        return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qfBuilder.toArray());
    }

    private String getOp() {
        return this.getPageCache().get(OP_KEY);
    }

    private void setOp(String op) {
        this.getPageCache().put(OP_KEY, op);
    }
}

