/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefVoucherHelper {
    private AccountTableRefVoucherHelper() {
    }

    protected static boolean getAccountTableModifyEnable(long id, long createOrgId, long newAccountTableId, List<Long> newAccountMasterIds, Date date) {
        if (id <= 0L) {
            return true;
        }
        if (newAccountMasterIds.isEmpty()) {
            return true;
        }
        if (date == null) {
            return true;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accountref", "=", (Object)id);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bd_accttabref_record", (String)"org", (QFilter[])qfBuilder.toArray());
        List orgIds = records.stream().map(x -> x.getLong("org")).collect(Collectors.toList());
        if (orgIds.isEmpty()) {
            return true;
        }
        qfBuilder.clear();
        qfBuilder.add("org", "in", orgIds);
        qfBuilder.add("entries.account.masterid", "in", newAccountMasterIds);
        QFilter largeDate = new QFilter("bookeddate", ">", (Object)date);
        QFilter equalsDate = new QFilter("bookeddate", "=", (Object)date).and(new QFilter("period.isadjustperiod", "=", (Object)Character.valueOf('1')));
        qfBuilder.add(equalsDate.or(largeDate));
        return !QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])qfBuilder.toArray());
    }

    protected static boolean getAccountModifyEnable(long id, long createOrgId, long newAccountMasterId, long newAccountTableId, Date date) {
        if (id <= 0L) {
            return true;
        }
        if (newAccountMasterId <= 0L) {
            return true;
        }
        if (date == null) {
            return true;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accountref", "=", (Object)id);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bd_accttabref_record", (String)"org", (QFilter[])qfBuilder.toArray());
        List orgIds = records.stream().map(x -> x.getLong("org")).collect(Collectors.toList());
        if (orgIds.isEmpty()) {
            return true;
        }
        qfBuilder.clear();
        qfBuilder.add("org", "in", orgIds);
        qfBuilder.add("entries.account.masterid", "=", (Object)newAccountMasterId);
        QFilter largeDate = new QFilter("bookeddate", ">", (Object)date);
        QFilter equalsDate = new QFilter("bookeddate", "=", (Object)date).and(new QFilter("period.isadjustperiod", "=", (Object)Character.valueOf('1')));
        qfBuilder.add(equalsDate.or(largeDate));
        return !QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])qfBuilder.toArray());
    }
}

