/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.bdctrl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.AssignHandle;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.formplugin.bdctrl.dataset.AccountData;
import kd.fi.bd.formplugin.bdctrl.dataset.AssignAcctGroup;
import kd.fi.bd.interfaces.service.IAccountAssignService;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;

public class AssignPlugin
extends AbstractListPlugin
implements TreeNodeQueryListener,
SearchEnterListener,
TreeNodeCheckListener,
ProgresssListener {
    private static Log logger = LogFactory.getLog(AssignPlugin.class);
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String _CTRLSTRATEGY = "_ctrlstrategy";
    public static final String USEORGID = "useOrgId";
    private static final String BILLLISTAP = "billlistap";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ALLORGLIST_KEY = "allOrgListKey";
    private static final String PROGRESSBARAP = "progressbarap";
    public static final String TREEVIEW = "treeviewap";
    private static final String ASSIGN_QUERY_CALLBACK = "assignQueryCallBack";
    private Long useOrgId = null;
    private static final String ASIGNEDDATAS = "asignedDatas";
    private static final String ASIGNEDORGS = "asignedOrgs";

    public void initialize() {
        super.initialize();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tvLeft.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        final String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        billList.setBillFormId(entityNumber);
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        billList.getFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
        this.addClickListeners(new String[]{"btn_assign", "btn_assign_query"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
                IDataEntityType dataEntityType = ORM.create().getDataEntityType(entityNumber);
                if (dataEntityType instanceof BasedataEntityType) {
                    BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
                    if (2 == basedataEntityType.getMasteridType()) {
                        beforeCreateListColumnsArgs.getListColumn("name").setVisible(0);
                        beforeCreateListColumnsArgs.getListColumn("number").setVisible(0);
                    } else {
                        beforeCreateListColumnsArgs.getListColumn("masterid.name").setVisible(0);
                        beforeCreateListColumnsArgs.getListColumn("masterid.number").setVisible(0);
                    }
                }
            }
        });
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap<String, Boolean> treeParams = new HashMap<String, Boolean>();
        treeParams.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(TREEVIEW, treeParams);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.selectAllRows();
        billList.refreshData();
        billList.getView().sendFormAction(billList.getView());
    }

    public void afterCreateNewData(EventObject evt) {
        super.initialize();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (null == ctrlView) {
            return;
        }
        List<TreeNode> orgList = this.getAllOrg(ctrlView);
        if (!CollectionUtils.isEmpty(orgList)) {
            this.getView().getPageCache().putBigObject(ALLORGLIST_KEY, SerializationUtils.toJsonString(orgList));
        }
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        if (null == this.useOrgId) {
            if (this.getView().getFormShowParameter().getCustomParam(USEORGID) instanceof Integer) {
                this.useOrgId = ((Integer)this.getView().getFormShowParameter().getCustomParam(USEORGID)).longValue();
            } else if (this.getView().getFormShowParameter().getCustomParam(USEORGID) instanceof Long) {
                this.useOrgId = (Long)this.getView().getFormShowParameter().getCustomParam(USEORGID);
            }
        }
        DynamicObject data = QueryServiceHelper.queryOne((String)entityNumber, (String)"id, createorg, org, ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("id", "=", ids.get(0))});
        String ctrlType = data.getString(CTRLSTRATEGY);
        this.getPageCache().put(this.getView().getPageId() + _CTRLSTRATEGY, data.getString(CTRLSTRATEGY));
        Long viewId = (Long)ctrlView.getPkValue();
        if ("2".equals(ctrlType)) {
            this.initCUFreeAssignTree(viewId);
            return;
        }
        try {
            this.initCUAssignTree(this.useOrgId, viewId);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private List<TreeNode> getAllOrg(DynamicObject ctrlView) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get("number")));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (null == rootNode) {
            return Collections.emptyList();
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = ?;", new Object[]{ctrlView.getPkValue()});
        Set allCtrlUintOrgIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashSet<String> result = new HashSet<String>(16);
            while (rs.next()) {
                result.add(rs.getString("forgid"));
            }
            return result;
        });
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        if (allCtrlUintOrgIds.contains(rootNode.getId())) {
            rootNode.setChildren(rootNodeChildList);
            nodeList.add(rootNode);
        }
        if (CollectionUtils.isEmpty((Collection)allChildOrgNodeList)) {
            return nodeList;
        }
        ArrayList<TreeNode> cuOrgChildNodeList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        for (TreeNode node : allChildOrgNodeList) {
            if (!allCtrlUintOrgIds.contains(node.getId())) continue;
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                ArrayList<TreeNode> tempChildOrgList = new ArrayList<TreeNode>(children.size());
                for (TreeNode childrenNode : children) {
                    if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                    tempChildOrgList.add(childrenNode);
                }
                if (tempChildOrgList.size() > 0) {
                    node.setChildren(tempChildOrgList);
                } else {
                    node.setChildren(null);
                }
            }
            if (node.getParentid().equals(rootNode.getId())) {
                rootNodeChildList.add(node);
            }
            nodeList.add(node);
            cuOrgChildNodeList.add(node);
        }
        this.getChildNode(cuOrgChildNodeList, nodeList, allCtrlUintOrgIds);
        return nodeList;
    }

    private void getChildNode(List<TreeNode> orgChildrenTreeData, List<TreeNode> allOrgs, Set<String> allCtrlUintOrgIds) {
        for (TreeNode node : orgChildrenTreeData) {
            List childNode = node.getChildren();
            if (null == childNode || childNode.isEmpty()) continue;
            ArrayList<TreeNode> tempChildOrgs = new ArrayList<TreeNode>(node.getChildren().size());
            for (TreeNode childrenNode : node.getChildren()) {
                if (!allCtrlUintOrgIds.contains(childrenNode.getId())) continue;
                allOrgs.add(childrenNode);
                tempChildOrgs.add(childrenNode);
            }
            if (tempChildOrgs.size() > 0) {
                node.setChildren(tempChildOrgs);
            } else {
                node.setChildren(null);
            }
            this.getChildNode(childNode, allOrgs, allCtrlUintOrgIds);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btn_assign")) {
            this.assign();
        } else if (control.getKey().equals("btn_assign_query")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ASIGNEDDATAS, this.getPageCache().get(this.getView().getPageId() + ASIGNEDDATAS));
            params.put(ASIGNEDORGS, this.getPageCache().get(this.getView().getPageId() + ASIGNEDORGS));
            params.put(USEORGID, this.getView().getFormShowParameter().getCustomParam(USEORGID));
            params.put(ENTITY_NUMBER, this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER));
            params.put("accTableId", this.getView().getFormShowParameter().getCustomParam("accTableId"));
            CloseCallBack assignQueryCallBack = new CloseCallBack((IFormPlugin)this, ASSIGN_QUERY_CALLBACK);
            this.showForm("bd_v_assign_query_new", params, assignQueryCallBack, ShowType.Modal);
        }
    }

    private void assign() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (col.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6570\u636e", (String)"AssignPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> dataIDs = new ArrayList<Long>();
        for (ListSelectedRow row : col) {
            dataIDs.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        List orgIDs = treeView.getTreeState().getCheckedNodeIds();
        if (orgIDs.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"AssignPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        String useOrgID = this.getView().getFormShowParameter().getCustomParam(USEORGID).toString();
        if (orgIDs.contains(useOrgID)) {
            if (orgIDs.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"AssignPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            orgIDs.remove(useOrgID);
        }
        ArrayList<Long> dataIDsTemp = new ArrayList<Long>(dataIDs.size());
        dataIDsTemp.addAll(dataIDs);
        this.getPageCache().put(this.getView().getPageId() + ASIGNEDDATAS, SerializationUtils.toJsonString(dataIDsTemp));
        this.getPageCache().put(this.getView().getPageId() + ASIGNEDORGS, SerializationUtils.toJsonString((Object)orgIDs));
        ArrayList<Long> orgIds = new ArrayList<Long>(orgIDs.size());
        for (String orgID : orgIDs) {
            orgIds.add(Long.valueOf(orgID));
        }
        String selectFields = "number,isleaf,level,longnumber,accounttable";
        QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", dataIDs)};
        DynamicObjectCollection dyCol = QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])qfArr);
        if (dyCol.isEmpty()) {
            return;
        }
        long accountTableId = ((DynamicObject)dyCol.get(0)).getLong("accounttable");
        HashSet<String> leafNumberSet = new HashSet<String>(dyCol.size());
        HashSet<String> allNumberSet = new HashSet<String>(dyCol.size());
        ArrayList<AssignAcctGroup> acctGroups = new ArrayList<AssignAcctGroup>(10);
        HashSet<String> firstNums = new HashSet<String>(10);
        for (DynamicObject acctObj : dyCol) {
            firstNums.add(acctObj.getString("longnumber").split("_")[0]);
        }
        for (String firstNum : firstNums) {
            AssignAcctGroup group = new AssignAcctGroup();
            group.setNumber(firstNum);
            acctGroups.add(group);
        }
        for (DynamicObject acctObj : dyCol) {
            allNumberSet.add(acctObj.getString("number"));
            if (!acctObj.getBoolean("isleaf")) continue;
            leafNumberSet.add(acctObj.getString("number"));
        }
        for (String num : allNumberSet) {
            boolean isContain = false;
            for (String leafNum : leafNumberSet) {
                if (!leafNum.startsWith(num, 0)) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u79d1\u76ee\u8981\u5305\u542b\u5230\u660e\u7ec6\u79d1\u76ee\uff0c\u5f53\u524d\u79d1\u76ee%s\u672a\u5305\u542b\u660e\u7ec6\u79d1\u76ee\u3002", (String)"AccountTreeListPlugin_30", (String)"fi-bd-formplugin", (Object[])new Object[0]), num);
            this.getView().showTipNotification(msg);
            return;
        }
        for (DynamicObject acctObj : dyCol) {
            for (AssignAcctGroup group : acctGroups) {
                if (!acctObj.getString("longnumber").startsWith(group.getNumber())) continue;
                group.setLevel(Math.max(group.getLevel(), acctObj.getInt("level")));
                group.getSubNums().add(acctObj.getString("number"));
            }
        }
        this.dealAssignData(acctGroups, Long.parseLong(useOrgID), accountTableId, allNumberSet);
        for (AssignAcctGroup group : acctGroups) {
            for (AccountData data : group.getMastermap().values()) {
                if (data.getNums().size() <= 1) continue;
                if (allNumberSet.contains(data.getNums().get(0)) && !allNumberSet.contains(data.getNumber()) && !this.existAcct(orgIds, accountTableId, data.getMasterId(), data.getNumber())) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5fc5\u987b\u5206\u914d\u7b2c\u4e00\u4e2a\u4f59\u989d\u7ed3\u8f6c\u4e0b\u7ea7\u79d1\u76ee:%s\u3002", (String)"AssignPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]), data.getNumber());
                    this.getView().showTipNotification(msg);
                    return;
                }
                HashSet<String> targetOrgNumbers = new HashSet<String>(10);
                ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(1);
                otherFilters.add(new QFilter("masterid", "=", (Object)data.getMasterId()));
                try (DataSet ds = AccountUtils.queryAccountDataSet(new HashSet<Long>(orgIds), (long)accountTableId, (String)"number,masterid", otherFilters, null);){
                    for (Row row : ds) {
                        targetOrgNumbers.add(row.getString("number"));
                    }
                }
                if (targetOrgNumbers.size() <= 0 || data.getNums().containsAll(targetOrgNumbers)) continue;
                targetOrgNumbers.removeAll(data.getNums());
                ArrayList nums = new ArrayList(targetOrgNumbers);
                nums.sort((a, b) -> a.length() > b.length() ? 1 : -1);
                ArrayList<QFilter> existsNumberFilters = new ArrayList<QFilter>(2);
                existsNumberFilters.add(new QFilter("masterid", "=", (Object)data.getMasterId()));
                existsNumberFilters.add(new QFilter("number", "=", nums.get(nums.size() - 1)));
                for (Long orgId : orgIds) {
                    if (!AccountUtils.existUseRangeAccountByOrg((long)orgId, (long)accountTableId, existsNumberFilters)) continue;
                    String useOrgName = BDUtil.getOrgById((long)orgId).getString("name");
                    String msg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u7ed3\u8f6c\u79d1\u76ee:%1$s \u5728\u88ab\u5206\u914d\u7ec4\u7ec7:%2$s \u4e2d\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e0d\u540c\u7684\u4f59\u989d\u7ed3\u8f6c\u79d1\u76ee:%3$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AssignPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]), data.getNumber(), useOrgName, nums.get(nums.size() - 1));
                    this.getView().showTipNotification(msg);
                    return;
                }
            }
        }
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle(dataIDs.get(0), (String)"bd_accountview");
        String lockKey = "assignlock" + accountObj.getLong("accounttable_id");
        DLockInfo lockInfo = DLock.getLockInfo((String)lockKey);
        if (lockInfo != null) {
            this.getView().showTipNotification(lockInfo.getDesc());
            return;
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5206\u914d", "AccountTreeListPlugin_9", "fi-bd-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5f00\u59cb\u5206\u914d\u79d1\u76ee", "CalLogUtils_1", "fi-cal-common");
        new OpLogHelper().addOperateLog(this.getView(), Long.parseLong(useOrgID), "", "assign", opNameBridge, opDescBridge, new String[]{""});
        ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u7b49...", (String)"AssignPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        this.getPageCache().put("mark", "start");
        AssignCtx ctx = new AssignCtx(Long.valueOf(Long.parseLong(useOrgID)), orgIds, dataIDs, accountObj.getString(CTRLSTRATEGY));
        String requestId = RequestContext.getOrCreate().getRequestId();
        ThreadService.execute(() -> {
            RequestContext.getOrCreate().setRequestId(requestId);
            if (AccountVersionUtil.isUseNewAssignMethodSystemProperty()) {
                IAccountAssignService accountAssignService = (IAccountAssignService)BDGLServiceFactory.getService((String)"IAccountAssignService");
                AssignResult assignResult = accountAssignService.doAssign(Long.parseLong(useOrgID), orgIds, dataIDs);
                this.getView().getPageCache().put("mark", "finish");
                if (AssignResult.ResultType.success != assignResult.getResultType()) {
                    this.getView().getPageCache().put("msg", assignResult.getMsgs().isEmpty() ? null : JSONObject.toJSONString((Object)assignResult.getMsgs()));
                }
            } else {
                new AssignHandle(ctx, this.getView()).handle();
            }
        }, (TaskType)TaskType.FIBD_ACCOUNT_ASSIGN_ASYNC_TASK);
    }

    private void dealAssignData(List<AssignAcctGroup> acctGroup, long orgId, long accountTableId, Set<String> allNumberSet) {
        try (DataSet ds = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"number,masterid,longnumber,level", null);){
            for (Row row : ds) {
                for (AssignAcctGroup group : acctGroup) {
                    int level = group.getLevel();
                    long masterId = row.getLong("masterid");
                    if (!row.getString("longnumber").startsWith(group.getNumber()) || row.getInteger("level") > level) continue;
                    AccountData data = group.getMastermap().get(masterId);
                    String number = row.getString("number");
                    if (Objects.isNull(data)) {
                        data = new AccountData();
                        data.getNums().add(number);
                        data.setNumber(number);
                        data.setMasterId(masterId);
                        group.getMastermap().put(masterId, data);
                        continue;
                    }
                    if (data.getNumber().equals(number)) continue;
                    data.getNums().add(number);
                    if (number.length() <= data.getNumber().length()) continue;
                    data.setNumber(number);
                }
            }
        }
    }

    private boolean existAcct(List<Long> orgIds, long accountTableId, long masterId, String number) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("masterid", "=", (Object)masterId));
        filters.add(new QFilter("number", "=", (Object)number));
        return AccountUtils.existUseRangeAccountByOrg(new HashSet<Long>(orgIds), (long)accountTableId, filters);
    }

    public void onProgress(ProgressEvent progressEvent) {
        String test = this.getPageCache().get("mark");
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DLockInfo lockInfo = null;
        if (selectedRows != null && selectedRows.size() > 0) {
            ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(selectedRow.getPrimaryKeyValue());
            }
            QFilter idFilters = new QFilter("id", "in", ids);
            DynamicObject accountObj = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttable_id", (QFilter[])idFilters.toArray());
            if (accountObj != null) {
                lockInfo = DLock.getLockInfo((String)("assignlock" + accountObj.getLong("accounttable_id")));
            }
        }
        if (lockInfo == null && "finish".equals(test)) {
            String msg = this.getPageCache().get("msg");
            Set acctCheckErrMsg = new HashSet();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                acctCheckErrMsg = (Set)JSONObject.parseObject((String)msg, Set.class);
            }
            if (acctCheckErrMsg.size() > 0) {
                OperationResult r = new OperationResult();
                r.setSuccess(false);
                ArrayList errInfos = acctCheckErrMsg.stream().map(m -> {
                    OperateErrorInfo e = new OperateErrorInfo("common", ErrorLevel.Error, (Object)"test");
                    e.setMessage(m);
                    return e;
                }).collect(() -> new ArrayList(10), (x, y) -> x.add(y), (l, f) -> l.addAll(f));
                r.setAllErrorInfo((List)errInfos);
                this.getView().showOperationResult(r);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"AssignHandle_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
            this.getPageCache().put("mark", "closeview");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5206\u914d", "AccountTreeListPlugin_9", "fi-bd-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u79d1\u76ee\u5206\u914d\u6210\u529f", "CalLogUtils_1", "fi-cal-common");
            new OpLogHelper().addOperateLog(this.getView(), Long.parseLong(this.getView().getFormShowParameter().getCustomParam(USEORGID).toString()), "", "assign", opNameBridge, opDescBridge, new String[]{""});
        } else if (lockInfo == null && "closeview".equals(test)) {
            ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
            bar.setPercent(100);
            bar.stop();
            this.getView().hideLoading();
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private void initCUAssignTree(Long srcOrgId, Long orgViewId) {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        param.setId(srcOrgId.longValue());
        TreeNode node = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        node.setData((Object)1);
        node.setParentid("");
        treeView.addNode(node);
        treeView.queryTreeNodeChildren("", String.valueOf(srcOrgId));
        treeView.expand(String.valueOf(srcOrgId));
    }

    private void initCUFreeAssignTree(Long orgViewId) {
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.deleteAllNodes();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (rootNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"AssignPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        tvLeft.addNode(rootNode);
        tvLeft.queryTreeNodeChildren("", rootNode.getId());
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (null == allOrgStr) {
            return;
        }
        String currentNodeId = arg0.getNodeId().toString();
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        List allNodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        for (TreeNode node : allNodeList) {
            String nodeId = node.getId();
            if (!currentNodeId.equals(nodeId)) continue;
            tvLeft.addNodes(node.getChildren());
            break;
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        QFilter idFilter = new QFilter("id", "in", (Object)ids);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (searchFields == null) {
            billList.setFilter(idFilter);
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            String filelistStr = SerializationUtils.toJsonString((Object)filedList);
            this.getPageCache().put("filedList", filelistStr);
            this.getPageCache().put("searchfiled", (String)text.get(0));
            QFilter orFilter = new QFilter((String)filedList.get(0), "like", (Object)("%" + (String)text.get(0) + "%"));
            for (int i = 1; i < filedList.size(); ++i) {
                QFilter filter = new QFilter((String)filedList.get(i), "like", (Object)("%" + (String)text.get(0) + "%"));
                orFilter = QFilter.or((QFilter)orFilter, (QFilter)filter);
            }
            billList.setFilter(idFilter.and(orFilter));
        }
        billList.refresh();
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        String ctrlStrategy = this.getPageCache().get(this.getView().getPageId() + _CTRLSTRATEGY);
        boolean isIncludeChild = (Boolean)this.getModel().getValue("chkincludechild");
        String checkedNodeId = event.getNodeId().toString();
        String allOrgStr = this.getView().getPageCache().getBigObject(ALLORGLIST_KEY);
        if (StringUtils.isEmpty((CharSequence)allOrgStr)) {
            return;
        }
        List nodeList = SerializationUtils.fromJsonStringToList((String)allOrgStr, TreeNode.class);
        if (event.getChecked().booleanValue()) {
            this.nodeCheck(ctrlStrategy, isIncludeChild, checkedNodeId, nodeList);
            return;
        }
        TreeNode checkedNode = this.getTreeNode(checkedNodeId, nodeList);
        if (null == checkedNode) {
            return;
        }
        ArrayList<TreeNode> unCheckNodes = new ArrayList<TreeNode>();
        unCheckNodes.add(checkedNode);
        if (!"2".equals(ctrlStrategy) || isIncludeChild) {
            this.getChildrenNodeList(checkedNode, unCheckNodes);
        }
        ArrayList uncheckNodeIds = new ArrayList(unCheckNodes.size());
        unCheckNodes.forEach(node -> uncheckNodeIds.add(node.getId()));
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.uncheckNodes(uncheckNodeIds);
    }

    private void nodeCheck(String ctrlStrategy, boolean isIncludeChild, String checkedNodeId, List<TreeNode> nodeList) {
        if (CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        TreeNode checkedNode = this.getTreeNode(checkedNodeId, nodeList);
        if (null == checkedNode) {
            return;
        }
        ArrayList<TreeNode> needCheckNodes = new ArrayList<TreeNode>(10);
        needCheckNodes.add(checkedNode);
        if (isIncludeChild) {
            this.getChildrenNodeList(checkedNode, needCheckNodes);
        }
        if ("1".equals(ctrlStrategy)) {
            this.queryParentNodesByOrgIds(needCheckNodes, nodeList, checkedNode.getParentid());
        }
        TreeView tvLeft = (TreeView)this.getControl(TREEVIEW);
        tvLeft.checkNodes(needCheckNodes);
    }

    private TreeNode getTreeNode(String checkedNodeId, List<TreeNode> nodeList) {
        for (TreeNode node : nodeList) {
            String nodeId = node.getId();
            if (!checkedNodeId.equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    private void getChildrenNodeList(TreeNode node, List<TreeNode> list) {
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        list.addAll(children);
        children.forEach(child -> this.getChildrenNodeList((TreeNode)child, list));
    }

    private void queryParentNodesByOrgIds(List<TreeNode> allNodes, List<TreeNode> nodeList, String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId) || CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        for (TreeNode node : nodeList) {
            if (!parentId.equals(node.getId())) continue;
            allNodes.add(node);
            String currentNodePid = node.getParentid();
            this.queryParentNodesByOrgIds(allNodes, nodeList, currentNodePid);
            break;
        }
    }
}

