/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.billparam;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fa.enums.BillParamValueTypeEnum;

public class FaBillParamEditPlugin
extends AbstractFormPlugin {
    private static final String BTN_SAVE = "save";
    public static final String APP_ID_FA = "83bfebc800001aac";
    public static final String FIELD_SUFFIX = "val";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"assetbook", "depreuse"});
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue("bizcloud", (Object)parentView.getPageCache().get("query_bizcloud_id"));
            this.getModel().setValue("bizapp", (Object)parentView.getPageCache().get("query_bizapp_id"));
        }
        this.showValueField(true);
    }

    public void afterBindData(EventObject e) {
        DynamicObject billParamObj = this.getModel().getDataEntity();
        DynamicObject bizAppObj = billParamObj.getDynamicObject("bizapp");
        if (bizAppObj != null && bizAppObj.getString("id").equals(APP_ID_FA)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"assetbook", "depreuse"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"assetbook", "depreuse"});
        }
        Boolean canModify = billParamObj.getBoolean("canmodify");
        this.getView().setVisible(canModify, new String[]{BTN_SAVE});
        this.showValueField(false);
        this.setShowValue();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cloudEdit = (BasedataEdit)this.getView().getControl("bizcloud");
        cloudEdit.addBeforeF7SelectListener(evt -> this.beforeF7BizCloudSelect(evt));
        BasedataEdit appEdit = (BasedataEdit)this.getView().getControl("bizapp");
        appEdit.addBeforeF7SelectListener(evt -> this.beforeF7BizAppSelect(evt));
        BasedataEdit paramTypeEdit = (BasedataEdit)this.getView().getControl("paramtype");
        paramTypeEdit.addBeforeF7SelectListener(evt -> this.beforeF7ParamTypeSelect(evt));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("bizapp".equals(propertyName)) {
            DynamicObject newBizAppObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newBizAppObj != null && newBizAppObj.getString("id").equals(APP_ID_FA)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"assetbook", "depreuse"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"assetbook", "depreuse"});
            }
        } else if ("paramtype".equals(propertyName)) {
            this.showValueField(e);
        }
    }

    private void beforeF7BizCloudSelect(BeforeF7SelectEvent evt) {
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List filters = param.getListFilterParameter().getQFilters();
        IFormView parentView = this.getView().getParentView();
        String cloudId = parentView == null ? "" : parentView.getPageCache().get("query_bizcloud_id");
        filters.add(new QFilter("id", "=", (Object)cloudId));
    }

    private void beforeF7BizAppSelect(BeforeF7SelectEvent evt) {
        DynamicObject bizCloudObj = (DynamicObject)this.getModel().getValue("bizcloud");
        if (bizCloudObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e91\u3002", (String)"FaBillParamEditPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List filters = param.getListFilterParameter().getQFilters();
        filters.add(new QFilter("id", "=", (Object)this.getView().getParentView().getPageCache().get("query_bizapp_id")));
    }

    private void beforeF7ParamTypeSelect(BeforeF7SelectEvent evt) {
        DynamicObject bizCloudObj = (DynamicObject)this.getModel().getValue("bizcloud");
        DynamicObject bizAppObj = (DynamicObject)this.getModel().getValue("bizapp");
        if (bizCloudObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e91\u3002", (String)"FaBillParamEditPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (bizAppObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7cfb\u7edf\u3002", (String)"FaBillParamEditPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List filters = param.getListFilterParameter().getQFilters();
        filters.add(new QFilter("bizcloud", "=", (Object)bizCloudObj.getString("id")));
        filters.add(new QFilter("bizapp", "=", (Object)bizAppObj.getString("id")));
    }

    private void showValueField(PropertyChangedArgs e) {
        DynamicObject oldParamType = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject newParamType = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (oldParamType != null) {
            String oldShowValueField = this.getShowValueField(oldParamType);
            this.getView().setVisible(Boolean.FALSE, new String[]{oldShowValueField});
        }
        if (newParamType != null) {
            String newShowValueField = this.getShowValueField(newParamType);
            this.getView().setVisible(Boolean.TRUE, new String[]{newShowValueField});
            if ("comboxval".equals(newShowValueField)) {
                this.setComboxItems(newParamType, true);
            }
        }
    }

    private void showValueField(boolean needSetDefVal) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"value", "passwordval", "booleanval", "comboxval", "dateval", "longval", "decimalval"});
        DynamicObject paramType = this.getModel().getDataEntity().getDynamicObject("paramtype");
        if (paramType != null) {
            String showValueField = this.getShowValueField(paramType);
            this.getView().setVisible(Boolean.TRUE, new String[]{showValueField});
            if ("comboxval".equals(showValueField)) {
                this.setComboxItems(paramType, needSetDefVal);
            }
        }
    }

    private void setComboxItems(DynamicObject paramType, boolean needSetDefVal) {
        MulComboEdit comboEdit = (MulComboEdit)this.getControl("comboxval");
        String newValRangeJsonStr = paramType.getString("paramrange");
        String defaultVal = paramType.getString("defaultval");
        if (StringUtils.isNotEmpty((String)newValRangeJsonStr)) {
            JSONObject jsonObject = JSONObject.parseObject((String)newValRangeJsonStr);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(jsonObject.size());
            for (Map.Entry entry : jsonObject.entrySet()) {
                comboItems.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
            }
            comboEdit.setComboItems(comboItems);
        }
        if (needSetDefVal && StringUtils.isNotEmpty((String)defaultVal)) {
            this.getModel().setValue("comboxval", (Object)defaultVal);
        }
    }

    private void setShowValue() {
        DynamicObject paramType = this.getModel().getDataEntity().getDynamicObject("paramtype");
        String showValueField = this.getShowValueField(paramType);
        this.getModel().setValue(showValueField, this.getModel().getValue("value"));
        DynamicProperty showValueProperty = this.getModel().getDataEntityType().getProperty(showValueField);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(showValueProperty.getOrdinal(), Boolean.FALSE.booleanValue());
    }

    private String getShowValueField(DynamicObject paramTypeObj) {
        String valueType;
        String valueField = "value";
        if (paramTypeObj != null && StringUtils.isNotEmpty((String)(valueType = paramTypeObj.getString("valuetype"))) && !BillParamValueTypeEnum.TEXT.getType().equals(valueType)) {
            valueField = valueType + FIELD_SUFFIX;
        }
        return valueField;
    }
}

